/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.Easings;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.compiler.signature.FunctionSignatures;
import com.laytonsmith.core.compiler.signature.SignatureBuilder;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.EnumSet;
import java.util.Set;

public class Easings {
    public static String docs() {
        return "Easing related functions. Easings are based on the easings listed at http://easings.net, with the addition of the LINEAR easing, which just returns x.";
    }

    @api
    @seealso(value={easing.class})
    public static class ease_between_loc
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args2) throws ConfigRuntimeException {
            CArray start = ArgumentValidation.getArray(args2[0], t);
            double startX = ArgumentValidation.getDouble(start.get("x", t), t);
            double startY = ArgumentValidation.getDouble(start.get("y", t), t);
            double startZ = ArgumentValidation.getDouble(start.get("z", t), t);
            CArray finish = ArgumentValidation.getArray(args2[1], t);
            double finishX = ArgumentValidation.getDouble(finish.get("x", t), t);
            double finishY = ArgumentValidation.getDouble(finish.get("y", t), t);
            double finishZ = ArgumentValidation.getDouble(finish.get("z", t), t);
            Easings.EasingType type = ArgumentValidation.getEnum(args2[2], Easings.EasingType.class, t);
            double x = ArgumentValidation.getDouble(args2[3], t);
            double percentage = com.laytonsmith.core.Easings.GetEasing(type, x);
            CArray result = new CArray(Target.UNKNOWN);
            result.set("x", startX + (finishX - startX) * percentage);
            result.set("y", startY + (finishY - startY) * percentage);
            result.set("z", startZ + (finishZ - startZ) * percentage);
            return result;
        }

        @Override
        public String getName() {
            return "ease_between_loc";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{4};
        }

        @Override
        public String docs() {
            return "array {array start, array finish, EasingType type, double x} Given an easing type, and a duration percentage x, returns the given resulting interpolated distance. ---- For instance, given the location arrays representing x: 0 and x: 100, with a LINEAR easing and 0.25 duration, a location array of x: 25 would be returned. Easing type may be one of " + StringUtils.Join(Easings.EasingType.values(), ", ", ", or ") + " and x must be a double between 0 and 1, or it is clamped. The return value may be less than zero or above one, depending on the easing algorithm. See http://easings.net/ for visual examples. The start and finish arrays must contain x, y, and z parameters, but don't necessarily have to represent locations.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }

        @Override
        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CArray.TYPE).param(CArray.TYPE, "start", "The starting position.").param(CArray.TYPE, "finish", "The ending position.").param(CClassType.getForEnum(Easings.EasingType.class), "type", "The easing type.").param(CDouble.TYPE, "x", "The duration percentage.").build();
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Usage with a LINEAR interpolation.", "@start = array(x: 0, y: 0, z: 0);\n@finish = array(x: 0, y: 100, z: 0);\nfor(@i = 0, @i <= 1, @i += 0.1) {\n\tmsg(ease_between_loc(@start, @finish, 'LINEAR', @i);\n}"), new ExampleScript("Usage with a EASE_IN_CUBIC interpolation.", "@start = array(x: 0, y: 0, z: 0);\n@finish = array(x: 0, y: 100, z: 0);\nfor(@i = 0, @i <= 1, @i += 0.1) {\n\tmsg(ease_between_loc(@start, @finish, 'EASE_IN_CUBIC', @i);\n}")};
        }
    }

    @api
    public static class easing
    extends AbstractFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args2) throws ConfigRuntimeException {
            Easings.EasingType type = ArgumentValidation.getEnum(args2[0], Easings.EasingType.class, t);
            double x = ArgumentValidation.getDouble(args2[1], t);
            double ret = com.laytonsmith.core.Easings.GetEasing(type, x);
            return new CDouble(ret, Target.UNKNOWN);
        }

        @Override
        public String getName() {
            return "easing";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "double {EasingType type, double x} Given an easing type, and a duration percentage x, returns the given resulting interpolation value. ---- Easing type may be one of " + StringUtils.Join(Easings.EasingType.values(), ", ", ", or ") + " and x must be a double between 0 and 1, or it is clamped. The return value may be less than zero or above one, depending on the easing algorithm. See http://easings.net/ for visual examples.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CACHE_RETURN, Optimizable.OptimizationOption.NO_SIDE_EFFECTS, Optimizable.OptimizationOption.CONSTANT_OFFLINE);
        }

        @Override
        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CDouble.TYPE).param(CClassType.getForEnum(Easings.EasingType.class), "type", "The easing type.").param(CDouble.TYPE, "x", "The duration percentage.").build();
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Usage with LINEAR interpolation.", "for(@x = 0, @x <= 1, @x += 0.1) {\n\tmsg(@x . ': ' . easing('LINEAR', @x));\n}"), new ExampleScript("Usage with EASE_IN_SINE interpolation.", "for(@x = 0, @x <= 1, @x += 0.1) {\n\tmsg(@x . ': ' . easing('EASE_IN_SINE', @x));\n}")};
        }
    }
}

