/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.abstraction.MCArmorMeta;
import com.laytonsmith.abstraction.MCAttributeModifier;
import com.laytonsmith.abstraction.MCAxolotlBucketMeta;
import com.laytonsmith.abstraction.MCBannerMeta;
import com.laytonsmith.abstraction.MCBlockStateMeta;
import com.laytonsmith.abstraction.MCBookMeta;
import com.laytonsmith.abstraction.MCBrewerInventory;
import com.laytonsmith.abstraction.MCBundleMeta;
import com.laytonsmith.abstraction.MCColor;
import com.laytonsmith.abstraction.MCColorableArmorMeta;
import com.laytonsmith.abstraction.MCCompassMeta;
import com.laytonsmith.abstraction.MCCookingRecipe;
import com.laytonsmith.abstraction.MCCreatureSpawner;
import com.laytonsmith.abstraction.MCCrossbowMeta;
import com.laytonsmith.abstraction.MCEnchantmentStorageMeta;
import com.laytonsmith.abstraction.MCFireworkBuilder;
import com.laytonsmith.abstraction.MCFireworkEffect;
import com.laytonsmith.abstraction.MCFireworkEffectMeta;
import com.laytonsmith.abstraction.MCFireworkMeta;
import com.laytonsmith.abstraction.MCFurnaceInventory;
import com.laytonsmith.abstraction.MCInventory;
import com.laytonsmith.abstraction.MCInventoryHolder;
import com.laytonsmith.abstraction.MCItemFactory;
import com.laytonsmith.abstraction.MCItemMeta;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCKnowledgeBookMeta;
import com.laytonsmith.abstraction.MCLeatherArmorMeta;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCMapMeta;
import com.laytonsmith.abstraction.MCMetadataValue;
import com.laytonsmith.abstraction.MCMusicInstrumentMeta;
import com.laytonsmith.abstraction.MCNamespacedKey;
import com.laytonsmith.abstraction.MCOfflinePlayer;
import com.laytonsmith.abstraction.MCPattern;
import com.laytonsmith.abstraction.MCPlayerProfile;
import com.laytonsmith.abstraction.MCPlugin;
import com.laytonsmith.abstraction.MCPotionData;
import com.laytonsmith.abstraction.MCPotionMeta;
import com.laytonsmith.abstraction.MCProfileProperty;
import com.laytonsmith.abstraction.MCRecipe;
import com.laytonsmith.abstraction.MCShapedRecipe;
import com.laytonsmith.abstraction.MCShapelessRecipe;
import com.laytonsmith.abstraction.MCSkullMeta;
import com.laytonsmith.abstraction.MCSmithingRecipe;
import com.laytonsmith.abstraction.MCStonecuttingRecipe;
import com.laytonsmith.abstraction.MCSuspiciousStewMeta;
import com.laytonsmith.abstraction.MCTropicalFishBucketMeta;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.abstraction.blocks.MCBanner;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.blocks.MCBlockState;
import com.laytonsmith.abstraction.blocks.MCBrewingStand;
import com.laytonsmith.abstraction.blocks.MCCommandBlock;
import com.laytonsmith.abstraction.blocks.MCDecoratedPot;
import com.laytonsmith.abstraction.blocks.MCFurnace;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.blocks.MCSign;
import com.laytonsmith.abstraction.blocks.MCSignText;
import com.laytonsmith.abstraction.entities.MCTropicalFish;
import com.laytonsmith.abstraction.enums.MCAttribute;
import com.laytonsmith.abstraction.enums.MCAxolotlType;
import com.laytonsmith.abstraction.enums.MCDyeColor;
import com.laytonsmith.abstraction.enums.MCEnchantment;
import com.laytonsmith.abstraction.enums.MCEntityType;
import com.laytonsmith.abstraction.enums.MCEquipmentSlot;
import com.laytonsmith.abstraction.enums.MCEquipmentSlotGroup;
import com.laytonsmith.abstraction.enums.MCFireworkType;
import com.laytonsmith.abstraction.enums.MCItemFlag;
import com.laytonsmith.abstraction.enums.MCPatternShape;
import com.laytonsmith.abstraction.enums.MCPotionEffectType;
import com.laytonsmith.abstraction.enums.MCPotionType;
import com.laytonsmith.abstraction.enums.MCRecipeType;
import com.laytonsmith.abstraction.enums.MCTagType;
import com.laytonsmith.abstraction.enums.MCTrimMaterial;
import com.laytonsmith.abstraction.enums.MCTrimPattern;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.AbstractCREException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREEnchantmentException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidWorldException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.MatchResult;

public class ObjectGenerator {
    private static ObjectGenerator pog = null;

    public static ObjectGenerator GetGenerator() {
        if (pog == null) {
            pog = new ObjectGenerator();
        }
        return pog;
    }

    public CArray location(MCLocation l) {
        return this.location(l, true);
    }

    public CArray location(MCLocation l, boolean includeYawAndPitch) {
        CArray ca = CArray.GetAssociativeArray(Target.UNKNOWN);
        CDouble x = new CDouble(l.getX(), Target.UNKNOWN);
        CDouble y = new CDouble(l.getY(), Target.UNKNOWN);
        CDouble z = new CDouble(l.getZ(), Target.UNKNOWN);
        Construct world = l.getWorld() != null ? new CString(l.getWorld().getName(), Target.UNKNOWN) : CNull.NULL;
        ca.set("0", (Mixed)x, Target.UNKNOWN);
        ca.set("1", (Mixed)y, Target.UNKNOWN);
        ca.set("2", (Mixed)z, Target.UNKNOWN);
        ca.set("3", (Mixed)world, Target.UNKNOWN);
        ca.set("x", (Mixed)x, Target.UNKNOWN);
        ca.set("y", (Mixed)y, Target.UNKNOWN);
        ca.set("z", (Mixed)z, Target.UNKNOWN);
        ca.set("world", (Mixed)world, Target.UNKNOWN);
        if (includeYawAndPitch) {
            float yawRaw = l.getYaw() % 360.0f;
            if (yawRaw < 0.0f) {
                yawRaw += 360.0f;
            }
            CDouble yaw = new CDouble(yawRaw, Target.UNKNOWN);
            CDouble pitch = new CDouble(l.getPitch(), Target.UNKNOWN);
            ca.set("4", (Mixed)yaw, Target.UNKNOWN);
            ca.set("5", (Mixed)pitch, Target.UNKNOWN);
            ca.set("yaw", (Mixed)yaw, Target.UNKNOWN);
            ca.set("pitch", (Mixed)pitch, Target.UNKNOWN);
        }
        return ca;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MCLocation location(Mixed c, MCWorld w, Target t) {
        if (!c.isInstanceOf(CArray.TYPE)) {
            throw new CREFormatException("Expecting an array, received " + c.typeof().getSimpleName(), t);
        }
        CArray array2 = (CArray)c;
        MCWorld world = w;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float yaw = 0.0f;
        float pitch = 0.0f;
        if (!array2.inAssociativeMode()) {
            if (array2.size() == 3L) {
                x = ArgumentValidation.getNumber(array2.get(0, t), t);
                y = ArgumentValidation.getNumber(array2.get(1, t), t);
                z = ArgumentValidation.getNumber(array2.get(2, t), t);
            } else if (array2.size() == 4L) {
                x = ArgumentValidation.getNumber(array2.get(0, t), t);
                y = ArgumentValidation.getNumber(array2.get(1, t), t);
                z = ArgumentValidation.getNumber(array2.get(2, t), t);
                world = Static.getServer().getWorld(array2.get(3, t).val());
            } else if (array2.size() == 5L) {
                x = ArgumentValidation.getNumber(array2.get(0, t), t);
                y = ArgumentValidation.getNumber(array2.get(1, t), t);
                z = ArgumentValidation.getNumber(array2.get(2, t), t);
                yaw = (float)ArgumentValidation.getNumber(array2.get(3, t), t);
                pitch = (float)ArgumentValidation.getNumber(array2.get(4, t), t);
            } else {
                if (array2.size() != 6L) throw new CREFormatException("Expecting a Location array, but the array did not meet the format specifications", t);
                x = ArgumentValidation.getNumber(array2.get(0, t), t);
                y = ArgumentValidation.getNumber(array2.get(1, t), t);
                z = ArgumentValidation.getNumber(array2.get(2, t), t);
                world = Static.getServer().getWorld(array2.get(3, t).val());
                yaw = (float)ArgumentValidation.getNumber(array2.get(4, t), t);
                pitch = (float)ArgumentValidation.getNumber(array2.get(5, t), t);
            }
        } else {
            if (array2.containsKey("x")) {
                x = ArgumentValidation.getNumber(array2.get("x", t), t);
            }
            if (array2.containsKey("y")) {
                y = ArgumentValidation.getNumber(array2.get("y", t), t);
            }
            if (array2.containsKey("z")) {
                z = ArgumentValidation.getNumber(array2.get("z", t), t);
            }
            if (array2.containsKey("world")) {
                world = Static.getServer().getWorld(array2.get("world", t).val());
            }
            if (array2.containsKey("yaw")) {
                yaw = (float)ArgumentValidation.getDouble(array2.get("yaw", t), t);
            }
            if (array2.containsKey("pitch")) {
                pitch = (float)ArgumentValidation.getDouble(array2.get("pitch", t), t);
            }
        }
        if (world != null) return StaticLayer.GetLocation(world, x, y, z, yaw, pitch);
        throw new CREInvalidWorldException("The specified world doesn't exist, or no world was provided", t);
    }

    public Construct item(MCItemStack is, Target t) {
        if (is == null || is.isEmpty()) {
            return CNull.NULL;
        }
        CArray ret = CArray.GetAssociativeArray(t);
        ret.set("name", (Mixed)new CString(is.getType().getName(), t), t);
        ret.set("qty", (Mixed)new CInt(is.getAmount(), t), t);
        ret.set("meta", (Mixed)this.itemMeta(is, t), t);
        return ret;
    }

    public MCItemStack item(Mixed i, Target t) {
        return this.item(i, t, false);
    }

    public MCItemStack item(Mixed i, Target t, boolean legacy) {
        MCItemStack ret;
        String mat;
        if (i instanceof CNull) {
            return ObjectGenerator.EmptyItem();
        }
        if (!i.isInstanceOf(CArray.TYPE)) {
            throw new CREFormatException("Expected an array!", t);
        }
        CArray item = (CArray)i;
        if (!item.isAssociative()) {
            throw new CREFormatException("Expected an associative array!", t);
        }
        int data = 0;
        int qty = 1;
        if (item.containsKey("qty") && (qty = ArgumentValidation.getInt32(item.get("qty", t), t)) <= 0) {
            return ObjectGenerator.EmptyItem();
        }
        boolean bl = legacy = legacy || item.containsKey("type") || item.containsKey("data");
        if (legacy) {
            String entityName;
            MCMaterial newmaterial;
            Mixed spawntype;
            Mixed meta;
            MCMaterial material;
            if (item.containsKey("data")) {
                data = ArgumentValidation.getInt32(item.get("data", t), t);
            }
            if (item.containsKey("name")) {
                mat = item.get("name", t).val();
                material = mat.equals("MAP") || mat.equals("POTION") ? StaticLayer.GetMaterialFromLegacy(mat, 0) : StaticLayer.GetMaterialFromLegacy(mat, data);
            } else {
                int seperatorIndex;
                Mixed type = item.get("type", t);
                if (type.isInstanceOf(CString.TYPE) && (seperatorIndex = type.val().indexOf(58)) != -1) {
                    try {
                        data = Integer.parseInt(type.val().substring(seperatorIndex + 1));
                    }
                    catch (NumberFormatException e) {
                        throw new CRERangeException("The item data \"" + type.val().substring(seperatorIndex + 1) + "\" is not a valid integer.", t);
                    }
                    type = new CString(type.val().substring(0, seperatorIndex), t);
                }
                mat = type.val();
                int id = ArgumentValidation.getInt32(type, t);
                material = id == 358 || id == 373 ? StaticLayer.GetMaterialFromLegacy(id, 0) : StaticLayer.GetMaterialFromLegacy(id, data);
            }
            if ((material == null || material.getName().equals("AIR")) && (material = StaticLayer.GetMaterial(mat)) == null) {
                throw new CREFormatException("Could not find legacy item material from \"" + mat + "\" with data \"" + data + "\"", t);
            }
            if (material.getName().equals("PIG_SPAWN_EGG") && item.containsKey("meta") && (meta = item.get("meta", t)).isInstanceOf(CArray.TYPE) && ((CArray)meta).containsKey("spawntype") && !((spawntype = ((CArray)meta).get("spawntype", t)) instanceof CNull) && (newmaterial = (entityName = spawntype.val().toUpperCase()).equals("MUSHROOM_COW") ? StaticLayer.GetMaterial("MOOSHROOM_SPAWN_EGG") : (entityName.equals("PIG_ZOMBIE") ? StaticLayer.GetMaterial("ZOMBIE_PIGMAN_SPAWN_EGG") : StaticLayer.GetMaterial(entityName + "_SPAWN_EGG"))) != null) {
                material = newmaterial;
            }
            ret = StaticLayer.GetItemStack(material, qty);
            MSLog.GetLogger().w(MSLog.Tags.DEPRECATION, "Converted \"" + mat + "\" with data \"" + data + "\" to " + material.getName(), t);
        } else {
            mat = item.get("name", t).val();
            ret = StaticLayer.GetItemStack(mat, qty);
        }
        if (ret == null) {
            throw new CREFormatException("Could not find item material from \"" + mat + "\"", t);
        }
        if (ret.isEmpty()) {
            return ret;
        }
        if (item.containsKey("meta")) {
            ret.setItemMeta(this.itemMeta(item.get("meta", t), ret.getType(), t));
        }
        if (legacy) {
            if (ret.getType().getName().equals("FILLED_MAP")) {
                meta = (MCMapMeta)ret.getItemMeta();
                meta.setMapId(data);
                ret.setItemMeta(meta);
            } else if (data > 0 && ret.getType().getMaxDurability() > 0) {
                meta = ret.getItemMeta();
                meta.setDamage(data);
                ret.setItemMeta(meta);
            }
        }
        if (item.containsKey("enchants")) {
            try {
                Map<MCEnchantment, Integer> enchants = this.enchants((CArray)item.get("enchants", t), t);
                for (Map.Entry<MCEnchantment, Integer> entry : enchants.entrySet()) {
                    ret.addUnsafeEnchantment(entry.getKey(), entry.getValue());
                }
            }
            catch (ClassCastException ex) {
                throw new CREFormatException("Enchants must be an array of enchantment arrays.", t);
            }
        }
        return ret;
    }

    private static MCItemStack EmptyItem() {
        return StaticLayer.GetItemStack("AIR", 0);
    }

    public Construct itemMeta(MCItemStack is, Target t) {
        Construct lore;
        if (!is.hasItemMeta()) {
            return CNull.NULL;
        }
        CArray ma = CArray.GetAssociativeArray(t);
        MCItemMeta meta = is.getItemMeta();
        Construct display = meta.hasDisplayName() ? new CString(meta.getDisplayName(), t) : CNull.NULL;
        if (meta.hasLore()) {
            lore = new CArray(t);
            for (String l : meta.getLore()) {
                ((CArray)lore).push(new CString(l, t), t);
            }
        } else {
            lore = CNull.NULL;
        }
        ma.set("display", (Mixed)display, t);
        ma.set("lore", (Mixed)lore, t);
        ma.set("enchants", (Mixed)this.enchants(meta.getEnchants(), t), t);
        ma.set("repair", (Mixed)new CInt(meta.getRepairCost(), t), t);
        if (meta.hasCustomModelData()) {
            ma.set("model", (Mixed)new CInt(meta.getCustomModelData(), t), t);
        } else {
            ma.set("model", (Mixed)CNull.NULL, t);
        }
        Set<MCItemFlag> itemFlags = meta.getItemFlags();
        CArray flagArray = new CArray(t);
        if (!itemFlags.isEmpty()) {
            for (MCItemFlag flag : itemFlags) {
                flagArray.push(new CString(flag.name(), t), t);
            }
        }
        ma.set("flags", (Mixed)flagArray, t);
        List<MCAttributeModifier> modifierList = meta.getAttributeModifiers();
        if (modifierList == null) {
            ma.set("modifiers", (Mixed)CNull.NULL, t);
        } else {
            CArray modifiers = new CArray(t);
            for (MCAttributeModifier m : meta.getAttributeModifiers()) {
                modifiers.push(this.attributeModifier(m, t), t);
            }
            ma.set("modifiers", (Mixed)modifiers, t);
        }
        if (meta.hasCustomTags()) {
            ma.set("tags", MCTagType.TAG_CONTAINER.construct(meta.getCustomTags()), t);
        } else {
            ma.set("tags", (Mixed)CNull.NULL, t);
        }
        MCMaterial material = is.getType();
        if (material.getMaxDurability() > 0) {
            ma.set("damage", (Mixed)new CInt(meta.getDamage(), t), t);
            ma.set("unbreakable", (Mixed)CBoolean.get(meta.isUnbreakable()), t);
        } else if (material.isBlock()) {
            if (meta.hasBlockData()) {
                ma.set("blockdata", (Mixed)this.blockData(meta.getBlockData(is.getType()), t), t);
            } else {
                ma.set("blockdata", (Mixed)CNull.NULL, t);
            }
        }
        if (meta instanceof MCBlockStateMeta) {
            MCBlockState bs = ((MCBlockStateMeta)meta).getBlockState(true);
            if (bs instanceof MCBanner) {
                if (((MCBlockStateMeta)meta).hasBlockState()) {
                    MCBanner banner = (MCBanner)bs;
                    ma.set("basecolor", banner.getBaseColor().name(), t);
                    CArray patterns = new CArray(t, banner.numberOfPatterns());
                    for (MCPattern p2 : banner.getPatterns()) {
                        CArray cArray = CArray.GetAssociativeArray(t);
                        cArray.set("shape", (Mixed)new CString(p2.getShape().toString(), t), t);
                        cArray.set("color", (Mixed)new CString(p2.getColor().toString(), t), t);
                        patterns.push(cArray, t);
                    }
                    ma.set("patterns", (Mixed)patterns, t);
                }
            } else if (bs instanceof MCCreatureSpawner) {
                MCCreatureSpawner mccs = (MCCreatureSpawner)bs;
                MCEntityType type = mccs.getSpawnedType();
                if (type == null) {
                    ma.set("spawntype", (Mixed)CNull.NULL, t);
                } else {
                    ma.set("spawntype", type.name());
                }
                ma.set("delay", (Mixed)new CInt(mccs.getDelay(), t), t);
                ma.set("mindelay", (Mixed)new CInt(mccs.getMinDelay(), t), t);
                ma.set("maxdelay", (Mixed)new CInt(mccs.getMaxDelay(), t), t);
                ma.set("spawncount", (Mixed)new CInt(mccs.getSpawnCount(), t), t);
                ma.set("maxnearbyentities", (Mixed)new CInt(mccs.getMaxNearbyEntities(), t), t);
                ma.set("playerrange", (Mixed)new CInt(mccs.getPlayerRange(), t), t);
                ma.set("spawnrange", (Mixed)new CInt(mccs.getSpawnRange(), t), t);
            } else if (bs instanceof MCBrewingStand) {
                MCBrewingStand brewStand = (MCBrewingStand)bs;
                ma.set("brewtime", (Mixed)new CInt(brewStand.getBrewingTime(), t), t);
                ma.set("fuel", (Mixed)new CInt(brewStand.getFuelLevel(), t), t);
                MCBrewerInventory inv = brewStand.getInventory();
                CArray invData = CArray.GetAssociativeArray(t);
                if (inv.getFuel().getAmount() != 0) {
                    invData.set("fuel", (Mixed)ObjectGenerator.GetGenerator().item(inv.getFuel(), t), t);
                }
                if (inv.getIngredient().getAmount() != 0) {
                    invData.set("ingredient", (Mixed)ObjectGenerator.GetGenerator().item(inv.getIngredient(), t), t);
                }
                if (inv.getLeftBottle().getAmount() != 0) {
                    invData.set("leftbottle", (Mixed)ObjectGenerator.GetGenerator().item(inv.getLeftBottle(), t), t);
                }
                if (inv.getMiddleBottle().getAmount() != 0) {
                    invData.set("middlebottle", (Mixed)ObjectGenerator.GetGenerator().item(inv.getMiddleBottle(), t), t);
                }
                if (inv.getRightBottle().getAmount() != 0) {
                    invData.set("rightbottle", (Mixed)ObjectGenerator.GetGenerator().item(inv.getRightBottle(), t), t);
                }
                ma.set("inventory", (Mixed)invData, t);
            } else if (bs instanceof MCFurnace) {
                MCFurnace furnace = (MCFurnace)bs;
                ma.set("burntime", (Mixed)new CInt(furnace.getBurnTime(), t), t);
                ma.set("cooktime", (Mixed)new CInt(furnace.getCookTime(), t), t);
                MCFurnaceInventory inv = furnace.getInventory();
                CArray invData = CArray.GetAssociativeArray(t);
                if (inv.getResult().getAmount() != 0) {
                    invData.set("result", (Mixed)ObjectGenerator.GetGenerator().item(inv.getResult(), t), t);
                }
                if (inv.getFuel().getAmount() != 0) {
                    invData.set("fuel", (Mixed)ObjectGenerator.GetGenerator().item(inv.getFuel(), t), t);
                }
                if (inv.getSmelting().getAmount() != 0) {
                    invData.set("smelting", (Mixed)ObjectGenerator.GetGenerator().item(inv.getSmelting(), t), t);
                }
                ma.set("inventory", (Mixed)invData, t);
            } else if (bs instanceof MCDecoratedPot) {
                MCDecoratedPot decoratedPot = (MCDecoratedPot)bs;
                CArray sherds = CArray.GetAssociativeArray(t);
                Map<MCDecoratedPot.Side, MCMaterial> potSherds = decoratedPot.getSherds();
                for (Map.Entry<MCDecoratedPot.Side, MCMaterial> side : potSherds.entrySet()) {
                    sherds.set(side.getKey().name().toLowerCase(), side.getValue().name());
                }
                ma.set("sherds", (Mixed)sherds, t);
                if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_4)) {
                    ma.set("item", (Mixed)this.item(decoratedPot.getItemStack(), t), t);
                }
            } else if (bs instanceof MCInventoryHolder) {
                MCInventory inv = ((MCInventoryHolder)((Object)bs)).getInventory();
                CArray box = CArray.GetAssociativeArray(t);
                for (int i = 0; i < inv.getSize(); ++i) {
                    Construct item = ObjectGenerator.GetGenerator().item(inv.getItem(i), t);
                    if (item instanceof CNull) continue;
                    box.set(i, (Mixed)item, t);
                }
                ma.set("inventory", (Mixed)box, t);
            } else if (bs instanceof MCSign) {
                MCSign sign = (MCSign)bs;
                ma.set("waxed", (Mixed)CBoolean.get(sign.isWaxed()), t);
                CArray lines = new CArray(t);
                for (String string : sign.getLines()) {
                    lines.push(new CString(string, t), t);
                }
                ma.set("signtext", (Mixed)lines, t);
                ma.set("glowing", (Mixed)CBoolean.get(sign.isGlowingText()), t);
                MCDyeColor color2 = sign.getDyeColor();
                if (color2 == null) {
                    ma.set("color", (Mixed)CNull.NULL, t);
                } else {
                    ma.set("color", color2.name(), t);
                }
                MCSignText backText = sign.getBackText();
                if (backText != null) {
                    CArray back = new CArray(t);
                    for (String line : backText.getLines()) {
                        back.push(new CString(line, t), t);
                    }
                    ma.set("backtext", (Mixed)back, t);
                    ma.set("backglowing", (Mixed)CBoolean.get(backText.isGlowingText()), t);
                    MCDyeColor mCDyeColor = backText.getDyeColor();
                    if (mCDyeColor == null) {
                        ma.set("backcolor", (Mixed)CNull.NULL, t);
                    } else {
                        ma.set("backcolor", mCDyeColor.name(), t);
                    }
                }
            } else if (bs instanceof MCCommandBlock) {
                MCCommandBlock cmdBlock = (MCCommandBlock)bs;
                ma.set("command", cmdBlock.getCommand());
                ma.set("customname", cmdBlock.getName());
            }
        } else if (meta instanceof MCArmorMeta) {
            MCArmorMeta armorMeta = (MCArmorMeta)meta;
            if (armorMeta.hasTrim()) {
                CArray trim2 = CArray.GetAssociativeArray(t);
                trim2.set("material", armorMeta.getTrimMaterial().name());
                trim2.set("pattern", armorMeta.getTrimPattern().name());
                ma.set("trim", (Mixed)trim2, t);
            } else {
                ma.set("trim", (Mixed)CNull.NULL, t);
            }
            if (armorMeta instanceof MCColorableArmorMeta) {
                ma.set("color", (Mixed)this.color(((MCColorableArmorMeta)armorMeta).getColor(), t), t);
            }
        } else if (meta instanceof MCFireworkEffectMeta) {
            MCFireworkEffectMeta mcfem = (MCFireworkEffectMeta)meta;
            MCFireworkEffect effect = mcfem.getEffect();
            if (effect == null) {
                ma.set("effect", (Mixed)CNull.NULL, t);
            } else {
                ma.set("effect", (Mixed)this.fireworkEffect(effect, t), t);
            }
        } else if (meta instanceof MCFireworkMeta) {
            MCFireworkMeta mcfm = (MCFireworkMeta)meta;
            CArray firework = CArray.GetAssociativeArray(t);
            firework.set("strength", (Mixed)new CInt(mcfm.getStrength(), t), t);
            CArray fe = new CArray(t);
            for (MCFireworkEffect effect : mcfm.getEffects()) {
                fe.push(this.fireworkEffect(effect, t), t);
            }
            firework.set("effects", (Mixed)fe, t);
            ma.set("firework", (Mixed)firework, t);
        } else if (meta instanceof MCLeatherArmorMeta) {
            CArray color3 = this.color(((MCLeatherArmorMeta)meta).getColor(), t);
            ma.set("color", (Mixed)color3, t);
        } else if (meta instanceof MCBookMeta) {
            Construct pages;
            CNull title2;
            MCBookMeta bookMeta = (MCBookMeta)meta;
            if (bookMeta.hasTitle()) {
                CString title3 = new CString(bookMeta.getTitle(), t);
            } else {
                title2 = CNull.NULL;
            }
            Construct author = bookMeta.hasAuthor() ? new CString(bookMeta.getAuthor(), t) : CNull.NULL;
            if (bookMeta.hasPages()) {
                pages = new CArray(t);
                for (String p3 : bookMeta.getPages()) {
                    ((CArray)pages).push(new CString(p3, t), t);
                }
            } else {
                pages = CNull.NULL;
            }
            ma.set("title", (Mixed)title2, t);
            ma.set("author", (Mixed)author, t);
            ma.set("pages", (Mixed)pages, t);
            ma.set("generation", bookMeta.getGeneration().name(), t);
        } else if (meta instanceof MCSkullMeta) {
            MCPlayerProfile profile = ((MCSkullMeta)meta).getProfile();
            if (profile != null) {
                if (profile.getName() != null) {
                    ma.set("owner", (Mixed)new CString(profile.getName(), t), t);
                } else {
                    ma.set("owner", (Mixed)CNull.NULL, t);
                }
                if (profile.getId() != null) {
                    ma.set("owneruuid", (Mixed)new CString(profile.getId().toString(), t), t);
                } else {
                    ma.set("owneruuid", (Mixed)CNull.NULL, t);
                }
                MCProfileProperty texture = profile.getProperty("textures");
                if (texture != null) {
                    ma.set("texture", (Mixed)new CString(texture.getValue(), t), t);
                } else {
                    ma.set("texture", (Mixed)CNull.NULL, t);
                }
            } else if (((MCSkullMeta)meta).hasOwner()) {
                ma.set("owner", (Mixed)new CString(((MCSkullMeta)meta).getOwner(), t), t);
                MCOfflinePlayer ofp = ((MCSkullMeta)meta).getOwningPlayer();
                if (ofp != null) {
                    ma.set("owneruuid", (Mixed)new CString(ofp.getUniqueID().toString(), t), t);
                } else {
                    ma.set("owneruuid", (Mixed)CNull.NULL, t);
                }
            } else {
                ma.set("owner", (Mixed)CNull.NULL, t);
                ma.set("owneruuid", (Mixed)CNull.NULL, t);
            }
        } else if (meta instanceof MCEnchantmentStorageMeta) {
            Construct stored = ((MCEnchantmentStorageMeta)meta).hasStoredEnchants() ? this.enchants(((MCEnchantmentStorageMeta)meta).getStoredEnchants(), t) : CNull.NULL;
            ma.set("stored", (Mixed)stored, t);
        } else if (meta instanceof MCPotionMeta) {
            MCPotionMeta potionmeta = (MCPotionMeta)meta;
            CArray effects = this.potions(potionmeta.getCustomEffects(), t);
            ma.set("potions", (Mixed)effects, t);
            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                MCPotionType potionType = potionmeta.getBasePotionType();
                if (potionType == null) {
                    ma.set("potiontype", (Mixed)CNull.NULL, t);
                } else {
                    ma.set("potiontype", potionType.name());
                }
            } else {
                MCPotionData potiondata = potionmeta.getBasePotionData();
                if (potiondata != null) {
                    ma.set("base", (Mixed)this.potionData(potiondata, t), t);
                }
            }
            if (potionmeta.hasColor()) {
                ma.set("color", (Mixed)this.color(potionmeta.getColor(), t), t);
            } else {
                ma.set("color", (Mixed)CNull.NULL, t);
            }
        } else if (meta instanceof MCSuspiciousStewMeta) {
            MCSuspiciousStewMeta susstew = (MCSuspiciousStewMeta)meta;
            CArray effects = this.potions(susstew.getCustomEffects(), t);
            ma.set("potions", (Mixed)effects, t);
        } else if (meta instanceof MCBannerMeta) {
            MCBannerMeta bannermeta = (MCBannerMeta)meta;
            CArray patterns = new CArray(t, bannermeta.numberOfPatterns());
            for (MCPattern p4 : bannermeta.getPatterns()) {
                CArray pattern = CArray.GetAssociativeArray(t);
                pattern.set("shape", (Mixed)new CString(p4.getShape().toString(), t), t);
                pattern.set("color", (Mixed)new CString(p4.getColor().toString(), t), t);
                patterns.push(pattern, t);
            }
            ma.set("patterns", (Mixed)patterns, t);
        } else if (meta instanceof MCMapMeta) {
            MCMapMeta mm = (MCMapMeta)meta;
            MCColor mapcolor = mm.getColor();
            if (mapcolor == null) {
                ma.set("color", (Mixed)CNull.NULL, t);
            } else {
                ma.set("color", (Mixed)this.color(mapcolor, t), t);
            }
            if (mm.hasMapId()) {
                ma.set("mapid", (Mixed)new CInt(mm.getMapId(), t), t);
            } else {
                ma.set("mapid", (Mixed)CNull.NULL, t);
            }
        } else if (meta instanceof MCTropicalFishBucketMeta) {
            MCTropicalFishBucketMeta fm = (MCTropicalFishBucketMeta)meta;
            if (fm.hasVariant()) {
                ma.set("fishcolor", (Mixed)new CString(fm.getBodyColor().name(), t), t);
                ma.set("fishpatterncolor", (Mixed)new CString(fm.getPatternColor().name(), t), t);
                ma.set("fishpattern", (Mixed)new CString(fm.getPattern().name(), t), t);
            } else {
                ma.set("fishcolor", (Mixed)CNull.NULL, t);
                ma.set("fishpatterncolor", (Mixed)CNull.NULL, t);
                ma.set("fishpattern", (Mixed)CNull.NULL, t);
            }
        } else if (meta instanceof MCCrossbowMeta) {
            MCCrossbowMeta cbm = (MCCrossbowMeta)meta;
            if (cbm.hasChargedProjectiles()) {
                CArray projectiles = new CArray(t);
                for (MCItemStack projectile : cbm.getChargedProjectiles()) {
                    projectiles.push(this.item(projectile, t), t);
                }
                ma.set("projectiles", (Mixed)projectiles, t);
            } else {
                ma.set("projectiles", (Mixed)CNull.NULL, t);
            }
        } else if (meta instanceof MCCompassMeta) {
            MCCompassMeta cm = (MCCompassMeta)meta;
            if (cm.getTargetLocation() == null) {
                ma.set("target", (Mixed)CNull.NULL, t);
            } else {
                ma.set("target", (Mixed)this.location(cm.getTargetLocation(), false), t);
            }
            ma.set("lodestone", (Mixed)CBoolean.get(cm.isLodestoneTracked()), t);
        } else if (meta instanceof MCBundleMeta) {
            MCBundleMeta bm = (MCBundleMeta)meta;
            List<MCItemStack> items = bm.getItems();
            CArray arrayItems = new CArray(t);
            for (MCItemStack item : items) {
                arrayItems.push(ObjectGenerator.GetGenerator().item(item, t), t);
            }
            ma.set("items", (Mixed)arrayItems, t);
        } else if (meta instanceof MCAxolotlBucketMeta) {
            ma.set("variant", ((MCAxolotlBucketMeta)meta).getAxolotlType().name());
        } else if (meta instanceof MCMusicInstrumentMeta) {
            String instrumentKey = ((MCMusicInstrumentMeta)meta).getInstrument();
            if (instrumentKey == null) {
                ma.set("instrument", (Mixed)CNull.NULL, t);
            } else {
                ma.set("instrument", instrumentKey);
            }
        } else if (meta instanceof MCKnowledgeBookMeta) {
            MCKnowledgeBookMeta knowledgeBookMeta = (MCKnowledgeBookMeta)meta;
            if (knowledgeBookMeta.hasRecipes()) {
                CArray recipes = new CArray(t);
                for (MCNamespacedKey key : knowledgeBookMeta.getRecipes()) {
                    recipes.push(new CString(key.toString(), t), t);
                }
                ma.set("recipes", (Mixed)recipes, t);
            } else {
                ma.set("recipes", (Mixed)CNull.NULL, t);
            }
        }
        return ma;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MCItemMeta itemMeta(Mixed c, MCMaterial mat, Target t) throws ConfigRuntimeException {
        MCItemFactory itemFactory = Static.getServer().getItemFactory();
        if (itemFactory == null) {
            throw new CRENotFoundException("Could not find the internal MCItemFactory object (are you running in cmdline mode?)", t);
        }
        MCItemMeta meta = itemFactory.getItemMeta(mat);
        if (c instanceof CNull || meta == null) {
            return meta;
        }
        if (!c.isInstanceOf(CArray.TYPE)) throw new CREFormatException("An array was expected but received " + String.valueOf(c) + " instead.", t);
        CArray ma = (CArray)c;
        try {
            Mixed mBlockData;
            Mixed tagArray;
            Mixed modifiers;
            Mixed m;
            Mixed r;
            Mixed li;
            Mixed dni;
            if (ma.containsKey("display") && !((dni = ma.get("display", t)) instanceof CNull)) {
                meta.setDisplayName(dni.val());
            }
            if (ma.containsKey("lore") && !((li = ma.get("lore", t)) instanceof CNull)) {
                if (li.isInstanceOf(CString.TYPE)) {
                    ArrayList<String> ll = new ArrayList<String>();
                    ll.add(li.val());
                    meta.setLore(ll);
                } else {
                    if (!li.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Lore was expected to be an array or a string.", t);
                    CArray la = (CArray)li;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int j = 0;
                    while ((long)j < la.size()) {
                        arrayList.add(la.get(j, t).val());
                        ++j;
                    }
                    meta.setLore(arrayList);
                }
            }
            if (ma.containsKey("enchants")) {
                Mixed enchants = ma.get("enchants", t);
                if (!enchants.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Enchants field was expected to be an array of Enchantment arrays", t);
                for (Map.Entry entry : this.enchants((CArray)enchants, t).entrySet()) {
                    meta.addEnchant((MCEnchantment)entry.getKey(), (Integer)entry.getValue(), true);
                }
            }
            if (ma.containsKey("repair") && !((r = ma.get("repair", t)) instanceof CNull)) {
                meta.setRepairCost(ArgumentValidation.getInt32(r, t));
            }
            if (ma.containsKey("model") && !((m = ma.get("model", t)) instanceof CNull)) {
                meta.setCustomModelData(ArgumentValidation.getInt32(m, t));
            }
            if (ma.containsKey("flags")) {
                void var9_14;
                Mixed flags = ma.get("flags", t);
                if (!flags.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Itemflags was expected to be an array of flags.", t);
                CArray flagArray = (CArray)flags;
                boolean bl = false;
                while ((long)var9_14 < flagArray.size()) {
                    Mixed flag = flagArray.get((int)var9_14, t);
                    meta.addItemFlags(MCItemFlag.valueOf(flag.val().toUpperCase()));
                    ++var9_14;
                }
            }
            if (ma.containsKey("modifiers") && !((modifiers = ma.get("modifiers", t)) instanceof CNull)) {
                if (!modifiers.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Attribute modifiers were expected to be an array.", t);
                CArray modifierArray = (CArray)modifiers;
                if (modifierArray.isAssociative()) {
                    throw new CREFormatException("Array of attribute modifiers cannot be associative.", t);
                }
                ArrayList<MCAttributeModifier> arrayList = new ArrayList<MCAttributeModifier>();
                for (String key : modifierArray.stringKeySet()) {
                    arrayList.add(this.attributeModifier(ArgumentValidation.getArray(modifierArray.get(key, t), t), t));
                }
                meta.setAttributeModifiers(arrayList);
            }
            if (ma.containsKey("tags") && !((tagArray = ma.get("tags", t)) instanceof CNull)) {
                MCTagType.TAG_CONTAINER.convert(meta.getCustomTags(), tagArray);
            }
            if (mat.getMaxDurability() > 0) {
                if (ma.containsKey("damage")) {
                    meta.setDamage(ArgumentValidation.getInt32(ma.get("damage", t), t));
                }
                if (ma.containsKey("unbreakable")) {
                    meta.setUnbreakable(ArgumentValidation.getBoolean(ma.get("unbreakable", t), t));
                }
            } else if (ma.containsKey("blockdata") && (mBlockData = ma.get("blockdata", t)) instanceof CArray) {
                meta.setBlockData(this.blockData((CArray)mBlockData, mat, t));
            }
            if (meta instanceof MCBlockStateMeta) {
                MCBlockStateMeta bsm = (MCBlockStateMeta)meta;
                MCBlockState bs = bsm.getBlockState();
                if (bs instanceof MCBanner) {
                    MCBanner banner = (MCBanner)bs;
                    if (!ma.containsKey("basecolor")) return meta;
                    String baseString = ma.get("basecolor", t).val().toUpperCase();
                    try {
                        banner.setBaseColor(MCDyeColor.valueOf(baseString));
                    }
                    catch (IllegalArgumentException ex) {
                        if (!baseString.equals("SILVER")) throw ex;
                        banner.setBaseColor(MCDyeColor.LIGHT_GRAY);
                    }
                    if (ma.containsKey("patterns")) {
                        CArray array2 = ArgumentValidation.getArray(ma.get("patterns", t), t);
                        for (String key : array2.stringKeySet()) {
                            CArray pattern = ArgumentValidation.getArray(array2.get(key, t), t);
                            MCPatternShape shape = MCPatternShape.valueOf(pattern.get("shape", t).val().toUpperCase());
                            String color2 = pattern.get("color", t).val().toUpperCase();
                            try {
                                MCDyeColor dyecolor = MCDyeColor.valueOf(color2);
                                banner.addPattern(StaticLayer.GetConvertor().GetPattern(dyecolor, shape));
                            }
                            catch (IllegalArgumentException ex) {
                                if (!color2.equals("SILVER")) throw ex;
                                banner.addPattern(StaticLayer.GetConvertor().GetPattern(MCDyeColor.LIGHT_GRAY, shape));
                            }
                        }
                    }
                    bsm.setBlockState(banner);
                    return meta;
                }
                if (bs instanceof MCCreatureSpawner) {
                    Mixed m2;
                    MCCreatureSpawner mccs = (MCCreatureSpawner)bs;
                    if (ma.containsKey("spawntype") && (m2 = ma.get("spawntype", t)) != CNull.NULL) {
                        MCEntityType type = MCEntityType.valueOf(m2.val().toUpperCase());
                        mccs.setSpawnedType(type);
                    }
                    if (ma.containsKey("delay")) {
                        int delay = ArgumentValidation.getInt32(ma.get("delay", t), t);
                        mccs.setDelay(delay);
                    }
                    if (ma.containsKey("mindelay")) {
                        int delay = ArgumentValidation.getInt32(ma.get("mindelay", t), t);
                        mccs.setMinDelay(delay);
                    }
                    if (ma.containsKey("maxdelay")) {
                        int delay = ArgumentValidation.getInt32(ma.get("maxdelay", t), t);
                        mccs.setMaxDelay(delay);
                    }
                    if (ma.containsKey("spawncount")) {
                        int count = ArgumentValidation.getInt32(ma.get("spawncount", t), t);
                        mccs.setSpawnCount(count);
                    }
                    if (ma.containsKey("maxnearbyentities")) {
                        int max2 = ArgumentValidation.getInt32(ma.get("maxnearbyentities", t), t);
                        mccs.setMaxNearbyEntities(max2);
                    }
                    if (ma.containsKey("spawnrange")) {
                        int range2 = ArgumentValidation.getInt32(ma.get("spawnrange", t), t);
                        mccs.setSpawnRange(range2);
                    }
                    if (ma.containsKey("playerrange")) {
                        int range3 = ArgumentValidation.getInt32(ma.get("playerrange", t), t);
                        mccs.setPlayerRange(range3);
                    }
                    bsm.setBlockState(bs);
                    return meta;
                } else if (bs instanceof MCBrewingStand) {
                    MCBrewingStand brewStand = (MCBrewingStand)bs;
                    if (ma.containsKey("brewtime")) {
                        brewStand.setBrewingTime(ArgumentValidation.getInt32(ma.get("brewtime", t), t));
                    }
                    if (ma.containsKey("fuel")) {
                        brewStand.setFuelLevel(ArgumentValidation.getInt32(ma.get("fuel", t), t));
                    }
                    if (ma.containsKey("inventory")) {
                        CArray invData = ArgumentValidation.getArray(ma.get("inventory", t), t);
                        MCBrewerInventory inv = brewStand.getInventory();
                        if (invData.containsKey("fuel")) {
                            inv.setFuel(ObjectGenerator.GetGenerator().item(invData.get("fuel", t), t));
                        }
                        if (invData.containsKey("ingredient")) {
                            inv.setIngredient(ObjectGenerator.GetGenerator().item(invData.get("ingredient", t), t));
                        }
                        if (invData.containsKey("leftbottle")) {
                            inv.setLeftBottle(ObjectGenerator.GetGenerator().item(invData.get("leftbottle", t), t));
                        }
                        if (invData.containsKey("middlebottle")) {
                            inv.setMiddleBottle(ObjectGenerator.GetGenerator().item(invData.get("middlebottle", t), t));
                        }
                        if (invData.containsKey("rightbottle")) {
                            inv.setRightBottle(ObjectGenerator.GetGenerator().item(invData.get("rightbottle", t), t));
                        }
                    }
                    bsm.setBlockState(bs);
                    return meta;
                } else if (bs instanceof MCFurnace) {
                    MCFurnace furnace = (MCFurnace)bs;
                    if (ma.containsKey("burntime")) {
                        furnace.setBurnTime(ArgumentValidation.getInt16(ma.get("burntime", t), t));
                    }
                    if (ma.containsKey("cooktime")) {
                        furnace.setCookTime(ArgumentValidation.getInt16(ma.get("cooktime", t), t));
                    }
                    if (ma.containsKey("inventory")) {
                        CArray invData = ArgumentValidation.getArray(ma.get("inventory", t), t);
                        MCFurnaceInventory inv = furnace.getInventory();
                        if (invData.containsKey("result")) {
                            inv.setResult(ObjectGenerator.GetGenerator().item(invData.get("result", t), t));
                        }
                        if (invData.containsKey("fuel")) {
                            inv.setFuel(ObjectGenerator.GetGenerator().item(invData.get("fuel", t), t));
                        }
                        if (invData.containsKey("smelting")) {
                            inv.setSmelting(ObjectGenerator.GetGenerator().item(invData.get("smelting", t), t));
                        }
                    }
                    bsm.setBlockState(bs);
                    return meta;
                } else if (bs instanceof MCDecoratedPot) {
                    MCDecoratedPot mCDecoratedPot = (MCDecoratedPot)bs;
                    if (ma.containsKey("sherds")) {
                        Mixed sherds = ma.get("sherds", t);
                        if (!sherds.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected associative array for decorated pot meta.", t);
                        CArray sherdArray = (CArray)sherds;
                        if (!sherdArray.isAssociative()) {
                            throw new CREFormatException("Expected associative array for decorated pot meta.", t);
                        }
                        for (String key : sherdArray.stringKeySet()) {
                            mCDecoratedPot.setSherd(MCDecoratedPot.Side.valueOf(key.toUpperCase()), MCMaterial.valueOf(sherdArray.get(key, t).val()));
                        }
                    }
                    if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_4) && ma.containsKey("item")) {
                        mCDecoratedPot.setItemStack(this.item(ma.get("item", t), t));
                    }
                    bsm.setBlockState(bs);
                    return meta;
                } else if (bs instanceof MCInventoryHolder) {
                    if (!ma.containsKey("inventory")) return meta;
                    MCInventory inv = ((MCInventoryHolder)((Object)bs)).getInventory();
                    Mixed cInvRaw = ma.get("inventory", t);
                    if (cInvRaw.isInstanceOf(CArray.TYPE)) {
                        CArray cinv = (CArray)cInvRaw;
                        for (String key : cinv.stringKeySet()) {
                            try {
                                int index = Integer.parseInt(key);
                                if (index < 0 || index >= inv.getSize()) {
                                    ConfigRuntimeException.DoWarning("Out of range value (" + index + ") found in " + bs.getClass().getSimpleName().replaceFirst("MC", "") + " inventory array, so ignoring.");
                                }
                                MCItemStack is = ObjectGenerator.GetGenerator().item(cinv.get(key, t), t);
                                inv.setItem(index, is);
                            }
                            catch (NumberFormatException ex) {
                                ConfigRuntimeException.DoWarning("Expecting integer value for key in " + bs.getClass().getSimpleName().replaceFirst("MC", "") + " inventory array, but \"" + key + "\" was found. Ignoring.");
                            }
                        }
                        bsm.setBlockState(bs);
                        return meta;
                    } else {
                        if (cInvRaw instanceof CNull) return meta;
                        throw new CREFormatException(bs.getClass().getSimpleName().replaceFirst("MC", "") + " inventory expected to be an array or null.", t);
                    }
                } else if (bs instanceof MCSign) {
                    MCSignText backText;
                    Mixed dye;
                    MCSign sign = (MCSign)bs;
                    if (ma.containsKey("waxed")) {
                        sign.setWaxed(ArgumentValidation.getBooleanObject(ma.get("waxed", t), t));
                    }
                    if (ma.containsKey("signtext")) {
                        Mixed possibleLines = ma.get("signtext", t);
                        if (!possibleLines.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected array for sign text", t);
                        CArray lines = (CArray)possibleLines;
                        int i = 0;
                        while ((long)i < lines.size()) {
                            sign.setLine(i, lines.get(i, t).val());
                            ++i;
                        }
                    }
                    if (ma.containsKey("glowing")) {
                        sign.setGlowingText(ArgumentValidation.getBooleanObject(ma.get("glowing", t), t));
                    }
                    if (ma.containsKey("color") && !((dye = ma.get("color", t)) instanceof CNull)) {
                        sign.setDyeColor(MCDyeColor.valueOf(dye.val()));
                    }
                    if ((backText = sign.getBackText()) != null) {
                        Mixed dye2;
                        if (ma.containsKey("backtext")) {
                            Mixed possibleLines = ma.get("backtext", t);
                            if (!possibleLines.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected array for sign back text", t);
                            CArray lines = (CArray)possibleLines;
                            int i = 0;
                            while ((long)i < lines.size()) {
                                backText.setLine(i, lines.get(i, t).val());
                                ++i;
                            }
                        }
                        if (ma.containsKey("backglowing")) {
                            backText.setGlowingText(ArgumentValidation.getBooleanObject(ma.get("backglowing", t), t));
                        }
                        if (ma.containsKey("backcolor") && !((dye2 = ma.get("backcolor", t)) instanceof CNull)) {
                            backText.setDyeColor(MCDyeColor.valueOf(dye2.val()));
                        }
                    }
                    bsm.setBlockState(bs);
                    return meta;
                } else {
                    if (!(bs instanceof MCCommandBlock)) return meta;
                    MCCommandBlock cmdBlock = (MCCommandBlock)bs;
                    if (ma.containsKey("command")) {
                        cmdBlock.setCommand(ma.get("command", t).val());
                    }
                    if (ma.containsKey("customname")) {
                        cmdBlock.setName(ma.get("customname", t).val());
                    }
                    bsm.setBlockState(bs);
                    return meta;
                }
            }
            if (meta instanceof MCArmorMeta) {
                Mixed ci;
                Mixed mtrim;
                MCArmorMeta armorMeta = (MCArmorMeta)meta;
                if (ma.containsKey("trim") && !((mtrim = ma.get("trim", t)) instanceof CNull)) {
                    if (!mtrim.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected an array or null for armor trim meta.", t);
                    CArray trim2 = (CArray)mtrim;
                    if (!trim2.isAssociative()) {
                        throw new CREFormatException("Expected associative array for armor trim meta.", t);
                    }
                    MCTrimPattern mCTrimPattern = MCTrimPattern.valueOf(trim2.get("pattern", t).val());
                    MCTrimMaterial material = MCTrimMaterial.valueOf(trim2.get("material", t).val());
                    armorMeta.setTrim(mCTrimPattern, material);
                }
                if (!(armorMeta instanceof MCColorableArmorMeta) || !ma.containsKey("color") || (ci = ma.get("color", t)) instanceof CNull) return meta;
                if (!ci.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Color was expected to be an array.", t);
                ((MCColorableArmorMeta)armorMeta).setColor(this.color((CArray)ci, t));
                return meta;
            } else if (meta instanceof MCFireworkEffectMeta) {
                MCFireworkEffectMeta femeta = (MCFireworkEffectMeta)meta;
                if (!ma.containsKey("effect")) return meta;
                Mixed cfem = ma.get("effect", t);
                if (cfem.isInstanceOf(CArray.TYPE)) {
                    femeta.setEffect(this.fireworkEffect((CArray)cfem, t));
                    return meta;
                } else {
                    if (cfem instanceof CNull) return meta;
                    throw new CREFormatException("FireworkCharge effect was expected to be an array or null.", t);
                }
            } else if (meta instanceof MCFireworkMeta) {
                MCFireworkMeta fmeta = (MCFireworkMeta)meta;
                if (!ma.containsKey("firework")) return meta;
                Mixed construct = ma.get("firework", t);
                if (!construct.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Firework was expected to be an array.", t);
                CArray cArray = (CArray)construct;
                if (cArray.containsKey("strength")) {
                    fmeta.setStrength(ArgumentValidation.getInt32(cArray.get("strength", t), t));
                }
                if (cArray.containsKey("effects")) {
                    Mixed effects = cArray.get("effects", t);
                    if (!effects.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Firework effects was expected to be an array.", t);
                    for (Mixed effect : ((CArray)effects).asList()) {
                        if (!effect.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Firework effect was expected to be an array.", t);
                        fmeta.addEffect(this.fireworkEffect((CArray)effect, t));
                    }
                    return meta;
                } else {
                    fmeta.addEffect(this.fireworkEffect(cArray, t));
                }
                return meta;
            } else if (meta instanceof MCLeatherArmorMeta) {
                Mixed ci;
                if (!ma.containsKey("color") || (ci = ma.get("color", t)) instanceof CNull) return meta;
                if (!ci.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Color was expected to be an array.", t);
                ((MCLeatherArmorMeta)meta).setColor(this.color((CArray)ci, t));
                return meta;
            } else if (meta instanceof MCBookMeta) {
                Mixed pages;
                Mixed author;
                Mixed title2;
                MCBookMeta bookMeta = (MCBookMeta)meta;
                bookMeta.setTitle("");
                bookMeta.setAuthor("");
                if (ma.containsKey("title") && !((title2 = ma.get("title", t)) instanceof CNull)) {
                    bookMeta.setTitle(title2.val());
                }
                if (ma.containsKey("author") && !((author = ma.get("author", t)) instanceof CNull)) {
                    bookMeta.setAuthor(author.val());
                }
                if (ma.containsKey("generation")) {
                    Mixed generation = ma.get("generation", t);
                    bookMeta.setGeneration(MCBookMeta.Generation.valueOf(generation.val()));
                }
                if (!ma.containsKey("pages") || (pages = ma.get("pages", t)) instanceof CNull) return meta;
                if (!pages.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Pages field was expected to be an array.", t);
                CArray pa = (CArray)pages;
                ArrayList<String> arrayList = new ArrayList<String>();
                int j = 0;
                while ((long)j < pa.size()) {
                    arrayList.add(pa.get(j, t).val());
                    ++j;
                }
                bookMeta.setPages(arrayList);
                return meta;
            } else if (meta instanceof MCSkullMeta) {
                Mixed mixed;
                String name = null;
                Iterator<Object> id = null;
                if (ma.containsKey("owner")) {
                    name = Construct.nval(ma.get("owner", t));
                }
                if (ma.containsKey("owneruuid") && (mixed = ma.get("owneruuid", t)) instanceof CString) {
                    id = Static.GetUUID(mixed, t);
                }
                if ((name == null || name.isEmpty()) && id == null) return meta;
                MCPlayerProfile mCPlayerProfile = Static.getServer().getPlayerProfile((UUID)((Object)id), name);
                if (mCPlayerProfile != null) {
                    Mixed texture;
                    if (ma.containsKey("texture") && (texture = ma.get("texture", t)) instanceof CString) {
                        mCPlayerProfile.setProperty(new MCProfileProperty("textures", texture.val(), null));
                    }
                    ((MCSkullMeta)meta).setProfile(mCPlayerProfile);
                    return meta;
                } else {
                    MCOfflinePlayer ofp = null;
                    if (id != null) {
                        ofp = Static.getServer().getOfflinePlayer((UUID)((Object)id));
                    }
                    if (ofp != null) {
                        ((MCSkullMeta)meta).setOwningPlayer(ofp);
                        return meta;
                    } else {
                        if (name == null || name.isEmpty()) return meta;
                        ((MCSkullMeta)meta).setOwner(name);
                        return meta;
                    }
                }
            } else if (meta instanceof MCEnchantmentStorageMeta) {
                Mixed stored;
                if (!ma.containsKey("stored") || (stored = ma.get("stored", t)) instanceof CNull) return meta;
                if (!stored.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Stored field was expected to be an array of Enchantment arrays", t);
                for (Map.Entry entry : this.enchants((CArray)stored, t).entrySet()) {
                    ((MCEnchantmentStorageMeta)meta).addStoredEnchant((MCEnchantment)entry.getKey(), (Integer)entry.getValue(), true);
                }
                return meta;
            } else if (meta instanceof MCPotionMeta) {
                Mixed potiondata;
                if (ma.containsKey("potions")) {
                    Mixed effects = ma.get("potions", t);
                    if (!effects.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Effects was expected to be an array of potion arrays.", t);
                    for (MCLivingEntity.MCEffect mCEffect : this.potions((CArray)effects, t)) {
                        ((MCPotionMeta)meta).addCustomEffect(mCEffect.getPotionEffectType(), mCEffect.getStrength(), mCEffect.getTicksRemaining(), mCEffect.isAmbient(), mCEffect.hasParticles(), mCEffect.showIcon(), true, t);
                    }
                }
                if (ma.containsKey("potiontype") && Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_2)) {
                    Mixed potiontype = ma.get("potiontype", t);
                    if (!(potiontype instanceof CNull)) {
                        ((MCPotionMeta)meta).setBasePotionType(MCPotionType.valueOf(potiontype.val()));
                    }
                } else if (ma.containsKey("base") && (potiondata = ma.get("base", t)).isInstanceOf(CArray.TYPE)) {
                    if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                        ((MCPotionMeta)meta).setBasePotionType(this.legacyPotionData((CArray)potiondata, t));
                    } else {
                        ((MCPotionMeta)meta).setBasePotionData(this.potionData((CArray)potiondata, t));
                    }
                }
                if (!ma.containsKey("color")) return meta;
                Mixed color3 = ma.get("color", t);
                if (color3.isInstanceOf(CArray.TYPE)) {
                    ((MCPotionMeta)meta).setColor(this.color((CArray)color3, t));
                    return meta;
                } else {
                    if (!color3.isInstanceOf(CString.TYPE)) return meta;
                    ((MCPotionMeta)meta).setColor(StaticLayer.GetConvertor().GetColor(color3.val(), t));
                    return meta;
                }
            } else if (meta instanceof MCSuspiciousStewMeta) {
                if (!ma.containsKey("potions")) return meta;
                Mixed effects = ma.get("potions", t);
                if (!effects.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Expected an array of potion arrays.", t);
                for (MCLivingEntity.MCEffect mCEffect : this.potions((CArray)effects, t)) {
                    ((MCSuspiciousStewMeta)meta).addCustomEffect(mCEffect.getPotionEffectType(), mCEffect.getStrength(), mCEffect.getTicksRemaining(), mCEffect.isAmbient(), mCEffect.hasParticles(), mCEffect.showIcon(), true, t);
                }
                return meta;
            } else if (meta instanceof MCBannerMeta) {
                if (!ma.containsKey("patterns")) return meta;
                CArray array3 = ArgumentValidation.getArray(ma.get("patterns", t), t);
                for (String string : array3.stringKeySet()) {
                    CArray pattern = ArgumentValidation.getArray(array3.get(string, t), t);
                    MCPatternShape shape = MCPatternShape.valueOf(pattern.get("shape", t).val().toUpperCase());
                    String color4 = pattern.get("color", t).val().toUpperCase();
                    try {
                        MCDyeColor dyecolor = MCDyeColor.valueOf(color4);
                        ((MCBannerMeta)meta).addPattern(StaticLayer.GetConvertor().GetPattern(dyecolor, shape));
                    }
                    catch (IllegalArgumentException ex) {
                        if (!color4.equals("SILVER")) throw ex;
                        ((MCBannerMeta)meta).addPattern(StaticLayer.GetConvertor().GetPattern(MCDyeColor.LIGHT_GRAY, shape));
                    }
                }
                return meta;
            } else if (meta instanceof MCMapMeta) {
                Mixed cid;
                if (ma.containsKey("color")) {
                    Mixed ci = ma.get("color", t);
                    if (ci.isInstanceOf(CArray.TYPE)) {
                        ((MCMapMeta)meta).setColor(this.color((CArray)ci, t));
                    } else if (!(ci instanceof CNull)) {
                        throw new CREFormatException("Color was expected to be an array.", t);
                    }
                }
                if (!ma.containsKey("mapid") || (cid = ma.get("mapid", t)) instanceof CNull) return meta;
                ((MCMapMeta)meta).setMapId(ArgumentValidation.getInt32(cid, t));
                return meta;
            } else if (meta instanceof MCTropicalFishBucketMeta) {
                Mixed pa;
                Mixed fishcolor;
                MCDyeColor color5;
                Mixed patterncolor;
                if (ma.containsKey("fishpatterncolor") && !((patterncolor = ma.get("fishpatterncolor", t)) instanceof CNull)) {
                    color5 = MCDyeColor.valueOf(patterncolor.val().toUpperCase());
                    ((MCTropicalFishBucketMeta)meta).setPatternColor(color5);
                }
                if (ma.containsKey("fishcolor") && !((fishcolor = ma.get("fishcolor", t)) instanceof CNull)) {
                    color5 = MCDyeColor.valueOf(fishcolor.val().toUpperCase());
                    ((MCTropicalFishBucketMeta)meta).setBodyColor(color5);
                }
                if (!ma.containsKey("fishpattern") || (pa = ma.get("fishpattern", t)) instanceof CNull) return meta;
                MCTropicalFish.MCPattern pattern = MCTropicalFish.MCPattern.valueOf(pa.val().toUpperCase());
                ((MCTropicalFishBucketMeta)meta).setPattern(pattern);
                return meta;
            } else if (meta instanceof MCCrossbowMeta) {
                Mixed value;
                if (!ma.containsKey("projectiles") || (value = ma.get("projectiles", t)) instanceof CNull) return meta;
                ArrayList<MCItemStack> projectiles = new ArrayList<MCItemStack>();
                for (Mixed m3 : ArgumentValidation.getArray(value, t).asList()) {
                    projectiles.add(this.item(m3, t));
                }
                ((MCCrossbowMeta)meta).setChargedProjectiles(projectiles);
                return meta;
            } else if (meta instanceof MCCompassMeta) {
                Mixed loc;
                if (ma.containsKey("target") && !((loc = ma.get("target", t)) instanceof CNull)) {
                    ((MCCompassMeta)meta).setTargetLocation(this.location(loc, null, t));
                }
                if (!ma.containsKey("lodestone")) return meta;
                ((MCCompassMeta)meta).setLodestoneTracked(ArgumentValidation.getBooleanObject(ma.get("lodestone", t), t));
                return meta;
            } else if (meta instanceof MCBundleMeta) {
                if (!ma.containsKey("items")) return meta;
                Mixed value = ma.get("items", t);
                if (value instanceof CArray) {
                    MCBundleMeta bm = (MCBundleMeta)meta;
                    CArray cArray = (CArray)value;
                    for (String key : cArray.stringKeySet()) {
                        Mixed entry = cArray.get(key, t);
                        if (entry instanceof CNull) continue;
                        bm.addItem(ObjectGenerator.GetGenerator().item(entry, t));
                    }
                    return meta;
                } else {
                    if (value instanceof CNull) return meta;
                    throw new CREFormatException("Items was expected to be an array or null.", t);
                }
            } else if (meta instanceof MCAxolotlBucketMeta) {
                Mixed value;
                if (!ma.containsKey("variant") || (value = ma.get("variant", t)) instanceof CNull) return meta;
                ((MCAxolotlBucketMeta)meta).setAxolotlType(MCAxolotlType.valueOf(value.val().toUpperCase()));
                return meta;
            } else if (meta instanceof MCMusicInstrumentMeta) {
                Mixed value;
                if (!ma.containsKey("instrument") || (value = ma.get("instrument", t)) instanceof CNull) return meta;
                ((MCMusicInstrumentMeta)meta).setInstrument(value.val());
                return meta;
            } else {
                if (!(meta instanceof MCKnowledgeBookMeta)) return meta;
                MCKnowledgeBookMeta mCKnowledgeBookMeta = (MCKnowledgeBookMeta)meta;
                if (!ma.containsKey("recipes")) return meta;
                Mixed value = ma.get("recipes", t);
                if (value.isInstanceOf(CArray.TYPE)) {
                    CArray array4 = (CArray)value;
                    ArrayList<MCNamespacedKey> arrayList = new ArrayList<MCNamespacedKey>((int)array4.size());
                    for (Mixed entry : ((CArray)value).asList()) {
                        arrayList.add(StaticLayer.GetConvertor().GetNamespacedKey(entry.val()));
                    }
                    mCKnowledgeBookMeta.setRecipes(arrayList);
                    return meta;
                } else {
                    if (value instanceof CNull) return meta;
                    throw new CREFormatException("Expected array or null for recipes but got " + value.val(), t);
                }
            }
        }
        catch (Exception ex) {
            throw new CREFormatException(ex.getMessage(), t, ex);
        }
    }

    public CArray exception(ConfigRuntimeException e, Environment env, Target t) {
        AbstractCREException ex = AbstractCREException.getAbstractCREException(e);
        return ex.getExceptionObject();
    }

    public AbstractCREException exception(CArray exception, Target t, Environment env) throws ClassNotFoundException {
        return AbstractCREException.getFromCArray(exception, t, env);
    }

    public CArray color(MCColor color2, Target t) {
        CArray ca = CArray.GetAssociativeArray(t);
        ca.set("r", (Mixed)new CInt(color2.getRed(), t), t);
        ca.set("g", (Mixed)new CInt(color2.getGreen(), t), t);
        ca.set("b", (Mixed)new CInt(color2.getBlue(), t), t);
        return ca;
    }

    public MCColor color(CArray color2, Target t) {
        int red = color2.containsKey("r") ? ArgumentValidation.getInt32(color2.get("r", t), t) : (color2.containsKey("red") ? ArgumentValidation.getInt32(color2.get("red", t), t) : ArgumentValidation.getInt32(color2.get(0, t), t));
        int green = color2.containsKey("g") ? ArgumentValidation.getInt32(color2.get("g", t), t) : (color2.containsKey("green") ? ArgumentValidation.getInt32(color2.get("green", t), t) : ArgumentValidation.getInt32(color2.get(1, t), t));
        int blue = color2.containsKey("b") ? ArgumentValidation.getInt32(color2.get("b", t), t) : (color2.containsKey("blue") ? ArgumentValidation.getInt32(color2.get("blue", t), t) : ArgumentValidation.getInt32(color2.get(2, t), t));
        try {
            return StaticLayer.GetConvertor().GetColor(red, green, blue);
        }
        catch (IllegalArgumentException ex) {
            throw new CRERangeException(ex.getMessage(), t, ex);
        }
    }

    public CArray vector(Vector3D vector) {
        return this.vector(vector, Target.UNKNOWN);
    }

    public CArray vector(Vector3D vector, Target t) {
        CArray ca = CArray.GetAssociativeArray(t);
        ca.set(0, (Mixed)new CDouble(vector.X(), t), t);
        ca.set(1, (Mixed)new CDouble(vector.Y(), t), t);
        ca.set(2, (Mixed)new CDouble(vector.Z(), t), t);
        ca.set("x", (Mixed)new CDouble(vector.X(), t), t);
        ca.set("y", (Mixed)new CDouble(vector.Y(), t), t);
        ca.set("z", (Mixed)new CDouble(vector.Z(), t), t);
        return ca;
    }

    public Vector3D vector(Mixed c, Target t) {
        return this.vector(Vector3D.ZERO, c, t);
    }

    public Vector3D vector(Vector3D v, Mixed c, Target t) {
        if (c.isInstanceOf(CArray.TYPE)) {
            CArray va = (CArray)c;
            double x = v.X();
            double y = v.Y();
            double z = v.Z();
            if (!va.isAssociative()) {
                if (va.size() == 3L) {
                    x = ArgumentValidation.getNumber(va.get(0, t), t);
                    y = ArgumentValidation.getNumber(va.get(1, t), t);
                    z = ArgumentValidation.getNumber(va.get(2, t), t);
                } else if (va.size() == 2L) {
                    x = ArgumentValidation.getNumber(va.get(0, t), t);
                    y = ArgumentValidation.getNumber(va.get(1, t), t);
                } else if (va.size() == 1L) {
                    x = ArgumentValidation.getNumber(va.get(0, t), t);
                }
            } else {
                if (va.containsKey("x")) {
                    x = ArgumentValidation.getNumber(va.get("x", t), t);
                }
                if (va.containsKey("y")) {
                    y = ArgumentValidation.getNumber(va.get("y", t), t);
                }
                if (va.containsKey("z")) {
                    z = ArgumentValidation.getNumber(va.get("z", t), t);
                }
            }
            return new Vector3D(x, y, z);
        }
        if (c instanceof CNull) {
            return v;
        }
        throw new CREFormatException("Expecting an array, received " + c.typeof().getSimpleName(), t);
    }

    public CArray enchants(Map<MCEnchantment, Integer> map, Target t) {
        CArray ret = CArray.GetAssociativeArray(t);
        for (Map.Entry<MCEnchantment, Integer> entry : map.entrySet()) {
            CArray enchant = CArray.GetAssociativeArray(t);
            enchant.set("elevel", (Mixed)new CInt(entry.getValue().intValue(), t), t);
            ret.set(entry.getKey().name().toLowerCase(), (Mixed)enchant, t);
        }
        return ret;
    }

    public Map<MCEnchantment, Integer> enchants(CArray enchantArray, Target t) {
        HashMap<MCEnchantment, Integer> ret = new HashMap<MCEnchantment, Integer>();
        for (String key : enchantArray.stringKeySet()) {
            String setype;
            MCEnchantment etype = null;
            Mixed value = enchantArray.get(key, t);
            if (enchantArray.isAssociative()) {
                try {
                    etype = MCEnchantment.valueOf(key.toUpperCase());
                    if (value.isInstanceOf(CInt.TYPE)) {
                        ret.put(etype, ArgumentValidation.getInt32(value, t));
                        continue;
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new CREEnchantmentException("Unknown enchantment type: " + key, t);
                }
            }
            if (!value.isInstanceOf(CArray.TYPE)) continue;
            CArray ea = (CArray)value;
            if (etype == null && (etype = MCEnchantment.valueOf(setype = ea.get("etype", t).val())) == null) {
                throw new CREEnchantmentException("Unknown enchantment type: " + setype, t);
            }
            int elevel = ArgumentValidation.getInt32(ea.get("elevel", t), t);
            ret.put(etype, elevel);
        }
        return ret;
    }

    public CArray attributeModifier(MCAttributeModifier m, Target t) {
        MCEquipmentSlot equipmentSlot;
        MCEquipmentSlotGroup equipmentSlotGroup;
        CArray modifier = CArray.GetAssociativeArray(t);
        modifier.set("attribute", m.getAttribute().name());
        modifier.set("name", m.getAttributeName());
        modifier.set("operation", m.getOperation().name());
        modifier.set("uuid", m.getUniqueId().toString());
        modifier.set("amount", (Mixed)new CDouble(m.getAmount(), t), t);
        Construct slot = CNull.NULL;
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6) && (equipmentSlotGroup = m.getEquipmentSlotGroup()) != null) {
            slot = new CString(equipmentSlotGroup.name(), t);
        }
        if (slot == CNull.NULL && (equipmentSlot = m.getEquipmentSlot()) != null) {
            slot = new CString(equipmentSlot.name(), t);
        }
        modifier.set("slot", (Mixed)slot, t);
        return modifier;
    }

    public MCAttributeModifier attributeModifier(CArray m, Target t) {
        Mixed s;
        MCAttributeModifier.Operation operation;
        MCAttribute attribute;
        if (!m.isAssociative()) {
            throw new CREFormatException("Attribute modifier array must be associative.", t);
        }
        UUID uuid2 = null;
        String name = "";
        MCEquipmentSlot slot = null;
        try {
            attribute = MCAttribute.valueOf(m.get("attribute", t).val());
        }
        catch (IllegalArgumentException ex) {
            throw new CREFormatException("Invalid attribute name: " + String.valueOf(m.get("attribute", t)), t);
        }
        try {
            operation = MCAttributeModifier.Operation.valueOf(m.get("operation", t).val());
        }
        catch (IllegalArgumentException ex) {
            throw new CREFormatException("Invalid operation name: " + String.valueOf(m.get("operation", t)), t);
        }
        double amount = ArgumentValidation.getDouble(m.get("amount", t), t);
        if (m.containsKey("name")) {
            name = m.get("name", t).val();
        }
        if (m.containsKey("uuid")) {
            try {
                uuid2 = UUID.fromString(m.get("uuid", t).val());
            }
            catch (IllegalArgumentException ex) {
                throw new CREFormatException("Invalid UUID format: " + String.valueOf(m.get("uuid", t)), t);
            }
        }
        if (m.containsKey("slot") && !((s = m.get("slot", t)) instanceof CNull)) {
            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                MCEquipmentSlotGroup slotGroup = null;
                if (s.val().equals("ANY")) {
                    slotGroup = MCEquipmentSlotGroup.ANY;
                } else if (s.val().equals("HAND")) {
                    slotGroup = MCEquipmentSlotGroup.HAND;
                } else if (s.val().equals("ARMOR")) {
                    slotGroup = MCEquipmentSlotGroup.ARMOR;
                }
                if (slotGroup != null) {
                    return StaticLayer.GetConvertor().GetAttributeModifier(attribute, uuid2, name, amount, operation, slotGroup);
                }
            }
            try {
                slot = MCEquipmentSlot.valueOf(s.val());
            }
            catch (IllegalArgumentException ex) {
                throw new CREFormatException("Invalid equipment slot name: " + String.valueOf(m.get("slot", t)), t);
            }
        }
        return StaticLayer.GetConvertor().GetAttributeModifier(attribute, uuid2, name, amount, operation, slot);
    }

    public CArray potion(MCLivingEntity.MCEffect eff, Target t) {
        CArray effect = CArray.GetAssociativeArray(t);
        effect.set("id", (Mixed)new CInt(eff.getPotionEffectType().getId(), t), t);
        effect.set("strength", (Mixed)new CInt(eff.getStrength(), t), t);
        effect.set("seconds", (Mixed)new CDouble((double)eff.getTicksRemaining() / 20.0, t), t);
        effect.set("ambient", (Mixed)CBoolean.get(eff.isAmbient()), t);
        effect.set("particles", (Mixed)CBoolean.get(eff.hasParticles()), t);
        effect.set("icon", (Mixed)CBoolean.get(eff.showIcon()), t);
        return effect;
    }

    public CArray potions(List<MCLivingEntity.MCEffect> effectList, Target t) {
        CArray ea = CArray.GetAssociativeArray(t);
        for (MCLivingEntity.MCEffect eff : effectList) {
            CArray effect = this.potion(eff, t);
            ea.set(eff.getPotionEffectType().name().toLowerCase(), (Mixed)effect, t);
        }
        return ea;
    }

    public List<MCLivingEntity.MCEffect> potions(CArray ea, Target t) {
        ArrayList<MCLivingEntity.MCEffect> ret = new ArrayList<MCLivingEntity.MCEffect>();
        for (String key : ea.stringKeySet()) {
            if (ea.get(key, t).isInstanceOf(CArray.TYPE)) {
                MCPotionEffectType type;
                boolean icon;
                boolean particles;
                boolean ambient;
                double seconds;
                int strength;
                CArray effect;
                block11: {
                    effect = (CArray)ea.get(key, t);
                    strength = 0;
                    seconds = 30.0;
                    ambient = false;
                    particles = true;
                    icon = true;
                    try {
                        if (ea.isAssociative()) {
                            type = MCPotionEffectType.valueOf(key.toUpperCase());
                            break block11;
                        }
                        if (effect.containsKey("id")) {
                            type = MCPotionEffectType.getById(ArgumentValidation.getInt32(effect.get("id", t), t));
                            break block11;
                        }
                        throw new CREFormatException("No potion type was given.", t);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new CREFormatException(ex.getMessage(), t);
                    }
                }
                if (effect.containsKey("strength")) {
                    strength = ArgumentValidation.getInt32(effect.get("strength", t), t);
                }
                if (effect.containsKey("seconds") && (seconds = ArgumentValidation.getDouble(effect.get("seconds", t), t)) * 20.0 > 2.147483647E9) {
                    throw new CRERangeException("Seconds cannot be greater than 107374182", t);
                }
                if (effect.containsKey("ambient")) {
                    ambient = ArgumentValidation.getBoolean(effect.get("ambient", t), t);
                }
                if (effect.containsKey("particles")) {
                    particles = ArgumentValidation.getBoolean(effect.get("particles", t), t);
                }
                if (effect.containsKey("icon")) {
                    icon = ArgumentValidation.getBoolean(effect.get("icon", t), t);
                }
                ret.add(new MCLivingEntity.MCEffect(type, strength, (int)(seconds * 20.0), ambient, particles, icon));
                continue;
            }
            throw new CREFormatException("Expected a potion array at index" + key, t);
        }
        return ret;
    }

    public CArray potionData(MCPotionData mcpd, Target t) {
        CArray base = CArray.GetAssociativeArray(t);
        base.set("type", mcpd.getType().name(), t);
        base.set("extended", (Mixed)CBoolean.get(mcpd.isExtended()), t);
        base.set("upgraded", (Mixed)CBoolean.get(mcpd.isUpgraded()), t);
        return base;
    }

    public MCPotionData potionData(CArray pd, Target t) {
        MCPotionType type;
        try {
            type = MCPotionType.valueOf(pd.get("type", t).val().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new CREFormatException("Invalid potion type: " + pd.get("type", t).val(), t);
        }
        boolean extended = false;
        boolean upgraded = false;
        if (pd.containsKey("extended")) {
            Mixed cext = pd.get("extended", t);
            if (cext.isInstanceOf(CBoolean.TYPE)) {
                extended = ((CBoolean)cext).getBoolean();
            } else {
                throw new CREFormatException("Expected potion value for key \"extended\" to be a boolean", t);
            }
        }
        if (pd.containsKey("upgraded")) {
            Mixed cupg = pd.get("upgraded", t);
            if (cupg.isInstanceOf(CBoolean.TYPE)) {
                upgraded = ((CBoolean)cupg).getBoolean();
            } else {
                throw new CREFormatException("Expected potion value for key \"upgraded\" to be a boolean", t);
            }
        }
        try {
            return StaticLayer.GetPotionData(type, extended, upgraded);
        }
        catch (IllegalArgumentException ex) {
            throw new CREFormatException(ex.getMessage(), t, ex);
        }
    }

    public MCPotionType legacyPotionData(CArray potionArray, Target t) {
        Mixed cupg;
        Mixed cext;
        MCPotionType type;
        try {
            type = MCPotionType.valueOf(potionArray.get("type", t).val().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new CREFormatException("Invalid potion type: " + potionArray.get("type", t).val(), t);
        }
        boolean extended = false;
        boolean upgraded = false;
        if (potionArray.containsKey("extended") && (cext = potionArray.get("extended", t)).isInstanceOf(CBoolean.TYPE)) {
            extended = ((CBoolean)cext).getBoolean();
        }
        if (potionArray.containsKey("upgraded") && (cupg = potionArray.get("upgraded", t)).isInstanceOf(CBoolean.TYPE)) {
            upgraded = ((CBoolean)cupg).getBoolean();
        }
        if (extended) {
            try {
                type = MCPotionType.valueOf("LONG_" + type.name());
            }
            catch (IllegalArgumentException ex) {
                throw new CREFormatException("Could not find extended potion type for: " + potionArray.get("type", t).val(), t);
            }
        }
        if (upgraded) {
            try {
                type = MCPotionType.valueOf("STRONG_" + type.name());
            }
            catch (IllegalArgumentException ex) {
                throw new CREFormatException("Could not find upgraded potion type for: " + potionArray.get("type", t).val(), t);
            }
        }
        return type;
    }

    public CArray fireworkEffect(MCFireworkEffect mcfe, Target t) {
        CArray fe = CArray.GetAssociativeArray(t);
        fe.set("flicker", (Mixed)CBoolean.get(mcfe.hasFlicker()), t);
        fe.set("trail", (Mixed)CBoolean.get(mcfe.hasTrail()), t);
        MCFireworkType type = mcfe.getType();
        if (type != null) {
            fe.set("type", (Mixed)new CString(mcfe.getType().name(), t), t);
        } else {
            fe.set("type", (Mixed)CNull.NULL, t);
        }
        CArray colors = new CArray(t);
        for (MCColor c : mcfe.getColors()) {
            colors.push(ObjectGenerator.GetGenerator().color(c, t), t);
        }
        fe.set("colors", (Mixed)colors, t);
        CArray fadeColors = new CArray(t);
        for (MCColor c : mcfe.getFadeColors()) {
            fadeColors.push(ObjectGenerator.GetGenerator().color(c, t), t);
        }
        fe.set("fade", (Mixed)fadeColors, t);
        return fe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MCFireworkEffect fireworkEffect(CArray fe, Target t) {
        String[] split2;
        CArray ccolors;
        Mixed colors;
        MCFireworkBuilder builder = StaticLayer.GetConvertor().GetFireworkBuilder();
        if (fe.containsKey("flicker")) {
            builder.setFlicker(ArgumentValidation.getBoolean(fe.get("flicker", t), t));
        }
        if (fe.containsKey("trail")) {
            builder.setTrail(ArgumentValidation.getBoolean(fe.get("trail", t), t));
        }
        if (fe.containsKey("colors")) {
            colors = fe.get("colors", t);
            if (colors.isInstanceOf(CArray.TYPE)) {
                ccolors = (CArray)colors;
                if (ccolors.size() == 0L) {
                    builder.addColor(MCColor.WHITE);
                } else {
                    for (Mixed color2 : ccolors.asList()) {
                        MCColor mccolor;
                        if (color2.isInstanceOf(CString.TYPE)) {
                            mccolor = StaticLayer.GetConvertor().GetColor(color2.val(), t);
                        } else {
                            if (!color2.isInstanceOf(CArray.TYPE)) {
                                if (!color2.isInstanceOf(CInt.TYPE) || ccolors.size() != 3L) throw new CREFormatException("Expecting individual color to be an array or string, but found " + String.valueOf(color2.typeof()), t);
                                builder.addColor(this.color(ccolors, t));
                                break;
                            }
                            mccolor = this.color((CArray)color2, t);
                        }
                        builder.addColor(mccolor);
                    }
                }
            } else {
                if (!colors.isInstanceOf(CString.TYPE)) throw new CREFormatException("Expecting an array or string for colors parameter, but found " + String.valueOf(colors.typeof()), t);
                split2 = colors.val().split("\\|");
                if (split2.length == 0) {
                    builder.addColor(MCColor.WHITE);
                } else {
                    for (String string : split2) {
                        builder.addColor(StaticLayer.GetConvertor().GetColor(string, t));
                    }
                }
            }
        } else {
            builder.addColor(MCColor.WHITE);
        }
        if (fe.containsKey("fade")) {
            colors = fe.get("fade", t);
            if (colors.isInstanceOf(CArray.TYPE)) {
                ccolors = (CArray)colors;
                for (Mixed color2 : ccolors.asList()) {
                    MCColor mccolor;
                    if (color2.isInstanceOf(CArray.TYPE)) {
                        mccolor = this.color((CArray)color2, t);
                    } else {
                        if (!color2.isInstanceOf(CString.TYPE)) {
                            if (!color2.isInstanceOf(CInt.TYPE) || ccolors.size() != 3L) throw new CREFormatException("Expecting individual color to be an array or string, but found " + String.valueOf(color2.typeof()), t);
                            builder.addFadeColor(this.color(ccolors, t));
                            break;
                        }
                        mccolor = StaticLayer.GetConvertor().GetColor(color2.val(), t);
                    }
                    builder.addFadeColor(mccolor);
                }
            } else {
                if (!colors.isInstanceOf(CString.TYPE)) throw new CREFormatException("Expecting an array or string for fade parameter, but found " + String.valueOf(colors.typeof()), t);
                split2 = colors.val().split("\\|");
                for (String string : split2) {
                    builder.addFadeColor(StaticLayer.GetConvertor().GetColor(string, t));
                }
            }
        }
        if (!fe.containsKey("type")) return builder.build();
        try {
            builder.setType(MCFireworkType.valueOf(fe.get("type", t).val().toUpperCase()));
            return builder.build();
        }
        catch (IllegalArgumentException ex) {
            throw new CREFormatException(ex.getMessage(), t, ex);
        }
    }

    public Construct recipe(MCRecipe r, Target t) {
        if (r == null) {
            return CNull.NULL;
        }
        CArray ret = CArray.GetAssociativeArray(t);
        ret.set("type", (Mixed)new CString(r.getRecipeType().name(), t), t);
        ret.set("result", (Mixed)this.item(r.getResult(), t), t);
        ret.set("key", r.getKey(), t);
        ret.set("group", r.getGroup(), t);
        if (r instanceof MCCookingRecipe) {
            MCCookingRecipe recipe = (MCCookingRecipe)r;
            MCMaterial[] list = recipe.getInput();
            if (list.length == 1) {
                ret.set("input", (Mixed)new CString(list[0].getName(), t), t);
            } else {
                CArray mats = new CArray(t);
                for (MCMaterial mat : recipe.getInput()) {
                    mats.push(new CString(mat.getName(), t), t);
                }
                ret.set("input", (Mixed)mats, t);
            }
            ret.set("experience", (Mixed)new CDouble(recipe.getExperience(), t), t);
            ret.set("cookingtime", (Mixed)new CInt(recipe.getCookingTime(), t), t);
        } else if (r instanceof MCShapelessRecipe) {
            MCShapelessRecipe shapeless = (MCShapelessRecipe)r;
            CArray il = new CArray(t);
            for (MCMaterial[] list : shapeless.getIngredients()) {
                if (list.length == 1) {
                    il.push(new CString(list[0].getName(), t), t);
                    continue;
                }
                CArray materials = new CArray(t);
                for (MCMaterial mat : list) {
                    materials.push(new CString(mat.getName(), t), t);
                }
                il.push(materials, t);
            }
            ret.set("ingredients", (Mixed)il, t);
        } else if (r instanceof MCShapedRecipe) {
            MCShapedRecipe shaped = (MCShapedRecipe)r;
            CArray shape = new CArray(t);
            for (String line : shaped.getShape()) {
                shape.push(new CString(line, t), t);
            }
            ret.set("shape", (Mixed)shape, t);
            CArray imap = CArray.GetAssociativeArray(t);
            for (Map.Entry<Character, MCMaterial[]> entry : shaped.getIngredientMap().entrySet()) {
                if (entry.getValue() == null) {
                    imap.set(entry.getKey().toString(), (Mixed)CNull.NULL, t);
                    continue;
                }
                if (entry.getValue().length == 1) {
                    imap.set(entry.getKey().toString(), entry.getValue()[0].getName(), t);
                    continue;
                }
                CArray materials = new CArray(t);
                for (MCMaterial mat : entry.getValue()) {
                    materials.push(new CString(mat.getName(), t), t);
                }
                imap.set(entry.getKey().toString(), (Mixed)materials, t);
            }
            ret.set("ingredients", (Mixed)imap, t);
        } else if (r instanceof MCStonecuttingRecipe) {
            MCStonecuttingRecipe recipe = (MCStonecuttingRecipe)r;
            MCMaterial[] list = recipe.getInput();
            if (list.length == 1) {
                ret.set("input", (Mixed)new CString(list[0].getName(), t), t);
            } else {
                CArray mats = new CArray(t);
                for (MCMaterial mat : list) {
                    mats.push(new CString(mat.getName(), t), t);
                }
                ret.set("input", (Mixed)mats, t);
            }
        } else if (r instanceof MCSmithingRecipe) {
            MCSmithingRecipe recipe = (MCSmithingRecipe)r;
            MCMaterial[] base = recipe.getBase();
            if (base.length == 1) {
                ret.set("base", (Mixed)new CString(base[0].getName(), t), t);
            } else {
                CArray mats = new CArray(t);
                for (MCMaterial mat : base) {
                    mats.push(new CString(mat.getName(), t), t);
                }
                ret.set("base", (Mixed)mats, t);
            }
            MCMaterial[] additions = recipe.getAddition();
            if (additions.length == 1) {
                ret.set("addition", (Mixed)new CString(additions[0].getName(), t), t);
            } else {
                CArray mats = new CArray(t);
                for (MCMaterial mat : additions) {
                    mats.push(new CString(mat.getName(), t), t);
                }
                ret.set("addition", (Mixed)mats, t);
            }
        }
        return ret;
    }

    public MCRecipe recipe(Mixed c, Target t) {
        MCRecipe ret;
        MCRecipeType recipeType;
        if (!c.isInstanceOf(CArray.TYPE)) {
            throw new CRECastException("Expected array but received " + c.typeof().getSimpleName(), t);
        }
        CArray recipe = (CArray)c;
        String recipeKey = recipe.get("key", t).val();
        try {
            recipeType = MCRecipeType.valueOf(recipe.get("type", t).val());
        }
        catch (IllegalArgumentException e) {
            throw new CREIllegalArgumentException("Invalid recipe type.", t);
        }
        MCItemStack result = this.item(recipe.get("result", t), t);
        try {
            ret = StaticLayer.GetNewRecipe(recipeKey, recipeType, result);
        }
        catch (IllegalArgumentException ex) {
            throw new CREIllegalArgumentException(ex.getMessage(), t);
        }
        if (recipe.containsKey("group")) {
            ret.setGroup(recipe.get("group", t).val());
        }
        switch (recipeType) {
            case SHAPED: {
                CArray shaped = ArgumentValidation.getArray(recipe.get("shape", t), t);
                String[] shape = new String[(int)shaped.size()];
                if (shaped.size() < 1L || shaped.size() > 3L || shaped.inAssociativeMode()) {
                    throw new CREFormatException("Shape array is invalid.", t);
                }
                int i = 0;
                for (Mixed mixed : shaped.asList()) {
                    if (mixed.isInstanceOf(CString.TYPE) && mixed.val().length() >= 1 && mixed.val().length() <= 3) {
                        shape[i] = mixed.val();
                        ++i;
                        continue;
                    }
                    throw new CREFormatException("Shape array is invalid.", t);
                }
                ((MCShapedRecipe)ret).setShape(shape);
                CArray shapedIngredients = ArgumentValidation.getArray(recipe.get("ingredients", t), t);
                if (!shapedIngredients.inAssociativeMode()) {
                    throw new CREIllegalArgumentException("Ingredients array is invalid.", t);
                }
                for (String key : shapedIngredients.stringKeySet()) {
                    Mixed ingredient = shapedIngredients.get(key, t);
                    if (ingredient.isInstanceOf(CArray.TYPE)) {
                        if (((CArray)ingredient).isAssociative()) {
                            ((MCShapedRecipe)ret).setIngredient(key.charAt(0), this.recipeItem(ingredient, t));
                            continue;
                        }
                        CArray list = (CArray)ingredient;
                        MCMaterial[] mats = new MCMaterial[(int)list.size()];
                        MCItemStack[] items = new MCItemStack[(int)list.size()];
                        boolean exactItemMatch = false;
                        int index = 0;
                        while ((long)index < list.size()) {
                            Mixed choice = list.get(index, t);
                            if (choice.isInstanceOf(CArray.TYPE)) {
                                exactItemMatch = true;
                                items[index] = this.recipeItem(choice, t);
                            } else {
                                mats[index] = this.recipeMaterial(choice, t);
                            }
                            ++index;
                        }
                        if (exactItemMatch) {
                            for (index = 0; index < items.length; ++index) {
                                if (items[index] != null) continue;
                                items[index] = StaticLayer.GetItemStack(mats[index], 1);
                            }
                            ((MCShapedRecipe)ret).setIngredient(key.charAt(0), items);
                            continue;
                        }
                        ((MCShapedRecipe)ret).setIngredient(key.charAt(0), mats);
                        continue;
                    }
                    if (ingredient instanceof CNull) continue;
                    ((MCShapedRecipe)ret).setIngredient(key.charAt(0), this.recipeMaterial(ingredient, t));
                }
                return ret;
            }
            case SHAPELESS: {
                CArray cArray = ArgumentValidation.getArray(recipe.get("ingredients", t), t);
                if (cArray.inAssociativeMode()) {
                    throw new CREIllegalArgumentException("Ingredients array is invalid.", t);
                }
                for (Mixed ingredient : cArray.asList()) {
                    if (ingredient.isInstanceOf(CArray.TYPE)) {
                        if (((CArray)ingredient).isAssociative()) {
                            ((MCShapelessRecipe)ret).addIngredient(this.recipeItem(ingredient, t));
                            continue;
                        }
                        ((MCShapelessRecipe)ret).addIngredient(this.recipeMaterialChoice((CArray)ingredient, t));
                        continue;
                    }
                    ((MCShapelessRecipe)ret).addIngredient(this.recipeMaterial(ingredient, t));
                }
                return ret;
            }
            case BLASTING: 
            case CAMPFIRE: 
            case FURNACE: 
            case SMOKING: {
                Mixed input = recipe.get("input", t);
                if (input.isInstanceOf(CArray.TYPE)) {
                    if (((CArray)input).isAssociative()) {
                        ((MCCookingRecipe)ret).setInput(this.recipeItem(input, t));
                    } else {
                        ((MCCookingRecipe)ret).setInput(this.recipeMaterialChoice((CArray)input, t));
                    }
                } else {
                    ((MCCookingRecipe)ret).setInput(this.recipeMaterial(input, t));
                }
                if (recipe.containsKey("experience")) {
                    ((MCCookingRecipe)ret).setExperience(ArgumentValidation.getDouble32(recipe.get("experience", t), t));
                }
                if (recipe.containsKey("cookingtime")) {
                    ((MCCookingRecipe)ret).setCookingTime(ArgumentValidation.getInt32(recipe.get("cookingtime", t), t));
                }
                return ret;
            }
            case STONECUTTING: {
                Mixed stoneCutterInput = recipe.get("input", t);
                if (stoneCutterInput.isInstanceOf(CArray.TYPE)) {
                    if (((CArray)stoneCutterInput).isAssociative()) {
                        ((MCStonecuttingRecipe)ret).setInput(this.recipeItem(stoneCutterInput, t));
                    } else {
                        ((MCStonecuttingRecipe)ret).setInput(this.recipeMaterialChoice((CArray)stoneCutterInput, t));
                    }
                } else {
                    ((MCStonecuttingRecipe)ret).setInput(this.recipeMaterial(stoneCutterInput, t));
                }
                return ret;
            }
        }
        throw new CREIllegalArgumentException("Could not find valid recipe type.", t);
    }

    private MCMaterial recipeMaterial(Mixed arg, Target t) {
        MCMaterial mat = StaticLayer.GetMaterial(arg.val());
        if (mat == null || mat.isAir()) {
            throw new CREIllegalArgumentException("Recipe input ingredient is invalid: " + arg.val(), t);
        }
        return mat;
    }

    private MCMaterial[] recipeMaterialChoice(CArray list, Target t) {
        MCMaterial[] mats = new MCMaterial[(int)list.size()];
        int i = 0;
        while ((long)i < list.size()) {
            mats[i] = this.recipeMaterial(list.get(i, t), t);
            ++i;
        }
        return mats;
    }

    private MCItemStack recipeItem(Mixed arg, Target t) {
        MCItemStack item = this.item(arg, t);
        if (item.isEmpty()) {
            throw new CREIllegalArgumentException("Recipe input ingredient is invalid: " + arg.val(), t);
        }
        return item;
    }

    public MCMaterial material(String name, Target t) {
        MCMaterial mat = StaticLayer.GetMaterial(name.toUpperCase());
        if (mat == null) {
            throw new CREFormatException("Unknown material type: " + name, t);
        }
        return mat;
    }

    public MCMaterial material(Mixed name, Target t) {
        return this.material(name.val(), t);
    }

    public MCBlockData blockData(CArray ca, Target t) {
        return this.blockData(ca, null, t);
    }

    public MCBlockData blockData(CArray ca, MCMaterial blockType, Target t) {
        StringBuilder b = new StringBuilder().append("[");
        boolean first = true;
        String block = null;
        for (String key : ca.stringKeySet()) {
            if (key.equals("block")) {
                block = ca.get("block", t).val();
                if (!Character.isUpperCase(block.charAt(0))) continue;
                block = block.toLowerCase();
                continue;
            }
            if (first) {
                first = false;
            } else {
                b.append(',');
            }
            b.append(key).append('=').append(ca.get(key, t).val());
        }
        b.append("]");
        if (block == null) {
            if (blockType == null) {
                throw new CREFormatException("Missing block type for block data.", t);
            }
            block = blockType.name().toLowerCase();
        }
        b.insert(0, block);
        return Static.getServer().createBlockData(b.toString());
    }

    public CArray blockData(MCBlockData blockdata, Target t) {
        CArray ca = CArray.GetAssociativeArray(t);
        String full = blockdata.getAsString().substring(10);
        int bracketPos = full.indexOf(91, 3);
        if (bracketPos != -1) {
            String[] states;
            ca.set("block", (Mixed)new CString(full.substring(0, bracketPos), t), t);
            for (String s : states = full.substring(bracketPos + 1, full.length() - 1).split(",")) {
                int equalsPos = s.indexOf(61);
                ca.set(s.substring(0, equalsPos), (Mixed)this.blockState(s.substring(equalsPos + 1)), t);
            }
        } else {
            ca.set("block", (Mixed)new CString(full, t), t);
        }
        return ca;
    }

    private Construct blockState(String value) {
        if (value.length() < 3 && Character.isDigit(value.charAt(0))) {
            try {
                return new CInt(Long.parseLong(value), Target.UNKNOWN);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            if (value.equals("true")) {
                return CBoolean.TRUE;
            }
            if (value.equals("false")) {
                return CBoolean.FALSE;
            }
        }
        return new CString(value, Target.UNKNOWN);
    }

    public MCMetadataValue metadataValue(Mixed value, MCPlugin plugin) {
        return this.metadataValue(Static.getJavaObject(value), plugin);
    }

    public MCMetadataValue metadataValue(Object value, MCPlugin plugin) {
        return StaticLayer.GetMetadataValue(value, plugin);
    }

    public CArray regMatchValue(MatchResult matchResult, Target t) {
        CArray ret = CArray.GetAssociativeArray(t);
        ret.set(0, (Mixed)new CString(matchResult.group(0), t), t);
        for (int i = 1; i <= matchResult.groupCount(); ++i) {
            if (matchResult.group(i) == null) {
                ret.set(i, (Mixed)CNull.NULL, t);
                continue;
            }
            ret.set(i, (Mixed)new CString(matchResult.group(i), t), t);
        }
        return ret;
    }
}

