/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.blocks;

import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockData;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.Material;

public class BukkitMCMaterial
extends MCMaterial<Material> {
    private static final Map<Material, MCMaterial> BUKKIT_MAP = new EnumMap<Material, MCMaterial>(Material.class);

    public BukkitMCMaterial(Material type) {
        this((MCMaterial.MCVanillaMaterial)null, type);
    }

    private BukkitMCMaterial(MCMaterial.MCVanillaMaterial vanillaMaterial, Material type) {
        super(vanillaMaterial, type);
    }

    @Override
    public String name() {
        return this.getAbstracted() == null ? ((Material)this.getConcrete()).name() : ((MCMaterial.MCVanillaMaterial)((Object)this.getAbstracted())).name();
    }

    public static MCMaterial valueOfConcrete(Material test) {
        MCMaterial type = BUKKIT_MAP.get(test);
        if (type == null) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit Material missing in BUKKIT_MAP: " + test.name(), Target.UNKNOWN);
            return new BukkitMCMaterial(null, test);
        }
        return type;
    }

    public static void build() {
        for (MCMaterial.MCVanillaMaterial mCVanillaMaterial : MCMaterial.MCVanillaMaterial.values()) {
            Material type;
            if (!mCVanillaMaterial.existsIn(Static.getServer().getMinecraftVersion())) continue;
            try {
                type = Material.valueOf((String)mCVanillaMaterial.name());
            }
            catch (IllegalArgumentException | NoSuchFieldError ex) {
                MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Could not find a Bukkit Material for " + mCVanillaMaterial.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCMaterial wrapper = new BukkitMCMaterial(mCVanillaMaterial, type);
            BY_STRING.put(mCVanillaMaterial.name(), wrapper);
            BUKKIT_MAP.put(type, wrapper);
        }
        for (MCMaterial.MCVanillaMaterial mCVanillaMaterial : Material.values()) {
            if (mCVanillaMaterial.isLegacy() || BUKKIT_MAP.containsKey((Object)mCVanillaMaterial)) continue;
            BukkitMCMaterial wrapper = new BukkitMCMaterial(null, (Material)mCVanillaMaterial);
            BY_STRING.put(mCVanillaMaterial.name(), wrapper);
            BUKKIT_MAP.put((Material)mCVanillaMaterial, wrapper);
        }
    }

    @Override
    public MCBlockData createBlockData() {
        return new BukkitMCBlockData(this.getHandle().createBlockData());
    }

    @Override
    public short getMaxDurability() {
        return this.getHandle().getMaxDurability();
    }

    @Override
    public int getType() {
        return this.getHandle().getId();
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public int getMaxStackSize() {
        return this.getHandle().getMaxStackSize();
    }

    @Override
    public boolean hasGravity() {
        return this.getHandle().hasGravity();
    }

    @Override
    public boolean isBlock() {
        return this.getHandle().isBlock();
    }

    @Override
    public boolean isItem() {
        return this.getHandle().isItem();
    }

    @Override
    public boolean isBurnable() {
        return this.getHandle().isBurnable();
    }

    @Override
    public boolean isEdible() {
        return this.getHandle().isEdible();
    }

    @Override
    public boolean isFlammable() {
        return this.getHandle().isFlammable();
    }

    @Override
    public boolean isOccluding() {
        return this.getHandle().isOccluding();
    }

    @Override
    public boolean isRecord() {
        return this.getHandle().isRecord();
    }

    @Override
    public boolean isSolid() {
        return this.getHandle().isSolid();
    }

    @Override
    public boolean isTransparent() {
        return this.getHandle().isTransparent();
    }

    @Override
    public boolean isInteractable() {
        return this.getHandle().isInteractable();
    }

    @Override
    public boolean isAir() {
        return this.getHandle().isAir();
    }

    @Override
    public boolean isLegacy() {
        return this.getHandle().isLegacy();
    }

    @Override
    public float getHardness() {
        return this.getHandle().getHardness();
    }

    @Override
    public float getBlastResistance() {
        return this.getHandle().getBlastResistance();
    }

    public Material getHandle() {
        return (Material)this.getConcrete();
    }

    public boolean equals(Object obj) {
        return obj instanceof MCMaterial && this.getHandle().equals(((MCMaterial)obj).getHandle());
    }

    public int hashCode() {
        return this.getHandle().hashCode();
    }

    @Override
    public String toString() {
        return this.name();
    }
}

