/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.events.drivers;

import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCServer;
import com.laytonsmith.abstraction.bukkit.events.BukkitPlayerEvents;
import com.laytonsmith.commandhelper.CommandHelperPlugin;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.events.drivers.PlayerEvents;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;

public class BukkitPlayerListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onFoodLevelChange(FoodLevelChangeEvent e) {
        BukkitPlayerEvents.BukkitMCFoodLevelChangeEvent pke = new BukkitPlayerEvents.BukkitMCFoodLevelChangeEvent(e);
        EventUtils.TriggerListener(Driver.FOOD_LEVEL_CHANGED, "food_level_changed", pke);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerKick(PlayerKickEvent e) {
        BukkitPlayerEvents.BukkitMCPlayerKickEvent pke = new BukkitPlayerEvents.BukkitMCPlayerKickEvent(e);
        EventUtils.TriggerListener(Driver.PLAYER_KICK, "player_kick", pke);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerBedEnter(PlayerBedEnterEvent e) {
        BukkitPlayerEvents.BukkitMCPlayerEnterBedEvent be = new BukkitPlayerEvents.BukkitMCPlayerEnterBedEvent(e);
        EventUtils.TriggerListener(Driver.PLAYER_ENTER_BED, "player_enter_bed", be);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerBedLeave(PlayerBedLeaveEvent e) {
        BukkitPlayerEvents.BukkitMCPlayerLeaveBedEvent be = new BukkitPlayerEvents.BukkitMCPlayerLeaveBedEvent(e);
        EventUtils.TriggerListener(Driver.PLAYER_LEAVE_BED, "player_leave_bed", be);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLogin(PlayerLoginEvent e) {
        BukkitPlayerEvents.BukkitMCPlayerLoginEvent ple = new BukkitPlayerEvents.BukkitMCPlayerLoginEvent(e);
        EventUtils.TriggerListener(Driver.PLAYER_LOGIN, "player_login", ple);
        if (e.getResult() == PlayerLoginEvent.Result.ALLOWED) {
            BukkitMCServer server = (BukkitMCServer)CommandHelperPlugin.myServer;
            server.playerUUIDsByName.put(e.getPlayer().getName(), e.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent e) {
        BukkitPlayerEvents.BukkitMCPlayerJoinEvent pje = new BukkitPlayerEvents.BukkitMCPlayerJoinEvent(e);
        EventUtils.TriggerListener(Driver.PLAYER_JOIN, "player_join", pje);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent e) {
        BukkitPlayerEvents.BukkitMCPlayerInteractEvent pie = new BukkitPlayerEvents.BukkitMCPlayerInteractEvent(e);
        if (e.getAction().equals((Object)Action.PHYSICAL)) {
            EventUtils.TriggerListener(Driver.PLAYER_INTERACT, "pressure_plate_activated", pie);
        } else {
            EventUtils.TriggerListener(Driver.PLAYER_INTERACT, "player_interact", pie);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        BukkitPlayerEvents.BukkitMCPlayerRespawnEvent pre = new BukkitPlayerEvents.BukkitMCPlayerRespawnEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_SPAWN, "player_spawn", pre);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (CommandHelperPlugin.self.interpreterListener.isInInterpreterMode(event.getPlayer().getName())) {
            return;
        }
        if (event.isAsynchronous()) {
            BukkitPlayerEvents.BukkitMCPlayerChatEvent pce = new BukkitPlayerEvents.BukkitMCPlayerChatEvent(event);
            EventUtils.TriggerListener(Driver.PLAYER_CHAT, "async_player_chat", pce);
            if (event.isCancelled()) {
                return;
            }
        }
        if (EventUtils.GetEvents(Driver.PLAYER_CHAT) != null && !EventUtils.GetEvents(Driver.PLAYER_CHAT).isEmpty()) {
            if (event.isAsynchronous()) {
                boolean canBeAsync = false;
                if (canBeAsync) {
                    this.fireChat(event);
                } else {
                    final AsyncPlayerChatEvent copy = new AsyncPlayerChatEvent(false, event.getPlayer(), event.getMessage(), event.getRecipients());
                    copy.setFormat(event.getFormat());
                    Future f = Bukkit.getServer().getScheduler().callSyncMethod((Plugin)CommandHelperPlugin.self, new Callable(){

                        public Object call() throws Exception {
                            BukkitPlayerListener.this.onPlayerChat(copy);
                            return null;
                        }
                    });
                    while (true) {
                        try {
                            f.get();
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        catch (ExecutionException ex) {
                            Logger.getLogger(BukkitPlayerListener.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        break;
                    }
                    event.setCancelled(copy.isCancelled());
                    event.setMessage(copy.getMessage());
                    event.setFormat(copy.getFormat());
                }
            } else {
                this.fireChat(event);
            }
        }
    }

    private void fireChat(AsyncPlayerChatEvent event) {
        BukkitPlayerEvents.BukkitMCPlayerChatEvent pce = new BukkitPlayerEvents.BukkitMCPlayerChatEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_CHAT, "player_chat", pce);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        BukkitPlayerEvents.BukkitMCPlayerQuitEvent pqe = new BukkitPlayerEvents.BukkitMCPlayerQuitEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_QUIT, "player_quit", pqe);
        ((BukkitMCServer)CommandHelperPlugin.myServer).playerUUIDsByName.remove(event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        if (event.getFrom().equals((Object)event.getPlayer().getWorld())) {
            return;
        }
        BukkitPlayerEvents.BukkitMCWorldChangedEvent wce = new BukkitPlayerEvents.BukkitMCWorldChangedEvent(event);
        EventUtils.TriggerListener(Driver.WORLD_CHANGED, "world_changed", wce);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getFrom().equals((Object)event.getTo())) {
            return;
        }
        BukkitPlayerEvents.BukkitMCPlayerTeleportEvent pte = new BukkitPlayerEvents.BukkitMCPlayerTeleportEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_TELEPORT, "player_teleport", pte);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPortalEnter(PlayerPortalEvent event) {
        BukkitPlayerEvents.BukkitMCPlayerPortalEvent pe = new BukkitPlayerEvents.BukkitMCPlayerPortalEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_PORTAL_TRAVEL, "player_portal_travel", pe);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onConsume(PlayerItemConsumeEvent event) {
        BukkitPlayerEvents.BukkitMCPlayerItemConsumeEvent pic = new BukkitPlayerEvents.BukkitMCPlayerItemConsumeEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_CONSUME, "player_consume", pic);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onFish(PlayerFishEvent event) {
        BukkitPlayerEvents.BukkitMCPlayerFishEvent fish = new BukkitPlayerEvents.BukkitMCPlayerFishEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_FISH, "player_fish", fish);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onGamemodeChange(PlayerGameModeChangeEvent event) {
        BukkitPlayerEvents.BukkitMCGamemodeChangeEvent e = new BukkitPlayerEvents.BukkitMCGamemodeChangeEvent(event);
        EventUtils.TriggerListener(Driver.GAMEMODE_CHANGE, "gamemode_change", e);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onExpChange(PlayerExpChangeEvent event) {
        BukkitPlayerEvents.BukkitMCExpChangeEvent e = new BukkitPlayerEvents.BukkitMCExpChangeEvent(event);
        EventUtils.TriggerListener(Driver.EXP_CHANGE, "exp_change", e);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerEditBook(PlayerEditBookEvent event) {
        BukkitPlayerEvents.BukkitMCPlayerEditBookEvent pebe = new BukkitPlayerEvents.BukkitMCPlayerEditBookEvent(event);
        EventUtils.TriggerListener(Driver.BOOK_EDITED, "book_edited", pebe);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        BukkitPlayerEvents.BukkitMCPlayerToggleFlightEvent ptfe = new BukkitPlayerEvents.BukkitMCPlayerToggleFlightEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_TOGGLE_FLIGHT, "player_toggle_flight", ptfe);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        BukkitPlayerEvents.BukkitMCPlayerToggleSneakEvent ptse = new BukkitPlayerEvents.BukkitMCPlayerToggleSneakEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_TOGGLE_SNEAK, "player_toggle_sneak", ptse);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        BukkitPlayerEvents.BukkitMCPlayerToggleSprintEvent ptse = new BukkitPlayerEvents.BukkitMCPlayerToggleSprintEvent(event);
        EventUtils.TriggerListener(Driver.PLAYER_TOGGLE_SPRINT, "player_toggle_sprint", ptse);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerResourcePackStatus(PlayerResourcePackStatusEvent event) {
        BukkitPlayerEvents.BukkitMCPlayerResourcePackEvent prpse = new BukkitPlayerEvents.BukkitMCPlayerResourcePackEvent(event);
        EventUtils.TriggerListener(Driver.RESOURCE_PACK_STATUS, "resource_pack_status", prpse);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null || from.getX() == to.getX() && from.getY() == to.getY() && from.getZ() == to.getZ()) {
            return;
        }
        String p2 = event.getPlayer().getName();
        for (Integer threshold : PlayerEvents.GetThresholdList()) {
            MCLocation last;
            Map<String, MCLocation> lastLocations = PlayerEvents.GetLastLocations(threshold);
            if (!lastLocations.containsKey(p2)) {
                last = new BukkitMCLocation(from);
                lastLocations.put(p2, last);
            } else {
                last = lastLocations.get(p2);
            }
            BukkitMCLocation movedTo = new BukkitMCLocation(to);
            if (!movedTo.getWorld().getName().equals(last.getWorld().getName())) {
                lastLocations.put(p2, movedTo);
                continue;
            }
            if (!(last.distance(movedTo) > (double)threshold.intValue())) continue;
            BukkitPlayerEvents.BukkitMCPlayerMoveEvent pme = new BukkitPlayerEvents.BukkitMCPlayerMoveEvent(event, threshold, last);
            EventUtils.TriggerListener(Driver.PLAYER_MOVE, "player_move", pme);
            if (pme.isCancelled()) continue;
            lastLocations.put(p2, movedTo);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onNewRespawnLocation(PlayerRespawnEvent event) {
        for (Integer i : PlayerEvents.GetThresholdList()) {
            PlayerEvents.GetLastLocations(i).put(event.getPlayer().getName(), new BukkitMCLocation(event.getRespawnLocation()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onNewTeleportLocation(PlayerTeleportEvent event) {
        if (event.getFrom().equals((Object)event.getTo())) {
            return;
        }
        if (!event.isCancelled()) {
            for (Integer i : PlayerEvents.GetThresholdList()) {
                PlayerEvents.GetLastLocations(i).put(event.getPlayer().getName(), new BukkitMCLocation(event.getTo()));
            }
        }
    }
}

