/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.enums.EnumConvertor;
import com.laytonsmith.abstraction.enums.MCPatternShape;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.annotations.abstractionenum;
import com.laytonsmith.core.Static;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.banner.PatternType;

@abstractionenum(implementation=Implementation.Type.BUKKIT, forAbstractEnum=MCPatternShape.class, forConcreteEnum=PatternType.class)
public class BukkitMCPatternShape
extends EnumConvertor<MCPatternShape, PatternType> {
    private static BukkitMCPatternShape instance;
    private PatternType diagonalRight;

    public static BukkitMCPatternShape getConvertor() {
        if (instance == null) {
            instance = new BukkitMCPatternShape();
        }
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
            BukkitMCPatternShape.instance.diagonalRight = (PatternType)Registry.BANNER_PATTERN.get(NamespacedKey.minecraft((String)"diagonal_right"));
        }
        return instance;
    }

    @Override
    protected MCPatternShape getAbstractedEnumCustom(PatternType concrete) {
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
            if (concrete == this.diagonalRight) {
                return MCPatternShape.DIAGONAL_RIGHT_MIRROR;
            }
            switch (concrete) {
                case DIAGONAL_UP_RIGHT: {
                    return MCPatternShape.DIAGONAL_RIGHT;
                }
                case SMALL_STRIPES: {
                    return MCPatternShape.STRIPE_SMALL;
                }
                case DIAGONAL_UP_LEFT: {
                    return MCPatternShape.DIAGONAL_LEFT_MIRROR;
                }
                case CIRCLE: {
                    return MCPatternShape.CIRCLE_MIDDLE;
                }
                case RHOMBUS: {
                    return MCPatternShape.RHOMBUS_MIDDLE;
                }
                case HALF_VERTICAL_RIGHT: {
                    return MCPatternShape.HALF_VERTICAL_MIRROR;
                }
                case HALF_HORIZONTAL_BOTTOM: {
                    return MCPatternShape.HALF_HORIZONTAL_MIRROR;
                }
            }
        }
        return (MCPatternShape)((Object)super.getAbstractedEnumCustom(concrete));
    }

    @Override
    protected PatternType getConcreteEnumCustom(MCPatternShape abstracted) {
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6) && abstracted == MCPatternShape.DIAGONAL_RIGHT_MIRROR) {
            return BukkitMCPatternShape.instance.diagonalRight;
        }
        return PatternType.valueOf((String)abstracted.name());
    }
}

