/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm;

import com.laytonsmith.PureUtilities.ArgumentParser;
import com.laytonsmith.PureUtilities.CommandExecutor;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.InternalException;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.asm.AsmHeaderCompiler;
import com.laytonsmith.core.asm.AsmInstaller;
import com.laytonsmith.core.asm.IRBuilder;
import com.laytonsmith.core.asm.IRData;
import com.laytonsmith.core.asm.IRType;
import com.laytonsmith.core.asm.LLVMEnvironment;
import com.laytonsmith.core.asm.LLVMFunction;
import com.laytonsmith.core.asm.LLVMPlatformResolver;
import com.laytonsmith.core.asm.metadata.IRMetadata;
import com.laytonsmith.core.asm.metadata.IRMetadataDICompileUnit;
import com.laytonsmith.core.asm.metadata.IRMetadataDIFile;
import com.laytonsmith.core.asm.metadata.IRMetadataDISubprogram;
import com.laytonsmith.core.asm.metadata.IRMetadataDISubroutineType;
import com.laytonsmith.core.asm.metadata.LLVMMetadataRegistry;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.persistence.DataSourceException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AsmCompiler {
    private static final Set<Class<? extends Environment.EnvironmentImpl>> ENVS = new HashSet<Class<? extends Environment.EnvironmentImpl>>();
    private final File llc;
    private final File lld;
    private final File clang;
    private final File llvmlink;
    private final LLVMEnvironment llvmenv;
    private final ArgumentParser.ArgumentParserResults asmOptions;

    public static ArgumentParser getArgs() {
        return ArgumentParser.GetParser().addDescription("Provides the interface for compiling MethodScript to native executables. The system compiles to LLVM, and so many of the options here are just wrappers around various LLVM tools. Make sure you install the toolchain first with --install-toolchain.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Installs the LLVM compiler toolchain. This is not necessary if your system is already set up with the toolchain, but this will automatically install the proper toolchain for you. Run as root/Administrator. Ignores other options, and exits once installation is complete. Installation is indempotent, you may run this unconditionally, and if everything is installed correctly, nothing will happen. New updates to MethodScript may require reinstallation of the toolchain.").asFlag().setName("install-toolchain")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Provides the input file/directory. If given a folder, the directory is scanned recursively to find all the ms files, with a file at the root named \"main.ms\" taken to be the entry point. If given a single file, it is compiled individually, and regardless of the name, is considered to be the entry point. By default, the current directory is used.").setUsageName("input").setOptionalAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Provides the output directory where the outputs should be placed. By default, this is considered to be the directory ./target.").setUsageName("output file").setOptional().setName('o', "output").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Sets the output name of the executable. The extension is added automatically. If a single file is provided as the input, the name is inherited from that file. Otherwise, the name is inherited by the containing folder.").setUsageName("executable name").setOptional().setName("executable-name").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Disables outputting of code target information in the LLVM IR file.").asFlag().setName("no-target-logging")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Disables optimizations. This is only useful for debugging, and should not normally be set. If this flag is set, --extraopt is ignored.").asFlag().setName("noopt")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Does more aggressive optimizations. This can be done for release binaries, and generally increases compile time, but in theory may make programs faster.").asFlag().setName("extraopt")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Compiles the files to IR without including the headers or running llvm-link, then quits. Useful for debugging the compiler, but results in potentially incomplete (and thus uncompilable) IR. No binary is generated with this option specified.").asFlag().setName("no-llvm-link")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Sets the build version. Can be release or debug. Debug builds tend to contain more detailed information, but note that some debug information is set in all builds. Defaults to \"release\", but may be \"debug\" instead.").setUsageName("debug/release").setOptional().setName("build-mode").setDefaultVal("release").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Overrides the default build target. By default, compilation occurs for the host currently running the build, but cross compilation is possible by setting this value. Specify the target in this option. You must first have installed the toolchain for this target, if this options is used in combination with the --install-toolchain option, it will install the toolchain for this target instead. The value should follow the format: \"<arch>[<sub>]-<vendor>-<sys>[-<abi>]\". Please see the associated documentation for full information on valid options.").setUsageName("build-target").setOptional().setName("build-target")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Outputs verbose information during the build process.").asFlag().setName('v', "verbose"));
    }

    public AsmCompiler(ArgumentParser.ArgumentParserResults asmOptions) {
        File llvmlink;
        File clang;
        File lld;
        File llc;
        this.asmOptions = asmOptions;
        if (OSUtils.GetOS().isWindows()) {
            llc = new File("C:\\Program Files\\LLVM\\bin\\llc.exe");
            lld = new File("C:\\Program Files\\LLVM\\bin\\lld-link.exe");
            clang = new File("C:\\Program Files\\LLVM\\bin\\clang.exe");
            llvmlink = new File("C:\\Program Files\\LLVM\\bin\\llvm-link.exe");
        } else if (OSUtils.GetOS().isLinux()) {
            llc = new File("/usr/bin/llc-12");
            lld = new File("/usr/bin/ld.lld-12");
            clang = new File("/usr/bin/clang");
            llvmlink = new File("/usr/bin/llvm-link-12");
        } else if (OSUtils.GetOS().isMac()) {
            llc = new File("/usr/local/opt/llvm@12/bin/llc");
            lld = new File("/Library/Developer/CommandLineTools/usr/bin/ld");
            clang = new File("/usr/local/opt/llvm@12/bin/clang");
            llvmlink = new File("/usr/local/opt/llvm@12/bin/llvm-link");
        } else {
            throw new UnsupportedOperationException("OS not yet supported");
        }
        this.llc = llc;
        this.lld = lld;
        this.clang = clang;
        this.llvmlink = llvmlink;
        this.llvmenv = new LLVMEnvironment();
        this.llvmenv.setOutputIRCodeTargetLogging(true);
        if (asmOptions.isFlagSet("no-target-logging")) {
            this.llvmenv.setOutputIRCodeTargetLogging(false);
        }
        if (asmOptions.isFlagSet("extraopt")) {
            this.llvmenv.setOptimizationLevel(LLVMEnvironment.OptimizationLevel.EXTRA);
        }
        if (asmOptions.isFlagSet("noopt")) {
            this.llvmenv.setOptimizationLevel(LLVMEnvironment.OptimizationLevel.NONE);
        }
    }

    private void log(String message) {
        if (this.asmOptions.isFlagSet("verbose")) {
            System.out.println(message);
        }
    }

    public LLVMEnvironment getEnvironment() {
        return this.llvmenv;
    }

    public void compileEntryPoint(File file, File outputDirectory, String exeName) throws IOException, DataSourceException, URISyntaxException, Profiles.InvalidProfileException, ConfigCompileException, ConfigCompileGroupException, InterruptedException {
        File obj;
        File ll;
        Environment env = Static.GenerateStandaloneEnvironment(true);
        boolean verbose = this.asmOptions.isFlagSet("verbose");
        if (!file.getAbsolutePath().endsWith(".ll")) {
            String startupFunctionName;
            if (!AsmInstaller.validateToolchain()) {
                return;
            }
            StringBuilder program = new StringBuilder();
            this.llvmenv.newMethodFrame("@main");
            this.llvmenv.pushVariableScope();
            this.llvmenv.getNewLocalVariableReference(IRType.INTEGER32);
            this.llvmenv.getNewLocalVariableReference(IRType.INTEGER8POINTERPOINTER);
            int entryPoint = this.llvmenv.getGotoLabel();
            env = env.cloneAndAdd(this.llvmenv);
            Target target = new Target(0, file, 0);
            String versionString = "MethodScript ASM compiler version " + MSVersion.LATEST.toString();
            IRMetadataDIFile diFile = new IRMetadataDIFile(env, file, "release".equals(this.asmOptions.getStringArgument("build-mode")));
            LLVMMetadataRegistry mdRegistry = this.llvmenv.getMetadataRegistry();
            IRMetadata enums = mdRegistry.getEmptyTuple(env);
            IRMetadata retainedTypes = mdRegistry.getEmptyTuple(env);
            IRMetadata globals = mdRegistry.getEmptyTuple(env);
            IRMetadata imports = mdRegistry.getEmptyTuple(env);
            IRMetadataDISubroutineType mainType = new IRMetadataDISubroutineType(env, CInt.TYPE, CClassType.EMPTY_CLASS_ARRAY);
            IRMetadataDICompileUnit compileUnit = new IRMetadataDICompileUnit(env, diFile, versionString, false, enums, retainedTypes, globals, imports);
            IRMetadataDISubprogram subprogram = new IRMetadataDISubprogram(env, "main", diFile, target, mainType, compileUnit);
            compileUnit.setIsDistinct(true);
            IRMetadata llvmDbgCu = IRMetadata.AsAnonymousTuple(env, compileUnit.getReference());
            IRMetadata versionInfo = IRMetadata.AsTuple(env, "!\"" + versionString + "\"");
            IRMetadata llvmIdent = IRMetadata.AsAnonymousTuple(env, versionInfo.getReference());
            IRMetadata llvmModuleFlags = IRMetadata.AsAnonymousTuple(env, this.newModuleFlagsMetadata(env, ModuleFlagMode.MAX, "Dwarf Version", "i32 2").getReference(), this.newModuleFlagsMetadata(env, ModuleFlagMode.MAX, "Debug Info Version", "i32 3").getReference());
            subprogram.setIsDistinct(true);
            if (verbose) {
                MSLog.GetLogger().always((MSLog.Tag)MSLog.Tags.COMPILER, "", Target.UNKNOWN);
            }
            this.log("Compiling " + file.getAbsolutePath());
            IRBuilder builder = this.compileFile(file, env);
            String lastLine = null;
            if (builder.lines.size() >= 1) {
                lastLine = builder.lines.get(builder.lines.size() - 1);
            }
            if (!"unreachable".equals(lastLine)) {
                builder.appendLine(new Target(0, new File("/synth"), 0), "ret i32 0");
            }
            this.llvmenv.newMethodFrame("__startup");
            this.llvmenv.getGotoLabel();
            String startupCode = builder.renderStartupCode(env);
            byte[] val = startupCode.getBytes();
            MessageDigest digest = null;
            try {
                digest = MessageDigest.getInstance("MD5");
                digest.update(val);
                startupFunctionName = "\"__" + StringUtils.toHex(digest.digest()).toLowerCase() + "\"";
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error(e);
            }
            program.append(builder.renderIR(env));
            StringBuilder ir = new StringBuilder();
            StringBuilder strings = new StringBuilder();
            String nl = OSUtils.GetLineEnding();
            strings.append(nl);
            for (Map.Entry<String, String> entry : this.llvmenv.getStrings().entrySet()) {
                String string = entry.getKey();
                String id = entry.getValue();
                String comdat = "";
                if (!OSUtils.GetOS().isMac()) {
                    strings.append("$").append(id).append(" = comdat any").append(nl);
                    comdat = "comdat, ";
                }
                strings.append("@").append(id).append(" = linkonce_odr dso_local unnamed_addr constant [").append(string.length() + 1).append(" x i8] c\"").append(string).append("\\00\", ").append(comdat).append("align 1").append(nl);
            }
            String nameMangling = "e";
            if (OSUtils.GetOS().isWindows()) {
                nameMangling = OSUtils.GetOSBitDepth() == OSUtils.BitDepth.B32 ? "x" : "w";
            }
            String[] datalayout = new String[]{"e", "m:" + nameMangling, "p270:32:32", "p271:32:32", "p272:64:64", "i64:64", "f80:128", "n8:16:32:64", "S128"};
            String targetTriple = this.getClangTriple();
            String irHeader = "source_filename = \"" + file.getName() + "\"" + nl + "target datalayout = \"" + StringUtils.Join(datalayout, "-") + "\"" + nl + "target triple = \"" + targetTriple + "\"" + nl;
            this.log("datalayout: " + String.valueOf(Arrays.asList(datalayout)));
            this.log("targetTriple: " + targetTriple);
            if (env.getEnv(CompilerEnvironment.class).getTargetOS().isWindows()) {
                irHeader = irHeader + "@_fltused = constant i32 0" + nl;
                irHeader = irHeader + "@__fltused = constant i32 0" + nl;
            }
            String irTop = "define dso_local i32 @main(i32 %0, i8** %1) !dbg " + subprogram.getReference() + " {" + nl + "  call void @" + startupFunctionName + "()" + nl;
            String irBottom = "}" + nl + nl;
            String namedMetadata = "!llvm.dbg.cu = " + llvmDbgCu.getDefinition() + nl + "!llvm.ident = " + llvmIdent.getDefinition() + nl + "!llvm.module.flags = " + llvmModuleFlags.getDefinition() + nl;
            ir.append(irHeader);
            ir.append(strings.toString());
            if (startupFunctionName != null) {
                ir.append("define linkonce_odr dso_local hidden void @" + startupFunctionName + "() alwaysinline {" + nl);
                ir.append(startupCode);
                ir.append("  ret void").append(nl);
                ir.append("}" + nl + nl);
            }
            ir.append(irTop);
            ir.append(program.toString());
            ir.append(irBottom);
            ir.append(this.llvmenv.getGlobalDeclarations()).append(nl);
            ir.append(namedMetadata);
            ir.append(StringUtils.Join(builder.metadata, nl));
            ll = new File(outputDirectory, exeName + ".ll");
            FileUtil.write(ir.toString(), ll);
            obj = env.getEnv(CompilerEnvironment.class).getTargetOS().isWindows() ? new File(outputDirectory, exeName + ".obj") : new File(outputDirectory, exeName + ".o");
        } else {
            ll = file;
            obj = env.getEnv(CompilerEnvironment.class).getTargetOS().isWindows() ? new File(file.getParentFile(), exeName + ".obj") : new File(file.getParentFile(), exeName + ".o");
        }
        if (this.asmOptions.isFlagSet("no-llvm-link")) {
            return;
        }
        ArrayList<File> headersLL = new ArrayList<File>();
        for (LLVMEnvironment.Header header : this.llvmenv.getAdditionalHeaders()) {
            File headerLL = new AsmHeaderCompiler(this.clang, header).parse();
            headersLL.add(headerLL);
        }
        if (!headersLL.isEmpty()) {
            ArrayList<String> args2 = new ArrayList<String>();
            args2.add(this.llvmlink.getAbsolutePath());
            args2.add("--disable-debug-info-type-map");
            args2.add("-o");
            args2.add(ll.getAbsolutePath());
            args2.add("-S");
            if (verbose) {
                args2.add("-v");
            }
            args2.add(ll.getAbsolutePath());
            for (File h : headersLL) {
                args2.add(h.getAbsolutePath());
            }
            this.log(((Object)args2).toString());
            CommandExecutor commandExecutor = new CommandExecutor(args2.toArray(new String[args2.size()]));
            commandExecutor.setWorkingDir(ll.getParentFile());
            commandExecutor.setSystemInputsAndOutputs();
            commandExecutor.start();
            int exitCode = commandExecutor.waitFor();
            if (exitCode != 0) {
                throw new InternalException("Header linkage failed.");
            }
        }
        String[] args3 = new String[]{this.llc.getAbsolutePath(), "--filetype=obj", "-o=" + obj.getCanonicalPath(), "--preserve-as-comments", this.llvmenv.getOptimizationLevel().getArg(), ll.getCanonicalPath()};
        this.log(Arrays.asList(args3).toString());
        CommandExecutor ex = new CommandExecutor(args3);
        ex.setWorkingDir(ll.getParentFile().getCanonicalFile());
        ex.setSystemInputsAndOutputs();
        ex.start();
        int n = ex.waitFor();
        if (n != 0) {
            throw new InternalException("Assembly failed.");
        }
        ArrayList<Object> args2 = new ArrayList<Object>();
        args2.add(this.lld.getAbsolutePath());
        HashMap<String, String> subprocessEnv = new HashMap<String, String>();
        if (env.getEnv(CompilerEnvironment.class).getTargetOS().isWindows()) {
            String string = "C:\\Program Files (x86)\\Windows Kits\\10\\";
            String sdkVersion = "10.0.19041.0\\";
            String libBase = string + "Lib\\" + sdkVersion + "\\";
            String targetDepth = OSUtils.GetOSBitDepth() == OSUtils.BitDepth.B64 ? "x64" : "x86";
            args2.add("/out:\"" + exeName + ".exe\"");
            args2.add("/entry:main");
            String buildToolsBase = AsmInstaller.getWindowsBuildToolsLocation().getCanonicalPath();
            this.log("Using build tools version " + buildToolsBase);
            String msvcBase = buildToolsBase + "\\lib\\" + targetDepth + "\\";
            String[] libs = new String[]{"msvcrt.lib", "libcmt.lib"};
            args2.addAll(Arrays.asList(libs));
            subprocessEnv.put("LIB", msvcBase + ";" + libBase + "ucrt\\" + targetDepth + ";" + libBase + "um\\" + targetDepth + ";" + System.getenv("LIB"));
            subprocessEnv.put("LIBPATH", msvcBase + ";" + System.getenv("LIBPATH"));
            args2.add("/libpath:" + string + "um\\" + targetDepth);
            args2.add("/defaultlib:" + libBase + "ucrt\\" + targetDepth + "\\ucrt.lib");
            args2.add("/subsystem:console");
        } else if (OSUtils.GetOS().isLinux()) {
            args2.add("--fatal-warnings");
            args2.add("-z");
            args2.add("relro");
            args2.add("--hash-style=gnu");
            args2.add("--build-id=uuid");
            args2.add("--eh-frame-hdr");
            args2.add("-m");
            args2.add("elf_x86_64");
            args2.add("-dynamic-linker");
            args2.add("/lib64/ld-linux-x86-64.so.2");
            args2.add("-o");
            args2.add(exeName);
            args2.add("/usr/lib/x86_64-linux-gnu/crt1.o");
            args2.add("/usr/lib/x86_64-linux-gnu/crti.o");
            args2.add("/usr/lib/x86_64-linux-gnu/crtn.o");
            args2.add("/usr/lib/gcc/x86_64-linux-gnu/9/crtbegin.o");
            args2.add("/usr/lib/gcc/x86_64-linux-gnu/9/crtend.o");
            args2.add("--library-path=/usr/lib/x86_64-linux-gnu");
            args2.add("--library-path=/usr/lib");
            args2.add("--library-path=/usr/lib64");
            args2.add("--library-path=/lib/x86_64-linux-gnu");
            args2.add("--library-path=/lib");
            args2.add("--library-path=/lib64");
            args2.add("--library-path=/usr/lib/llvm-12/lib");
            args2.add("--library-path=/usr/lib/gcc/x86_64-linux-gnu/9");
            args2.add("-lc");
            args2.add("-lgcc");
            args2.add("--as-needed");
            args2.add("-lgcc_s");
            args2.add("--no-as-needed");
        } else if (OSUtils.GetOS().isMac()) {
            args2.add("-demangle");
            args2.add("-lto_library");
            args2.add("/Library/Developer/CommandLineTools/usr/lib/libLTO.dylib");
            args2.add("-no_deduplicate");
            args2.add("-dynamic");
            args2.add("-arch");
            args2.add("x86_64");
            args2.add("-platform_version");
            args2.add("macos");
            args2.add("11.0.0");
            args2.add("11.3");
            args2.add("-syslibroot");
            args2.add("/Library/Developer/CommandLineTools/SDKs/MacOSX.sdk");
            args2.add("-o");
            args2.add(exeName);
            args2.add("-L/usr/local/lib");
            args2.add("-lSystem");
            args2.add("/Library/Developer/CommandLineTools/usr/lib/clang/12.0.5/lib/darwin/libclang_rt.osx.a");
        } else {
            throw new UnsupportedOperationException("OS not yet supported");
        }
        args2.add(obj.getAbsolutePath());
        this.log(((Object)args2).toString());
        CommandExecutor commandExecutor = new CommandExecutor(args2.toArray(new String[args2.size()]));
        commandExecutor.setEnvironmentVariables(subprocessEnv);
        commandExecutor.setWorkingDir(obj.getParentFile());
        commandExecutor.setSystemInputsAndOutputs();
        commandExecutor.start();
        int exitCode2 = commandExecutor.waitFor();
        if (exitCode2 != 0) {
            throw new InternalException("Linking failed.");
        }
    }

    private IRBuilder compileFile(File file, Environment env) throws IOException, DataSourceException, Profiles.InvalidProfileException, ConfigCompileException, URISyntaxException, ConfigCompileGroupException {
        String script = FileUtil.read(file);
        env = env.cloneAndAdd(new Environment.EnvironmentImpl[0]);
        ParseTree tree = MethodScriptCompiler.compile(MethodScriptCompiler.lex(script, env, file, true), env, ENVS);
        IRBuilder builder = new IRBuilder();
        if (tree != null) {
            AsmCompiler.getIR(builder, tree.getChildAt(0), env);
        } else {
            builder.appendLine(Target.UNKNOWN, "unreachable");
        }
        builder.setFinalMetadata(env);
        return builder;
    }

    public static IRData getIR(IRBuilder builder, ParseTree node, Environment env) throws ConfigCompileException {
        Mixed mixed = node.getData();
        if (mixed instanceof CFunction) {
            CFunction cf = (CFunction)mixed;
            FunctionBase fb = FunctionList.getFunction(cf, api.Platforms.COMPILER_LLVM, ENVS);
            if (fb instanceof LLVMFunction) {
                LLVMFunction f = (LLVMFunction)fb;
                builder.functionsUsed.add(f);
                return f.buildIR(builder, node.getTarget(), env, node.getChildren().toArray(new ParseTree[node.getChildren().size()]));
            }
            throw new Error("Unexpected function type");
        }
        return LLVMPlatformResolver.outputConstant(builder, node.getData(), env);
    }

    public String getClangTriple() throws InterruptedException, IOException {
        String[] args2 = new String[]{this.clang.getAbsolutePath(), "--print-effective-triple"};
        return CommandExecutor.Execute(args2).replace("\n", "").replace("\r", "");
    }

    private IRMetadata newModuleFlagsMetadata(Environment env, ModuleFlagMode mode2, String flagName, String flagValue) {
        String[] tuples = new String[]{"i32 " + mode2.getValue(), "!\"" + flagName + "\"", flagValue};
        return IRMetadata.AsTuple(env, tuples);
    }

    static {
        ENVS.add(GlobalEnv.class);
        ENVS.add(CompilerEnvironment.class);
        ENVS.add(LLVMEnvironment.class);
    }

    private static enum ModuleFlagMode {
        ERROR(1),
        WARNING(2),
        REQUIRE(3),
        OVERRIDE(4),
        APPEND(5),
        APPEND_UNIQUE(6),
        MAX(7);

        private final int value;

        private ModuleFlagMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

