/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis.params;

import com.laytonsmith.libs.redis.clients.jedis.CommandArguments;
import com.laytonsmith.libs.redis.clients.jedis.Protocol;
import com.laytonsmith.libs.redis.clients.jedis.params.IParams;

public class XTrimParams
implements IParams {
    private Long maxLen;
    private boolean approximateTrimming;
    private boolean exactTrimming;
    private String minId;
    private Long limit;

    public static XTrimParams xTrimParams() {
        return new XTrimParams();
    }

    public XTrimParams maxLen(long maxLen) {
        this.maxLen = maxLen;
        return this;
    }

    public XTrimParams minId(String minId) {
        this.minId = minId;
        return this;
    }

    public XTrimParams approximateTrimming() {
        this.approximateTrimming = true;
        return this;
    }

    public XTrimParams exactTrimming() {
        this.exactTrimming = true;
        return this;
    }

    public XTrimParams limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.maxLen != null) {
            args2.add(Protocol.Keyword.MAXLEN);
            if (this.approximateTrimming) {
                args2.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                args2.add(Protocol.BYTES_EQUAL);
            }
            args2.add(Protocol.toByteArray(this.maxLen));
        } else if (this.minId != null) {
            args2.add(Protocol.Keyword.MINID);
            if (this.approximateTrimming) {
                args2.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                args2.add(Protocol.BYTES_EQUAL);
            }
            args2.add(this.minId);
        }
        if (this.limit != null) {
            args2.add(Protocol.Keyword.LIMIT).add(this.limit);
        }
    }
}

