/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis.providers;

import com.laytonsmith.libs.redis.clients.jedis.CommandArguments;
import com.laytonsmith.libs.redis.clients.jedis.Connection;
import com.laytonsmith.libs.redis.clients.jedis.ConnectionFactory;
import com.laytonsmith.libs.redis.clients.jedis.ConnectionPool;
import com.laytonsmith.libs.redis.clients.jedis.HostAndPort;
import com.laytonsmith.libs.redis.clients.jedis.JedisClientConfig;
import com.laytonsmith.libs.redis.clients.jedis.csc.ClientSideCache;
import com.laytonsmith.libs.redis.clients.jedis.providers.ConnectionProvider;
import com.laytonsmith.libs.redis.clients.jedis.util.Pool;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class PooledConnectionProvider
implements ConnectionProvider {
    private final Pool<Connection> pool;
    private Object connectionMapKey = "";

    public PooledConnectionProvider(HostAndPort hostAndPort) {
        this(new ConnectionFactory(hostAndPort));
        this.connectionMapKey = hostAndPort;
    }

    public PooledConnectionProvider(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(new ConnectionPool(hostAndPort, clientConfig));
        this.connectionMapKey = hostAndPort;
    }

    public PooledConnectionProvider(HostAndPort hostAndPort, JedisClientConfig clientConfig, ClientSideCache clientSideCache) {
        this(new ConnectionPool(hostAndPort, clientConfig, clientSideCache));
        this.connectionMapKey = hostAndPort;
    }

    public PooledConnectionProvider(HostAndPort hostAndPort, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ConnectionPool(hostAndPort, clientConfig, poolConfig));
        this.connectionMapKey = hostAndPort;
    }

    public PooledConnectionProvider(HostAndPort hostAndPort, JedisClientConfig clientConfig, ClientSideCache clientSideCache, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ConnectionPool(hostAndPort, clientConfig, clientSideCache, poolConfig));
        this.connectionMapKey = hostAndPort;
    }

    public PooledConnectionProvider(PooledObjectFactory<Connection> factory) {
        this(new ConnectionPool(factory));
        this.connectionMapKey = factory;
    }

    public PooledConnectionProvider(PooledObjectFactory<Connection> factory, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ConnectionPool(factory, poolConfig));
        this.connectionMapKey = factory;
    }

    private PooledConnectionProvider(Pool<Connection> pool) {
        this.pool = pool;
    }

    @Override
    public void close() {
        this.pool.close();
    }

    public final Pool<Connection> getPool() {
        return this.pool;
    }

    @Override
    public Connection getConnection() {
        return this.pool.getResource();
    }

    @Override
    public Connection getConnection(CommandArguments args2) {
        return this.pool.getResource();
    }

    public Map<?, Pool<Connection>> getConnectionMap() {
        return Collections.singletonMap(this.connectionMapKey, this.pool);
    }
}

