/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassUtils {
    private static final Pattern ARRAY_COUNT_PATTERN = Pattern.compile("\\[\\]");
    private static final Map<String, Class> CANONICAL_CLASS_CACHE = new ConcurrentHashMap<String, Class>();

    public static Class forCanonicalName(String className) throws ClassNotFoundException {
        return ClassUtils.forCanonicalName(className, false, false, null);
    }

    public static Class forCanonicalName(String className, boolean initialize, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassUtils.forCanonicalName(className, true, initialize, classLoader);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Class forCanonicalName(String className, boolean useInitializer, boolean initialize, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> c;
        block33: {
            void var8_17;
            if (CANONICAL_CLASS_CACHE.containsKey(className)) {
                return CANONICAL_CLASS_CACHE.get(className);
            }
            if ("void".equals(className)) {
                return Void.TYPE;
            }
            className = StringUtils.replaceLast((String)className, "\\.\\.\\.", "[]");
            int arrays = 0;
            Matcher m = ARRAY_COUNT_PATTERN.matcher((CharSequence)className);
            while (m.find()) {
                ++arrays;
            }
            String simpleName = ((String)className).replaceAll("\\[\\]", "");
            String primitiveID = null;
            Object var8_8 = null;
            if (null != simpleName) {
                switch (simpleName) {
                    case "boolean": {
                        primitiveID = "Z";
                        Class<Boolean> clazz = Boolean.TYPE;
                        break;
                    }
                    case "byte": {
                        primitiveID = "B";
                        Class<Byte> clazz = Byte.TYPE;
                        break;
                    }
                    case "short": {
                        primitiveID = "S";
                        Class<Short> clazz = Short.TYPE;
                        break;
                    }
                    case "int": {
                        primitiveID = "I";
                        Class<Integer> clazz = Integer.TYPE;
                        break;
                    }
                    case "long": {
                        primitiveID = "J";
                        Class<Long> clazz = Long.TYPE;
                        break;
                    }
                    case "float": {
                        primitiveID = "F";
                        Class<Float> clazz = Float.TYPE;
                        break;
                    }
                    case "double": {
                        primitiveID = "D";
                        Class<Double> clazz = Double.TYPE;
                        break;
                    }
                    case "char": {
                        primitiveID = "C";
                        Class<Character> clazz = Character.TYPE;
                    }
                }
            }
            if (var8_17 != null) {
                if (arrays <= 0) return var8_17;
                className = StringUtils.stringMultiply(arrays, "[") + primitiveID;
            } else if (arrays > 0) {
                className = StringUtils.stringMultiply(arrays, "[") + "L" + simpleName + ";";
            }
            c = null;
            try {
                c = useInitializer ? Class.forName((String)className, initialize, classLoader) : Class.forName((String)className);
            }
            catch (ClassNotFoundException ex) {
                Object name = className;
                while (((String)name).contains(".")) {
                    name = StringUtils.replaceLast((String)name, "\\.", "$");
                    try {
                        if (useInitializer) {
                            c = Class.forName((String)name, initialize, classLoader);
                            break;
                        }
                        c = Class.forName((String)name);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                if (c != null) break block33;
                throw ex;
            }
        }
        CANONICAL_CLASS_CACHE.put((String)className, c);
        return c;
    }

    public static String getJVMName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    public static Class<?> getArrayClassFromType(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        try {
            return Class.forName("[" + ClassUtils.getJVMName(clazz).replace('/', '.'));
        }
        catch (ClassNotFoundException ex) {
            throw new NoClassDefFoundError(ex.getMessage());
        }
    }

    public static String getCommonName(Class c) {
        if (!c.isArray()) {
            return c.getName();
        }
        int arrayCount = c.getName().lastIndexOf("[") + 1;
        Class<?> cc = c.getComponentType();
        while (cc.isArray()) {
            cc = cc.getComponentType();
        }
        return cc.getName() + StringUtils.stringMultiply(arrayCount, "[]");
    }

    public static String getCommonNameFromJVMName(String classname) {
        int arrayCount = classname.lastIndexOf("[") + 1;
        if ("Z".equals(classname = classname.substring(arrayCount))) {
            classname = "boolean";
        } else if ("B".equals(classname)) {
            classname = "byte";
        } else if ("S".equals(classname)) {
            classname = "short";
        } else if ("I".equals(classname)) {
            classname = "int";
        } else if ("J".equals(classname)) {
            classname = "long";
        } else if ("D".equals(classname)) {
            classname = "double";
        } else if ("F".equals(classname)) {
            classname = "float";
        } else if ("C".equals(classname)) {
            classname = "char";
        } else {
            if ("V".equals(classname)) {
                return "void";
            }
            classname = classname.substring(1, classname.length() - 1).replace('/', '.');
        }
        return classname + StringUtils.stringMultiply(arrayCount, "[]");
    }

    public static Set<Class<?>> getAllCastableClasses(Class<?> c) {
        HashSet ret = new HashSet();
        ClassUtils.getAllCastableClassesWithBlacklist(c, ret);
        return ret;
    }

    private static Set<Class<?>> getAllCastableClassesWithBlacklist(Class<?> c, Set<Class<?>> blacklist) {
        if (blacklist.contains(c)) {
            return blacklist;
        }
        while (true) {
            blacklist.add(c);
            Class<?> su = c.getSuperclass();
            if (su == null) {
                return blacklist;
            }
            blacklist.add(su);
            blacklist.addAll(ClassUtils.getAllCastableClassesWithBlacklist(su, blacklist));
            for (Class<?> iface : c.getInterfaces()) {
                blacklist.add(iface);
                blacklist.addAll(ClassUtils.getAllCastableClassesWithBlacklist(iface, blacklist));
            }
            c = su;
        }
    }
}

