/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums;

import com.laytonsmith.annotations.MEnum;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.natives.interfaces.Mixed;

@MEnum(value="com.commandhelper.GameRule")
public enum MCGameRule {
    ALLOWFIRETICKSAWAYFROMPLAYER("allowFireTicksAwayFromPlayer"),
    ANNOUNCEADVANCEMENTS("announceAdvancements"),
    BLOCKEXPLOSIONDROPDECAY("blockExplosionDropDecay"),
    COMMANDBLOCKOUTPUT("commandBlockOutput"),
    COMMANDMODIFICATIONBLOCKLIMIT("commandModificationBlockLimit", CInt.class),
    DISABLEELYTRAMOVEMENTCHECK("disableElytraMovementCheck"),
    DISABLEPLAYERMOVEMENTCHECK("disablePlayerMovementCheck"),
    DISABLERAIDS("disableRaids"),
    DODAYLIGHTCYCLE("doDaylightCycle"),
    DOENTITYDROPS("doEntityDrops"),
    DOFIRETICK("doFireTick"),
    DOIMMEDIATERESPAWN("doImmediateRespawn"),
    DOINSOMNIA("doInsomnia"),
    DOLIMITEDCRAFTING("doLimitedCrafting"),
    DOMOBLOOT("doMobLoot"),
    DOMOBSPAWNING("doMobSpawning"),
    DOPATROLSPAWNING("doPatrolSpawning"),
    DOTILEDROPS("doTileDrops"),
    DOTRADERSPAWNING("doTraderSpawning"),
    DOVINESSPREAD("doVinesSpread"),
    DOWARDENSPAWNING("doWardenSpawning"),
    DOWEATHERCYCLE("doWeatherCycle"),
    DROWNINGDAMAGE("drowningDamage"),
    ENDERPEARLSVANISHONDEATH("enderPearlsVanishOnDeath"),
    FALLDAMAGE("fallDamage"),
    FIREDAMAGE("fireDamage"),
    FORGIVEDEADPLAYERS("forgiveDeadPlayers"),
    FREEZEDAMAGE("freezeDamage"),
    GLOBALSOUNDEVENTS("globalSoundEvents"),
    KEEPINVENTORY("keepInventory"),
    LAVASOURCECONVERSION("lavaSourceConversion"),
    LOGADMINCOMMANDS("logAdminCommands"),
    MAXCOMMANDCHAINLENGTH("maxCommandChainLength", CInt.class),
    MAXCOMMANDFORKCOUNT("maxCommandForkCount", CInt.class),
    MAXENTITYCRAMMING("maxEntityCramming", CInt.class),
    MINECARTMAXSPEED("minecartMaxSpeed", CInt.class),
    MOBEXPLOSIONDROPDECAY("mobExplosionDropDecay"),
    MOBGRIEFING("mobGriefing"),
    NATURALREGENERATION("naturalRegeneration"),
    PLAYERSNETHERPORTALCREATIVEDELAY("playersNetherPortalCreativeDelay", CInt.class),
    PLAYERSNETHERPORTALDEFAULTDELAY("playersNetherPortalDefaultDelay", CInt.class),
    PLAYERSSLEEPINGPERCENTAGE("playersSleepingPercentage", CInt.class),
    PROJECTILESCANBREAKBLOCKS("projectilesCanBreakBlocks"),
    RANDOMTICKSPEED("randomTickSpeed", CInt.class),
    REDUCEDDEBUGINFO("reducedDebugInfo"),
    SENDCOMMANDFEEDBACK("sendCommandFeedback"),
    SHOWDEATHMESSAGES("showDeathMessages"),
    SNOWACCUMULATIONHEIGHT("snowAccumulationHeight", CInt.class),
    SPAWNCHUNKRADIUS("spawnChunkRadius", CInt.class),
    SPAWNRADIUS("spawnRadius", CInt.class),
    SPECTATORSGENERATECHUNKS("spectatorsGenerateChunks"),
    TNTEXPLODES("tntExplodes"),
    TNTEXPLOSIONDROPDECAY("tntExplosionDropDecay"),
    UNIVERSALANGER("universalAnger"),
    WATERSOURCECONVERSION("waterSourceConversion");

    private final String gameRule;
    private final Class<? extends Mixed> ruleType;

    private MCGameRule(String gameRule) {
        this.gameRule = gameRule;
        this.ruleType = CBoolean.class;
    }

    private MCGameRule(String gameRule, Class<? extends Mixed> type) {
        this.gameRule = gameRule;
        this.ruleType = type;
    }

    public static String[] getGameRules() {
        MCGameRule[] values2 = MCGameRule.values();
        String[] names = new String[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            names[i] = values2[i].getRuleName();
        }
        return names;
    }

    public String getRuleName() {
        return this.gameRule;
    }

    public Object convertValue(Mixed value, Target t) {
        if (this.ruleType == CBoolean.class) {
            return ArgumentValidation.getBooleanish(value, t);
        }
        if (this.ruleType == CInt.class) {
            return ArgumentValidation.getInt(value, t);
        }
        MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.RUNTIME, "The gamerule \"" + this.gameRule + "\" has an invalid type.", t);
        return null;
    }

    public Mixed constructValue(Object value, Target t) {
        try {
            if (this.ruleType == CBoolean.class) {
                return CBoolean.get((Boolean)value);
            }
            if (this.ruleType == CInt.class) {
                return new CInt(((Integer)value).intValue(), t);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.RUNTIME, "The gamerule \"" + this.gameRule + "\" has an invalid type.", t);
        return new CString(value.toString(), t);
    }
}

