/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Session;

public final class MailLogger {
    private final Logger logger;
    private final String prefix;
    private final boolean debug;
    private final PrintStream out;

    public MailLogger(String name, String prefix, boolean debug2, PrintStream out) {
        this.logger = Logger.getLogger(name);
        this.prefix = prefix;
        this.debug = debug2;
        this.out = out != null ? out : System.out;
    }

    public MailLogger(Class<?> clazz, String prefix, boolean debug2, PrintStream out) {
        String name = this.packageOf(clazz);
        this.logger = Logger.getLogger(name);
        this.prefix = prefix;
        this.debug = debug2;
        this.out = out != null ? out : System.out;
    }

    public MailLogger(Class<?> clazz, String subname, String prefix, boolean debug2, PrintStream out) {
        String name = this.packageOf(clazz) + "." + subname;
        this.logger = Logger.getLogger(name);
        this.prefix = prefix;
        this.debug = debug2;
        this.out = out != null ? out : System.out;
    }

    @Deprecated
    public MailLogger(String name, String prefix, Session session) {
        this(name, prefix, session.getDebug(), session.getDebugOut());
    }

    @Deprecated
    public MailLogger(Class<?> clazz, String prefix, Session session) {
        this(clazz, prefix, session.getDebug(), session.getDebugOut());
    }

    public MailLogger getLogger(String name, String prefix) {
        return new MailLogger(name, prefix, this.debug, this.out);
    }

    public MailLogger getLogger(Class<?> clazz, String prefix) {
        return new MailLogger(clazz, prefix, this.debug, this.out);
    }

    public MailLogger getSubLogger(String subname, String prefix) {
        return new MailLogger(this.logger.getName() + "." + subname, prefix, this.debug, this.out);
    }

    public MailLogger getSubLogger(String subname, String prefix, boolean debug2) {
        return new MailLogger(this.logger.getName() + "." + subname, prefix, debug2, this.out);
    }

    public void log(Level level, String msg2) {
        this.ifDebugOut(msg2);
        if (this.logger.isLoggable(level)) {
            StackTraceElement frame = this.inferCaller();
            this.logger.logp(level, frame.getClassName(), frame.getMethodName(), msg2);
        }
    }

    public void log(Level level, String msg2, Object param1) {
        if (this.debug) {
            msg2 = MessageFormat.format(msg2, param1);
            this.debugOut(msg2);
        }
        if (this.logger.isLoggable(level)) {
            StackTraceElement frame = this.inferCaller();
            this.logger.logp(level, frame.getClassName(), frame.getMethodName(), msg2, param1);
        }
    }

    public void log(Level level, String msg2, Object ... params) {
        if (this.debug) {
            msg2 = MessageFormat.format(msg2, params);
            this.debugOut(msg2);
        }
        if (this.logger.isLoggable(level)) {
            StackTraceElement frame = this.inferCaller();
            this.logger.logp(level, frame.getClassName(), frame.getMethodName(), msg2, params);
        }
    }

    public void logf(Level level, String msg2, Object ... params) {
        msg2 = String.format(msg2, params);
        this.ifDebugOut(msg2);
        this.logger.log(level, msg2);
    }

    public void log(Level level, String msg2, Throwable thrown) {
        if (this.debug) {
            if (thrown != null) {
                this.debugOut(msg2 + ", THROW: ");
                thrown.printStackTrace(this.out);
            } else {
                this.debugOut(msg2);
            }
        }
        if (this.logger.isLoggable(level)) {
            StackTraceElement frame = this.inferCaller();
            this.logger.logp(level, frame.getClassName(), frame.getMethodName(), msg2, thrown);
        }
    }

    public void config(String msg2) {
        this.log(Level.CONFIG, msg2);
    }

    public void fine(String msg2) {
        this.log(Level.FINE, msg2);
    }

    public void finer(String msg2) {
        this.log(Level.FINER, msg2);
    }

    public void finest(String msg2) {
        this.log(Level.FINEST, msg2);
    }

    public boolean isLoggable(Level level) {
        return this.debug || this.logger.isLoggable(level);
    }

    private void ifDebugOut(String msg2) {
        if (this.debug) {
            this.debugOut(msg2);
        }
    }

    private void debugOut(String msg2) {
        if (this.prefix != null) {
            this.out.println(this.prefix + ": " + msg2);
        } else {
            this.out.println(msg2);
        }
    }

    private String packageOf(Class<?> clazz) {
        Package p2 = clazz.getPackage();
        if (p2 != null) {
            return p2.getName();
        }
        String cname = clazz.getName();
        int i = cname.lastIndexOf(46);
        if (i > 0) {
            return cname.substring(0, i);
        }
        return "";
    }

    private StackTraceElement inferCaller() {
        StackTraceElement frame;
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !this.isLoggerImplFrame(cname = (frame = stack[ix]).getClassName()); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!this.isLoggerImplFrame(cname)) {
                return frame;
            }
            ++ix;
        }
        return new StackTraceElement(MailLogger.class.getName(), "log", MailLogger.class.getName(), -1);
    }

    private boolean isLoggerImplFrame(String cname) {
        return MailLogger.class.getName().equals(cname);
    }
}

