/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

public class Point3D {
    public static final Point3D ZERO = new Point3D(0.0, 0.0, 0.0);
    protected final double x;
    protected final double y;
    protected final double z;

    public Point3D(Point3D other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public Point3D(double x, double y) {
        this.x = x;
        this.y = y;
        this.z = 0.0;
    }

    public Point3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double X() {
        return this.x;
    }

    public double Y() {
        return this.y;
    }

    public double Z() {
        return this.z;
    }

    public Point3D translate(Point3D other) {
        return new Point3D(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public double distanceSquared(Point3D other) {
        double dX = this.x - other.x;
        double dY = this.y - other.y;
        double dZ = this.z - other.z;
        return dX * dX + dY * dY + dZ * dZ;
    }

    public double distance(Point3D other) {
        return Math.sqrt(this.distanceSquared(other));
    }
}

