/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums;

import com.laytonsmith.PureUtilities.ClassLoading.DynamicEnum;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.annotations.MDynamicEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@MDynamicEnum(value="com.commandhelper.Sound")
public abstract class MCSound<Concrete>
extends DynamicEnum<MCVanillaSound, Concrete> {
    protected static final Map<String, MCSound> MAP = new HashMap<String, MCSound>();

    public MCSound(MCVanillaSound mcVanillaSound, Concrete concrete) {
        super(mcVanillaSound, concrete);
    }

    public static MCSound valueOf(String test) throws IllegalArgumentException {
        MCSound ret = MAP.get(test);
        if (ret == null) {
            throw new IllegalArgumentException("Unknown sound: " + test);
        }
        return ret;
    }

    public static Set<String> types() {
        if (MAP.isEmpty()) {
            HashSet<String> dummy = new HashSet<String>();
            for (MCVanillaSound s : MCVanillaSound.values()) {
                if (!s.existsIn(MCVersion.CURRENT)) continue;
                dummy.add(s.name());
            }
            return dummy;
        }
        return new TreeSet<String>(MAP.keySet());
    }

    public static List<MCSound> values() {
        if (MAP.isEmpty()) {
            ArrayList<MCSound> dummy = new ArrayList<MCSound>();
            for (final MCVanillaSound s : MCVanillaSound.values()) {
                if (!s.existsIn(MCVersion.CURRENT)) continue;
                dummy.add(new MCSound<Object>(s, null){

                    @Override
                    public String name() {
                        return s.name();
                    }
                });
            }
            return dummy;
        }
        return new ArrayList<MCSound>(MAP.values());
    }

    public static enum MCVanillaSound {
        AMBIENT_CAVE,
        BLOCK_ANVIL_BREAK,
        BLOCK_ANVIL_DESTROY,
        BLOCK_ANVIL_FALL,
        BLOCK_ANVIL_HIT,
        BLOCK_ANVIL_LAND,
        BLOCK_ANVIL_PLACE,
        BLOCK_ANVIL_STEP,
        BLOCK_ANVIL_USE,
        BLOCK_BREWING_STAND_BREW,
        BLOCK_CHEST_CLOSE,
        BLOCK_CHEST_LOCKED,
        BLOCK_CHEST_OPEN,
        BLOCK_CHORUS_FLOWER_DEATH,
        BLOCK_CHORUS_FLOWER_GROW,
        BLOCK_COMPARATOR_CLICK,
        BLOCK_DISPENSER_DISPENSE,
        BLOCK_DISPENSER_FAIL,
        BLOCK_DISPENSER_LAUNCH,
        BLOCK_ENCHANTMENT_TABLE_USE,
        BLOCK_END_GATEWAY_SPAWN,
        BLOCK_END_PORTAL_FRAME_FILL,
        BLOCK_END_PORTAL_SPAWN,
        BLOCK_FENCE_GATE_CLOSE,
        BLOCK_FENCE_GATE_OPEN,
        BLOCK_FIRE_AMBIENT,
        BLOCK_FIRE_EXTINGUISH,
        BLOCK_FURNACE_FIRE_CRACKLE,
        BLOCK_GLASS_BREAK,
        BLOCK_GLASS_FALL,
        BLOCK_GLASS_HIT,
        BLOCK_GLASS_PLACE,
        BLOCK_GLASS_STEP,
        BLOCK_GRASS_BREAK,
        BLOCK_GRASS_FALL,
        BLOCK_GRASS_HIT,
        BLOCK_GRASS_PLACE,
        BLOCK_GRASS_STEP,
        BLOCK_GRAVEL_BREAK,
        BLOCK_GRAVEL_FALL,
        BLOCK_GRAVEL_HIT,
        BLOCK_GRAVEL_PLACE,
        BLOCK_GRAVEL_STEP,
        BLOCK_IRON_DOOR_CLOSE,
        BLOCK_IRON_DOOR_OPEN,
        BLOCK_IRON_TRAPDOOR_CLOSE,
        BLOCK_IRON_TRAPDOOR_OPEN,
        BLOCK_LADDER_BREAK,
        BLOCK_LADDER_FALL,
        BLOCK_LADDER_HIT,
        BLOCK_LADDER_PLACE,
        BLOCK_LADDER_STEP,
        BLOCK_LAVA_AMBIENT,
        BLOCK_LAVA_EXTINGUISH,
        BLOCK_LAVA_POP,
        BLOCK_LEVER_CLICK,
        BLOCK_METAL_BREAK,
        BLOCK_METAL_FALL,
        BLOCK_METAL_HIT,
        BLOCK_METAL_PLACE,
        BLOCK_METAL_STEP,
        BLOCK_PISTON_CONTRACT,
        BLOCK_PISTON_EXTEND,
        BLOCK_PORTAL_AMBIENT,
        BLOCK_PORTAL_TRAVEL,
        BLOCK_PORTAL_TRIGGER,
        BLOCK_REDSTONE_TORCH_BURNOUT,
        BLOCK_SAND_BREAK,
        BLOCK_SAND_FALL,
        BLOCK_SAND_HIT,
        BLOCK_SAND_PLACE,
        BLOCK_SAND_STEP,
        BLOCK_SHULKER_BOX_CLOSE,
        BLOCK_SHULKER_BOX_OPEN,
        BLOCK_SNOW_BREAK,
        BLOCK_SNOW_FALL,
        BLOCK_SNOW_HIT,
        BLOCK_SNOW_PLACE,
        BLOCK_SNOW_STEP,
        BLOCK_STONE_BREAK,
        BLOCK_STONE_BUTTON_CLICK_OFF,
        BLOCK_STONE_BUTTON_CLICK_ON,
        BLOCK_STONE_FALL,
        BLOCK_STONE_HIT,
        BLOCK_STONE_PLACE,
        BLOCK_STONE_STEP,
        BLOCK_TRIPWIRE_ATTACH,
        BLOCK_TRIPWIRE_CLICK_OFF,
        BLOCK_TRIPWIRE_CLICK_ON,
        BLOCK_TRIPWIRE_DETACH,
        BLOCK_WATER_AMBIENT,
        BLOCK_WOODEN_DOOR_CLOSE,
        BLOCK_WOODEN_DOOR_OPEN,
        BLOCK_WOODEN_TRAPDOOR_CLOSE,
        BLOCK_WOODEN_TRAPDOOR_OPEN,
        BLOCK_WOOD_BREAK,
        BLOCK_WOOD_FALL,
        BLOCK_WOOD_HIT,
        BLOCK_WOOD_PLACE,
        BLOCK_WOOD_STEP,
        ENCHANT_THORNS_HIT,
        ENTITY_ARROW_HIT,
        ENTITY_ARROW_HIT_PLAYER,
        ENTITY_ARROW_SHOOT,
        ENTITY_BAT_AMBIENT,
        ENTITY_BAT_DEATH,
        ENTITY_BAT_HURT,
        ENTITY_BAT_LOOP,
        ENTITY_BAT_TAKEOFF,
        ENTITY_BLAZE_AMBIENT,
        ENTITY_BLAZE_BURN,
        ENTITY_BLAZE_DEATH,
        ENTITY_BLAZE_HURT,
        ENTITY_BLAZE_SHOOT,
        ENTITY_BOAT_PADDLE_LAND,
        ENTITY_BOAT_PADDLE_WATER,
        ENTITY_CAT_AMBIENT,
        ENTITY_CAT_DEATH,
        ENTITY_CAT_HISS,
        ENTITY_CAT_HURT,
        ENTITY_CAT_PURR,
        ENTITY_CAT_PURREOW,
        ENTITY_CHICKEN_AMBIENT,
        ENTITY_CHICKEN_DEATH,
        ENTITY_CHICKEN_EGG,
        ENTITY_CHICKEN_HURT,
        ENTITY_CHICKEN_STEP,
        ENTITY_COW_AMBIENT,
        ENTITY_COW_DEATH,
        ENTITY_COW_HURT,
        ENTITY_COW_MILK,
        ENTITY_COW_STEP,
        ENTITY_CREEPER_DEATH,
        ENTITY_CREEPER_HURT,
        ENTITY_CREEPER_PRIMED,
        ENTITY_DONKEY_AMBIENT,
        ENTITY_DONKEY_ANGRY,
        ENTITY_DONKEY_CHEST,
        ENTITY_DONKEY_DEATH,
        ENTITY_DONKEY_HURT,
        ENTITY_EGG_THROW,
        ENTITY_ELDER_GUARDIAN_AMBIENT,
        ENTITY_ELDER_GUARDIAN_AMBIENT_LAND,
        ENTITY_ELDER_GUARDIAN_CURSE,
        ENTITY_ELDER_GUARDIAN_DEATH,
        ENTITY_ELDER_GUARDIAN_DEATH_LAND,
        ENTITY_ELDER_GUARDIAN_FLOP,
        ENTITY_ELDER_GUARDIAN_HURT,
        ENTITY_ELDER_GUARDIAN_HURT_LAND,
        ENTITY_ENDERMITE_AMBIENT,
        ENTITY_ENDERMITE_DEATH,
        ENTITY_ENDERMITE_HURT,
        ENTITY_ENDERMITE_STEP,
        ENTITY_EXPERIENCE_BOTTLE_THROW,
        ENTITY_EXPERIENCE_ORB_PICKUP,
        ENTITY_GENERIC_BIG_FALL,
        ENTITY_GENERIC_BURN,
        ENTITY_GENERIC_DEATH,
        ENTITY_GENERIC_DRINK,
        ENTITY_GENERIC_EAT,
        ENTITY_GENERIC_EXPLODE,
        ENTITY_GENERIC_EXTINGUISH_FIRE,
        ENTITY_GENERIC_HURT,
        ENTITY_GENERIC_SMALL_FALL,
        ENTITY_GENERIC_SPLASH,
        ENTITY_GENERIC_SWIM,
        ENTITY_GHAST_AMBIENT,
        ENTITY_GHAST_DEATH,
        ENTITY_GHAST_HURT,
        ENTITY_GHAST_SCREAM,
        ENTITY_GHAST_SHOOT,
        ENTITY_GHAST_WARN,
        ENTITY_GUARDIAN_AMBIENT,
        ENTITY_GUARDIAN_AMBIENT_LAND,
        ENTITY_GUARDIAN_ATTACK,
        ENTITY_GUARDIAN_DEATH,
        ENTITY_GUARDIAN_DEATH_LAND,
        ENTITY_GUARDIAN_FLOP,
        ENTITY_GUARDIAN_HURT,
        ENTITY_GUARDIAN_HURT_LAND,
        ENTITY_HORSE_AMBIENT,
        ENTITY_HORSE_ANGRY,
        ENTITY_HORSE_ARMOR,
        ENTITY_HORSE_BREATHE,
        ENTITY_HORSE_DEATH,
        ENTITY_HORSE_EAT,
        ENTITY_HORSE_GALLOP,
        ENTITY_HORSE_HURT,
        ENTITY_HORSE_JUMP,
        ENTITY_HORSE_LAND,
        ENTITY_HORSE_SADDLE,
        ENTITY_HORSE_STEP,
        ENTITY_HORSE_STEP_WOOD,
        ENTITY_HOSTILE_BIG_FALL,
        ENTITY_HOSTILE_DEATH,
        ENTITY_HOSTILE_HURT,
        ENTITY_HOSTILE_SMALL_FALL,
        ENTITY_HOSTILE_SPLASH,
        ENTITY_HOSTILE_SWIM,
        ENTITY_HUSK_AMBIENT,
        ENTITY_HUSK_DEATH,
        ENTITY_HUSK_HURT,
        ENTITY_HUSK_STEP,
        ENTITY_ITEM_BREAK,
        ENTITY_ITEM_PICKUP,
        ENTITY_LLAMA_AMBIENT,
        ENTITY_LLAMA_ANGRY,
        ENTITY_LLAMA_CHEST,
        ENTITY_LLAMA_DEATH,
        ENTITY_LLAMA_EAT,
        ENTITY_LLAMA_HURT,
        ENTITY_LLAMA_SPIT,
        ENTITY_LLAMA_STEP,
        ENTITY_LLAMA_SWAG,
        ENTITY_MINECART_INSIDE,
        ENTITY_MINECART_RIDING,
        ENTITY_MOOSHROOM_SHEAR,
        ENTITY_MULE_AMBIENT,
        ENTITY_MULE_CHEST,
        ENTITY_MULE_DEATH,
        ENTITY_MULE_HURT,
        ENTITY_PAINTING_BREAK,
        ENTITY_PAINTING_PLACE,
        ENTITY_PARROT_AMBIENT,
        ENTITY_PARROT_DEATH,
        ENTITY_PARROT_EAT,
        ENTITY_PARROT_FLY,
        ENTITY_PARROT_HURT,
        ENTITY_PARROT_IMITATE_BLAZE,
        ENTITY_PARROT_IMITATE_CREEPER,
        ENTITY_PARROT_IMITATE_ELDER_GUARDIAN,
        ENTITY_PARROT_IMITATE_ENDERMITE,
        ENTITY_PARROT_IMITATE_GHAST,
        ENTITY_PARROT_IMITATE_HUSK,
        ENTITY_PARROT_IMITATE_SHULKER,
        ENTITY_PARROT_IMITATE_SILVERFISH,
        ENTITY_PARROT_IMITATE_SKELETON,
        ENTITY_PARROT_IMITATE_SLIME,
        ENTITY_PARROT_IMITATE_SPIDER,
        ENTITY_PARROT_IMITATE_STRAY,
        ENTITY_PARROT_IMITATE_VEX,
        ENTITY_PARROT_IMITATE_WITCH,
        ENTITY_PARROT_IMITATE_WITHER,
        ENTITY_PARROT_IMITATE_WITHER_SKELETON,
        ENTITY_PARROT_IMITATE_ZOMBIE,
        ENTITY_PARROT_IMITATE_ZOMBIE_VILLAGER,
        ENTITY_PARROT_STEP,
        ENTITY_PIG_AMBIENT,
        ENTITY_PIG_DEATH,
        ENTITY_PIG_HURT,
        ENTITY_PIG_SADDLE,
        ENTITY_PIG_STEP,
        ENTITY_PLAYER_ATTACK_CRIT,
        ENTITY_PLAYER_ATTACK_KNOCKBACK,
        ENTITY_PLAYER_ATTACK_NODAMAGE,
        ENTITY_PLAYER_ATTACK_STRONG,
        ENTITY_PLAYER_ATTACK_SWEEP,
        ENTITY_PLAYER_ATTACK_WEAK,
        ENTITY_PLAYER_BIG_FALL,
        ENTITY_PLAYER_BREATH,
        ENTITY_PLAYER_BURP,
        ENTITY_PLAYER_DEATH,
        ENTITY_PLAYER_HURT,
        ENTITY_PLAYER_HURT_DROWN,
        ENTITY_PLAYER_HURT_ON_FIRE,
        ENTITY_PLAYER_LEVELUP,
        ENTITY_PLAYER_SMALL_FALL,
        ENTITY_PLAYER_SPLASH,
        ENTITY_PLAYER_SWIM,
        ENTITY_POLAR_BEAR_AMBIENT,
        ENTITY_POLAR_BEAR_DEATH,
        ENTITY_POLAR_BEAR_HURT,
        ENTITY_POLAR_BEAR_STEP,
        ENTITY_POLAR_BEAR_WARNING,
        ENTITY_RABBIT_AMBIENT,
        ENTITY_RABBIT_ATTACK,
        ENTITY_RABBIT_DEATH,
        ENTITY_RABBIT_HURT,
        ENTITY_RABBIT_JUMP,
        ENTITY_SHEEP_AMBIENT,
        ENTITY_SHEEP_DEATH,
        ENTITY_SHEEP_HURT,
        ENTITY_SHEEP_SHEAR,
        ENTITY_SHEEP_STEP,
        ENTITY_SHULKER_AMBIENT,
        ENTITY_SHULKER_BULLET_HIT,
        ENTITY_SHULKER_BULLET_HURT,
        ENTITY_SHULKER_CLOSE,
        ENTITY_SHULKER_DEATH,
        ENTITY_SHULKER_HURT,
        ENTITY_SHULKER_HURT_CLOSED,
        ENTITY_SHULKER_OPEN,
        ENTITY_SHULKER_SHOOT,
        ENTITY_SHULKER_TELEPORT,
        ENTITY_SILVERFISH_AMBIENT,
        ENTITY_SILVERFISH_DEATH,
        ENTITY_SILVERFISH_HURT,
        ENTITY_SILVERFISH_STEP,
        ENTITY_SKELETON_AMBIENT,
        ENTITY_SKELETON_DEATH,
        ENTITY_SKELETON_HORSE_AMBIENT,
        ENTITY_SKELETON_HORSE_DEATH,
        ENTITY_SKELETON_HORSE_HURT,
        ENTITY_SKELETON_HURT,
        ENTITY_SKELETON_SHOOT,
        ENTITY_SKELETON_STEP,
        ENTITY_SLIME_ATTACK,
        ENTITY_SLIME_DEATH,
        ENTITY_SLIME_HURT,
        ENTITY_SLIME_JUMP,
        ENTITY_SLIME_SQUISH,
        ENTITY_SNOWBALL_THROW,
        ENTITY_SPIDER_AMBIENT,
        ENTITY_SPIDER_DEATH,
        ENTITY_SPIDER_HURT,
        ENTITY_SPIDER_STEP,
        ENTITY_SPLASH_POTION_BREAK,
        ENTITY_SPLASH_POTION_THROW,
        ENTITY_SQUID_AMBIENT,
        ENTITY_SQUID_DEATH,
        ENTITY_SQUID_HURT,
        ENTITY_STRAY_AMBIENT,
        ENTITY_STRAY_DEATH,
        ENTITY_STRAY_HURT,
        ENTITY_STRAY_STEP,
        ENTITY_TNT_PRIMED,
        ENTITY_VEX_AMBIENT,
        ENTITY_VEX_CHARGE,
        ENTITY_VEX_DEATH,
        ENTITY_VEX_HURT,
        ENTITY_VILLAGER_AMBIENT,
        ENTITY_VILLAGER_DEATH,
        ENTITY_VILLAGER_HURT,
        ENTITY_VILLAGER_NO,
        ENTITY_VILLAGER_YES,
        ENTITY_WITCH_AMBIENT,
        ENTITY_WITCH_DEATH,
        ENTITY_WITCH_DRINK,
        ENTITY_WITCH_HURT,
        ENTITY_WITCH_THROW,
        ENTITY_WITHER_AMBIENT,
        ENTITY_WITHER_BREAK_BLOCK,
        ENTITY_WITHER_DEATH,
        ENTITY_WITHER_HURT,
        ENTITY_WITHER_SHOOT,
        ENTITY_WITHER_SKELETON_AMBIENT,
        ENTITY_WITHER_SKELETON_DEATH,
        ENTITY_WITHER_SKELETON_HURT,
        ENTITY_WITHER_SKELETON_STEP,
        ENTITY_WITHER_SPAWN,
        ENTITY_WOLF_AMBIENT,
        ENTITY_WOLF_DEATH,
        ENTITY_WOLF_GROWL,
        ENTITY_WOLF_HOWL(MCVersion.MC1_4, MCVersion.MC1_21_4),
        ENTITY_WOLF_HURT,
        ENTITY_WOLF_PANT,
        ENTITY_WOLF_SHAKE,
        ENTITY_WOLF_STEP,
        ENTITY_WOLF_WHINE,
        ENTITY_ZOMBIE_AMBIENT,
        ENTITY_ZOMBIE_ATTACK_IRON_DOOR,
        ENTITY_ZOMBIE_DEATH,
        ENTITY_ZOMBIE_HORSE_AMBIENT,
        ENTITY_ZOMBIE_HORSE_DEATH,
        ENTITY_ZOMBIE_HORSE_HURT,
        ENTITY_ZOMBIE_HURT,
        ENTITY_ZOMBIE_INFECT,
        ENTITY_ZOMBIE_STEP,
        ENTITY_ZOMBIE_VILLAGER_AMBIENT,
        ENTITY_ZOMBIE_VILLAGER_CONVERTED,
        ENTITY_ZOMBIE_VILLAGER_CURE,
        ENTITY_ZOMBIE_VILLAGER_DEATH,
        ENTITY_ZOMBIE_VILLAGER_HURT,
        ENTITY_ZOMBIE_VILLAGER_STEP,
        ITEM_ARMOR_EQUIP_CHAIN,
        ITEM_ARMOR_EQUIP_DIAMOND,
        ITEM_ARMOR_EQUIP_ELYTRA,
        ITEM_ARMOR_EQUIP_GENERIC,
        ITEM_ARMOR_EQUIP_GOLD,
        ITEM_ARMOR_EQUIP_IRON,
        ITEM_ARMOR_EQUIP_LEATHER,
        ITEM_BOTTLE_EMPTY,
        ITEM_BOTTLE_FILL,
        ITEM_BOTTLE_FILL_DRAGONBREATH,
        ITEM_BUCKET_EMPTY,
        ITEM_BUCKET_EMPTY_LAVA,
        ITEM_BUCKET_FILL,
        ITEM_BUCKET_FILL_LAVA,
        ITEM_CHORUS_FRUIT_TELEPORT,
        ITEM_ELYTRA_FLYING,
        ITEM_FIRECHARGE_USE,
        ITEM_FLINTANDSTEEL_USE,
        ITEM_HOE_TILL,
        ITEM_SHIELD_BLOCK,
        ITEM_SHIELD_BREAK,
        ITEM_SHOVEL_FLATTEN,
        ITEM_TOTEM_USE,
        MUSIC_CREATIVE,
        MUSIC_CREDITS,
        MUSIC_DRAGON,
        MUSIC_END,
        MUSIC_GAME,
        MUSIC_MENU,
        UI_BUTTON_CLICK,
        UI_TOAST_CHALLENGE_COMPLETE,
        UI_TOAST_IN,
        UI_TOAST_OUT,
        WEATHER_RAIN,
        WEATHER_RAIN_ABOVE,
        BLOCK_ENDER_CHEST_CLOSE,
        BLOCK_ENDER_CHEST_OPEN,
        BLOCK_LILY_PAD_PLACE,
        BLOCK_METAL_PRESSURE_PLATE_CLICK_OFF,
        BLOCK_METAL_PRESSURE_PLATE_CLICK_ON,
        BLOCK_NOTE_BLOCK_BASEDRUM,
        BLOCK_NOTE_BLOCK_BASS,
        BLOCK_NOTE_BLOCK_BELL,
        BLOCK_NOTE_BLOCK_CHIME,
        BLOCK_NOTE_BLOCK_FLUTE,
        BLOCK_NOTE_BLOCK_GUITAR,
        BLOCK_NOTE_BLOCK_HARP,
        BLOCK_NOTE_BLOCK_HAT,
        BLOCK_NOTE_BLOCK_PLING,
        BLOCK_NOTE_BLOCK_SNARE,
        BLOCK_NOTE_BLOCK_XYLOPHONE,
        BLOCK_SLIME_BLOCK_BREAK,
        BLOCK_SLIME_BLOCK_FALL,
        BLOCK_SLIME_BLOCK_HIT,
        BLOCK_SLIME_BLOCK_PLACE,
        BLOCK_SLIME_BLOCK_STEP,
        BLOCK_STONE_PRESSURE_PLATE_CLICK_OFF,
        BLOCK_STONE_PRESSURE_PLATE_CLICK_ON,
        BLOCK_WOODEN_BUTTON_CLICK_OFF,
        BLOCK_WOODEN_BUTTON_CLICK_ON,
        BLOCK_WOODEN_PRESSURE_PLATE_CLICK_OFF,
        BLOCK_WOODEN_PRESSURE_PLATE_CLICK_ON,
        BLOCK_WOOL_BREAK,
        BLOCK_WOOL_FALL,
        BLOCK_WOOL_HIT,
        BLOCK_WOOL_PLACE,
        BLOCK_WOOL_STEP,
        ENTITY_ARMOR_STAND_BREAK,
        ENTITY_ARMOR_STAND_FALL,
        ENTITY_ARMOR_STAND_HIT,
        ENTITY_ARMOR_STAND_PLACE,
        ENTITY_DRAGON_FIREBALL_EXPLODE,
        ENTITY_ENDERMAN_AMBIENT,
        ENTITY_ENDERMAN_DEATH,
        ENTITY_ENDERMAN_HURT,
        ENTITY_ENDERMAN_SCREAM,
        ENTITY_ENDERMAN_STARE,
        ENTITY_ENDERMAN_TELEPORT,
        ENTITY_ENDER_DRAGON_AMBIENT,
        ENTITY_ENDER_DRAGON_DEATH,
        ENTITY_ENDER_DRAGON_FLAP,
        ENTITY_ENDER_DRAGON_GROWL,
        ENTITY_ENDER_DRAGON_HURT,
        ENTITY_ENDER_DRAGON_SHOOT,
        ENTITY_ENDER_EYE_DEATH,
        ENTITY_ENDER_EYE_LAUNCH,
        ENTITY_ENDER_PEARL_THROW,
        ENTITY_EVOKER_AMBIENT,
        ENTITY_EVOKER_CAST_SPELL,
        ENTITY_EVOKER_DEATH,
        ENTITY_EVOKER_FANGS_ATTACK,
        ENTITY_EVOKER_HURT,
        ENTITY_EVOKER_PREPARE_ATTACK,
        ENTITY_EVOKER_PREPARE_SUMMON,
        ENTITY_EVOKER_PREPARE_WOLOLO,
        ENTITY_FIREWORK_ROCKET_BLAST,
        ENTITY_FIREWORK_ROCKET_BLAST_FAR,
        ENTITY_FIREWORK_ROCKET_LARGE_BLAST,
        ENTITY_FIREWORK_ROCKET_LARGE_BLAST_FAR,
        ENTITY_FIREWORK_ROCKET_LAUNCH,
        ENTITY_FIREWORK_ROCKET_SHOOT,
        ENTITY_FIREWORK_ROCKET_TWINKLE,
        ENTITY_FIREWORK_ROCKET_TWINKLE_FAR,
        ENTITY_FISHING_BOBBER_RETRIEVE,
        ENTITY_FISHING_BOBBER_SPLASH,
        ENTITY_FISHING_BOBBER_THROW,
        ENTITY_ILLUSIONER_AMBIENT,
        ENTITY_ILLUSIONER_CAST_SPELL,
        ENTITY_ILLUSIONER_DEATH,
        ENTITY_ILLUSIONER_HURT,
        ENTITY_ILLUSIONER_MIRROR_MOVE,
        ENTITY_ILLUSIONER_PREPARE_BLINDNESS,
        ENTITY_ILLUSIONER_PREPARE_MIRROR,
        ENTITY_IRON_GOLEM_ATTACK,
        ENTITY_IRON_GOLEM_DEATH,
        ENTITY_IRON_GOLEM_HURT,
        ENTITY_IRON_GOLEM_STEP,
        ENTITY_ITEM_FRAME_ADD_ITEM,
        ENTITY_ITEM_FRAME_BREAK,
        ENTITY_ITEM_FRAME_PLACE,
        ENTITY_ITEM_FRAME_REMOVE_ITEM,
        ENTITY_ITEM_FRAME_ROTATE_ITEM,
        ENTITY_LEASH_KNOT_BREAK(MCVersion.MC1_9, MCVersion.MC1_21_5),
        ENTITY_LEASH_KNOT_PLACE(MCVersion.MC1_9, MCVersion.MC1_21_5),
        ENTITY_LIGHTNING_BOLT_IMPACT,
        ENTITY_LIGHTNING_BOLT_THUNDER,
        ENTITY_LINGERING_POTION_THROW,
        ENTITY_MAGMA_CUBE_DEATH,
        ENTITY_MAGMA_CUBE_DEATH_SMALL,
        ENTITY_MAGMA_CUBE_HURT,
        ENTITY_MAGMA_CUBE_HURT_SMALL,
        ENTITY_MAGMA_CUBE_JUMP,
        ENTITY_MAGMA_CUBE_SQUISH,
        ENTITY_MAGMA_CUBE_SQUISH_SMALL,
        ENTITY_PARROT_IMITATE_ENDER_DRAGON,
        ENTITY_PARROT_IMITATE_EVOKER,
        ENTITY_PARROT_IMITATE_ILLUSIONER,
        ENTITY_PARROT_IMITATE_MAGMA_CUBE,
        ENTITY_PARROT_IMITATE_VINDICATOR,
        ENTITY_POLAR_BEAR_AMBIENT_BABY,
        ENTITY_SLIME_DEATH_SMALL,
        ENTITY_SLIME_HURT_SMALL,
        ENTITY_SLIME_JUMP_SMALL,
        ENTITY_SLIME_SQUISH_SMALL,
        ENTITY_SNOW_GOLEM_AMBIENT,
        ENTITY_SNOW_GOLEM_DEATH,
        ENTITY_SNOW_GOLEM_HURT,
        ENTITY_SNOW_GOLEM_SHOOT,
        ENTITY_VILLAGER_TRADE,
        ENTITY_VINDICATOR_AMBIENT,
        ENTITY_VINDICATOR_DEATH,
        ENTITY_VINDICATOR_HURT,
        ENTITY_ZOMBIE_ATTACK_WOODEN_DOOR,
        ENTITY_ZOMBIE_BREAK_WOODEN_DOOR,
        MUSIC_DISC_11,
        MUSIC_DISC_13,
        MUSIC_DISC_BLOCKS,
        MUSIC_DISC_CAT,
        MUSIC_DISC_CHIRP,
        MUSIC_DISC_FAR,
        MUSIC_DISC_MALL,
        MUSIC_DISC_MELLOHI,
        MUSIC_DISC_STAL,
        MUSIC_DISC_STRAD,
        MUSIC_DISC_WAIT,
        MUSIC_DISC_WARD,
        AMBIENT_UNDERWATER_ENTER,
        AMBIENT_UNDERWATER_EXIT,
        AMBIENT_UNDERWATER_LOOP,
        AMBIENT_UNDERWATER_LOOP_ADDITIONS,
        AMBIENT_UNDERWATER_LOOP_ADDITIONS_RARE,
        AMBIENT_UNDERWATER_LOOP_ADDITIONS_ULTRA_RARE,
        BLOCK_BEACON_ACTIVATE,
        BLOCK_BEACON_AMBIENT,
        BLOCK_BEACON_DEACTIVATE,
        BLOCK_BEACON_POWER_SELECT,
        BLOCK_BUBBLE_COLUMN_BUBBLE_POP,
        BLOCK_BUBBLE_COLUMN_UPWARDS_AMBIENT,
        BLOCK_BUBBLE_COLUMN_UPWARDS_INSIDE,
        BLOCK_BUBBLE_COLUMN_WHIRLPOOL_AMBIENT,
        BLOCK_BUBBLE_COLUMN_WHIRLPOOL_INSIDE,
        BLOCK_CONDUIT_ACTIVATE,
        BLOCK_CONDUIT_AMBIENT,
        BLOCK_CONDUIT_AMBIENT_SHORT,
        BLOCK_CONDUIT_ATTACK_TARGET,
        BLOCK_CONDUIT_DEACTIVATE,
        BLOCK_CORAL_BLOCK_BREAK,
        BLOCK_CORAL_BLOCK_FALL,
        BLOCK_CORAL_BLOCK_HIT,
        BLOCK_CORAL_BLOCK_PLACE,
        BLOCK_CORAL_BLOCK_STEP,
        BLOCK_PUMPKIN_CARVE,
        BLOCK_WET_GRASS_BREAK,
        BLOCK_WET_GRASS_FALL,
        BLOCK_WET_GRASS_HIT,
        BLOCK_WET_GRASS_PLACE,
        BLOCK_WET_GRASS_STEP,
        ENTITY_COD_AMBIENT,
        ENTITY_COD_DEATH,
        ENTITY_COD_FLOP,
        ENTITY_COD_HURT,
        ENTITY_DOLPHIN_AMBIENT,
        ENTITY_DOLPHIN_AMBIENT_WATER,
        ENTITY_DOLPHIN_ATTACK,
        ENTITY_DOLPHIN_DEATH,
        ENTITY_DOLPHIN_EAT,
        ENTITY_DOLPHIN_HURT,
        ENTITY_DOLPHIN_JUMP,
        ENTITY_DOLPHIN_PLAY,
        ENTITY_DOLPHIN_SPLASH,
        ENTITY_DOLPHIN_SWIM,
        ENTITY_DROWNED_AMBIENT,
        ENTITY_DROWNED_AMBIENT_WATER,
        ENTITY_DROWNED_DEATH,
        ENTITY_DROWNED_DEATH_WATER,
        ENTITY_DROWNED_HURT,
        ENTITY_DROWNED_HURT_WATER,
        ENTITY_DROWNED_SHOOT,
        ENTITY_DROWNED_STEP,
        ENTITY_DROWNED_SWIM,
        ENTITY_FISH_SWIM,
        ENTITY_HUSK_CONVERTED_TO_ZOMBIE,
        ENTITY_PARROT_IMITATE_DROWNED,
        ENTITY_PARROT_IMITATE_PHANTOM,
        ENTITY_PHANTOM_AMBIENT,
        ENTITY_PHANTOM_BITE,
        ENTITY_PHANTOM_DEATH,
        ENTITY_PHANTOM_FLAP,
        ENTITY_PHANTOM_HURT,
        ENTITY_PHANTOM_SWOOP,
        ENTITY_PLAYER_SPLASH_HIGH_SPEED,
        ENTITY_PUFFER_FISH_AMBIENT(MCVersion.MC1_13, MCVersion.MC1_21_5),
        ENTITY_PUFFER_FISH_BLOW_OUT,
        ENTITY_PUFFER_FISH_BLOW_UP,
        ENTITY_PUFFER_FISH_DEATH,
        ENTITY_PUFFER_FISH_FLOP,
        ENTITY_PUFFER_FISH_HURT,
        ENTITY_PUFFER_FISH_STING,
        ENTITY_SALMON_AMBIENT,
        ENTITY_SALMON_DEATH,
        ENTITY_SALMON_FLOP,
        ENTITY_SALMON_HURT,
        ENTITY_SKELETON_HORSE_AMBIENT_WATER,
        ENTITY_SKELETON_HORSE_GALLOP_WATER,
        ENTITY_SKELETON_HORSE_JUMP_WATER,
        ENTITY_SKELETON_HORSE_STEP_WATER,
        ENTITY_SKELETON_HORSE_SWIM,
        ENTITY_SQUID_SQUIRT,
        ENTITY_TROPICAL_FISH_AMBIENT,
        ENTITY_TROPICAL_FISH_DEATH,
        ENTITY_TROPICAL_FISH_FLOP,
        ENTITY_TROPICAL_FISH_HURT,
        ENTITY_TURTLE_AMBIENT_LAND,
        ENTITY_TURTLE_DEATH,
        ENTITY_TURTLE_DEATH_BABY,
        ENTITY_TURTLE_EGG_BREAK,
        ENTITY_TURTLE_EGG_CRACK,
        ENTITY_TURTLE_EGG_HATCH,
        ENTITY_TURTLE_HURT,
        ENTITY_TURTLE_HURT_BABY,
        ENTITY_TURTLE_LAY_EGG,
        ENTITY_TURTLE_SHAMBLE,
        ENTITY_TURTLE_SHAMBLE_BABY,
        ENTITY_TURTLE_SWIM,
        ENTITY_ZOMBIE_CONVERTED_TO_DROWNED,
        ENTITY_ZOMBIE_DESTROY_EGG,
        ITEM_ARMOR_EQUIP_TURTLE,
        ITEM_AXE_STRIP,
        ITEM_BUCKET_EMPTY_FISH,
        ITEM_BUCKET_FILL_FISH,
        ITEM_TRIDENT_HIT,
        ITEM_TRIDENT_HIT_GROUND,
        ITEM_TRIDENT_RETURN,
        ITEM_TRIDENT_RIPTIDE_1,
        ITEM_TRIDENT_RIPTIDE_2,
        ITEM_TRIDENT_RIPTIDE_3,
        ITEM_TRIDENT_THROW,
        ITEM_TRIDENT_THUNDER,
        MUSIC_UNDER_WATER,
        BLOCK_BAMBOO_BREAK(MCVersion.MC1_14),
        BLOCK_BAMBOO_FALL(MCVersion.MC1_14),
        BLOCK_BAMBOO_HIT(MCVersion.MC1_14),
        BLOCK_BAMBOO_PLACE(MCVersion.MC1_14),
        BLOCK_BAMBOO_SAPLING_BREAK(MCVersion.MC1_14),
        BLOCK_BAMBOO_SAPLING_HIT(MCVersion.MC1_14),
        BLOCK_BAMBOO_SAPLING_PLACE(MCVersion.MC1_14),
        BLOCK_BAMBOO_STEP(MCVersion.MC1_14),
        BLOCK_BARREL_CLOSE(MCVersion.MC1_14),
        BLOCK_BARREL_OPEN(MCVersion.MC1_14),
        BLOCK_BELL_RESONATE(MCVersion.MC1_14),
        BLOCK_BELL_USE(MCVersion.MC1_14),
        BLOCK_BLASTFURNACE_FIRE_CRACKLE(MCVersion.MC1_14),
        BLOCK_CAMPFIRE_CRACKLE(MCVersion.MC1_14),
        BLOCK_COMPOSTER_EMPTY(MCVersion.MC1_14),
        BLOCK_COMPOSTER_FILL(MCVersion.MC1_14),
        BLOCK_COMPOSTER_FILL_SUCCESS(MCVersion.MC1_14),
        BLOCK_COMPOSTER_READY(MCVersion.MC1_14),
        BLOCK_CROP_BREAK(MCVersion.MC1_14),
        BLOCK_GRINDSTONE_USE(MCVersion.MC1_14),
        BLOCK_LANTERN_BREAK(MCVersion.MC1_14),
        BLOCK_LANTERN_FALL(MCVersion.MC1_14),
        BLOCK_LANTERN_HIT(MCVersion.MC1_14),
        BLOCK_LANTERN_PLACE(MCVersion.MC1_14),
        BLOCK_LANTERN_STEP(MCVersion.MC1_14),
        BLOCK_NETHER_WART_BREAK(MCVersion.MC1_14),
        BLOCK_NOTE_BLOCK_BANJO(MCVersion.MC1_14),
        BLOCK_NOTE_BLOCK_BIT(MCVersion.MC1_14),
        BLOCK_NOTE_BLOCK_COW_BELL(MCVersion.MC1_14),
        BLOCK_NOTE_BLOCK_DIDGERIDOO(MCVersion.MC1_14),
        BLOCK_NOTE_BLOCK_IRON_XYLOPHONE(MCVersion.MC1_14),
        BLOCK_SCAFFOLDING_BREAK(MCVersion.MC1_14),
        BLOCK_SCAFFOLDING_FALL(MCVersion.MC1_14),
        BLOCK_SCAFFOLDING_HIT(MCVersion.MC1_14),
        BLOCK_SCAFFOLDING_PLACE(MCVersion.MC1_14),
        BLOCK_SCAFFOLDING_STEP(MCVersion.MC1_14),
        BLOCK_SMOKER_SMOKE(MCVersion.MC1_14),
        BLOCK_SWEET_BERRY_BUSH_BREAK(MCVersion.MC1_14),
        BLOCK_SWEET_BERRY_BUSH_PLACE(MCVersion.MC1_14),
        ENTITY_CAT_BEG_FOR_FOOD(MCVersion.MC1_14),
        ENTITY_CAT_EAT(MCVersion.MC1_14),
        ENTITY_CAT_STRAY_AMBIENT(MCVersion.MC1_14),
        ENTITY_EVOKER_CELEBRATE(MCVersion.MC1_14),
        ENTITY_FOX_AGGRO(MCVersion.MC1_14),
        ENTITY_FOX_AMBIENT(MCVersion.MC1_14),
        ENTITY_FOX_BITE(MCVersion.MC1_14),
        ENTITY_FOX_DEATH(MCVersion.MC1_14),
        ENTITY_FOX_EAT(MCVersion.MC1_14),
        ENTITY_FOX_HURT(MCVersion.MC1_14),
        ENTITY_FOX_SCREECH(MCVersion.MC1_14),
        ENTITY_FOX_SLEEP(MCVersion.MC1_14),
        ENTITY_FOX_SNIFF(MCVersion.MC1_14),
        ENTITY_FOX_SPIT(MCVersion.MC1_14),
        ENTITY_MOOSHROOM_CONVERT(MCVersion.MC1_14),
        ENTITY_MOOSHROOM_EAT(MCVersion.MC1_14),
        ENTITY_MOOSHROOM_MILK(MCVersion.MC1_14),
        ENTITY_MOOSHROOM_SUSPICIOUS_MILK(MCVersion.MC1_14),
        ENTITY_OCELOT_AMBIENT(MCVersion.MC1_14),
        ENTITY_OCELOT_DEATH(MCVersion.MC1_14),
        ENTITY_OCELOT_HURT(MCVersion.MC1_14),
        ENTITY_PANDA_AGGRESSIVE_AMBIENT(MCVersion.MC1_14),
        ENTITY_PANDA_AMBIENT(MCVersion.MC1_14),
        ENTITY_PANDA_BITE(MCVersion.MC1_14),
        ENTITY_PANDA_CANT_BREED(MCVersion.MC1_14),
        ENTITY_PANDA_DEATH(MCVersion.MC1_14),
        ENTITY_PANDA_EAT(MCVersion.MC1_14),
        ENTITY_PANDA_HURT(MCVersion.MC1_14),
        ENTITY_PANDA_PRE_SNEEZE(MCVersion.MC1_14),
        ENTITY_PANDA_SNEEZE(MCVersion.MC1_14),
        ENTITY_PANDA_STEP(MCVersion.MC1_14),
        ENTITY_PANDA_WORRIED_AMBIENT(MCVersion.MC1_14),
        ENTITY_PARROT_IMITATE_GUARDIAN(MCVersion.MC1_14),
        ENTITY_PARROT_IMITATE_PILLAGER(MCVersion.MC1_14),
        ENTITY_PARROT_IMITATE_RAVAGER(MCVersion.MC1_14),
        ENTITY_PILLAGER_AMBIENT(MCVersion.MC1_14),
        ENTITY_PILLAGER_CELEBRATE(MCVersion.MC1_14),
        ENTITY_PILLAGER_DEATH(MCVersion.MC1_14),
        ENTITY_PILLAGER_HURT(MCVersion.MC1_14),
        ENTITY_PLAYER_HURT_SWEET_BERRY_BUSH(MCVersion.MC1_14),
        ENTITY_RAVAGER_AMBIENT(MCVersion.MC1_14),
        ENTITY_RAVAGER_ATTACK(MCVersion.MC1_14),
        ENTITY_RAVAGER_CELEBRATE(MCVersion.MC1_14),
        ENTITY_RAVAGER_DEATH(MCVersion.MC1_14),
        ENTITY_RAVAGER_HURT(MCVersion.MC1_14),
        ENTITY_RAVAGER_ROAR(MCVersion.MC1_14),
        ENTITY_RAVAGER_STEP(MCVersion.MC1_14),
        ENTITY_RAVAGER_STUNNED(MCVersion.MC1_14),
        ENTITY_VILLAGER_CELEBRATE(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_ARMORER(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_BUTCHER(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_CARTOGRAPHER(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_CLERIC(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_FARMER(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_FISHERMAN(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_FLETCHER(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_LEATHERWORKER(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_LIBRARIAN(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_MASON(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_SHEPHERD(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_TOOLSMITH(MCVersion.MC1_14),
        ENTITY_VILLAGER_WORK_WEAPONSMITH(MCVersion.MC1_14),
        ENTITY_VINDICATOR_CELEBRATE(MCVersion.MC1_14),
        ENTITY_WANDERING_TRADER_AMBIENT(MCVersion.MC1_14),
        ENTITY_WANDERING_TRADER_DEATH(MCVersion.MC1_14),
        ENTITY_WANDERING_TRADER_DISAPPEARED(MCVersion.MC1_14),
        ENTITY_WANDERING_TRADER_DRINK_MILK(MCVersion.MC1_14),
        ENTITY_WANDERING_TRADER_DRINK_POTION(MCVersion.MC1_14),
        ENTITY_WANDERING_TRADER_HURT(MCVersion.MC1_14),
        ENTITY_WANDERING_TRADER_NO(MCVersion.MC1_14),
        ENTITY_WANDERING_TRADER_REAPPEARED(MCVersion.MC1_14),
        ENTITY_WANDERING_TRADER_TRADE(MCVersion.MC1_14),
        ENTITY_WANDERING_TRADER_YES(MCVersion.MC1_14),
        ENTITY_WITCH_CELEBRATE(MCVersion.MC1_14),
        EVENT_RAID_HORN(MCVersion.MC1_14),
        ITEM_BOOK_PAGE_TURN(MCVersion.MC1_14),
        ITEM_BOOK_PUT(MCVersion.MC1_14),
        ITEM_CROP_PLANT(MCVersion.MC1_14),
        ITEM_CROSSBOW_HIT(MCVersion.MC1_14),
        ITEM_CROSSBOW_LOADING_END(MCVersion.MC1_14),
        ITEM_CROSSBOW_LOADING_MIDDLE(MCVersion.MC1_14),
        ITEM_CROSSBOW_LOADING_START(MCVersion.MC1_14),
        ITEM_CROSSBOW_QUICK_CHARGE_1(MCVersion.MC1_14),
        ITEM_CROSSBOW_QUICK_CHARGE_2(MCVersion.MC1_14),
        ITEM_CROSSBOW_QUICK_CHARGE_3(MCVersion.MC1_14),
        ITEM_CROSSBOW_SHOOT(MCVersion.MC1_14),
        ITEM_NETHER_WART_PLANT(MCVersion.MC1_14),
        ITEM_SWEET_BERRIES_PICK_FROM_BUSH(MCVersion.MC1_14, MCVersion.MC1_16_X),
        UI_CARTOGRAPHY_TABLE_TAKE_RESULT(MCVersion.MC1_14),
        UI_LOOM_SELECT_PATTERN(MCVersion.MC1_14),
        UI_LOOM_TAKE_RESULT(MCVersion.MC1_14),
        UI_STONECUTTER_SELECT_RECIPE(MCVersion.MC1_14),
        UI_STONECUTTER_TAKE_RESULT(MCVersion.MC1_14),
        BLOCK_BEEHIVE_DRIP(MCVersion.MC1_15),
        BLOCK_BEEHIVE_ENTER(MCVersion.MC1_15),
        BLOCK_BEEHIVE_EXIT(MCVersion.MC1_15),
        BLOCK_BEEHIVE_SHEAR(MCVersion.MC1_15),
        BLOCK_BEEHIVE_WORK(MCVersion.MC1_15),
        BLOCK_HONEY_BLOCK_BREAK(MCVersion.MC1_15),
        BLOCK_HONEY_BLOCK_FALL(MCVersion.MC1_15),
        BLOCK_HONEY_BLOCK_HIT(MCVersion.MC1_15),
        BLOCK_HONEY_BLOCK_PLACE(MCVersion.MC1_15),
        BLOCK_HONEY_BLOCK_SLIDE(MCVersion.MC1_15),
        BLOCK_HONEY_BLOCK_STEP(MCVersion.MC1_15),
        ENTITY_BEE_DEATH(MCVersion.MC1_15),
        ENTITY_BEE_HURT(MCVersion.MC1_15),
        ENTITY_BEE_LOOP(MCVersion.MC1_15),
        ENTITY_BEE_LOOP_AGGRESSIVE(MCVersion.MC1_15),
        ENTITY_BEE_POLLINATE(MCVersion.MC1_15),
        ENTITY_BEE_STING(MCVersion.MC1_15),
        ENTITY_IRON_GOLEM_DAMAGE(MCVersion.MC1_15),
        ENTITY_IRON_GOLEM_REPAIR(MCVersion.MC1_15),
        ITEM_HONEY_BOTTLE_DRINK(MCVersion.MC1_15),
        AMBIENT_BASALT_DELTAS_ADDITIONS(MCVersion.MC1_16),
        AMBIENT_BASALT_DELTAS_LOOP(MCVersion.MC1_16),
        AMBIENT_BASALT_DELTAS_MOOD(MCVersion.MC1_16),
        AMBIENT_CRIMSON_FOREST_ADDITIONS(MCVersion.MC1_16),
        AMBIENT_CRIMSON_FOREST_LOOP(MCVersion.MC1_16),
        AMBIENT_CRIMSON_FOREST_MOOD(MCVersion.MC1_16),
        AMBIENT_NETHER_WASTES_ADDITIONS(MCVersion.MC1_16),
        AMBIENT_NETHER_WASTES_LOOP(MCVersion.MC1_16),
        AMBIENT_NETHER_WASTES_MOOD(MCVersion.MC1_16),
        AMBIENT_SOUL_SAND_VALLEY_ADDITIONS(MCVersion.MC1_16),
        AMBIENT_SOUL_SAND_VALLEY_LOOP(MCVersion.MC1_16),
        AMBIENT_SOUL_SAND_VALLEY_MOOD(MCVersion.MC1_16),
        AMBIENT_WARPED_FOREST_ADDITIONS(MCVersion.MC1_16),
        AMBIENT_WARPED_FOREST_LOOP(MCVersion.MC1_16),
        AMBIENT_WARPED_FOREST_MOOD(MCVersion.MC1_16),
        BLOCK_ANCIENT_DEBRIS_BREAK(MCVersion.MC1_16),
        BLOCK_ANCIENT_DEBRIS_FALL(MCVersion.MC1_16),
        BLOCK_ANCIENT_DEBRIS_HIT(MCVersion.MC1_16),
        BLOCK_ANCIENT_DEBRIS_PLACE(MCVersion.MC1_16),
        BLOCK_ANCIENT_DEBRIS_STEP(MCVersion.MC1_16),
        BLOCK_BASALT_BREAK(MCVersion.MC1_16),
        BLOCK_BASALT_FALL(MCVersion.MC1_16),
        BLOCK_BASALT_HIT(MCVersion.MC1_16),
        BLOCK_BASALT_PLACE(MCVersion.MC1_16),
        BLOCK_BASALT_STEP(MCVersion.MC1_16),
        BLOCK_BONE_BLOCK_BREAK(MCVersion.MC1_16),
        BLOCK_BONE_BLOCK_FALL(MCVersion.MC1_16),
        BLOCK_BONE_BLOCK_HIT(MCVersion.MC1_16),
        BLOCK_BONE_BLOCK_PLACE(MCVersion.MC1_16),
        BLOCK_BONE_BLOCK_STEP(MCVersion.MC1_16),
        BLOCK_CHAIN_BREAK(MCVersion.MC1_16),
        BLOCK_CHAIN_FALL(MCVersion.MC1_16),
        BLOCK_CHAIN_HIT(MCVersion.MC1_16),
        BLOCK_CHAIN_PLACE(MCVersion.MC1_16),
        BLOCK_CHAIN_STEP(MCVersion.MC1_16),
        BLOCK_FUNGUS_BREAK(MCVersion.MC1_16),
        BLOCK_FUNGUS_FALL(MCVersion.MC1_16),
        BLOCK_FUNGUS_HIT(MCVersion.MC1_16),
        BLOCK_FUNGUS_PLACE(MCVersion.MC1_16),
        BLOCK_FUNGUS_STEP(MCVersion.MC1_16),
        BLOCK_GILDED_BLACKSTONE_BREAK(MCVersion.MC1_16),
        BLOCK_GILDED_BLACKSTONE_FALL(MCVersion.MC1_16),
        BLOCK_GILDED_BLACKSTONE_HIT(MCVersion.MC1_16),
        BLOCK_GILDED_BLACKSTONE_PLACE(MCVersion.MC1_16),
        BLOCK_GILDED_BLACKSTONE_STEP(MCVersion.MC1_16),
        BLOCK_LODESTONE_BREAK(MCVersion.MC1_16),
        BLOCK_LODESTONE_FALL(MCVersion.MC1_16),
        BLOCK_LODESTONE_HIT(MCVersion.MC1_16),
        BLOCK_LODESTONE_PLACE(MCVersion.MC1_16),
        BLOCK_LODESTONE_STEP(MCVersion.MC1_16),
        BLOCK_NETHERITE_BLOCK_BREAK(MCVersion.MC1_16),
        BLOCK_NETHERITE_BLOCK_FALL(MCVersion.MC1_16),
        BLOCK_NETHERITE_BLOCK_HIT(MCVersion.MC1_16),
        BLOCK_NETHERITE_BLOCK_PLACE(MCVersion.MC1_16),
        BLOCK_NETHERITE_BLOCK_STEP(MCVersion.MC1_16),
        BLOCK_NETHERRACK_BREAK(MCVersion.MC1_16),
        BLOCK_NETHERRACK_FALL(MCVersion.MC1_16),
        BLOCK_NETHERRACK_HIT(MCVersion.MC1_16),
        BLOCK_NETHERRACK_PLACE(MCVersion.MC1_16),
        BLOCK_NETHERRACK_STEP(MCVersion.MC1_16),
        BLOCK_NETHER_BRICKS_BREAK(MCVersion.MC1_16),
        BLOCK_NETHER_BRICKS_FALL(MCVersion.MC1_16),
        BLOCK_NETHER_BRICKS_HIT(MCVersion.MC1_16),
        BLOCK_NETHER_BRICKS_PLACE(MCVersion.MC1_16),
        BLOCK_NETHER_BRICKS_STEP(MCVersion.MC1_16),
        BLOCK_NETHER_GOLD_ORE_BREAK(MCVersion.MC1_16),
        BLOCK_NETHER_GOLD_ORE_FALL(MCVersion.MC1_16),
        BLOCK_NETHER_GOLD_ORE_HIT(MCVersion.MC1_16),
        BLOCK_NETHER_GOLD_ORE_PLACE(MCVersion.MC1_16),
        BLOCK_NETHER_GOLD_ORE_STEP(MCVersion.MC1_16),
        BLOCK_NETHER_ORE_BREAK(MCVersion.MC1_16),
        BLOCK_NETHER_ORE_FALL(MCVersion.MC1_16),
        BLOCK_NETHER_ORE_HIT(MCVersion.MC1_16),
        BLOCK_NETHER_ORE_PLACE(MCVersion.MC1_16),
        BLOCK_NETHER_ORE_STEP(MCVersion.MC1_16),
        BLOCK_NETHER_SPROUTS_BREAK(MCVersion.MC1_16),
        BLOCK_NETHER_SPROUTS_FALL(MCVersion.MC1_16),
        BLOCK_NETHER_SPROUTS_HIT(MCVersion.MC1_16),
        BLOCK_NETHER_SPROUTS_PLACE(MCVersion.MC1_16),
        BLOCK_NETHER_SPROUTS_STEP(MCVersion.MC1_16),
        BLOCK_NYLIUM_BREAK(MCVersion.MC1_16),
        BLOCK_NYLIUM_FALL(MCVersion.MC1_16),
        BLOCK_NYLIUM_HIT(MCVersion.MC1_16),
        BLOCK_NYLIUM_PLACE(MCVersion.MC1_16),
        BLOCK_NYLIUM_STEP(MCVersion.MC1_16),
        BLOCK_RESPAWN_ANCHOR_AMBIENT(MCVersion.MC1_16),
        BLOCK_RESPAWN_ANCHOR_CHARGE(MCVersion.MC1_16),
        BLOCK_RESPAWN_ANCHOR_DEPLETE(MCVersion.MC1_16),
        BLOCK_RESPAWN_ANCHOR_SET_SPAWN(MCVersion.MC1_16),
        BLOCK_ROOTS_BREAK(MCVersion.MC1_16),
        BLOCK_ROOTS_FALL(MCVersion.MC1_16),
        BLOCK_ROOTS_HIT(MCVersion.MC1_16),
        BLOCK_ROOTS_PLACE(MCVersion.MC1_16),
        BLOCK_ROOTS_STEP(MCVersion.MC1_16),
        BLOCK_SHROOMLIGHT_BREAK(MCVersion.MC1_16),
        BLOCK_SHROOMLIGHT_FALL(MCVersion.MC1_16),
        BLOCK_SHROOMLIGHT_HIT(MCVersion.MC1_16),
        BLOCK_SHROOMLIGHT_PLACE(MCVersion.MC1_16),
        BLOCK_SHROOMLIGHT_STEP(MCVersion.MC1_16),
        BLOCK_SMITHING_TABLE_USE(MCVersion.MC1_16),
        BLOCK_SOUL_SAND_BREAK(MCVersion.MC1_16),
        BLOCK_SOUL_SAND_FALL(MCVersion.MC1_16),
        BLOCK_SOUL_SAND_HIT(MCVersion.MC1_16),
        BLOCK_SOUL_SAND_PLACE(MCVersion.MC1_16),
        BLOCK_SOUL_SAND_STEP(MCVersion.MC1_16),
        BLOCK_SOUL_SOIL_BREAK(MCVersion.MC1_16),
        BLOCK_SOUL_SOIL_FALL(MCVersion.MC1_16),
        BLOCK_SOUL_SOIL_HIT(MCVersion.MC1_16),
        BLOCK_SOUL_SOIL_PLACE(MCVersion.MC1_16),
        BLOCK_SOUL_SOIL_STEP(MCVersion.MC1_16),
        BLOCK_STEM_BREAK(MCVersion.MC1_16),
        BLOCK_STEM_FALL(MCVersion.MC1_16),
        BLOCK_STEM_HIT(MCVersion.MC1_16),
        BLOCK_STEM_PLACE(MCVersion.MC1_16),
        BLOCK_STEM_STEP(MCVersion.MC1_16),
        BLOCK_VINE_STEP(MCVersion.MC1_16),
        BLOCK_WART_BLOCK_BREAK(MCVersion.MC1_16),
        BLOCK_WART_BLOCK_FALL(MCVersion.MC1_16),
        BLOCK_WART_BLOCK_HIT(MCVersion.MC1_16),
        BLOCK_WART_BLOCK_PLACE(MCVersion.MC1_16),
        BLOCK_WART_BLOCK_STEP(MCVersion.MC1_16),
        BLOCK_WEEPING_VINES_BREAK(MCVersion.MC1_16),
        BLOCK_WEEPING_VINES_FALL(MCVersion.MC1_16),
        BLOCK_WEEPING_VINES_HIT(MCVersion.MC1_16),
        BLOCK_WEEPING_VINES_PLACE(MCVersion.MC1_16),
        BLOCK_WEEPING_VINES_STEP(MCVersion.MC1_16),
        ENTITY_DONKEY_EAT(MCVersion.MC1_16),
        ENTITY_FOX_TELEPORT(MCVersion.MC1_16),
        ENTITY_HOGLIN_AMBIENT(MCVersion.MC1_16),
        ENTITY_HOGLIN_ANGRY(MCVersion.MC1_16),
        ENTITY_HOGLIN_ATTACK(MCVersion.MC1_16),
        ENTITY_HOGLIN_CONVERTED_TO_ZOMBIFIED(MCVersion.MC1_16),
        ENTITY_HOGLIN_DEATH(MCVersion.MC1_16),
        ENTITY_HOGLIN_HURT(MCVersion.MC1_16),
        ENTITY_HOGLIN_RETREAT(MCVersion.MC1_16),
        ENTITY_HOGLIN_STEP(MCVersion.MC1_16),
        ENTITY_MULE_ANGRY(MCVersion.MC1_16),
        ENTITY_MULE_EAT(MCVersion.MC1_16),
        ENTITY_PARROT_IMITATE_HOGLIN(MCVersion.MC1_16),
        ENTITY_PARROT_IMITATE_PIGLIN(MCVersion.MC1_16),
        ENTITY_PARROT_IMITATE_ZOGLIN(MCVersion.MC1_16),
        ENTITY_PIGLIN_ADMIRING_ITEM(MCVersion.MC1_16),
        ENTITY_PIGLIN_AMBIENT(MCVersion.MC1_16),
        ENTITY_PIGLIN_ANGRY(MCVersion.MC1_16),
        ENTITY_PIGLIN_CELEBRATE(MCVersion.MC1_16),
        ENTITY_PIGLIN_CONVERTED_TO_ZOMBIFIED(MCVersion.MC1_16),
        ENTITY_PIGLIN_DEATH(MCVersion.MC1_16),
        ENTITY_PIGLIN_HURT(MCVersion.MC1_16),
        ENTITY_PIGLIN_JEALOUS(MCVersion.MC1_16),
        ENTITY_PIGLIN_RETREAT(MCVersion.MC1_16),
        ENTITY_PIGLIN_STEP(MCVersion.MC1_16),
        ENTITY_SNOW_GOLEM_SHEAR(MCVersion.MC1_16),
        ENTITY_STRIDER_AMBIENT(MCVersion.MC1_16),
        ENTITY_STRIDER_DEATH(MCVersion.MC1_16),
        ENTITY_STRIDER_EAT(MCVersion.MC1_16),
        ENTITY_STRIDER_HAPPY(MCVersion.MC1_16),
        ENTITY_STRIDER_HURT(MCVersion.MC1_16),
        ENTITY_STRIDER_RETREAT(MCVersion.MC1_16),
        ENTITY_STRIDER_SADDLE(MCVersion.MC1_16),
        ENTITY_STRIDER_STEP(MCVersion.MC1_16),
        ENTITY_STRIDER_STEP_LAVA(MCVersion.MC1_16),
        ENTITY_ZOGLIN_AMBIENT(MCVersion.MC1_16),
        ENTITY_ZOGLIN_ANGRY(MCVersion.MC1_16),
        ENTITY_ZOGLIN_ATTACK(MCVersion.MC1_16),
        ENTITY_ZOGLIN_DEATH(MCVersion.MC1_16),
        ENTITY_ZOGLIN_HURT(MCVersion.MC1_16),
        ENTITY_ZOGLIN_STEP(MCVersion.MC1_16),
        ENTITY_ZOMBIFIED_PIGLIN_AMBIENT(MCVersion.MC1_16),
        ENTITY_ZOMBIFIED_PIGLIN_ANGRY(MCVersion.MC1_16),
        ENTITY_ZOMBIFIED_PIGLIN_DEATH(MCVersion.MC1_16),
        ENTITY_ZOMBIFIED_PIGLIN_HURT(MCVersion.MC1_16),
        ITEM_ARMOR_EQUIP_NETHERITE(MCVersion.MC1_16),
        ITEM_LODESTONE_COMPASS_LOCK(MCVersion.MC1_16),
        MUSIC_DISC_PIGSTEP(MCVersion.MC1_16),
        MUSIC_NETHER_BASALT_DELTAS(MCVersion.MC1_16),
        MUSIC_NETHER_CRIMSON_FOREST(MCVersion.MC1_16),
        MUSIC_NETHER_NETHER_WASTES(MCVersion.MC1_16),
        MUSIC_NETHER_SOUL_SAND_VALLEY(MCVersion.MC1_16),
        MUSIC_NETHER_WARPED_FOREST(MCVersion.MC1_16),
        PARTICLE_SOUL_ESCAPE(MCVersion.MC1_16),
        ENTITY_PARROT_IMITATE_PIGLIN_BRUTE(MCVersion.MC1_16_X),
        ENTITY_PIGLIN_BRUTE_AMBIENT(MCVersion.MC1_16_X),
        ENTITY_PIGLIN_BRUTE_ANGRY(MCVersion.MC1_16_X),
        ENTITY_PIGLIN_BRUTE_CONVERTED_TO_ZOMBIFIED(MCVersion.MC1_16_X),
        ENTITY_PIGLIN_BRUTE_DEATH(MCVersion.MC1_16_X),
        ENTITY_PIGLIN_BRUTE_HURT(MCVersion.MC1_16_X),
        ENTITY_PIGLIN_BRUTE_STEP(MCVersion.MC1_16_X),
        BLOCK_AMETHYST_BLOCK_BREAK(MCVersion.MC1_17),
        BLOCK_AMETHYST_BLOCK_CHIME(MCVersion.MC1_17),
        BLOCK_AMETHYST_BLOCK_FALL(MCVersion.MC1_17),
        BLOCK_AMETHYST_BLOCK_HIT(MCVersion.MC1_17),
        BLOCK_AMETHYST_BLOCK_PLACE(MCVersion.MC1_17),
        BLOCK_AMETHYST_BLOCK_STEP(MCVersion.MC1_17),
        BLOCK_AMETHYST_CLUSTER_BREAK(MCVersion.MC1_17),
        BLOCK_AMETHYST_CLUSTER_FALL(MCVersion.MC1_17),
        BLOCK_AMETHYST_CLUSTER_HIT(MCVersion.MC1_17),
        BLOCK_AMETHYST_CLUSTER_PLACE(MCVersion.MC1_17),
        BLOCK_AMETHYST_CLUSTER_STEP(MCVersion.MC1_17),
        BLOCK_AZALEA_BREAK(MCVersion.MC1_17),
        BLOCK_AZALEA_FALL(MCVersion.MC1_17),
        BLOCK_AZALEA_HIT(MCVersion.MC1_17),
        BLOCK_AZALEA_LEAVES_BREAK(MCVersion.MC1_17),
        BLOCK_AZALEA_LEAVES_FALL(MCVersion.MC1_17),
        BLOCK_AZALEA_LEAVES_HIT(MCVersion.MC1_17),
        BLOCK_AZALEA_LEAVES_PLACE(MCVersion.MC1_17),
        BLOCK_AZALEA_LEAVES_STEP(MCVersion.MC1_17),
        BLOCK_AZALEA_PLACE(MCVersion.MC1_17),
        BLOCK_AZALEA_STEP(MCVersion.MC1_17),
        BLOCK_BIG_DRIPLEAF_BREAK(MCVersion.MC1_17),
        BLOCK_BIG_DRIPLEAF_FALL(MCVersion.MC1_17),
        BLOCK_BIG_DRIPLEAF_HIT(MCVersion.MC1_17),
        BLOCK_BIG_DRIPLEAF_PLACE(MCVersion.MC1_17),
        BLOCK_BIG_DRIPLEAF_STEP(MCVersion.MC1_17),
        BLOCK_BIG_DRIPLEAF_TILT_DOWN(MCVersion.MC1_17),
        BLOCK_BIG_DRIPLEAF_TILT_UP(MCVersion.MC1_17),
        BLOCK_CAKE_ADD_CANDLE(MCVersion.MC1_17),
        BLOCK_CALCITE_BREAK(MCVersion.MC1_17),
        BLOCK_CALCITE_FALL(MCVersion.MC1_17),
        BLOCK_CALCITE_HIT(MCVersion.MC1_17),
        BLOCK_CALCITE_PLACE(MCVersion.MC1_17),
        BLOCK_CALCITE_STEP(MCVersion.MC1_17),
        BLOCK_CANDLE_AMBIENT(MCVersion.MC1_17),
        BLOCK_CANDLE_BREAK(MCVersion.MC1_17),
        BLOCK_CANDLE_EXTINGUISH(MCVersion.MC1_17),
        BLOCK_CANDLE_FALL(MCVersion.MC1_17),
        BLOCK_CANDLE_HIT(MCVersion.MC1_17),
        BLOCK_CANDLE_PLACE(MCVersion.MC1_17),
        BLOCK_CANDLE_STEP(MCVersion.MC1_17),
        BLOCK_CAVE_VINES_BREAK(MCVersion.MC1_17),
        BLOCK_CAVE_VINES_FALL(MCVersion.MC1_17),
        BLOCK_CAVE_VINES_HIT(MCVersion.MC1_17),
        BLOCK_CAVE_VINES_PICK_BERRIES(MCVersion.MC1_17),
        BLOCK_CAVE_VINES_PLACE(MCVersion.MC1_17),
        BLOCK_CAVE_VINES_STEP(MCVersion.MC1_17),
        BLOCK_COPPER_BREAK(MCVersion.MC1_17),
        BLOCK_COPPER_FALL(MCVersion.MC1_17),
        BLOCK_COPPER_HIT(MCVersion.MC1_17),
        BLOCK_COPPER_PLACE(MCVersion.MC1_17),
        BLOCK_COPPER_STEP(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_BREAK(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_BRICKS_BREAK(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_BRICKS_FALL(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_BRICKS_HIT(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_BRICKS_PLACE(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_BRICKS_STEP(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_FALL(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_HIT(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_PLACE(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_STEP(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_TILES_BREAK(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_TILES_FALL(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_TILES_HIT(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_TILES_PLACE(MCVersion.MC1_17),
        BLOCK_DEEPSLATE_TILES_STEP(MCVersion.MC1_17),
        BLOCK_DRIPSTONE_BLOCK_BREAK(MCVersion.MC1_17),
        BLOCK_DRIPSTONE_BLOCK_FALL(MCVersion.MC1_17),
        BLOCK_DRIPSTONE_BLOCK_HIT(MCVersion.MC1_17),
        BLOCK_DRIPSTONE_BLOCK_PLACE(MCVersion.MC1_17),
        BLOCK_DRIPSTONE_BLOCK_STEP(MCVersion.MC1_17),
        BLOCK_FLOWERING_AZALEA_BREAK(MCVersion.MC1_17),
        BLOCK_FLOWERING_AZALEA_FALL(MCVersion.MC1_17),
        BLOCK_FLOWERING_AZALEA_HIT(MCVersion.MC1_17),
        BLOCK_FLOWERING_AZALEA_PLACE(MCVersion.MC1_17),
        BLOCK_FLOWERING_AZALEA_STEP(MCVersion.MC1_17),
        BLOCK_HANGING_ROOTS_BREAK(MCVersion.MC1_17),
        BLOCK_HANGING_ROOTS_FALL(MCVersion.MC1_17),
        BLOCK_HANGING_ROOTS_HIT(MCVersion.MC1_17),
        BLOCK_HANGING_ROOTS_PLACE(MCVersion.MC1_17),
        BLOCK_HANGING_ROOTS_STEP(MCVersion.MC1_17),
        BLOCK_LARGE_AMETHYST_BUD_BREAK(MCVersion.MC1_17),
        BLOCK_LARGE_AMETHYST_BUD_PLACE(MCVersion.MC1_17),
        BLOCK_MEDIUM_AMETHYST_BUD_BREAK(MCVersion.MC1_17),
        BLOCK_MEDIUM_AMETHYST_BUD_PLACE(MCVersion.MC1_17),
        BLOCK_MOSS_BREAK(MCVersion.MC1_17),
        BLOCK_MOSS_CARPET_BREAK(MCVersion.MC1_17),
        BLOCK_MOSS_CARPET_FALL(MCVersion.MC1_17),
        BLOCK_MOSS_CARPET_HIT(MCVersion.MC1_17),
        BLOCK_MOSS_CARPET_PLACE(MCVersion.MC1_17),
        BLOCK_MOSS_CARPET_STEP(MCVersion.MC1_17),
        BLOCK_MOSS_FALL(MCVersion.MC1_17),
        BLOCK_MOSS_HIT(MCVersion.MC1_17),
        BLOCK_MOSS_PLACE(MCVersion.MC1_17),
        BLOCK_MOSS_STEP(MCVersion.MC1_17),
        BLOCK_POINTED_DRIPSTONE_BREAK(MCVersion.MC1_17),
        BLOCK_POINTED_DRIPSTONE_DRIP_LAVA(MCVersion.MC1_17),
        BLOCK_POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON(MCVersion.MC1_17),
        BLOCK_POINTED_DRIPSTONE_DRIP_WATER(MCVersion.MC1_17),
        BLOCK_POINTED_DRIPSTONE_DRIP_WATER_INTO_CAULDRON(MCVersion.MC1_17),
        BLOCK_POINTED_DRIPSTONE_FALL(MCVersion.MC1_17),
        BLOCK_POINTED_DRIPSTONE_HIT(MCVersion.MC1_17),
        BLOCK_POINTED_DRIPSTONE_LAND(MCVersion.MC1_17),
        BLOCK_POINTED_DRIPSTONE_PLACE(MCVersion.MC1_17),
        BLOCK_POINTED_DRIPSTONE_STEP(MCVersion.MC1_17),
        BLOCK_POLISHED_DEEPSLATE_BREAK(MCVersion.MC1_17),
        BLOCK_POLISHED_DEEPSLATE_FALL(MCVersion.MC1_17),
        BLOCK_POLISHED_DEEPSLATE_HIT(MCVersion.MC1_17),
        BLOCK_POLISHED_DEEPSLATE_PLACE(MCVersion.MC1_17),
        BLOCK_POLISHED_DEEPSLATE_STEP(MCVersion.MC1_17),
        BLOCK_POWDER_SNOW_BREAK(MCVersion.MC1_17),
        BLOCK_POWDER_SNOW_FALL(MCVersion.MC1_17),
        BLOCK_POWDER_SNOW_HIT(MCVersion.MC1_17),
        BLOCK_POWDER_SNOW_PLACE(MCVersion.MC1_17),
        BLOCK_POWDER_SNOW_STEP(MCVersion.MC1_17),
        BLOCK_ROOTED_DIRT_BREAK(MCVersion.MC1_17),
        BLOCK_ROOTED_DIRT_FALL(MCVersion.MC1_17),
        BLOCK_ROOTED_DIRT_HIT(MCVersion.MC1_17),
        BLOCK_ROOTED_DIRT_PLACE(MCVersion.MC1_17),
        BLOCK_ROOTED_DIRT_STEP(MCVersion.MC1_17),
        BLOCK_SCULK_SENSOR_BREAK(MCVersion.MC1_17),
        BLOCK_SCULK_SENSOR_CLICKING(MCVersion.MC1_17),
        BLOCK_SCULK_SENSOR_CLICKING_STOP(MCVersion.MC1_17),
        BLOCK_SCULK_SENSOR_FALL(MCVersion.MC1_17),
        BLOCK_SCULK_SENSOR_HIT(MCVersion.MC1_17),
        BLOCK_SCULK_SENSOR_PLACE(MCVersion.MC1_17),
        BLOCK_SCULK_SENSOR_STEP(MCVersion.MC1_17),
        BLOCK_SMALL_AMETHYST_BUD_BREAK(MCVersion.MC1_17),
        BLOCK_SMALL_AMETHYST_BUD_PLACE(MCVersion.MC1_17),
        BLOCK_SMALL_DRIPLEAF_BREAK(MCVersion.MC1_17),
        BLOCK_SMALL_DRIPLEAF_FALL(MCVersion.MC1_17),
        BLOCK_SMALL_DRIPLEAF_HIT(MCVersion.MC1_17),
        BLOCK_SMALL_DRIPLEAF_PLACE(MCVersion.MC1_17),
        BLOCK_SMALL_DRIPLEAF_STEP(MCVersion.MC1_17),
        BLOCK_SPORE_BLOSSOM_BREAK(MCVersion.MC1_17),
        BLOCK_SPORE_BLOSSOM_FALL(MCVersion.MC1_17),
        BLOCK_SPORE_BLOSSOM_HIT(MCVersion.MC1_17),
        BLOCK_SPORE_BLOSSOM_PLACE(MCVersion.MC1_17),
        BLOCK_SPORE_BLOSSOM_STEP(MCVersion.MC1_17),
        BLOCK_SWEET_BERRY_BUSH_PICK_BERRIES(MCVersion.MC1_17),
        BLOCK_TUFF_BREAK(MCVersion.MC1_17),
        BLOCK_TUFF_FALL(MCVersion.MC1_17),
        BLOCK_TUFF_HIT(MCVersion.MC1_17),
        BLOCK_TUFF_PLACE(MCVersion.MC1_17),
        BLOCK_TUFF_STEP(MCVersion.MC1_17),
        BLOCK_VINE_BREAK(MCVersion.MC1_17),
        BLOCK_VINE_FALL(MCVersion.MC1_17),
        BLOCK_VINE_HIT(MCVersion.MC1_17),
        BLOCK_VINE_PLACE(MCVersion.MC1_17),
        ENTITY_AXOLOTL_ATTACK(MCVersion.MC1_17),
        ENTITY_AXOLOTL_DEATH(MCVersion.MC1_17),
        ENTITY_AXOLOTL_HURT(MCVersion.MC1_17),
        ENTITY_AXOLOTL_IDLE_AIR(MCVersion.MC1_17),
        ENTITY_AXOLOTL_IDLE_WATER(MCVersion.MC1_17),
        ENTITY_AXOLOTL_SPLASH(MCVersion.MC1_17),
        ENTITY_AXOLOTL_SWIM(MCVersion.MC1_17),
        ENTITY_GLOW_ITEM_FRAME_ADD_ITEM(MCVersion.MC1_17),
        ENTITY_GLOW_ITEM_FRAME_BREAK(MCVersion.MC1_17),
        ENTITY_GLOW_ITEM_FRAME_PLACE(MCVersion.MC1_17),
        ENTITY_GLOW_ITEM_FRAME_REMOVE_ITEM(MCVersion.MC1_17),
        ENTITY_GLOW_ITEM_FRAME_ROTATE_ITEM(MCVersion.MC1_17),
        ENTITY_GLOW_SQUID_AMBIENT(MCVersion.MC1_17),
        ENTITY_GLOW_SQUID_DEATH(MCVersion.MC1_17),
        ENTITY_GLOW_SQUID_HURT(MCVersion.MC1_17),
        ENTITY_GLOW_SQUID_SQUIRT(MCVersion.MC1_17),
        ENTITY_GOAT_AMBIENT(MCVersion.MC1_17),
        ENTITY_GOAT_DEATH(MCVersion.MC1_17),
        ENTITY_GOAT_EAT(MCVersion.MC1_17),
        ENTITY_GOAT_HURT(MCVersion.MC1_17),
        ENTITY_GOAT_LONG_JUMP(MCVersion.MC1_17),
        ENTITY_GOAT_MILK(MCVersion.MC1_17),
        ENTITY_GOAT_PREPARE_RAM(MCVersion.MC1_17),
        ENTITY_GOAT_RAM_IMPACT(MCVersion.MC1_17),
        ENTITY_GOAT_SCREAMING_AMBIENT(MCVersion.MC1_17),
        ENTITY_GOAT_SCREAMING_DEATH(MCVersion.MC1_17),
        ENTITY_GOAT_SCREAMING_EAT(MCVersion.MC1_17),
        ENTITY_GOAT_SCREAMING_HURT(MCVersion.MC1_17),
        ENTITY_GOAT_SCREAMING_LONG_JUMP(MCVersion.MC1_17),
        ENTITY_GOAT_SCREAMING_MILK(MCVersion.MC1_17),
        ENTITY_GOAT_SCREAMING_PREPARE_RAM(MCVersion.MC1_17),
        ENTITY_GOAT_SCREAMING_RAM_IMPACT(MCVersion.MC1_17),
        ENTITY_GOAT_STEP(MCVersion.MC1_17),
        ENTITY_MINECART_INSIDE_UNDERWATER(MCVersion.MC1_17),
        ENTITY_PLAYER_HURT_FREEZE(MCVersion.MC1_17),
        ENTITY_SKELETON_CONVERTED_TO_STRAY(MCVersion.MC1_17),
        ITEM_AXE_SCRAPE(MCVersion.MC1_17),
        ITEM_AXE_WAX_OFF(MCVersion.MC1_17),
        ITEM_BONE_MEAL_USE(MCVersion.MC1_17),
        ITEM_BUCKET_EMPTY_AXOLOTL(MCVersion.MC1_17),
        ITEM_BUCKET_EMPTY_POWDER_SNOW(MCVersion.MC1_17),
        ITEM_BUCKET_FILL_AXOLOTL(MCVersion.MC1_17),
        ITEM_BUCKET_FILL_POWDER_SNOW(MCVersion.MC1_17),
        ITEM_DYE_USE(MCVersion.MC1_17),
        ITEM_GLOW_INK_SAC_USE(MCVersion.MC1_17),
        ITEM_HONEYCOMB_WAX_ON(MCVersion.MC1_17),
        ITEM_INK_SAC_USE(MCVersion.MC1_17),
        ITEM_SPYGLASS_STOP_USING(MCVersion.MC1_17),
        ITEM_SPYGLASS_USE(MCVersion.MC1_17),
        BLOCK_GROWING_PLANT_CROP(MCVersion.MC1_18),
        ITEM_BUNDLE_DROP_CONTENTS(MCVersion.MC1_18),
        ITEM_BUNDLE_INSERT(MCVersion.MC1_18),
        ITEM_BUNDLE_REMOVE_ONE(MCVersion.MC1_18),
        MUSIC_DISC_OTHERSIDE(MCVersion.MC1_18),
        MUSIC_OVERWORLD_DRIPSTONE_CAVES(MCVersion.MC1_18),
        MUSIC_OVERWORLD_FROZEN_PEAKS(MCVersion.MC1_18),
        MUSIC_OVERWORLD_GROVE(MCVersion.MC1_18),
        MUSIC_OVERWORLD_JAGGED_PEAKS(MCVersion.MC1_18),
        MUSIC_OVERWORLD_LUSH_CAVES(MCVersion.MC1_18),
        MUSIC_OVERWORLD_MEADOW(MCVersion.MC1_18),
        MUSIC_OVERWORLD_SNOWY_SLOPES(MCVersion.MC1_18),
        MUSIC_OVERWORLD_STONY_PEAKS(MCVersion.MC1_18),
        BLOCK_FROGLIGHT_BREAK(MCVersion.MC1_19),
        BLOCK_FROGLIGHT_FALL(MCVersion.MC1_19),
        BLOCK_FROGLIGHT_HIT(MCVersion.MC1_19),
        BLOCK_FROGLIGHT_PLACE(MCVersion.MC1_19),
        BLOCK_FROGLIGHT_STEP(MCVersion.MC1_19),
        BLOCK_FROGSPAWN_BREAK(MCVersion.MC1_19),
        BLOCK_FROGSPAWN_FALL(MCVersion.MC1_19),
        BLOCK_FROGSPAWN_HATCH(MCVersion.MC1_19),
        BLOCK_FROGSPAWN_HIT(MCVersion.MC1_19),
        BLOCK_FROGSPAWN_PLACE(MCVersion.MC1_19),
        BLOCK_FROGSPAWN_STEP(MCVersion.MC1_19),
        BLOCK_MANGROVE_ROOTS_BREAK(MCVersion.MC1_19),
        BLOCK_MANGROVE_ROOTS_FALL(MCVersion.MC1_19),
        BLOCK_MANGROVE_ROOTS_HIT(MCVersion.MC1_19),
        BLOCK_MANGROVE_ROOTS_PLACE(MCVersion.MC1_19),
        BLOCK_MANGROVE_ROOTS_STEP(MCVersion.MC1_19),
        BLOCK_MUDDY_MANGROVE_ROOTS_BREAK(MCVersion.MC1_19),
        BLOCK_MUDDY_MANGROVE_ROOTS_FALL(MCVersion.MC1_19),
        BLOCK_MUDDY_MANGROVE_ROOTS_HIT(MCVersion.MC1_19),
        BLOCK_MUDDY_MANGROVE_ROOTS_PLACE(MCVersion.MC1_19),
        BLOCK_MUDDY_MANGROVE_ROOTS_STEP(MCVersion.MC1_19),
        BLOCK_MUD_BREAK(MCVersion.MC1_19),
        BLOCK_MUD_BRICKS_BREAK(MCVersion.MC1_19),
        BLOCK_MUD_BRICKS_FALL(MCVersion.MC1_19),
        BLOCK_MUD_BRICKS_HIT(MCVersion.MC1_19),
        BLOCK_MUD_BRICKS_PLACE(MCVersion.MC1_19),
        BLOCK_MUD_BRICKS_STEP(MCVersion.MC1_19),
        BLOCK_MUD_FALL(MCVersion.MC1_19),
        BLOCK_MUD_HIT(MCVersion.MC1_19),
        BLOCK_MUD_PLACE(MCVersion.MC1_19),
        BLOCK_MUD_STEP(MCVersion.MC1_19),
        BLOCK_PACKED_MUD_BREAK(MCVersion.MC1_19),
        BLOCK_PACKED_MUD_FALL(MCVersion.MC1_19),
        BLOCK_PACKED_MUD_HIT(MCVersion.MC1_19),
        BLOCK_PACKED_MUD_PLACE(MCVersion.MC1_19),
        BLOCK_PACKED_MUD_STEP(MCVersion.MC1_19),
        BLOCK_SCULK_BREAK(MCVersion.MC1_19),
        BLOCK_SCULK_CATALYST_BLOOM(MCVersion.MC1_19),
        BLOCK_SCULK_CATALYST_BREAK(MCVersion.MC1_19),
        BLOCK_SCULK_CATALYST_FALL(MCVersion.MC1_19),
        BLOCK_SCULK_CATALYST_HIT(MCVersion.MC1_19),
        BLOCK_SCULK_CATALYST_PLACE(MCVersion.MC1_19),
        BLOCK_SCULK_CATALYST_STEP(MCVersion.MC1_19),
        BLOCK_SCULK_CHARGE(MCVersion.MC1_19),
        BLOCK_SCULK_FALL(MCVersion.MC1_19),
        BLOCK_SCULK_HIT(MCVersion.MC1_19),
        BLOCK_SCULK_PLACE(MCVersion.MC1_19),
        BLOCK_SCULK_SHRIEKER_BREAK(MCVersion.MC1_19),
        BLOCK_SCULK_SHRIEKER_FALL(MCVersion.MC1_19),
        BLOCK_SCULK_SHRIEKER_HIT(MCVersion.MC1_19),
        BLOCK_SCULK_SHRIEKER_PLACE(MCVersion.MC1_19),
        BLOCK_SCULK_SHRIEKER_SHRIEK(MCVersion.MC1_19),
        BLOCK_SCULK_SHRIEKER_STEP(MCVersion.MC1_19),
        BLOCK_SCULK_SPREAD(MCVersion.MC1_19),
        BLOCK_SCULK_STEP(MCVersion.MC1_19),
        BLOCK_SCULK_VEIN_BREAK(MCVersion.MC1_19),
        BLOCK_SCULK_VEIN_FALL(MCVersion.MC1_19),
        BLOCK_SCULK_VEIN_HIT(MCVersion.MC1_19),
        BLOCK_SCULK_VEIN_PLACE(MCVersion.MC1_19),
        BLOCK_SCULK_VEIN_STEP(MCVersion.MC1_19),
        ENTITY_ALLAY_AMBIENT_WITHOUT_ITEM(MCVersion.MC1_19),
        ENTITY_ALLAY_AMBIENT_WITH_ITEM(MCVersion.MC1_19),
        ENTITY_ALLAY_DEATH(MCVersion.MC1_19),
        ENTITY_ALLAY_HURT(MCVersion.MC1_19),
        ENTITY_ALLAY_ITEM_GIVEN(MCVersion.MC1_19),
        ENTITY_ALLAY_ITEM_TAKEN(MCVersion.MC1_19),
        ENTITY_ALLAY_ITEM_THROWN(MCVersion.MC1_19),
        ENTITY_FROG_AMBIENT(MCVersion.MC1_19),
        ENTITY_FROG_DEATH(MCVersion.MC1_19),
        ENTITY_FROG_EAT(MCVersion.MC1_19),
        ENTITY_FROG_HURT(MCVersion.MC1_19),
        ENTITY_FROG_LAY_SPAWN(MCVersion.MC1_19),
        ENTITY_FROG_LONG_JUMP(MCVersion.MC1_19),
        ENTITY_FROG_STEP(MCVersion.MC1_19),
        ENTITY_FROG_TONGUE(MCVersion.MC1_19),
        ENTITY_GOAT_HORN_BREAK(MCVersion.MC1_19),
        ENTITY_PARROT_IMITATE_WARDEN(MCVersion.MC1_19),
        ENTITY_TADPOLE_DEATH(MCVersion.MC1_19),
        ENTITY_TADPOLE_FLOP(MCVersion.MC1_19),
        ENTITY_TADPOLE_GROW_UP(MCVersion.MC1_19),
        ENTITY_TADPOLE_HURT(MCVersion.MC1_19),
        ENTITY_WARDEN_AGITATED(MCVersion.MC1_19),
        ENTITY_WARDEN_AMBIENT(MCVersion.MC1_19),
        ENTITY_WARDEN_ANGRY(MCVersion.MC1_19),
        ENTITY_WARDEN_ATTACK_IMPACT(MCVersion.MC1_19),
        ENTITY_WARDEN_DEATH(MCVersion.MC1_19),
        ENTITY_WARDEN_DIG(MCVersion.MC1_19),
        ENTITY_WARDEN_EMERGE(MCVersion.MC1_19),
        ENTITY_WARDEN_HEARTBEAT(MCVersion.MC1_19),
        ENTITY_WARDEN_HURT(MCVersion.MC1_19),
        ENTITY_WARDEN_LISTENING(MCVersion.MC1_19),
        ENTITY_WARDEN_LISTENING_ANGRY(MCVersion.MC1_19),
        ENTITY_WARDEN_NEARBY_CLOSE(MCVersion.MC1_19),
        ENTITY_WARDEN_NEARBY_CLOSER(MCVersion.MC1_19),
        ENTITY_WARDEN_NEARBY_CLOSEST(MCVersion.MC1_19),
        ENTITY_WARDEN_ROAR(MCVersion.MC1_19),
        ENTITY_WARDEN_SNIFF(MCVersion.MC1_19),
        ENTITY_WARDEN_SONIC_BOOM(MCVersion.MC1_19),
        ENTITY_WARDEN_SONIC_CHARGE(MCVersion.MC1_19),
        ENTITY_WARDEN_STEP(MCVersion.MC1_19),
        ENTITY_WARDEN_TENDRIL_CLICKS(MCVersion.MC1_19),
        ITEM_BUCKET_EMPTY_TADPOLE(MCVersion.MC1_19),
        ITEM_BUCKET_FILL_TADPOLE(MCVersion.MC1_19),
        ITEM_GOAT_HORN_SOUND_0(MCVersion.MC1_19),
        ITEM_GOAT_HORN_SOUND_1(MCVersion.MC1_19),
        ITEM_GOAT_HORN_SOUND_2(MCVersion.MC1_19),
        ITEM_GOAT_HORN_SOUND_3(MCVersion.MC1_19),
        ITEM_GOAT_HORN_SOUND_4(MCVersion.MC1_19),
        ITEM_GOAT_HORN_SOUND_5(MCVersion.MC1_19),
        ITEM_GOAT_HORN_SOUND_6(MCVersion.MC1_19),
        ITEM_GOAT_HORN_SOUND_7(MCVersion.MC1_19),
        MUSIC_DISC_5(MCVersion.MC1_19),
        MUSIC_OVERWORLD_DEEP_DARK(MCVersion.MC1_19),
        MUSIC_OVERWORLD_JUNGLE_AND_FOREST(MCVersion.MC1_19, MCVersion.MC1_19_4),
        MUSIC_OVERWORLD_OLD_GROWTH_TAIGA(MCVersion.MC1_19),
        MUSIC_OVERWORLD_SWAMP(MCVersion.MC1_19),
        BLOCK_BAMBOO_WOOD_BREAK(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_BUTTON_CLICK_OFF(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_BUTTON_CLICK_ON(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_DOOR_CLOSE(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_DOOR_OPEN(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_FALL(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_FENCE_GATE_CLOSE(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_FENCE_GATE_OPEN(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_HANGING_SIGN_BREAK(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_HANGING_SIGN_FALL(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_HANGING_SIGN_HIT(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_HANGING_SIGN_PLACE(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_HANGING_SIGN_STEP(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_HIT(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_PLACE(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_PRESSURE_PLATE_CLICK_OFF(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_PRESSURE_PLATE_CLICK_ON(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_STEP(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_TRAPDOOR_CLOSE(MCVersion.MC1_19_3),
        BLOCK_BAMBOO_WOOD_TRAPDOOR_OPEN(MCVersion.MC1_19_3),
        BLOCK_CHISELED_BOOKSHELF_BREAK(MCVersion.MC1_19_3),
        BLOCK_CHISELED_BOOKSHELF_FALL(MCVersion.MC1_19_3),
        BLOCK_CHISELED_BOOKSHELF_HIT(MCVersion.MC1_19_3),
        BLOCK_CHISELED_BOOKSHELF_INSERT(MCVersion.MC1_19_3),
        BLOCK_CHISELED_BOOKSHELF_INSERT_ENCHANTED(MCVersion.MC1_19_3),
        BLOCK_CHISELED_BOOKSHELF_PICKUP(MCVersion.MC1_19_3),
        BLOCK_CHISELED_BOOKSHELF_PICKUP_ENCHANTED(MCVersion.MC1_19_3),
        BLOCK_CHISELED_BOOKSHELF_PLACE(MCVersion.MC1_19_3),
        BLOCK_CHISELED_BOOKSHELF_STEP(MCVersion.MC1_19_3),
        BLOCK_HANGING_SIGN_BREAK(MCVersion.MC1_19_3),
        BLOCK_HANGING_SIGN_FALL(MCVersion.MC1_19_3),
        BLOCK_HANGING_SIGN_HIT(MCVersion.MC1_19_3),
        BLOCK_HANGING_SIGN_PLACE(MCVersion.MC1_19_3),
        BLOCK_HANGING_SIGN_STEP(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_BREAK(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_BUTTON_CLICK_OFF(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_BUTTON_CLICK_ON(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_DOOR_CLOSE(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_DOOR_OPEN(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_FALL(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_FENCE_GATE_CLOSE(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_FENCE_GATE_OPEN(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_HANGING_SIGN_BREAK(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_HANGING_SIGN_FALL(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_HANGING_SIGN_HIT(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_HANGING_SIGN_PLACE(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_HANGING_SIGN_STEP(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_HIT(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_PLACE(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_PRESSURE_PLATE_CLICK_OFF(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_PRESSURE_PLATE_CLICK_ON(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_STEP(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_TRAPDOOR_CLOSE(MCVersion.MC1_19_3),
        BLOCK_NETHER_WOOD_TRAPDOOR_OPEN(MCVersion.MC1_19_3),
        BLOCK_NOTE_BLOCK_IMITATE_CREEPER(MCVersion.MC1_19_3),
        BLOCK_NOTE_BLOCK_IMITATE_ENDER_DRAGON(MCVersion.MC1_19_3),
        BLOCK_NOTE_BLOCK_IMITATE_PIGLIN(MCVersion.MC1_19_3),
        BLOCK_NOTE_BLOCK_IMITATE_SKELETON(MCVersion.MC1_19_3),
        BLOCK_NOTE_BLOCK_IMITATE_WITHER_SKELETON(MCVersion.MC1_19_3),
        BLOCK_NOTE_BLOCK_IMITATE_ZOMBIE(MCVersion.MC1_19_3),
        ENTITY_CAMEL_AMBIENT(MCVersion.MC1_19_3),
        ENTITY_CAMEL_DASH(MCVersion.MC1_19_3),
        ENTITY_CAMEL_DASH_READY(MCVersion.MC1_19_3),
        ENTITY_CAMEL_DEATH(MCVersion.MC1_19_3),
        ENTITY_CAMEL_EAT(MCVersion.MC1_19_3),
        ENTITY_CAMEL_HURT(MCVersion.MC1_19_3),
        ENTITY_CAMEL_SADDLE(MCVersion.MC1_19_3),
        ENTITY_CAMEL_SIT(MCVersion.MC1_19_3),
        ENTITY_CAMEL_STAND(MCVersion.MC1_19_3),
        ENTITY_CAMEL_STEP(MCVersion.MC1_19_3),
        ENTITY_CAMEL_STEP_SAND(MCVersion.MC1_19_3),
        BLOCK_CHERRY_LEAVES_BREAK(MCVersion.MC1_19_4),
        BLOCK_CHERRY_LEAVES_FALL(MCVersion.MC1_19_4),
        BLOCK_CHERRY_LEAVES_HIT(MCVersion.MC1_19_4),
        BLOCK_CHERRY_LEAVES_PLACE(MCVersion.MC1_19_4),
        BLOCK_CHERRY_LEAVES_STEP(MCVersion.MC1_19_4),
        BLOCK_CHERRY_SAPLING_BREAK(MCVersion.MC1_19_4),
        BLOCK_CHERRY_SAPLING_FALL(MCVersion.MC1_19_4),
        BLOCK_CHERRY_SAPLING_HIT(MCVersion.MC1_19_4),
        BLOCK_CHERRY_SAPLING_PLACE(MCVersion.MC1_19_4),
        BLOCK_CHERRY_SAPLING_STEP(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_BREAK(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_BUTTON_CLICK_OFF(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_BUTTON_CLICK_ON(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_DOOR_CLOSE(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_DOOR_OPEN(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_FALL(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_FENCE_GATE_CLOSE(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_FENCE_GATE_OPEN(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_HANGING_SIGN_BREAK(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_HANGING_SIGN_FALL(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_HANGING_SIGN_HIT(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_HANGING_SIGN_PLACE(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_HANGING_SIGN_STEP(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_HIT(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_PLACE(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_PRESSURE_PLATE_CLICK_OFF(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_PRESSURE_PLATE_CLICK_ON(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_STEP(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_TRAPDOOR_CLOSE(MCVersion.MC1_19_4),
        BLOCK_CHERRY_WOOD_TRAPDOOR_OPEN(MCVersion.MC1_19_4),
        BLOCK_DECORATED_POT_BREAK(MCVersion.MC1_19_4),
        BLOCK_DECORATED_POT_FALL(MCVersion.MC1_19_4),
        BLOCK_DECORATED_POT_HIT(MCVersion.MC1_19_4),
        BLOCK_DECORATED_POT_PLACE(MCVersion.MC1_19_4),
        BLOCK_DECORATED_POT_SHATTER(MCVersion.MC1_19_4),
        BLOCK_DECORATED_POT_STEP(MCVersion.MC1_19_4),
        BLOCK_PINK_PETALS_BREAK(MCVersion.MC1_19_4),
        BLOCK_PINK_PETALS_FALL(MCVersion.MC1_19_4),
        BLOCK_PINK_PETALS_HIT(MCVersion.MC1_19_4),
        BLOCK_PINK_PETALS_PLACE(MCVersion.MC1_19_4),
        BLOCK_PINK_PETALS_STEP(MCVersion.MC1_19_4),
        BLOCK_SUSPICIOUS_SAND_BREAK(MCVersion.MC1_19_4),
        BLOCK_SUSPICIOUS_SAND_FALL(MCVersion.MC1_19_4),
        BLOCK_SUSPICIOUS_SAND_HIT(MCVersion.MC1_19_4),
        BLOCK_SUSPICIOUS_SAND_PLACE(MCVersion.MC1_19_4),
        BLOCK_SUSPICIOUS_SAND_STEP(MCVersion.MC1_19_4),
        ENTITY_SNIFFER_DEATH(MCVersion.MC1_19_4),
        ENTITY_SNIFFER_DIGGING(MCVersion.MC1_19_4),
        ENTITY_SNIFFER_DIGGING_STOP(MCVersion.MC1_19_4),
        ENTITY_SNIFFER_DROP_SEED(MCVersion.MC1_19_4),
        ENTITY_SNIFFER_EAT(MCVersion.MC1_19_4),
        ENTITY_SNIFFER_HAPPY(MCVersion.MC1_19_4),
        ENTITY_SNIFFER_HURT(MCVersion.MC1_19_4),
        ENTITY_SNIFFER_IDLE(MCVersion.MC1_19_4),
        ENTITY_SNIFFER_SCENTING(MCVersion.MC1_19_4),
        ENTITY_SNIFFER_SEARCHING(MCVersion.MC1_19_4),
        ENTITY_SNIFFER_SNIFFING(MCVersion.MC1_19_4),
        ENTITY_SNIFFER_STEP(MCVersion.MC1_19_4),
        INTENTIONALLY_EMPTY(MCVersion.MC1_19_4),
        ITEM_BRUSH_BRUSHING(MCVersion.MC1_19_4, MCVersion.MC1_19_4),
        ITEM_BRUSH_BRUSH_SAND_COMPLETED(MCVersion.MC1_19_4, MCVersion.MC1_19_4),
        MUSIC_OVERWORLD_CHERRY_GROVE(MCVersion.MC1_19_4),
        BLOCK_AMETHYST_BLOCK_RESONATE(MCVersion.MC1_20),
        BLOCK_SIGN_WAXED_INTERACT_FAIL(MCVersion.MC1_20),
        BLOCK_SNIFFER_EGG_CRACK(MCVersion.MC1_20),
        BLOCK_SNIFFER_EGG_HATCH(MCVersion.MC1_20),
        BLOCK_SNIFFER_EGG_PLOP(MCVersion.MC1_20),
        BLOCK_SUSPICIOUS_GRAVEL_BREAK(MCVersion.MC1_20),
        BLOCK_SUSPICIOUS_GRAVEL_FALL(MCVersion.MC1_20),
        BLOCK_SUSPICIOUS_GRAVEL_HIT(MCVersion.MC1_20),
        BLOCK_SUSPICIOUS_GRAVEL_PLACE(MCVersion.MC1_20),
        BLOCK_SUSPICIOUS_GRAVEL_STEP(MCVersion.MC1_20),
        ITEM_BRUSH_BRUSHING_GENERIC(MCVersion.MC1_20),
        ITEM_BRUSH_BRUSHING_GRAVEL(MCVersion.MC1_20),
        ITEM_BRUSH_BRUSHING_GRAVEL_COMPLETE(MCVersion.MC1_20),
        ITEM_BRUSH_BRUSHING_SAND(MCVersion.MC1_20),
        ITEM_BRUSH_BRUSHING_SAND_COMPLETE(MCVersion.MC1_20),
        MUSIC_DISC_RELIC(MCVersion.MC1_20),
        MUSIC_OVERWORLD_BADLANDS(MCVersion.MC1_20),
        MUSIC_OVERWORLD_BAMBOO_JUNGLE(MCVersion.MC1_20),
        MUSIC_OVERWORLD_DESERT(MCVersion.MC1_20),
        MUSIC_OVERWORLD_FLOWER_FOREST(MCVersion.MC1_20),
        MUSIC_OVERWORLD_FOREST(MCVersion.MC1_20),
        MUSIC_OVERWORLD_JUNGLE(MCVersion.MC1_20),
        MUSIC_OVERWORLD_SPARSE_JUNGLE(MCVersion.MC1_20),
        BLOCK_SPONGE_ABSORB(MCVersion.MC1_20_2),
        BLOCK_SPONGE_BREAK(MCVersion.MC1_20_2),
        BLOCK_SPONGE_FALL(MCVersion.MC1_20_2),
        BLOCK_SPONGE_HIT(MCVersion.MC1_20_2),
        BLOCK_SPONGE_PLACE(MCVersion.MC1_20_2),
        BLOCK_SPONGE_STEP(MCVersion.MC1_20_2),
        BLOCK_WET_SPONGE_BREAK(MCVersion.MC1_20_2),
        BLOCK_WET_SPONGE_FALL(MCVersion.MC1_20_2),
        BLOCK_WET_SPONGE_HIT(MCVersion.MC1_20_2),
        BLOCK_WET_SPONGE_PLACE(MCVersion.MC1_20_2),
        BLOCK_WET_SPONGE_STEP(MCVersion.MC1_20_2),
        BLOCK_COPPER_BULB_BREAK(MCVersion.MC1_20_4),
        BLOCK_COPPER_BULB_FALL(MCVersion.MC1_20_4),
        BLOCK_COPPER_BULB_HIT(MCVersion.MC1_20_4),
        BLOCK_COPPER_BULB_PLACE(MCVersion.MC1_20_4),
        BLOCK_COPPER_BULB_STEP(MCVersion.MC1_20_4),
        BLOCK_COPPER_BULB_TURN_OFF(MCVersion.MC1_20_4),
        BLOCK_COPPER_BULB_TURN_ON(MCVersion.MC1_20_4),
        BLOCK_COPPER_DOOR_CLOSE(MCVersion.MC1_20_4),
        BLOCK_COPPER_DOOR_OPEN(MCVersion.MC1_20_4),
        BLOCK_COPPER_GRATE_BREAK(MCVersion.MC1_20_4),
        BLOCK_COPPER_GRATE_FALL(MCVersion.MC1_20_4),
        BLOCK_COPPER_GRATE_HIT(MCVersion.MC1_20_4),
        BLOCK_COPPER_GRATE_PLACE(MCVersion.MC1_20_4),
        BLOCK_COPPER_GRATE_STEP(MCVersion.MC1_20_4),
        BLOCK_COPPER_TRAPDOOR_CLOSE(MCVersion.MC1_20_4),
        BLOCK_COPPER_TRAPDOOR_OPEN(MCVersion.MC1_20_4),
        BLOCK_CRAFTER_CRAFT(MCVersion.MC1_20_4),
        BLOCK_CRAFTER_FAIL(MCVersion.MC1_20_4),
        BLOCK_DECORATED_POT_INSERT(MCVersion.MC1_20_4),
        BLOCK_DECORATED_POT_INSERT_FAIL(MCVersion.MC1_20_4),
        BLOCK_HANGING_SIGN_WAXED_INTERACT_FAIL(MCVersion.MC1_20_4),
        BLOCK_POLISHED_TUFF_BREAK(MCVersion.MC1_20_4),
        BLOCK_POLISHED_TUFF_FALL(MCVersion.MC1_20_4),
        BLOCK_POLISHED_TUFF_HIT(MCVersion.MC1_20_4),
        BLOCK_POLISHED_TUFF_PLACE(MCVersion.MC1_20_4),
        BLOCK_POLISHED_TUFF_STEP(MCVersion.MC1_20_4),
        BLOCK_TRIAL_SPAWNER_AMBIENT(MCVersion.MC1_20_4),
        BLOCK_TRIAL_SPAWNER_BREAK(MCVersion.MC1_20_4),
        BLOCK_TRIAL_SPAWNER_CLOSE_SHUTTER(MCVersion.MC1_20_4),
        BLOCK_TRIAL_SPAWNER_DETECT_PLAYER(MCVersion.MC1_20_4),
        BLOCK_TRIAL_SPAWNER_EJECT_ITEM(MCVersion.MC1_20_4),
        BLOCK_TRIAL_SPAWNER_FALL(MCVersion.MC1_20_4),
        BLOCK_TRIAL_SPAWNER_HIT(MCVersion.MC1_20_4),
        BLOCK_TRIAL_SPAWNER_OPEN_SHUTTER(MCVersion.MC1_20_4),
        BLOCK_TRIAL_SPAWNER_PLACE(MCVersion.MC1_20_4),
        BLOCK_TRIAL_SPAWNER_SPAWN_MOB(MCVersion.MC1_20_4),
        BLOCK_TRIAL_SPAWNER_STEP(MCVersion.MC1_20_4),
        BLOCK_TUFF_BRICKS_BREAK(MCVersion.MC1_20_4),
        BLOCK_TUFF_BRICKS_FALL(MCVersion.MC1_20_4),
        BLOCK_TUFF_BRICKS_HIT(MCVersion.MC1_20_4),
        BLOCK_TUFF_BRICKS_PLACE(MCVersion.MC1_20_4),
        BLOCK_TUFF_BRICKS_STEP(MCVersion.MC1_20_4),
        ENTITY_BREEZE_DEATH(MCVersion.MC1_20_4),
        ENTITY_BREEZE_HURT(MCVersion.MC1_20_4),
        ENTITY_BREEZE_IDLE_AIR(MCVersion.MC1_20_4),
        ENTITY_BREEZE_IDLE_GROUND(MCVersion.MC1_20_4),
        ENTITY_BREEZE_INHALE(MCVersion.MC1_20_4),
        ENTITY_BREEZE_JUMP(MCVersion.MC1_20_4),
        ENTITY_BREEZE_LAND(MCVersion.MC1_20_4),
        ENTITY_BREEZE_SHOOT(MCVersion.MC1_20_4),
        ENTITY_BREEZE_SLIDE(MCVersion.MC1_20_4),
        ENTITY_GENERIC_WIND_BURST(MCVersion.MC1_20_4, MCVersion.MC1_20_4),
        ENTITY_PARROT_IMITATE_BREEZE(MCVersion.MC1_20_4),
        ENTITY_PLAYER_TELEPORT(MCVersion.MC1_20_4),
        BLOCK_COBWEB_BREAK(MCVersion.MC1_20_6),
        BLOCK_COBWEB_FALL(MCVersion.MC1_20_6),
        BLOCK_COBWEB_HIT(MCVersion.MC1_20_6),
        BLOCK_COBWEB_PLACE(MCVersion.MC1_20_6),
        BLOCK_COBWEB_STEP(MCVersion.MC1_20_6),
        BLOCK_HEAVY_CORE_BREAK(MCVersion.MC1_20_6),
        BLOCK_HEAVY_CORE_FALL(MCVersion.MC1_20_6),
        BLOCK_HEAVY_CORE_HIT(MCVersion.MC1_20_6),
        BLOCK_HEAVY_CORE_PLACE(MCVersion.MC1_20_6),
        BLOCK_HEAVY_CORE_STEP(MCVersion.MC1_20_6),
        BLOCK_TRIAL_SPAWNER_ABOUT_TO_SPAWN_ITEM(MCVersion.MC1_20_6),
        BLOCK_TRIAL_SPAWNER_AMBIENT_CHARGED(MCVersion.MC1_20_6, MCVersion.MC1_20_6),
        BLOCK_TRIAL_SPAWNER_CHARGE_ACTIVATE(MCVersion.MC1_20_6, MCVersion.MC1_20_6),
        BLOCK_TRIAL_SPAWNER_SPAWN_ITEM(MCVersion.MC1_20_6),
        BLOCK_TRIAL_SPAWNER_SPAWN_ITEM_BEGIN(MCVersion.MC1_20_6),
        BLOCK_VAULT_ACTIVATE(MCVersion.MC1_20_6),
        BLOCK_VAULT_AMBIENT(MCVersion.MC1_20_6),
        BLOCK_VAULT_BREAK(MCVersion.MC1_20_6),
        BLOCK_VAULT_CLOSE_SHUTTER(MCVersion.MC1_20_6),
        BLOCK_VAULT_DEACTIVATE(MCVersion.MC1_20_6),
        BLOCK_VAULT_EJECT_ITEM(MCVersion.MC1_20_6),
        BLOCK_VAULT_FALL(MCVersion.MC1_20_6),
        BLOCK_VAULT_HIT(MCVersion.MC1_20_6),
        BLOCK_VAULT_INSERT_ITEM(MCVersion.MC1_20_6),
        BLOCK_VAULT_INSERT_ITEM_FAIL(MCVersion.MC1_20_6),
        BLOCK_VAULT_OPEN_SHUTTER(MCVersion.MC1_20_6),
        BLOCK_VAULT_PLACE(MCVersion.MC1_20_6),
        BLOCK_VAULT_STEP(MCVersion.MC1_20_6),
        BLOCK_WET_SPONGE_DRIES(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_AMBIENT(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_BRUSH(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_DEATH(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_EAT(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_HURT(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_HURT_REDUCED(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_LAND(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_PEEK(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_ROLL(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_SCUTE_DROP(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_STEP(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_UNROLL_FINISH(MCVersion.MC1_20_6),
        ENTITY_ARMADILLO_UNROLL_START(MCVersion.MC1_20_6),
        ENTITY_BOGGED_AMBIENT(MCVersion.MC1_20_6),
        ENTITY_BOGGED_DEATH(MCVersion.MC1_20_6),
        ENTITY_BOGGED_HURT(MCVersion.MC1_20_6),
        ENTITY_BOGGED_SHEAR(MCVersion.MC1_20_6),
        ENTITY_BOGGED_STEP(MCVersion.MC1_20_6),
        ENTITY_BREEZE_CHARGE(MCVersion.MC1_20_6),
        ENTITY_BREEZE_DEFLECT(MCVersion.MC1_20_6),
        ENTITY_BREEZE_WHIRL(MCVersion.MC1_20_6),
        ENTITY_BREEZE_WIND_BURST(MCVersion.MC1_20_6),
        ENTITY_DONKEY_JUMP(MCVersion.MC1_20_6),
        ENTITY_MULE_JUMP(MCVersion.MC1_20_6),
        ENTITY_PARROT_IMITATE_BOGGED(MCVersion.MC1_20_6),
        ENTITY_WIND_CHARGE_THROW(MCVersion.MC1_20_6),
        ENTITY_WIND_CHARGE_WIND_BURST(MCVersion.MC1_20_6),
        EVENT_MOB_EFFECT_BAD_OMEN(MCVersion.MC1_20_6),
        EVENT_MOB_EFFECT_RAID_OMEN(MCVersion.MC1_20_6),
        EVENT_MOB_EFFECT_TRIAL_OMEN(MCVersion.MC1_20_6),
        ITEM_ARMOR_EQUIP_WOLF(MCVersion.MC1_20_6),
        ITEM_ARMOR_UNEQUIP_WOLF(MCVersion.MC1_20_6),
        ITEM_MACE_SMASH_AIR(MCVersion.MC1_20_6),
        ITEM_MACE_SMASH_GROUND(MCVersion.MC1_20_6),
        ITEM_MACE_SMASH_GROUND_HEAVY(MCVersion.MC1_20_6),
        ITEM_WOLF_ARMOR_BREAK(MCVersion.MC1_20_6),
        ITEM_WOLF_ARMOR_CRACK(MCVersion.MC1_20_6),
        ITEM_WOLF_ARMOR_DAMAGE(MCVersion.MC1_20_6),
        ITEM_WOLF_ARMOR_REPAIR(MCVersion.MC1_20_6),
        BLOCK_TRIAL_SPAWNER_AMBIENT_OMINOUS(MCVersion.MC1_21),
        BLOCK_TRIAL_SPAWNER_OMINOUS_ACTIVATE(MCVersion.MC1_21),
        BLOCK_VAULT_REJECT_REWARDED_PLAYER(MCVersion.MC1_21),
        MUSIC_DISC_CREATOR(MCVersion.MC1_21),
        MUSIC_DISC_CREATOR_MUSIC_BOX(MCVersion.MC1_21),
        MUSIC_DISC_PRECIPICE(MCVersion.MC1_21),
        BLOCK_CREAKING_HEART_BREAK(MCVersion.MC1_21_3),
        BLOCK_CREAKING_HEART_FALL(MCVersion.MC1_21_3),
        BLOCK_CREAKING_HEART_HIT(MCVersion.MC1_21_3),
        BLOCK_CREAKING_HEART_HURT(MCVersion.MC1_21_3),
        BLOCK_CREAKING_HEART_IDLE(MCVersion.MC1_21_3),
        BLOCK_CREAKING_HEART_PLACE(MCVersion.MC1_21_3),
        BLOCK_CREAKING_HEART_SPAWN(MCVersion.MC1_21_3),
        BLOCK_CREAKING_HEART_STEP(MCVersion.MC1_21_3),
        BLOCK_PALE_HANGING_MOSS_IDLE(MCVersion.MC1_21_3),
        BLOCK_SPAWNER_BREAK(MCVersion.MC1_21_3),
        BLOCK_SPAWNER_FALL(MCVersion.MC1_21_3),
        BLOCK_SPAWNER_HIT(MCVersion.MC1_21_3),
        BLOCK_SPAWNER_PLACE(MCVersion.MC1_21_3),
        BLOCK_SPAWNER_STEP(MCVersion.MC1_21_3),
        ENTITY_CREAKING_ACTIVATE(MCVersion.MC1_21_3),
        ENTITY_CREAKING_AMBIENT(MCVersion.MC1_21_3),
        ENTITY_CREAKING_ATTACK(MCVersion.MC1_21_3),
        ENTITY_CREAKING_DEACTIVATE(MCVersion.MC1_21_3),
        ENTITY_CREAKING_DEATH(MCVersion.MC1_21_3),
        ENTITY_CREAKING_FREEZE(MCVersion.MC1_21_3),
        ENTITY_CREAKING_SPAWN(MCVersion.MC1_21_3),
        ENTITY_CREAKING_STEP(MCVersion.MC1_21_3),
        ENTITY_CREAKING_SWAY(MCVersion.MC1_21_3),
        ENTITY_CREAKING_UNFREEZE(MCVersion.MC1_21_3),
        ENTITY_PARROT_IMITATE_CREAKING(MCVersion.MC1_21_3),
        ITEM_BUNDLE_INSERT_FAIL(MCVersion.MC1_21_3),
        UI_HUD_BUBBLE_POP(MCVersion.MC1_21_3),
        BLOCK_EYEBLOSSOM_CLOSE(MCVersion.MC1_21_4),
        BLOCK_EYEBLOSSOM_CLOSE_LONG(MCVersion.MC1_21_4),
        BLOCK_EYEBLOSSOM_IDLE(MCVersion.MC1_21_4),
        BLOCK_EYEBLOSSOM_OPEN(MCVersion.MC1_21_4),
        BLOCK_EYEBLOSSOM_OPEN_LONG(MCVersion.MC1_21_4),
        BLOCK_RESIN_BREAK(MCVersion.MC1_21_4),
        BLOCK_RESIN_BRICKS_BREAK(MCVersion.MC1_21_4),
        BLOCK_RESIN_BRICKS_FALL(MCVersion.MC1_21_4),
        BLOCK_RESIN_BRICKS_HIT(MCVersion.MC1_21_4),
        BLOCK_RESIN_BRICKS_PLACE(MCVersion.MC1_21_4),
        BLOCK_RESIN_BRICKS_STEP(MCVersion.MC1_21_4),
        BLOCK_RESIN_FALL(MCVersion.MC1_21_4),
        BLOCK_RESIN_PLACE(MCVersion.MC1_21_4),
        BLOCK_RESIN_STEP(MCVersion.MC1_21_4),
        ENTITY_CREAKING_TWITCH(MCVersion.MC1_21_4),
        BLOCK_CACTUS_FLOWER_BREAK(MCVersion.MC1_21_5),
        BLOCK_CACTUS_FLOWER_PLACE(MCVersion.MC1_21_5),
        BLOCK_DEADBUSH_IDLE(MCVersion.MC1_21_5),
        BLOCK_FIREFLY_BUSH_IDLE(MCVersion.MC1_21_5),
        BLOCK_IRON_BREAK(MCVersion.MC1_21_5),
        BLOCK_IRON_FALL(MCVersion.MC1_21_5),
        BLOCK_IRON_HIT(MCVersion.MC1_21_5),
        BLOCK_IRON_PLACE(MCVersion.MC1_21_5),
        BLOCK_IRON_STEP(MCVersion.MC1_21_5),
        BLOCK_LEAF_LITTER_BREAK(MCVersion.MC1_21_5),
        BLOCK_LEAF_LITTER_STEP(MCVersion.MC1_21_5),
        BLOCK_LEAF_LITTER_PLACE(MCVersion.MC1_21_5),
        BLOCK_LEAF_LITTER_HIT(MCVersion.MC1_21_5),
        BLOCK_LEAF_LITTER_FALL(MCVersion.MC1_21_5),
        BLOCK_SAND_IDLE(MCVersion.MC1_21_5),
        BLOCK_SAND_WIND(MCVersion.MC1_21_5, MCVersion.MC1_21_5),
        ENTITY_WOLF_ANGRY_AMBIENT(MCVersion.MC1_21_5),
        ENTITY_WOLF_ANGRY_DEATH(MCVersion.MC1_21_5),
        ENTITY_WOLF_ANGRY_GROWL(MCVersion.MC1_21_5),
        ENTITY_WOLF_ANGRY_HURT(MCVersion.MC1_21_5),
        ENTITY_WOLF_ANGRY_PANT(MCVersion.MC1_21_5),
        ENTITY_WOLF_ANGRY_WHINE(MCVersion.MC1_21_5),
        ENTITY_WOLF_BIG_AMBIENT(MCVersion.MC1_21_5),
        ENTITY_WOLF_BIG_DEATH(MCVersion.MC1_21_5),
        ENTITY_WOLF_BIG_GROWL(MCVersion.MC1_21_5),
        ENTITY_WOLF_BIG_HURT(MCVersion.MC1_21_5),
        ENTITY_WOLF_BIG_PANT(MCVersion.MC1_21_5),
        ENTITY_WOLF_BIG_WHINE(MCVersion.MC1_21_5),
        ENTITY_WOLF_CUTE_AMBIENT(MCVersion.MC1_21_5),
        ENTITY_WOLF_CUTE_DEATH(MCVersion.MC1_21_5),
        ENTITY_WOLF_CUTE_GROWL(MCVersion.MC1_21_5),
        ENTITY_WOLF_CUTE_HURT(MCVersion.MC1_21_5),
        ENTITY_WOLF_CUTE_PANT(MCVersion.MC1_21_5),
        ENTITY_WOLF_CUTE_WHINE(MCVersion.MC1_21_5),
        ENTITY_WOLF_GRUMPY_AMBIENT(MCVersion.MC1_21_5),
        ENTITY_WOLF_GRUMPY_DEATH(MCVersion.MC1_21_5),
        ENTITY_WOLF_GRUMPY_GROWL(MCVersion.MC1_21_5),
        ENTITY_WOLF_GRUMPY_HURT(MCVersion.MC1_21_5),
        ENTITY_WOLF_GRUMPY_PANT(MCVersion.MC1_21_5),
        ENTITY_WOLF_GRUMPY_WHINE(MCVersion.MC1_21_5),
        ENTITY_WOLF_PUGLIN_AMBIENT(MCVersion.MC1_21_5),
        ENTITY_WOLF_PUGLIN_DEATH(MCVersion.MC1_21_5),
        ENTITY_WOLF_PUGLIN_GROWL(MCVersion.MC1_21_5),
        ENTITY_WOLF_PUGLIN_HURT(MCVersion.MC1_21_5),
        ENTITY_WOLF_PUGLIN_PANT(MCVersion.MC1_21_5),
        ENTITY_WOLF_PUGLIN_WHINE(MCVersion.MC1_21_5),
        ENTITY_WOLF_SAD_AMBIENT(MCVersion.MC1_21_5),
        ENTITY_WOLF_SAD_DEATH(MCVersion.MC1_21_5),
        ENTITY_WOLF_SAD_GROWL(MCVersion.MC1_21_5),
        ENTITY_WOLF_SAD_HURT(MCVersion.MC1_21_5),
        ENTITY_WOLF_SAD_PANT(MCVersion.MC1_21_5),
        ENTITY_WOLF_SAD_WHINE(MCVersion.MC1_21_5),
        BLOCK_DRIED_GHAST_AMBIENT(MCVersion.MC1_21_6),
        BLOCK_DRIED_GHAST_AMBIENT_WATER(MCVersion.MC1_21_6),
        BLOCK_DRIED_GHAST_BREAK(MCVersion.MC1_21_6),
        BLOCK_DRIED_GHAST_FALL(MCVersion.MC1_21_6),
        BLOCK_DRIED_GHAST_PLACE(MCVersion.MC1_21_6),
        BLOCK_DRIED_GHAST_PLACE_IN_WATER(MCVersion.MC1_21_6),
        BLOCK_DRIED_GHAST_STEP(MCVersion.MC1_21_6),
        BLOCK_DRIED_GHAST_TRANSITION(MCVersion.MC1_21_6),
        BLOCK_DRY_GRASS_AMBIENT(MCVersion.MC1_21_6),
        ENTITY_GHASTLING_AMBIENT(MCVersion.MC1_21_6),
        ENTITY_GHASTLING_DEATH(MCVersion.MC1_21_6),
        ENTITY_GHASTLING_HURT(MCVersion.MC1_21_6),
        ENTITY_GHASTLING_SPAWN(MCVersion.MC1_21_6),
        ENTITY_HAPPY_GHAST_AMBIENT(MCVersion.MC1_21_6),
        ENTITY_HAPPY_GHAST_DEATH(MCVersion.MC1_21_6),
        ENTITY_HAPPY_GHAST_EQUIP(MCVersion.MC1_21_6),
        ENTITY_HAPPY_GHAST_HARNESS_GOGGLES_DOWN(MCVersion.MC1_21_6),
        ENTITY_HAPPY_GHAST_HARNESS_GOGGLES_UP(MCVersion.MC1_21_6),
        ENTITY_HAPPY_GHAST_HURT(MCVersion.MC1_21_6),
        ENTITY_HAPPY_GHAST_RIDING(MCVersion.MC1_21_6),
        ENTITY_HAPPY_GHAST_UNEQUIP(MCVersion.MC1_21_6),
        ITEM_HORSE_ARMOR_UNEQUIP(MCVersion.MC1_21_6),
        ITEM_LEAD_BREAK(MCVersion.MC1_21_6),
        ITEM_LEAD_TIED(MCVersion.MC1_21_6),
        ITEM_LEAD_UNTIED(MCVersion.MC1_21_6),
        ITEM_LLAMA_CARPET_UNEQUIP(MCVersion.MC1_21_6),
        ITEM_SADDLE_UNEQUIP(MCVersion.MC1_21_6),
        ITEM_SHEARS_SNIP(MCVersion.MC1_21_6),
        MUSIC_DISC_TEARS(MCVersion.MC1_21_6),
        MUSIC_DISC_LAVA_CHICKEN(MCVersion.MC1_21_7),
        BLOCK_COPPER_CHEST_CLOSE(MCVersion.MC1_21_9),
        BLOCK_COPPER_CHEST_OPEN(MCVersion.MC1_21_9),
        BLOCK_COPPER_CHEST_OXIDIZED_CLOSE(MCVersion.MC1_21_9),
        BLOCK_COPPER_CHEST_OXIDIZED_OPEN(MCVersion.MC1_21_9),
        BLOCK_COPPER_CHEST_WEATHERED_CLOSE(MCVersion.MC1_21_9),
        BLOCK_COPPER_CHEST_WEATHERED_OPEN(MCVersion.MC1_21_9),
        BLOCK_COPPER_GOLEM_STATUE_BREAK(MCVersion.MC1_21_9),
        BLOCK_COPPER_GOLEM_STATUE_FALL(MCVersion.MC1_21_9),
        BLOCK_COPPER_GOLEM_STATUE_HIT(MCVersion.MC1_21_9),
        BLOCK_COPPER_GOLEM_STATUE_PLACE(MCVersion.MC1_21_9),
        BLOCK_COPPER_GOLEM_STATUE_STEP(MCVersion.MC1_21_9),
        BLOCK_SHELF_ACTIVATE(MCVersion.MC1_21_9),
        BLOCK_SHELF_BREAK(MCVersion.MC1_21_9),
        BLOCK_SHELF_DEACTIVATE(MCVersion.MC1_21_9),
        BLOCK_SHELF_FALL(MCVersion.MC1_21_9),
        BLOCK_SHELF_HIT(MCVersion.MC1_21_9),
        BLOCK_SHELF_MULTI_SWAP(MCVersion.MC1_21_9),
        BLOCK_SHELF_PLACE(MCVersion.MC1_21_9),
        BLOCK_SHELF_PLACE_ITEM(MCVersion.MC1_21_9),
        BLOCK_SHELF_SINGLE_SWAP(MCVersion.MC1_21_9),
        BLOCK_SHELF_STEP(MCVersion.MC1_21_9),
        BLOCK_SHELF_TAKE_ITEM(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_DEATH(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_HURT(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_ITEM_DROP(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_ITEM_NO_DROP(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_NO_ITEM_GET(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_NO_ITEM_NO_GET(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_SHEAR(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_SPAWN(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_SPIN(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_STEP(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_BECOME_STATUE(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_OXIDIZED_DEATH(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_OXIDIZED_HURT(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_OXIDIZED_SPIN(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_OXIDIZED_STEP(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_WEATHERED_DEATH(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_WEATHERED_HURT(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_WEATHERED_SPIN(MCVersion.MC1_21_9),
        ENTITY_COPPER_GOLEM_WEATHERED_STEP(MCVersion.MC1_21_9),
        ITEM_ARMOR_EQUIP_COPPER(MCVersion.MC1_21_9),
        WEATHER_END_FLASH(MCVersion.MC1_21_9),
        UNKNOWN(MCVersion.NEVER);

        private final MCVersion since;
        private final MCVersion until;

        private MCVanillaSound() {
            this(MCVersion.MC1_9);
        }

        private MCVanillaSound(MCVersion since) {
            this.since = since;
            this.until = MCVersion.FUTURE;
        }

        private MCVanillaSound(MCVersion since, MCVersion until) {
            this.since = since;
            this.until = until;
        }

        public boolean existsIn(MCVersion version) {
            return version.gte(this.since) && version.lte(this.until);
        }
    }
}

