/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SSHWrapper {
    private static final Map<String, Session> SESSION_LIST = new HashMap<String, Session>();

    private SSHWrapper() {
    }

    public static void closeSessions() {
        for (Session s : SESSION_LIST.values()) {
            s.disconnect();
        }
        SESSION_LIST.clear();
    }

    public static boolean SCP(String from, String to) throws IOException {
        return SSHWrapper.SCP(from, to, null);
    }

    public static boolean SCP(String from, String to, String privateKeyLocation) throws IOException {
        if (from.contains("@") && to.contains("@") || !from.contains("@") && !to.contains("@")) {
            throw new IOException("Paths cannot be both remote, or both local.");
        }
        String remote = to;
        if (from.contains("@")) {
            remote = from;
        }
        Matcher m = Pattern.compile("(.+?)@(.+?)(?:\\:(.+?)(?:\\:(.+?))?)?\\:(.+)").matcher(remote);
        String syntaxErrorMsg = "Remote host connection must match the following syntax: user@host[:port[:password]]:path/to/file";
        if (m.find()) {
            String file;
            String password;
            int port;
            String host;
            String user2;
            block20: {
                user2 = m.group(1);
                host = m.group(2);
                String sport = m.group(3);
                port = 22;
                password = m.group(4);
                file = m.group(5);
                try {
                    if (sport != null) {
                        port = Integer.parseInt(sport);
                    }
                    if (port == 0) {
                        port = 22;
                    }
                }
                catch (NumberFormatException e) {
                    if (password != null) break block20;
                    throw new IOException(syntaxErrorMsg + " (It appears as though you may have been trying a password in place of the port. You may specify the port to be 0 if you want it to use the default, to bypass the port parameter.)");
                }
            }
            if (port < 1 || port > 65535) {
                throw new IOException("Port numbers must be between 1 and 65535");
            }
            try {
                File localFile;
                JSch jsch = new JSch();
                Session sshSession = null;
                File knownHosts = new File(System.getProperty("user.home") + "/.ssh/known_hosts");
                if (!knownHosts.exists()) {
                    if (password == null) {
                        throw new IOException("No known hosts file exists at " + knownHosts.getAbsolutePath() + ", and no password was provided");
                    }
                } else {
                    jsch.setKnownHosts(knownHosts.getAbsolutePath());
                }
                if (password == null) {
                    File privKey;
                    Object idRsa = System.getProperty("user.home") + "/.ssh/id_rsa";
                    if (privateKeyLocation != null) {
                        idRsa = privateKeyLocation;
                    }
                    if ((privKey = new File((String)idRsa)).exists()) {
                        jsch.addIdentity(privKey.getAbsolutePath());
                    } else {
                        throw new IOException("No password provided, and no private key exists at " + privKey.getAbsolutePath());
                    }
                }
                if (!SESSION_LIST.containsKey(user2 + host + port)) {
                    sshSession = jsch.getSession(user2, host, port);
                    sshSession.setUserInfo(new UserInfo(){

                        public String getPassphrase() {
                            return password;
                        }

                        public String getPassword() {
                            return password;
                        }

                        public boolean promptPassword(String message) {
                            return true;
                        }

                        public boolean promptPassphrase(String message) {
                            return true;
                        }

                        public boolean promptYesNo(String message) {
                            StreamUtils.GetSystemOut().println(message + " (Automatically responding with 'Yes')");
                            return true;
                        }

                        public void showMessage(String message) {
                            StreamUtils.GetSystemOut().println(message);
                        }
                    });
                    sshSession.connect(15000);
                    SESSION_LIST.put(user2 + host + port, sshSession);
                } else {
                    sshSession = SESSION_LIST.get(user2 + host + port);
                }
                if (!from.contains("@")) {
                    localFile = new File(from);
                    return SSHWrapper.SCPTo(localFile, file, sshSession);
                }
                localFile = new File(to);
                SSHWrapper.SCPFrom(file, localFile, sshSession);
                return true;
            }
            catch (JSchException | SftpException ex) {
                throw new IOException(ex);
            }
        }
        throw new IOException(syntaxErrorMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean SCPTo(File lfile, String rfile, Session session) throws JSchException, IOException, SftpException {
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)session.openChannel("sftp");
            channel.connect();
            String[] folders = rfile.split("/");
            File frfile = new File(rfile);
            try {
                channel.cd(frfile.getParent());
            }
            catch (SftpException ex) {
                channel.cd("/");
                for (int i = 0; i < folders.length - 1; ++i) {
                    String folder = folders[i];
                    if (folder.length() <= 0) continue;
                    try {
                        channel.cd(folder);
                        continue;
                    }
                    catch (SftpException e) {
                        channel.mkdir(folder);
                        channel.cd(folder);
                    }
                }
            }
            String remote = SSHWrapper.getRemoteMD5(rfile, session);
            String local = SSHWrapper.getLocalMD5(lfile);
            if (!remote.equals(local)) {
                channel.put((InputStream)new FileInputStream(lfile), frfile.getName());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (channel != null) {
                channel.exit();
                channel.disconnect();
            }
        }
    }

    public static String getLocalMD5(File localFile) throws IOException {
        try {
            byte[] f = StreamUtils.GetBytes(new FileInputStream(localFile));
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(f);
            String hash2 = StringUtils.toHex(digest.digest()).toLowerCase();
            return hash2;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRemoteMD5(String remoteFile, Session session) throws JSchException, IOException {
        ChannelExec channel = null;
        StringBuilder sb = new StringBuilder();
        try {
            channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand("openssl md5 " + remoteFile);
            channel.setInputStream(null);
            channel.setOutputStream(null);
            channel.setErrStream((OutputStream)System.err);
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] tmp = new byte[1024];
            while (true) {
                int i;
                if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                    sb.append(new String(tmp, 0, i));
                    continue;
                }
                if (channel.isClosed()) {
                    if (in.available() > 0) continue;
                    if (channel.getExitStatus() != 0) {
                        String string = "invalidMD5sum";
                        return string;
                    }
                    break;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        if ("".equals(sb.toString())) {
            return "invalidMD5sum";
        }
        String opensslReturn = sb.toString();
        opensslReturn = opensslReturn.replaceAll("MD5\\(.*\\)= ", "");
        return opensslReturn.replaceAll("\n|\r", "");
    }

    private static void SCPFrom(String remote, File local, Session session) throws IOException, JSchException {
        int c;
        String command = "scp -f " + remote;
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(command);
        OutputStream out = channel.getOutputStream();
        InputStream in = channel.getInputStream();
        channel.connect();
        byte[] buf = new byte[1024];
        buf[0] = 0;
        out.write(buf, 0, 1);
        out.flush();
        while ((c = SSHWrapper.checkAckFrom(in)) == 67) {
            int foo;
            in.read(buf, 0, 5);
            long filesize = 0L;
            while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                filesize = filesize * 10L + (long)(buf[0] - 48);
            }
            String file = null;
            int i = 0;
            while (true) {
                in.read(buf, i, 1);
                if (buf[i] == 10) break;
                ++i;
            }
            file = new String(buf, 0, i);
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            String prefix = null;
            if (local.isDirectory()) {
                prefix = local.getPath() + File.separator;
            }
            FileOutputStream fos = new FileOutputStream((String)(prefix == null ? local.getPath() : prefix + file));
            do {
                foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                if ((foo = in.read(buf, 0, foo)) < 0) break;
                fos.write(buf, 0, foo);
            } while ((filesize -= (long)foo) != 0L);
            fos.close();
            fos = null;
            SSHWrapper.checkAckFrom(in);
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
        }
        channel.disconnect();
    }

    private static void checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 1 || b == 2) {
            int c;
            StringBuilder sb = new StringBuilder();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                throw new IOException(sb.toString());
            }
            if (b == 2) {
                throw new IOException(sb.toString());
            }
        }
    }

    static int checkAckFrom(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuilder sb = new StringBuilder();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                throw new IOException(sb.toString());
            }
            if (b == 2) {
                throw new IOException(sb.toString());
            }
        }
        return b;
    }

    public static boolean SCPWrite(InputStream is, String to) throws IOException {
        return SSHWrapper.SCPWrite(is, to, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SCPWrite(InputStream is, String to, String idRsa) throws IOException {
        File temp = File.createTempFile("methodscript-temp-file", ".tmp");
        FileOutputStream fos = new FileOutputStream(temp);
        StreamUtils.Copy(is, fos);
        fos.close();
        try {
            boolean bl = SSHWrapper.SCP(temp.getAbsolutePath(), to, idRsa);
            return bl;
        }
        finally {
            temp.delete();
            temp.deleteOnExit();
        }
    }

    public static void SCPWrite(String contents, String to) throws IOException {
        SSHWrapper.SCPWrite(StreamUtils.GetInputStream(contents), to);
    }

    public static InputStream SCPRead(String from) throws IOException {
        File temp = File.createTempFile("methodscript-temp-file", ".tmp");
        SSHWrapper.SCP(from, temp.getAbsolutePath());
        FileInputStream fis = new FileInputStream(temp);
        temp.deleteOnExit();
        return fis;
    }

    public static String SCPReadString(String from) throws IOException {
        return StreamUtils.GetString(SSHWrapper.SCPRead(from));
    }
}

