/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import com.laytonsmith.PureUtilities.CommandExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class OSUtils {
    public static OS GetOS() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return OS.WINDOWS;
        }
        if (os.contains("mac")) {
            return OS.MAC;
        }
        if (os.contains("nix") || os.contains("nux")) {
            return OS.LINUX;
        }
        if (os.contains("sunos")) {
            return OS.SOLARIS;
        }
        return OS.UNKNOWN;
    }

    public static String GetLineEnding() {
        return System.getProperty("line.separator");
    }

    public static long GetMyPid() throws UnsupportedOperationException {
        return ProcessHandle.current().pid();
    }

    public static List<ProcessInfo> GetRunningProcesses() {
        try {
            if (OSUtils.GetOS().isWindows()) {
                return OSUtils.GetRunningProcessesWindows();
            }
            if (OSUtils.GetOS().isUnixLike()) {
                return OSUtils.GetRunningProcessesUnix();
            }
            throw new UnsupportedOperationException("Unsupported OS");
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static BitDepth GetOSBitDepth() {
        if (OSUtils.GetOS().isWindows()) {
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            return arch != null && arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? BitDepth.B64 : BitDepth.B32;
        }
        return System.getProperty("os.arch").endsWith("64") ? BitDepth.B64 : BitDepth.B32;
    }

    private static List<ProcessInfo> GetRunningProcessesWindows() throws InterruptedException, IOException {
        ArrayList<ProcessInfo> list = new ArrayList<ProcessInfo>();
        String cmd = CommandExecutor.Execute("tasklist.exe /fo list");
        String imageName = null;
        String pid = null;
        for (String line : cmd.split("\n|\r\n|\n\r")) {
            if ((line = line.trim()).isEmpty()) {
                if (imageName == null) continue;
                list.add(new ProcessInfo(Long.parseLong(pid), imageName));
                continue;
            }
            if (line.startsWith("Image Name")) {
                imageName = line.replaceAll("Image Name:\\s*(.*)", "$1");
                continue;
            }
            if (!line.startsWith("PID")) continue;
            pid = line.replaceAll("PID:\\s*(.*)", "$1");
        }
        return list;
    }

    private static List<ProcessInfo> GetRunningProcessesUnix() throws InterruptedException, IOException {
        ArrayList<ProcessInfo> list = new ArrayList<ProcessInfo>();
        String cmd = CommandExecutor.Execute("ps -ea");
        boolean first = true;
        for (String line : cmd.split("\n|\r\n|\n\r")) {
            if (first) {
                first = false;
                continue;
            }
            line = line.trim();
            String[] params = line.split("\\s+", 4);
            list.add(new ProcessInfo(Long.parseLong(params[0]), params[3]));
        }
        return list;
    }

    private static Properties GetLsbRelease() throws IOException {
        if (!OSUtils.GetOS().isLinux()) {
            throw new UnsupportedOperationException("Only Linux distributions are supported in this method.");
        }
        File lsbRelease = new File("/etc/lsb-release");
        if (!lsbRelease.exists()) {
            return null;
        }
        Properties props = new Properties();
        props.load(new FileInputStream(lsbRelease));
        return props;
    }

    public static String GetLinuxDistro() throws IOException {
        return OSUtils.GetLsbRelease().getProperty("DISTRIB_ID");
    }

    public static String GetLinuxVersion() throws IOException {
        return OSUtils.GetLsbRelease().getProperty("DISTRIB_RELEASE");
    }

    public static enum OS {
        WINDOWS,
        MAC,
        LINUX,
        SOLARIS,
        UNKNOWN;


        public boolean isWindows() {
            return this == WINDOWS;
        }

        public boolean isMac() {
            return this == MAC;
        }

        public boolean isLinux() {
            return this == LINUX;
        }

        public boolean isSolaris() {
            return this == SOLARIS;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        public boolean isUnix() {
            return this == MAC || this == SOLARIS;
        }

        public boolean isUnixLike() {
            return this.isUnix() || this == LINUX;
        }
    }

    public static enum BitDepth {
        B32,
        B64;

    }

    public static class ProcessInfo {
        private final long pid;
        private final String command;

        ProcessInfo(long pid, String command) {
            this.pid = pid;
            this.command = command;
        }

        public long getPid() {
            return this.pid;
        }

        public String getCommand() {
            return this.command;
        }

        public String toString() {
            return this.pid + ": " + this.command;
        }
    }
}

