/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCCreatureSpawner;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockState;
import com.laytonsmith.abstraction.enums.MCEntityType;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEntityType;
import com.laytonsmith.core.Static;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;

public class BukkitMCCreatureSpawner
extends BukkitMCBlockState
implements MCCreatureSpawner {
    CreatureSpawner cs;

    public BukkitMCCreatureSpawner(CreatureSpawner cs) {
        super((BlockState)cs);
        this.cs = cs;
    }

    @Override
    public MCEntityType getSpawnedType() {
        EntityType type = this.cs.getSpawnedType();
        if (type == null) {
            return null;
        }
        return BukkitMCEntityType.valueOfConcrete(type);
    }

    @Override
    public void setSpawnedType(MCEntityType type) {
        if (type == null) {
            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20)) {
                this.cs.setSpawnedType(null);
            } else {
                this.cs.setSpawnedType(EntityType.PIG);
            }
        } else {
            this.cs.setSpawnedType((EntityType)((BukkitMCEntityType)type).getConcrete());
        }
        this.cs.update();
    }

    @Override
    public int getDelay() {
        return this.cs.getDelay();
    }

    @Override
    public void setDelay(int delay) {
        this.cs.setDelay(delay);
        this.cs.update();
    }

    @Override
    public int getMinDelay() {
        return this.cs.getMinSpawnDelay();
    }

    @Override
    public void setMinDelay(int delay) {
        this.cs.setMinSpawnDelay(delay);
    }

    @Override
    public int getMaxDelay() {
        return this.cs.getMaxSpawnDelay();
    }

    @Override
    public void setMaxDelay(int delay) {
        this.cs.setMaxSpawnDelay(delay);
    }

    @Override
    public int getSpawnCount() {
        return this.cs.getSpawnCount();
    }

    @Override
    public void setSpawnCount(int count) {
        this.cs.setSpawnCount(count);
    }

    @Override
    public int getMaxNearbyEntities() {
        return this.cs.getMaxNearbyEntities();
    }

    @Override
    public void setMaxNearbyEntities(int max2) {
        this.cs.setMaxNearbyEntities(max2);
    }

    @Override
    public int getPlayerRange() {
        return this.cs.getRequiredPlayerRange();
    }

    @Override
    public void setPlayerRange(int range2) {
        this.cs.setRequiredPlayerRange(range2);
    }

    @Override
    public int getSpawnRange() {
        return this.cs.getSpawnRange();
    }

    @Override
    public void setSpawnRange(int range2) {
        this.cs.setSpawnRange(range2);
    }
}

