/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.events;

import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.bukkit.BukkitMCCommandSender;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.events.MCBroadcastMessageEvent;
import com.laytonsmith.abstraction.events.MCServerCommandEvent;
import com.laytonsmith.abstraction.events.MCServerPingEvent;
import com.laytonsmith.annotations.abstraction;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.event.server.ServerListPingEvent;

public class BukkitServerEvents {

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCBroadcastMessageEvent
    implements MCBroadcastMessageEvent {
        private final BroadcastMessageEvent bme;

        public BukkitMCBroadcastMessageEvent(Event event) {
            this.bme = (BroadcastMessageEvent)event;
        }

        public BukkitMCBroadcastMessageEvent(BroadcastMessageEvent event) {
            this.bme = event;
        }

        public static BroadcastMessageEvent _instantiate(String message, Set<MCCommandSender> recipients) {
            HashSet<CommandSender> bukkitRecipients = new HashSet<CommandSender>(recipients.size());
            for (MCCommandSender commandSender : recipients) {
                if (!(commandSender.getHandle() instanceof CommandSender)) continue;
                bukkitRecipients.add((CommandSender)commandSender.getHandle());
            }
            return new BroadcastMessageEvent(message, bukkitRecipients);
        }

        @Override
        public Object _GetObject() {
            return this.bme;
        }

        @Override
        public void cancel(boolean state) {
            this.bme.setCancelled(state);
        }

        @Override
        public String getMessage() {
            return this.bme.getMessage();
        }

        @Override
        public void setMessage(String message) {
            this.bme.setMessage(message);
        }

        @Override
        public Set<MCCommandSender> getRecipients() {
            HashSet<MCCommandSender> ret = new HashSet<MCCommandSender>();
            for (CommandSender sender : this.bme.getRecipients()) {
                ret.add(new BukkitMCCommandSender(sender));
            }
            return ret;
        }

        @Override
        public Set<MCPlayer> getPlayerRecipients() {
            HashSet<MCPlayer> ret = new HashSet<MCPlayer>();
            for (CommandSender sender : this.bme.getRecipients()) {
                if (!(sender instanceof Player)) continue;
                ret.add(new BukkitMCPlayer((Entity)((Player)sender)));
            }
            return ret;
        }

        @Override
        public boolean isCancelled() {
            return this.bme.isCancelled();
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCServerPingEvent
    implements MCServerPingEvent {
        private final ServerListPingEvent slp;

        public BukkitMCServerPingEvent(ServerListPingEvent event) {
            this.slp = event;
        }

        @Override
        public Object _GetObject() {
            return this.slp;
        }

        @Override
        public InetAddress getAddress() {
            return this.slp.getAddress();
        }

        @Override
        public int getMaxPlayers() {
            return this.slp.getMaxPlayers();
        }

        @Override
        public String getMOTD() {
            return this.slp.getMotd();
        }

        @Override
        public int getNumPlayers() {
            return this.slp.getNumPlayers();
        }

        @Override
        public void setMaxPlayers(int max2) {
            this.slp.setMaxPlayers(max2);
        }

        @Override
        public void setMOTD(String motd) {
            this.slp.setMotd(motd);
        }

        @Override
        public Set<MCPlayer> getPlayers() {
            HashSet<MCPlayer> players = new HashSet<MCPlayer>();
            try {
                Iterator iterator = this.slp.iterator();
                while (iterator.hasNext()) {
                    players.add(new BukkitMCPlayer((Entity)iterator.next()));
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return players;
        }

        @Override
        public void setPlayers(Collection<MCPlayer> players) {
            HashSet<Player> ps = new HashSet<Player>();
            for (MCPlayer player2 : players) {
                ps.add((Player)player2.getHandle());
            }
            try {
                Iterator iterator = this.slp.iterator();
                while (iterator.hasNext()) {
                    if (ps.contains(iterator.next())) continue;
                    iterator.remove();
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCServerCommandEvent
    implements MCServerCommandEvent {
        ServerCommandEvent sce;
        MCCommandSender sender;

        public BukkitMCServerCommandEvent(ServerCommandEvent sce, MCCommandSender sender) {
            this.sce = sce;
            this.sender = sender;
        }

        @Override
        public Object _GetObject() {
            return this.sce;
        }

        @Override
        public String getCommand() {
            return this.sce.getCommand();
        }

        @Override
        public void setCommand(String command) {
            this.sce.setCommand(command);
        }

        @Override
        public MCCommandSender getCommandSender() {
            return this.sender;
        }
    }
}

