/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Token;
import com.laytonsmith.core.natives.interfaces.Mixed;

public class CSymbol
extends Construct {
    String conversion = "";
    Token.TType symbolType;

    public CSymbol(String symbol, Token.TType type, Target target) {
        super(symbol, Construct.ConstructType.SYMBOL, target);
        this.symbolType = type;
        switch (this.symbolType) {
            case CONCAT: {
                this.conversion = "concat";
                break;
            }
            case PLUS: {
                this.conversion = "add";
                break;
            }
            case MINUS: {
                this.conversion = "subtract";
                break;
            }
            case MULTIPLICATION: {
                this.conversion = "multiply";
                break;
            }
            case DIVISION: {
                this.conversion = "divide";
                break;
            }
            case EQUALS: {
                this.conversion = "equals";
                break;
            }
            case NOT_EQUALS: {
                this.conversion = "nequals";
                break;
            }
            case STRICT_EQUALS: {
                this.conversion = "sequals";
                break;
            }
            case STRICT_NOT_EQUALS: {
                this.conversion = "snequals";
                break;
            }
            case LT: {
                this.conversion = "lt";
                break;
            }
            case GT: {
                this.conversion = "gt";
                break;
            }
            case LTE: {
                this.conversion = "lte";
                break;
            }
            case GTE: {
                this.conversion = "gte";
                break;
            }
            case LOGICAL_AND: {
                this.conversion = "and";
                break;
            }
            case LOGICAL_OR: {
                this.conversion = "or";
                break;
            }
            case DEFAULT_AND: {
                this.conversion = "dand";
                break;
            }
            case DEFAULT_OR: {
                this.conversion = "dor";
                break;
            }
            case LOGICAL_NOT: {
                this.conversion = "not";
                break;
            }
            case MODULO: {
                this.conversion = "mod";
                break;
            }
            case INCREMENT: {
                this.conversion = "inc";
                break;
            }
            case DECREMENT: {
                this.conversion = "dec";
                break;
            }
            case EXPONENTIAL: {
                this.conversion = "pow";
                break;
            }
            case COMMA: {
                this.conversion = ",";
                break;
            }
            default: {
                this.conversion = "";
            }
        }
    }

    public String convert() {
        return this.conversion;
    }

    public boolean isConcatenation() {
        return this.symbolType.equals((Object)Token.TType.CONCAT);
    }

    public boolean isPostfix() {
        return this.symbolType.isPostfix();
    }

    public boolean isUnary() {
        return this.symbolType.isUnary();
    }

    public boolean isMultaplicative() {
        return this.symbolType.isMultaplicative();
    }

    public boolean isAdditive() {
        return this.symbolType.isAdditive();
    }

    public boolean isRelational() {
        return this.symbolType.isRelational();
    }

    public boolean isEquality() {
        return this.symbolType.isEquality();
    }

    public boolean isLogicalAnd() {
        return this.symbolType.isLogicalAnd();
    }

    public boolean isLogicalOr() {
        return this.symbolType.isLogicalOr();
    }

    public boolean isDefaultAnd() {
        return this.symbolType.isDefaultAnd();
    }

    public boolean isDefaultOr() {
        return this.symbolType.isDefaultOr();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    public boolean isExponential() {
        return this.symbolType.isExponential();
    }

    public boolean isAssignment() {
        return this.symbolType.isAssignment();
    }

    public String convertAssignment() {
        switch (this.symbolType) {
            case PLUS_ASSIGNMENT: {
                return "add";
            }
            case MINUS_ASSIGNMENT: {
                return "subtract";
            }
            case MULTIPLICATION_ASSIGNMENT: {
                return "multiply";
            }
            case DIVISION_ASSIGNMENT: {
                return "divide";
            }
            case CONCAT_ASSIGNMENT: {
                return "concat";
            }
        }
        return null;
    }

    @Override
    public Version since() {
        return super.since();
    }

    @Override
    public String docs() {
        return super.docs();
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[0];
    }
}

