/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.com.squareup.okhttp;

import com.laytonsmith.libs.com.squareup.okhttp.internal.http.HttpDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class Headers {
    private final String[] namesAndValues;

    private Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] namesAndValues) {
        this.namesAndValues = namesAndValues;
    }

    public String get(String name) {
        return Headers.get(this.namesAndValues, name);
    }

    public Date getDate(String name) {
        String value = this.get(name);
        return value != null ? HttpDate.parse(value) : null;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public String name(int index) {
        int nameIndex = index * 2;
        if (nameIndex < 0 || nameIndex >= this.namesAndValues.length) {
            return null;
        }
        return this.namesAndValues[nameIndex];
    }

    public String value(int index) {
        int valueIndex = index * 2 + 1;
        if (valueIndex < 0 || valueIndex >= this.namesAndValues.length) {
            return null;
        }
        return this.namesAndValues[valueIndex];
    }

    public Set<String> names() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            result.add(this.name(i));
        }
        return Collections.unmodifiableSet(result);
    }

    public List<String> values(String name) {
        ArrayList<String> result = null;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!name.equalsIgnoreCase(this.name(i))) continue;
            if (result == null) {
                result = new ArrayList<String>(2);
            }
            result.add(this.value(i));
        }
        return result != null ? Collections.unmodifiableList(result) : Collections.emptyList();
    }

    public Builder newBuilder() {
        Builder result = new Builder();
        Collections.addAll(result.namesAndValues, this.namesAndValues);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            result.append(this.name(i)).append(": ").append(this.value(i)).append("\n");
        }
        return result.toString();
    }

    public Map<String, List<String>> toMultimap() {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            String name = this.name(i);
            ArrayList<String> values2 = (ArrayList<String>)result.get(name);
            if (values2 == null) {
                values2 = new ArrayList<String>(2);
                result.put(name, values2);
            }
            values2.add(this.value(i));
        }
        return result;
    }

    private static String get(String[] namesAndValues, String name) {
        for (int i = namesAndValues.length - 2; i >= 0; i -= 2) {
            if (!name.equalsIgnoreCase(namesAndValues[i])) continue;
            return namesAndValues[i + 1];
        }
        return null;
    }

    public static Headers of(String ... namesAndValues) {
        int i;
        if (namesAndValues == null || namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Expected alternating header names and values");
        }
        namesAndValues = (String[])namesAndValues.clone();
        for (i = 0; i < namesAndValues.length; ++i) {
            if (namesAndValues[i] == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            namesAndValues[i] = namesAndValues[i].trim();
        }
        for (i = 0; i < namesAndValues.length; i += 2) {
            String name = namesAndValues[i];
            String value = namesAndValues[i + 1];
            if (name.length() != 0 && name.indexOf(0) == -1 && value.indexOf(0) == -1) continue;
            throw new IllegalArgumentException("Unexpected header: " + name + ": " + value);
        }
        return new Headers(namesAndValues);
    }

    public static Headers of(Map<String, String> headers) {
        if (headers == null) {
            throw new IllegalArgumentException("Expected map with header names and values");
        }
        String[] namesAndValues = new String[headers.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> header : headers.entrySet()) {
            if (header.getKey() == null || header.getValue() == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            String name = header.getKey().trim();
            String value = header.getValue().trim();
            if (name.length() == 0 || name.indexOf(0) != -1 || value.indexOf(0) != -1) {
                throw new IllegalArgumentException("Unexpected header: " + name + ": " + value);
            }
            namesAndValues[i] = name;
            namesAndValues[i + 1] = value;
            i += 2;
        }
        return new Headers(namesAndValues);
    }

    public static final class Builder {
        private final List<String> namesAndValues = new ArrayList<String>(20);

        Builder addLenient(String line) {
            int index = line.indexOf(":", 1);
            if (index != -1) {
                return this.addLenient(line.substring(0, index), line.substring(index + 1));
            }
            if (line.startsWith(":")) {
                return this.addLenient("", line.substring(1));
            }
            return this.addLenient("", line);
        }

        public Builder add(String line) {
            int index = line.indexOf(":");
            if (index == -1) {
                throw new IllegalArgumentException("Unexpected header: " + line);
            }
            return this.add(line.substring(0, index).trim(), line.substring(index + 1));
        }

        public Builder add(String name, String value) {
            this.checkNameAndValue(name, value);
            return this.addLenient(name, value);
        }

        Builder addLenient(String name, String value) {
            this.namesAndValues.add(name);
            this.namesAndValues.add(value.trim());
            return this;
        }

        public Builder removeAll(String name) {
            for (int i = 0; i < this.namesAndValues.size(); i += 2) {
                if (!name.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                this.namesAndValues.remove(i);
                this.namesAndValues.remove(i);
                i -= 2;
            }
            return this;
        }

        public Builder set(String name, String value) {
            this.checkNameAndValue(name, value);
            this.removeAll(name);
            this.addLenient(name, value);
            return this;
        }

        private void checkNameAndValue(String name, String value) {
            char c;
            int i;
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("name is empty");
            }
            int length2 = name.length();
            for (i = 0; i < length2; ++i) {
                c = name.charAt(i);
                if (c > '\u001f' && c < '\u007f') continue;
                throw new IllegalArgumentException(String.format("Unexpected char %#04x at %d in header name: %s", c, i, name));
            }
            if (value == null) {
                throw new IllegalArgumentException("value == null");
            }
            length2 = value.length();
            for (i = 0; i < length2; ++i) {
                c = value.charAt(i);
                if (c > '\u001f' && c < '\u007f') continue;
                throw new IllegalArgumentException(String.format("Unexpected char %#04x at %d in header value: %s", c, i, value));
            }
        }

        public String get(String name) {
            for (int i = this.namesAndValues.size() - 2; i >= 0; i -= 2) {
                if (!name.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                return this.namesAndValues.get(i + 1);
            }
            return null;
        }

        public Headers build() {
            return new Headers(this);
        }
    }
}

