/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.VirtualFS;

import com.laytonsmith.PureUtilities.VirtualFS.VirtualFile;
import java.util.regex.Pattern;

public class VirtualGlob
implements Comparable<VirtualGlob> {
    private final String glob;
    private final boolean matchAll;
    private final Pattern globPattern;

    public VirtualGlob(String glob) {
        this.glob = glob.trim().toLowerCase();
        this.matchAll = "**".equals(glob);
        this.globPattern = this.getPattern(glob);
    }

    public VirtualGlob(VirtualFile file) {
        this.glob = file.getPath();
        this.matchAll = false;
        this.globPattern = this.getPattern(this.glob);
    }

    private Pattern getPattern(String glob) {
        if (glob.isEmpty()) {
            throw new IllegalArgumentException("Glob cannot be empty");
        }
        StringBuilder buffer = new StringBuilder();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < glob.length(); ++i) {
            char c1 = glob.charAt(i);
            char c2 = '\u0000';
            if (i < glob.length() - 1) {
                c2 = glob.charAt(i + 1);
            }
            if (c1 == '?' || c1 == '*') {
                if (buffer.length() > 0) {
                    pattern.append(Pattern.quote(buffer.toString()));
                    buffer = new StringBuilder();
                }
                if (c1 == '?') {
                    pattern.append('.');
                    continue;
                }
                if (c2 == '*') {
                    ++i;
                    pattern.append(".*");
                    continue;
                }
                pattern.append("[^/\\\\]*");
                continue;
            }
            buffer.append(c1);
        }
        if (buffer.length() > 0) {
            pattern.append(Pattern.quote(buffer.toString()));
        }
        return Pattern.compile(pattern.toString(), 66);
    }

    public boolean matches(VirtualFile file) {
        if (this.matchAll) {
            return true;
        }
        return this.globPattern.matcher(file.getPath()).matches();
    }

    @Override
    public int compareTo(VirtualGlob o) {
        return this.glob.length() - o.glob.length();
    }

    public String toString() {
        return this.glob;
    }
}

