/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import java.io.File;
import java.io.IOException;

public class FileLocations {
    private static FileLocations defaultInstance = null;
    private static final File USER_HOME;
    private static final File USER_DIR;
    private static final File JAVA_HOME;
    private static final File TEMP_DIR;

    public static FileLocations getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new FileLocations();
        }
        return defaultInstance;
    }

    public static void setDefault(FileLocations provider) {
        defaultInstance = provider;
    }

    public File getUserHome() {
        return USER_HOME;
    }

    public File getUserDir() {
        return USER_DIR;
    }

    public File getJavaHome() {
        return JAVA_HOME;
    }

    public File getTempDir() {
        return TEMP_DIR;
    }

    static {
        File userHome = null;
        File userDir = null;
        File javaHome = null;
        File tempDir = null;
        try {
            userHome = new File(System.getProperty("user.home"));
            userDir = new File(System.getProperty("user.dir"));
            javaHome = new File(System.getProperty("java.home"));
            File tmp = File.createTempFile("FileLocationTempFile", ".tmp");
            tempDir = tmp.getParentFile();
            tmp.delete();
            tmp.deleteOnExit();
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        USER_HOME = userHome;
        USER_DIR = userDir;
        JAVA_HOME = javaHome;
        TEMP_DIR = tempDir;
    }
}

