/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.core.Profiles;
import java.util.HashMap;
import java.util.Map;

@Profiles.ProfileType(type="email")
public class EmailProfile
extends Profiles.Profile {
    private String host = "localhost";
    private String user = null;
    private String password = null;
    private int port = 587;
    private boolean useSsl = false;
    private boolean useStartTls = false;
    private int timeout = 10000;

    public EmailProfile(String id, Map<String, String> elements) throws Profiles.InvalidProfileException {
        super(id);
        if (elements.containsKey("host")) {
            this.host = elements.get("host");
        }
        if (elements.containsKey("user")) {
            this.user = elements.get("user");
        }
        if (elements.containsKey("password")) {
            this.password = elements.get("password");
        }
        if (elements.containsKey("port")) {
            try {
                this.port = Integer.parseInt(elements.get("port"));
            }
            catch (NumberFormatException ex) {
                throw new Profiles.InvalidProfileException(ex.getMessage());
            }
        }
        if (elements.containsKey("use_ssl")) {
            this.useSsl = Boolean.parseBoolean(elements.get("use_ssl"));
        }
        if (elements.containsKey("use_start_tls")) {
            this.useStartTls = Boolean.parseBoolean(elements.get("use_start_tls"));
        }
        if (elements.containsKey("timeout")) {
            try {
                this.timeout = Integer.parseInt(elements.get("timeout"));
            }
            catch (NumberFormatException ex) {
                throw new Profiles.InvalidProfileException(ex.getMessage());
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public boolean getUseSSL() {
        return this.useSsl;
    }

    public boolean getUseStartTLS() {
        return this.useStartTls;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Map<String, Object> getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("host", this.getHost());
        map.put("user", this.getUser());
        map.put("password", this.getPassword());
        map.put("port", this.getPort());
        map.put("use_ssl", this.getUseSSL());
        map.put("use_start_tls", this.getUseStartTLS());
        map.put("timeout", this.getTimeout());
        return map;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.user + "@" + this.host + ":" + this.port;
    }
}

