/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.natives.interfaces.Sizeable;
import com.laytonsmith.core.natives.interfaces.ValueType;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

@typeof(value="ms.lang.mutable_primitive")
public class CMutablePrimitive
extends CArray
implements Sizeable {
    public static final CClassType TYPE = CClassType.get(CMutablePrimitive.class);
    private Mixed value = CNull.NULL;

    public CMutablePrimitive(Target t) {
        this(null, t);
    }

    public CMutablePrimitive(Mixed value, Target t) {
        super(t, 0);
        this.set(value, t);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    public void set(Mixed value, Target t) {
        if (!value.isInstanceOf(ValueType.TYPE)) {
            throw new CREFormatException("mutable_primitives can only store primitive values.", t);
        }
        this.value = value;
    }

    @Override
    public void set(Mixed index, Mixed c, Target t) {
        throw new CRECastException("mutable_primitives cannot have values set in them", t);
    }

    public CMutablePrimitive setAndReturn(Mixed value, Target t) {
        this.set(value, t);
        return this;
    }

    public Mixed get() {
        return this.value;
    }

    @Override
    public Mixed get(Mixed index, Target t) {
        return this.value;
    }

    @Override
    public String val() {
        return this.value.val();
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public CMutablePrimitive clone() {
        return this;
    }

    @Override
    protected String getQuote() {
        return new CString(this.value.val(), Target.UNKNOWN).getQuote();
    }

    @Override
    public long size() {
        if (this.value.isInstanceOf(Sizeable.TYPE)) {
            return ArgumentValidation.getObject(this.value, Target.UNKNOWN, Sizeable.class).size();
        }
        return 0L;
    }

    @Override
    public boolean canBeAssociative() {
        return false;
    }

    @Override
    public List<Mixed> asList() {
        return this.getArray();
    }

    @Override
    public void clear() {
        this.value = CNull.NULL;
    }

    @Override
    public CArray createNew(Target t) {
        return new CMutablePrimitive(this.value, t);
    }

    @Override
    protected List<Mixed> getArray() {
        ArrayList<Mixed> array2 = new ArrayList<Mixed>();
        array2.add(this.value);
        return array2;
    }

    @Override
    protected String getString(Stack<CArray> arrays, Target t) {
        return this.value.val();
    }

    @Override
    public void push(Mixed c, Integer i, Target t) {
        this.set(c, t);
    }

    @Override
    public String docs() {
        return "A mutable primitive is a special data type that allows you to store primitives by reference, instead of value.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{CArray.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[]{Sizeable.TYPE};
    }
}

