/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.PropertiesManager;
import com.laytonsmith.persistence.DataSourceException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class DataSourceFilter {
    private Map<Pattern, String> mappings = new HashMap<Pattern, String>();
    private Map<Pattern, String> original = new HashMap<Pattern, String>();
    private Map<String[], String> namespaced = new HashMap<String[], String>();
    private Map<String, URI> cache = new TreeMap<String, URI>();
    private Map<String, Set<URI>> namespaceCache = new TreeMap<String, Set<URI>>();

    public DataSourceFilter(File file, URI defaultURI) throws IOException, DataSourceException {
        try {
            this.process(FileUtil.read(file), defaultURI);
        }
        catch (DataSourceException e) {
            throw new DataSourceException("Could not process filter file located at " + file.getAbsolutePath() + ": " + e.getMessage());
        }
    }

    public DataSourceFilter(String filters, URI defaultURI) throws DataSourceException {
        this.process(filters, defaultURI);
    }

    private void process(String filters, URI defaultURI) throws DataSourceException {
        if (defaultURI == null) {
            throw new NullPointerException("defaultURI cannot be null");
        }
        PropertiesManager p2 = new PropertiesManager(filters);
        HashMap<String, String> aliases = new HashMap<String, String>();
        boolean hasDefault = false;
        for (String key : p2.keySet()) {
            if ((key = key.trim()).matches("\\$[^a-zA-Z_]+")) {
                throw new DataSourceException("Aliases in your filters may not start with a digit.");
            }
            if (key.matches("\\$[a-zA-Z_][a-zA-Z0-9_]*")) {
                if (aliases.containsKey(key)) {
                    throw new DataSourceException("Duplicate aliases defined: " + key);
                }
                aliases.put(key, (String)p2.get(key));
            }
            if (!key.equals("**")) continue;
            hasDefault = true;
        }
        for (String key : p2.keySet()) {
            String value;
            if (key.matches("\\$.*")) continue;
            if (key.matches("[^a-zA-Z0-9_\\*]")) {
                throw new DataSourceException("Invalid character in filter. Only the following characters are allowed: a-zA-Z0-9_()* Found this instead: " + key);
            }
            String regexKey = DataSourceFilter.toRegex(key);
            Pattern pattern = Pattern.compile(regexKey + "$");
            String originalValue = value = (String)p2.get(key);
            boolean isAlias = false;
            if (value.matches("\\$.*")) {
                if (!aliases.containsKey(value)) {
                    throw new DataSourceException("Invalid alias: " + value + " is trying to be used, but has not been defined.");
                }
                value = (String)aliases.get(value);
                isAlias = true;
            }
            if (this.mappings.containsKey(pattern)) {
                throw new DataSourceException("Multiple definitions exist for the key: " + key);
            }
            try {
                URI uriValue = new URI(value);
            }
            catch (URISyntaxException e) {
                throw new DataSourceException("Invalid URI for " + value + (String)(isAlias ? "(Defined for alias " + originalValue + ")" : "") + ".");
            }
            this.mappings.put(pattern, value);
            this.original.put(pattern, key);
            this.namespaced.put(key.split("\\."), value);
        }
        if (!hasDefault) {
            Pattern m = Pattern.compile(".*?");
            this.mappings.put(m, defaultURI.toString());
            this.original.put(m, "**");
            this.namespaced.put(new String[]{"**"}, defaultURI.toString());
        }
    }

    public static String toRegex(String key) {
        String newKey = key.replace(".", "\\.");
        StringBuilder b = new StringBuilder("^");
        for (int i = 0; i < newKey.length(); ++i) {
            Character c1 = Character.valueOf(newKey.charAt(i));
            Character c2 = null;
            if (i + 1 < newKey.length()) {
                c2 = Character.valueOf(newKey.charAt(i + 1));
            }
            if (c1.charValue() == '*' && c2 != null && c2.charValue() == '*') {
                b.append(".*?");
                ++i;
                continue;
            }
            if (c1.charValue() == '*') {
                b.append("[^\\.]*?");
                continue;
            }
            b.append(c1);
        }
        return b.toString();
    }

    public URI getConnection(String key) {
        URI cached = this.cache.get(key);
        if (cached != null) {
            return cached;
        }
        ArrayList<Pattern> matches = new ArrayList<Pattern>();
        for (Pattern p2 : this.mappings.keySet()) {
            if (!p2.matcher(key).matches()) continue;
            matches.add(p2);
        }
        Pattern closest = null;
        if (matches.isEmpty()) {
            if (key.contains("\\n")) {
                throw new IllegalArgumentException("Invalid new line character found in persistence key here:" + key.substring(0, key.indexOf("\\n")) + " <---");
            }
            throw new RuntimeException("Persistence mappings missing match for key: " + key);
        }
        if (matches.size() == 1) {
            closest = (Pattern)matches.get(0);
        } else {
            int lowest = Integer.MAX_VALUE;
            for (Pattern p3 : matches) {
                String originalKey = this.original.get(p3);
                int dist = StringUtils.LevenshteinDistance(key, originalKey.replaceAll("\\*", "").replaceAll("[\\(\\)]", ""));
                if (dist >= lowest) continue;
                closest = p3;
                lowest = dist;
            }
        }
        try {
            String uri = this.mappings.get(closest);
            URI u = new URI(uri);
            this.cache.put(key, u);
            return u;
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public URI getConnection(String[] key) {
        return this.getConnection(StringUtils.Join(key, "."));
    }

    public Set<URI> getAllConnections() {
        HashSet<URI> set = new HashSet<URI>();
        for (String uri : this.namespaced.values()) {
            try {
                set.add(new URI(uri));
            }
            catch (URISyntaxException ex) {
                throw new Error(ex);
            }
        }
        return set;
    }

    public Set<URI> getAllConnections(String[] key) {
        return this.getAllConnections(StringUtils.Join(key, "."));
    }

    public Set<URI> getAllConnections(String key) {
        if (this.namespaceCache.containsKey(key)) {
            return new HashSet<URI>((Collection)this.namespaceCache.get(key));
        }
        HashMap<String[], String> matches = new HashMap<String[], String>();
        String[] split2 = key.split("\\.");
        block2: for (String[] comparison : this.namespaced.keySet()) {
            for (int comparing = 0; comparing < split2.length; ++comparing) {
                String regexPart;
                if (this.arrayContains(comparison, "**", 0, comparing)) {
                    matches.put(comparison, this.namespaced.get(comparison));
                    continue block2;
                }
                if (comparison.length <= comparing) continue;
                String requestedPart = split2[comparing];
                String myPart = comparison[comparing];
                if (!myPart.contains("*") ? !requestedPart.equals(myPart) : !requestedPart.matches(regexPart = DataSourceFilter.toRegex(myPart))) continue block2;
                if (comparing != split2.length - 1) continue;
                matches.put(comparison, this.namespaced.get(comparison));
                continue block2;
            }
        }
        HashSet<URI> list = new HashSet<URI>();
        for (String[] match : matches.keySet()) {
            String uri = (String)matches.get(match);
            try {
                list.add(new URI(uri));
            }
            catch (URISyntaxException ex) {
                throw new Error(ex);
            }
        }
        this.namespaceCache.put(key, list);
        return new HashSet<URI>(list);
    }

    private boolean arrayContains(String[] array2, String contains, int from, int to) {
        for (int i = from; i < (to + 1 <= array2.length ? to + 1 : array2.length); ++i) {
            String part = array2[i];
            if (!part.contains(contains)) continue;
            return true;
        }
        return false;
    }
}

