/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.events;

import com.laytonsmith.abstraction.bukkit.BukkitMCServer;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.events.AbstractGenericEvent;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.EventMixinInterface;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.hanging.HangingEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.server.ServerEvent;
import org.bukkit.event.vehicle.VehicleEvent;
import org.bukkit.event.weather.WeatherEvent;
import org.bukkit.event.world.WorldEvent;

public class BukkitAbstractEventMixin
implements EventMixinInterface {
    AbstractGenericEvent mySuper;

    public BukkitAbstractEventMixin(AbstractGenericEvent mySuper) {
        this.mySuper = mySuper;
    }

    @Override
    public void cancel(BindableEvent e, boolean state) {
        if (e._GetObject() instanceof Cancellable) {
            ((Cancellable)e._GetObject()).setCancelled(state);
        }
    }

    @Override
    public boolean shouldFire(BindableEvent event) {
        Object e = event._GetObject();
        if (e instanceof PlayerEvent) {
            return !((PlayerEvent)e).getPlayer().hasMetadata("NPC");
        }
        if (e instanceof EntityEvent && ((EntityEvent)e).getEntity() instanceof Player) {
            return !((EntityEvent)e).getEntity().hasMetadata("NPC");
        }
        return true;
    }

    @Override
    public Map<String, Mixed> evaluate_helper(BindableEvent event) throws EventException {
        String macro;
        HashMap<String, Mixed> map = new HashMap<String, Mixed>();
        map.put("event_type", new CString(this.mySuper.getName(), Target.UNKNOWN));
        Object e = event._GetObject();
        if (e instanceof BlockEvent) {
            macro = "block";
        } else if (e instanceof EntityEvent) {
            macro = "entity";
            if (((EntityEvent)e).getEntity() instanceof Player) {
                Entity entity = ((EntityEvent)e).getEntity();
                map.put("player", new CString(entity.getName(), Target.UNKNOWN));
            }
        } else if (e instanceof HangingEvent) {
            macro = "entity";
        } else if (e instanceof InventoryEvent) {
            macro = "inventory";
        } else if (e instanceof PlayerEvent) {
            map.put("player", new CString(((PlayerEvent)e).getPlayer().getName(), Target.UNKNOWN));
            macro = "player";
        } else {
            macro = e instanceof ServerEvent ? "server" : (e instanceof VehicleEvent ? "vehicle" : (e instanceof WeatherEvent ? "weather" : (e instanceof WorldEvent ? "world" : "custom")));
        }
        map.put("macrotype", new CString(macro, Target.UNKNOWN));
        return map;
    }

    @Override
    public void manualTrigger(BindableEvent e) {
        if (e._GetObject() instanceof Event) {
            ((BukkitMCServer)Static.getServer()).__Server().getPluginManager().callEvent((Event)e._GetObject());
        }
    }

    @Override
    public boolean isCancellable(BindableEvent o) {
        return o._GetObject() instanceof Cancellable;
    }

    @Override
    public boolean isCancelled(BindableEvent o) {
        if (o._GetObject() instanceof Cancellable) {
            return ((Cancellable)o._GetObject()).isCancelled();
        }
        return false;
    }
}

