/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common.Annotations;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassMirror;
import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.ClassUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.annotations.MustUseOverride;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"java.lang.Override", "com.laytonsmith.annotations.MustUseOverride"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_16)
public class CheckOverrides
extends AbstractProcessor {
    private static final boolean ENABLED = true;
    private static Map<Class, Set<Method>> methods = null;
    private static final Set<Class> INTERFACES_WITH_MUST_USE_OVERRIDE = new HashSet<Class>();
    private static final Pattern METHOD_SIGNATURE = Pattern.compile("[a-zA-Z0-9_]+\\((.*)\\)");
    private static final Pattern CLASS_TEMPLATES = Pattern.compile("^.*?<(.*)>?$");

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        CheckOverrides.setup();
        if (!roundEnv.processingOver()) {
            Class c;
            String className;
            for (Element element : roundEnv.getElementsAnnotatedWith(MustUseOverride.class)) {
                className = element.toString();
                c = null;
                try {
                    c = CheckOverrides.getClassFromName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace(System.err);
                }
                if (c == null) continue;
                if (!c.isInterface()) {
                    String string = "Only interfaces may be annotated with " + MustUseOverride.class.getName();
                    System.err.println(string);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string);
                }
                INTERFACES_WITH_MUST_USE_OVERRIDE.add(c);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(Override.class)) {
                int i;
                Class[] argTypes;
                className = element.getEnclosingElement().toString();
                c = null;
                try {
                    c = CheckOverrides.getClassFromName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace(System.err);
                }
                if (c == null || c.isInterface()) continue;
                Matcher matcher = METHOD_SIGNATURE.matcher(element.toString());
                String methodName = element.getSimpleName().toString();
                boolean isTemplate = false;
                if (!matcher.find()) {
                    argTypes = new Class[]{};
                } else {
                    String[] args;
                    String string = matcher.group(1);
                    if ("".equals(string.trim())) {
                        args = ArrayUtils.EMPTY_STRING_ARRAY;
                    } else {
                        String string2 = CheckOverrides.removeGenerics(string);
                        args = StringUtils.trimSplit(string2, ",");
                    }
                    argTypes = new Class[args.length];
                    for (i = 0; i < args.length; ++i) {
                        try {
                            argTypes[i] = CheckOverrides.getClassFromName(args[i]);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            String codeClassName = element.getEnclosingElement().asType().toString();
                            Matcher mm = CLASS_TEMPLATES.matcher(codeClassName);
                            boolean found = false;
                            if (mm.find()) {
                                String[] templates = CheckOverrides.removeGenerics(mm.group(1)).split(",");
                                String baseClass = args[i].replaceAll("\\[\\]", "");
                                for (String template : templates) {
                                    if (!baseClass.equals(template)) continue;
                                    isTemplate = true;
                                    found = true;
                                    args[i] = args[i].replaceFirst(Pattern.quote(template), "java.lang.Object");
                                    break;
                                }
                            }
                            if (!isTemplate || !found) {
                                e.printStackTrace(System.err);
                            }
                            try {
                                argTypes[i] = Class.forName(args[i]);
                                continue;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (isTemplate) {
                    Method[] methodArray = c.getDeclaredMethods();
                    int args = methodArray.length;
                    for (i = 0; i < args; ++i) {
                        Method method = methodArray[i];
                        if (!method.getName().equals(methodName) || method.getParameterTypes().length != argTypes.length) continue;
                        methods.get(c).remove(method);
                    }
                } else {
                    try {
                        Method method = c.getDeclaredMethod(methodName, argTypes);
                        Iterator<Method> it = methods.get(c).iterator();
                        while (it.hasNext()) {
                            Method next = it.next();
                            if (!next.getName().equals(method.getName()) || !CheckOverrides.checkSignatureForCompatibility(next.getParameterTypes(), method.getParameterTypes())) continue;
                            it.remove();
                        }
                    }
                    catch (NoSuchMethodException | SecurityException exception) {
                        exception.printStackTrace(System.err);
                    }
                }
                if (!methods.get(c).isEmpty()) continue;
                methods.remove(c);
            }
            HashSet<Method> methodsInError = new HashSet<Method>();
            for (Class c2 : methods.keySet()) {
                Set<Method> mm = methods.get(c2);
                Iterator<Method> iterator2 = mm.iterator();
                while (iterator2.hasNext()) {
                    Method m2 = iterator2.next();
                    HashSet<Class> supers = new HashSet<Class>();
                    CheckOverrides.getAllSupers(c2, supers, true);
                    ArrayList<Method> compare = new ArrayList<Method>();
                    for (Class s : supers) {
                        compare.addAll(CheckOverrides.getOverridableMethods(s));
                    }
                    block19: for (Method superM : compare) {
                        if (!m2.getName().equals(superM.getName()) || !CheckOverrides.checkSignatureForCompatibility(superM.getParameterTypes(), m2.getParameterTypes()) || m2.isAnnotationPresent(SuppressCheckOverrides.class)) continue;
                        Class<?> container = m2.getDeclaringClass();
                        while (!container.isAnnotationPresent(SuppressCheckOverrides.class)) {
                            if ((container = container.getEnclosingClass()) != null) continue;
                            methodsInError.add(m2);
                            continue block19;
                        }
                    }
                }
            }
            if (!methodsInError.isEmpty()) {
                final List<String> list = Arrays.asList("java.lang", "java.util", "java.io");
                TreeSet<CallSite> stringMethodsInError = new TreeSet<CallSite>();
                for (Method method : methodsInError) {
                    stringMethodsInError.add((CallSite)((Object)(method.getDeclaringClass().getName() + "." + method.getName() + "(" + StringUtils.Join(Arrays.asList(method.getParameterTypes()), ", ", ", ", ", ", "", new StringUtils.Renderer<Class<?>>(){

                        @Override
                        public String toString(Class<?> item) {
                            String name = ClassUtils.getCommonName(item);
                            for (String v : list) {
                                if (!name.matches(Pattern.quote(v) + "\\.([^\\.]*?)$")) continue;
                                return name.replaceFirst(Pattern.quote(v) + "\\.", "");
                            }
                            return name;
                        }
                    }) + ")")));
                }
                StringBuilder b = new StringBuilder();
                b.append("There ").append(StringUtils.PluralTemplateHelper(stringMethodsInError.size(), "is a method which overrides or implements a method in a super class/super interface, but doesn't use the @Override tag. Please tag this method", "are %d methods which override or implement a method in a super class/super interface but don't use the @Override tag. Please tag these methods")).append(" with @Override to continue the build process.").append(StringUtils.NL).append(StringUtils.Join(stringMethodsInError, StringUtils.NL));
                System.err.println(b.toString());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, b.toString());
            } else {
                StreamUtils.GetSystemOut().println("No @Override annotations were found to be missing.");
            }
        }
        return false;
    }

    private static void getAllSupers(Class c, Set<Class> building, boolean first) {
        if (c == null || c == Object.class) {
            return;
        }
        if (!first) {
            building.add(c);
        } else {
            building.add(Object.class);
        }
        CheckOverrides.getAllSupers(c.getSuperclass(), building, false);
        for (Class<?> cc : c.getInterfaces()) {
            if (!INTERFACES_WITH_MUST_USE_OVERRIDE.contains(cc)) continue;
            building.add(cc);
        }
    }

    private static boolean checkSignatureForCompatibility(Class[] superArgs, Class[] subArgs) {
        if (superArgs.length != subArgs.length) {
            return false;
        }
        for (int i = 0; i < superArgs.length; ++i) {
            if (superArgs[i] == subArgs[i]) continue;
            return false;
        }
        return true;
    }

    private static String removeGenerics(String identifier) {
        StringBuilder b = new StringBuilder();
        int genericCount = 0;
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (ch == '<') {
                ++genericCount;
                continue;
            }
            if (ch == '>') {
                --genericCount;
                continue;
            }
            if (genericCount != 0) continue;
            b.append(ch);
        }
        return b.toString();
    }

    private static Class getClassFromName(String className) throws ClassNotFoundException {
        return ClassUtils.forCanonicalName(className, false, CheckOverrides.class.getClassLoader());
    }

    private static void setup() {
        if (methods == null) {
            methods = new HashMap<Class, Set<Method>>();
            List<ClassMirror<?>> classes = ClassDiscovery.getDefaultInstance().getKnownClasses(ClassDiscovery.GetClassContainer(CheckOverrides.class));
            for (ClassMirror<?> cm : classes) {
                Set<Method> mm;
                Class<?> c = cm.loadClass(CheckOverrides.class.getClassLoader(), false);
                if (c.isInterface() || c.isRecord() || (mm = CheckOverrides.getPotentiallyOverridingMethods(c)).isEmpty()) continue;
                methods.put(c, mm);
            }
        }
    }

    private static Set<Method> getPotentiallyOverridingMethods(Class c) {
        HashSet<Method> methodList = new HashSet<Method>();
        for (Method m : c.getDeclaredMethods()) {
            if ((m.getModifiers() & 2) != 0 || (m.getModifiers() & 8) != 0 || m.isSynthetic()) continue;
            methodList.add(m);
        }
        return methodList;
    }

    private static List<Method> getOverridableMethods(Class c) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method m : c.getDeclaredMethods()) {
            if ((m.getModifiers() & 2) != 0 || (m.getModifiers() & 8) != 0 || (m.getModifiers() & 0x10) != 0 || m.isSynthetic()) continue;
            methodList.add(m);
        }
        return methodList;
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SuppressCheckOverrides {
    }
}

