/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DynamicClassLoader
extends ClassLoader {
    private final Map<URL, URLClassLoader> classLoaders = new LinkedHashMap<URL, URLClassLoader>();
    private final Set<URL> urls = new HashSet<URL>();
    private boolean destroyed = false;

    public synchronized void addJar(URL url) {
        this.checkDestroy();
        if (this.urls.contains(url)) {
            return;
        }
        this.urls.add(url);
        this.classLoaders.put(url, new URLClassLoader(new URL[]{url}, DynamicClassLoader.class.getClassLoader()));
    }

    public synchronized void removeJar(URL url) {
        this.checkDestroy();
        if (!this.urls.contains(url)) {
            return;
        }
        this.urls.remove(url);
        URLClassLoader l = this.classLoaders.remove(url);
        try {
            l.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected synchronized Package getPackage(String name) {
        for (ClassLoader classLoader : this.classLoaders.values()) {
            Package p2 = (Package)ReflectionUtils.invokeMethod(classLoader.getClass(), classLoader, "getPackage", new Class[]{String.class}, new Object[]{name});
            if (p2 == null) continue;
            return p2;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> locations = new ArrayList<URL>();
        for (ClassLoader classLoader : this.classLoaders.values()) {
            Enumeration<URL> res = classLoader.getResources(name);
            while (res.hasMoreElements()) {
                locations.add(res.nextElement());
            }
        }
        final Iterator iterator = locations.iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    @Override
    protected synchronized Package[] getPackages() {
        ArrayList<Package> packages = new ArrayList<Package>();
        for (ClassLoader classLoader : this.classLoaders.values()) {
            packages.addAll(Arrays.asList((Package[])ReflectionUtils.invokeMethod(classLoader.getClass(), classLoader, "getPackages")));
        }
        return packages.toArray(new Package[packages.size()]);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.checkDestroy();
        try {
            Class<?> c = Class.forName(name, resolve, DynamicClassLoader.class.getClassLoader());
            return c;
        }
        catch (ClassNotFoundException ex) {
            for (URLClassLoader url : this.classLoaders.values()) {
                try {
                    Class<?> c = url.loadClass(name);
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    public synchronized void destroy() {
        this.destroyed = true;
        this.classLoaders.clear();
        this.urls.clear();
    }

    private void checkDestroy() {
        if (this.destroyed) {
            throw new RuntimeException("Cannot access this instance of " + DynamicClassLoader.class.getSimpleName() + ", as it has already been destroyed. This may be caused by an earlier loading error.");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }
}

