/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.enums.MCArt;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Art;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;

public class BukkitMCArt
extends MCArt<Art> {
    private static final Map<Art, MCArt> BUKKIT_MAP = new HashMap<Art, MCArt>();

    public BukkitMCArt(MCArt.MCVanillaArt vanillaArtType, Art art) {
        super(vanillaArtType, art);
    }

    @Override
    public String name() {
        if (this.getAbstracted() == MCArt.MCVanillaArt.UNKNOWN) {
            NamespacedKey key = (NamespacedKey)ReflectionUtils.invokeMethod(Keyed.class, this.getConcrete(), "getKey");
            return key.getKey().toUpperCase(Locale.ROOT);
        }
        return ((MCArt.MCVanillaArt)((Object)this.getAbstracted())).name();
    }

    public static MCArt valueOfConcrete(Art test) {
        MCArt type = BUKKIT_MAP.get(test);
        if (type == null) {
            NamespacedKey key = (NamespacedKey)ReflectionUtils.invokeMethod(Keyed.class, test, "getKey");
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit Art missing in BUKKIT_MAP: " + key.getKey().toUpperCase(Locale.ROOT), Target.UNKNOWN);
            return new BukkitMCArt(MCArt.MCVanillaArt.UNKNOWN, test);
        }
        return type;
    }

    public static void build() {
        Object wrapper;
        for (MCArt.MCVanillaArt mCVanillaArt : MCArt.MCVanillaArt.values()) {
            Art type;
            if (!mCVanillaArt.existsIn(Static.getServer().getMinecraftVersion())) continue;
            try {
                type = (Art)Art.class.getDeclaredField(mCVanillaArt.name()).get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find a Bukkit Art for " + mCVanillaArt.name(), Target.UNKNOWN);
                continue;
            }
            wrapper = new BukkitMCArt(mCVanillaArt, type);
            MAP.put(mCVanillaArt.name(), wrapper);
            BUKKIT_MAP.put(type, (MCArt)wrapper);
        }
        for (Field field : Art.class.getFields()) {
            try {
                Art a;
                wrapper = field.get(null);
                if (!(wrapper instanceof Art) || BUKKIT_MAP.containsKey(a = (Art)wrapper)) continue;
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find an MCArt for " + field.getName(), Target.UNKNOWN);
                wrapper = new BukkitMCArt(MCArt.MCVanillaArt.UNKNOWN, a);
                MAP.put(field.getName(), wrapper);
                BUKKIT_MAP.put(a, (MCArt)wrapper);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

