/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.core;

import com.laytonsmith.libs.org.postgresql.core.Field;
import com.laytonsmith.libs.org.postgresql.core.ProtocolConnection;
import com.laytonsmith.libs.org.postgresql.core.Query;
import com.laytonsmith.libs.org.postgresql.core.QueryExecutor;
import com.laytonsmith.libs.org.postgresql.core.ResultCursor;
import com.laytonsmith.libs.org.postgresql.core.ResultHandler;
import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class SetupQueryRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[][] run(ProtocolConnection protoConnection, String queryString, boolean wantResults) throws SQLException {
        QueryExecutor executor = protoConnection.getQueryExecutor();
        Query query2 = executor.createSimpleQuery(queryString);
        SimpleResultHandler handler = new SimpleResultHandler(protoConnection);
        int flags = 17;
        if (!wantResults) {
            flags |= 6;
        }
        try {
            executor.execute(query2, null, (ResultHandler)handler, 0, 0, flags);
        }
        finally {
            query2.close();
        }
        if (!wantResults) {
            return null;
        }
        Vector tuples = handler.getResults();
        if (tuples == null || tuples.size() != 1) {
            throw new PSQLException(GT.tr("An unexpected result was returned by a query."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return (byte[][])tuples.elementAt(0);
    }

    private static class SimpleResultHandler
    implements ResultHandler {
        private SQLException error;
        private Vector tuples;
        private final ProtocolConnection protoConnection;

        SimpleResultHandler(ProtocolConnection protoConnection) {
            this.protoConnection = protoConnection;
        }

        Vector getResults() {
            return this.tuples;
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
            this.tuples = tuples;
        }

        @Override
        public void handleCommandStatus(String status, int updateCount, long insertOID) {
        }

        @Override
        public void handleWarning(SQLWarning warning) {
        }

        @Override
        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        @Override
        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

