/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.events;

import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlock;
import com.laytonsmith.abstraction.enums.MCCollisionType;
import com.laytonsmith.abstraction.events.MCVehicleBlockCollideEvent;
import com.laytonsmith.abstraction.events.MCVehicleDestroyEvent;
import com.laytonsmith.abstraction.events.MCVehicleEnterExitEvent;
import com.laytonsmith.abstraction.events.MCVehicleEntityCollideEvent;
import com.laytonsmith.abstraction.events.MCVehicleEvent;
import com.laytonsmith.abstraction.events.MCVehicleMoveEvent;
import com.laytonsmith.annotations.abstraction;
import org.bukkit.entity.Entity;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleCollisionEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;

public class BukkitVehicleEvents {

    public static class BukkitMCVehicleEvent
    implements MCVehicleEvent {
        private final VehicleEvent ve;
        private MCEntity vehicle;

        public BukkitMCVehicleEvent(VehicleEvent event) {
            this.ve = event;
        }

        @Override
        public MCEntity getVehicle() {
            if (this.vehicle == null) {
                this.vehicle = BukkitConvertor.BukkitGetCorrectEntity((Entity)this.ve.getVehicle());
            }
            return this.vehicle;
        }

        @Override
        public Object _GetObject() {
            return this.ve;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCVehicleDestroyEvent
    extends BukkitMCVehicleEvent
    implements MCVehicleDestroyEvent {
        VehicleDestroyEvent vee;

        public BukkitMCVehicleDestroyEvent(VehicleDestroyEvent event) {
            super((VehicleEvent)event);
            this.vee = event;
        }

        @Override
        public MCEntity getAttacker() {
            if (this.vee.getAttacker() == null) {
                return null;
            }
            return BukkitConvertor.BukkitGetCorrectEntity(this.vee.getAttacker());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCVehicleMoveEvent
    extends BukkitMCVehicleEvent
    implements MCVehicleMoveEvent {
        VehicleMoveEvent vme;
        int threshold;
        boolean cancelled;
        MCLocation from;

        public BukkitMCVehicleMoveEvent(VehicleMoveEvent event, int threshold, MCLocation from) {
            super((VehicleEvent)event);
            this.vme = event;
            this.threshold = threshold;
            this.cancelled = false;
            this.from = from;
        }

        @Override
        public int getThreshold() {
            return this.threshold;
        }

        @Override
        public MCLocation getFrom() {
            return new BukkitMCLocation(this.from);
        }

        @Override
        public MCLocation getTo() {
            return new BukkitMCLocation(this.vme.getTo());
        }

        @Override
        public void setCancelled(boolean state) {
            this.cancelled = state;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCVehicleExitEvent
    extends BukkitMCVehicleEvent
    implements MCVehicleEnterExitEvent {
        VehicleExitEvent vee;

        public BukkitMCVehicleExitEvent(VehicleExitEvent event) {
            super((VehicleEvent)event);
            this.vee = event;
        }

        @Override
        public MCEntity getEntity() {
            return BukkitConvertor.BukkitGetCorrectEntity((Entity)this.vee.getExited());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCVehicleEnterEvent
    extends BukkitMCVehicleEvent
    implements MCVehicleEnterExitEvent {
        VehicleEnterEvent vee;

        public BukkitMCVehicleEnterEvent(VehicleEnterEvent event) {
            super((VehicleEvent)event);
            this.vee = event;
        }

        @Override
        public MCEntity getEntity() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.vee.getEntered());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCVehicleBlockCollideEvent
    extends BukkitMCVehicleEvent
    implements MCVehicleBlockCollideEvent {
        VehicleBlockCollisionEvent vbc;

        public BukkitMCVehicleBlockCollideEvent(VehicleCollisionEvent event) {
            super((VehicleEvent)event);
            this.vbc = (VehicleBlockCollisionEvent)event;
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.vbc.getBlock());
        }

        @Override
        public MCCollisionType getCollisionType() {
            return MCCollisionType.BLOCK;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCVehicleEntityCollideEvent
    extends BukkitMCVehicleEvent
    implements MCVehicleEntityCollideEvent {
        private final VehicleEntityCollisionEvent vec;
        private MCEntity entity;

        public BukkitMCVehicleEntityCollideEvent(VehicleEntityCollisionEvent event) {
            super((VehicleEvent)event);
            this.vec = event;
        }

        @Override
        public MCEntity getEntity() {
            if (this.entity == null) {
                this.entity = BukkitConvertor.BukkitGetCorrectEntity(this.vec.getEntity());
            }
            return this.entity;
        }

        @Override
        public boolean isCollisionCancelled() {
            return this.vec.isCollisionCancelled();
        }

        @Override
        public boolean isPickupCancelled() {
            return this.vec.isPickupCancelled();
        }

        @Override
        public void setCollisionCancelled(boolean cancel2) {
            this.vec.setCollisionCancelled(cancel2);
        }

        @Override
        public void setPickupCancelled(boolean cancel2) {
            this.vec.setPickupCancelled(cancel2);
        }

        @Override
        public MCCollisionType getCollisionType() {
            return MCCollisionType.ENTITY;
        }
    }
}

