/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.signature;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.core.compiler.signature.FunctionSignature;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class FunctionSignatures {
    private final List<FunctionSignature> signatures = new ArrayList<FunctionSignature>();
    private MatchType matchType;

    protected FunctionSignatures(MatchType matchType) {
        this.matchType = matchType;
    }

    protected void addSignature(FunctionSignature signature) {
        this.signatures.add(signature);
    }

    public List<FunctionSignature> getSignatures() {
        return Collections.unmodifiableList(this.signatures);
    }

    public String getSignaturesParamTypesString() {
        return StringUtils.Join(this.signatures, " | ", null, null, null, signature -> signature.getParamTypesString());
    }

    public CClassType getReturnType(Target t, List<CClassType> argTypes, List<Target> argTargets, Environment env, Set<ConfigCompileException> exceptions) {
        ArrayList<FunctionSignature> matches = new ArrayList<FunctionSignature>();
        for (FunctionSignature signature : this.getSignatures()) {
            if (!signature.matches(argTypes, env, false)) continue;
            if (this.matchType == MatchType.MATCH_FIRST) {
                return signature.getReturnType().getType();
            }
            matches.add(signature);
        }
        switch (matches.size()) {
            case 0: {
                String argTypesStr = "(" + StringUtils.Join(argTypes, ", ", null, null, null, type -> type == null ? "none" : type.getSimpleName()) + ")";
                exceptions.add(new ConfigCompileException("Arguments " + argTypesStr + " do not match required " + this.getSignaturesParamTypesString() + ".", t));
                return CClassType.AUTO;
            }
            case 1: {
                return ((FunctionSignature)matches.get(0)).getReturnType().getType();
            }
        }
        CClassType type2 = ((FunctionSignature)matches.get(0)).getReturnType().getType();
        for (int i = 1; i < matches.size(); ++i) {
            CClassType retType = ((FunctionSignature)matches.get(i)).getReturnType().getType();
            if (!(retType == null ? retType != type2 : !retType.equals(type2))) continue;
            return CClassType.AUTO;
        }
        return type2;
    }

    public static enum MatchType {
        MATCH_ALL,
        MATCH_FIRST;

    }
}

