/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.abstraction.AbstractionObject;
import com.laytonsmith.abstraction.MCChunk;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.bukkit.BukkitMCChunk;
import com.laytonsmith.abstraction.bukkit.BukkitMCWorld;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlock;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class BukkitMCLocation
implements MCLocation {
    Location l;

    public BukkitMCLocation(Location l) {
        this.l = l;
    }

    public BukkitMCLocation(AbstractionObject a) {
        if (!(a instanceof MCLocation)) {
            throw new ClassCastException();
        }
        this.l = (Location)a.getHandle();
    }

    @Override
    public Object getHandle() {
        return this.l;
    }

    @Override
    public double getX() {
        return this.l.getX();
    }

    @Override
    public double getY() {
        return this.l.getY();
    }

    @Override
    public double getZ() {
        return this.l.getZ();
    }

    @Override
    public double distance(MCLocation o) {
        return this.l.distance(((BukkitMCLocation)o)._Location());
    }

    @Override
    public double distanceSquared(MCLocation o) {
        return this.l.distanceSquared(((BukkitMCLocation)o)._Location());
    }

    @Override
    public MCWorld getWorld() {
        if (this.l.getWorld() == null) {
            return null;
        }
        return new BukkitMCWorld(this.l.getWorld());
    }

    @Override
    public float getYaw() {
        return this.l.getYaw();
    }

    @Override
    public float getPitch() {
        return this.l.getPitch();
    }

    @Override
    public int getBlockX() {
        return this.l.getBlockX();
    }

    @Override
    public int getBlockY() {
        return this.l.getBlockY();
    }

    @Override
    public int getBlockZ() {
        return this.l.getBlockZ();
    }

    @Override
    public MCBlock getBlock() {
        return new BukkitMCBlock(this.l.getBlock());
    }

    public Location _Location() {
        return this.l;
    }

    @Override
    public void setX(double x) {
        this.l.setX(x);
    }

    @Override
    public void setY(double y) {
        this.l.setY(y);
    }

    @Override
    public void setZ(double z) {
        this.l.setZ(z);
    }

    @Override
    public void setPitch(float p2) {
        this.l.setPitch(p2);
    }

    @Override
    public void setYaw(float y) {
        this.l.setYaw(y);
    }

    @Override
    public MCLocation add(MCLocation vec) {
        return new BukkitMCLocation(this.l.add(((BukkitMCLocation)vec)._Location()));
    }

    @Override
    public MCLocation add(Vector3D vec) {
        return new BukkitMCLocation(this.l.add(new Vector(vec.X(), vec.Y(), vec.Z())));
    }

    @Override
    public MCLocation add(double x, double y, double z) {
        return new BukkitMCLocation(this.l.add(x, y, z));
    }

    @Override
    public MCLocation multiply(double m) {
        return new BukkitMCLocation(this.l.multiply(m));
    }

    @Override
    public Vector3D toVector() {
        return new Vector3D(this.l.getX(), this.l.getY(), this.l.getZ());
    }

    @Override
    public MCLocation subtract(MCLocation vec) {
        return new BukkitMCLocation(this.l.subtract(((BukkitMCLocation)vec)._Location()));
    }

    @Override
    public MCLocation subtract(Vector3D vec) {
        return new BukkitMCLocation(this.l.subtract(new Vector(vec.X(), vec.Y(), vec.Z())));
    }

    @Override
    public MCLocation subtract(double x, double y, double z) {
        return new BukkitMCLocation(this.l.subtract(x, y, z));
    }

    @Override
    public MCLocation clone() {
        return new BukkitMCLocation(this.l.clone());
    }

    public Location asLocation() {
        return this.l;
    }

    public String toString() {
        return this.l.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof BukkitMCLocation && this.l.equals((Object)((BukkitMCLocation)obj).l);
    }

    public int hashCode() {
        return this.l.hashCode();
    }

    @Override
    public Vector3D getDirection() {
        Vector v = this.l.getDirection();
        return new Vector3D(v.getX(), v.getY(), v.getZ());
    }

    @Override
    public MCChunk getChunk() {
        return new BukkitMCChunk(this.l.getChunk());
    }
}

