/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.natives.interfaces;

import com.laytonsmith.annotations.nofield;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.natives.interfaces.MList;
import com.laytonsmith.core.natives.interfaces.MMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MObject {
    private final Map<String, Construct> fields = new HashMap<String, Construct>();

    public static <T extends MObject> T Construct(Class<T> type, CArray data) {
        try {
            MObject instance = (MObject)type.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(type.getName() + " does not have a default constructor.");
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(type.getName() + "'s default constructor is not public.");
        }
        return null;
    }

    public static MObject Construct(CArray data) {
        return MObject.Construct(MObject.class, data);
    }

    protected String alias(String field) {
        return null;
    }

    public final void set(String field, Construct value, Target t) {
        String alias = this.alias(field);
        if (alias != null) {
            field = alias;
        }
        for (Field f : this.getClass().getFields()) {
            Object val;
            if (f.isAnnotationPresent(nofield.class) || !f.getName().equals(field)) continue;
            Class<?> fType = f.getType();
            if (value instanceof CNull) {
                val = null;
            } else if (fType == Byte.TYPE) {
                val = ArgumentValidation.getInt8(value, t);
            } else if (fType == Short.TYPE) {
                val = ArgumentValidation.getInt16(value, t);
            } else if (fType == Integer.TYPE) {
                val = ArgumentValidation.getInt32(value, t);
            } else if (fType == Long.TYPE) {
                val = ArgumentValidation.getInt(value, t);
            } else if (fType == Character.TYPE) {
                val = value.val().length() == 0 ? null : Character.valueOf(value.val().charAt(0));
            } else if (fType == Boolean.TYPE) {
                val = ArgumentValidation.getBoolean(value, t);
            } else if (fType == Float.TYPE) {
                val = Float.valueOf(ArgumentValidation.getDouble32(value, t));
            } else if (fType == Double.TYPE) {
                val = ArgumentValidation.getDouble(value, t);
            } else if (fType == MMap.class) {
                ca = ArgumentValidation.getArray(value, t);
                m = new MMap();
                for (String key : ca.stringKeySet()) {
                    ((HashMap)m).put(key, ca.get(key, t));
                }
                val = m;
            } else if (fType == MList.class) {
                ca = ArgumentValidation.getArray(value, t);
                m = new MList();
                if (ca.inAssociativeMode()) {
                    throw new CRECastException("Expected non-associative array, but an associative array was found instead.", t);
                }
                int i = 0;
                while ((long)i < ca.size()) {
                    ((ArrayList)m).add(ca.get(i, t));
                    ++i;
                }
                val = m;
            } else if (Construct.class.isAssignableFrom(fType)) {
                val = value;
            } else if (MObject.class.isAssignableFrom(fType)) {
                ca = ArgumentValidation.getArray(value, t);
                val = MObject.Construct(fType, ca);
            } else {
                throw new Error(this.getClass().getName() + " contained the public field " + f.getName() + " of type " + fType.getName() + ", which is an unsupported field type.");
            }
            try {
                f.set(this, val);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new Error(ex);
            }
        }
        this.fields.put(field, value);
    }

    public Construct get(String field) {
        return null;
    }
}

