/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.persistence.AbstractDataSource;
import com.laytonsmith.persistence.DataSource;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.DataSourceModel;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class StringSerializableDataSource
extends AbstractDataSource {
    protected DataSourceModel model;
    private boolean doPopulate = true;
    private boolean hasChanges = false;

    protected StringSerializableDataSource() {
    }

    protected StringSerializableDataSource(URI uri, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException {
        super(uri, options);
    }

    protected void writeData(DaemonManager dm, String data) throws IOException, ReadOnlyException, DataSourceException {
        this.getConnectionMixin().writeData(dm, data);
    }

    @Override
    protected void clearKey0(DaemonManager dm, String[] key) throws DataSourceException, ReadOnlyException, IOException {
        this.model.clearKey(key);
        this.writeData(dm, this.serializeModel());
    }

    @Override
    protected final void startTransaction0(DaemonManager dm) {
        this.doPopulate = true;
    }

    @Override
    protected final void stopTransaction0(DaemonManager dm, boolean rollback) throws DataSourceException, IOException {
        this.doPopulate = true;
        if (this.hasChanges) {
            this.hasChanges = false;
            if (rollback) {
                this.populate();
            } else {
                try {
                    this.writeData(dm, this.serializeModel());
                }
                catch (ReadOnlyException ex) {
                    Logger.getLogger(StringSerializableDataSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    @Override
    public void populate() throws DataSourceException {
        String data;
        if (this.inTransaction()) {
            if (this.doPopulate) {
                this.doPopulate = false;
            } else {
                return;
            }
        }
        try {
            data = this.getConnectionMixin().getData();
        }
        catch (DataSourceException | IOException e) {
            throw new DataSourceException("Could not populate the data source (" + String.valueOf(this.uri) + ") with data: " + e.getMessage(), e);
        }
        this.populateModel(data);
    }

    @Override
    public Set<String[]> keySet(String[] keyBase) {
        HashSet<String[]> keys = new HashSet<String[]>();
        String kb = StringUtils.Join(keyBase, ".");
        for (String[] key : this.model.keySet()) {
            if (!StringUtils.Join(key, ".").startsWith(kb)) continue;
            keys.add(key);
        }
        return keys;
    }

    @Override
    protected final String get0(String[] key) throws DataSourceException {
        return this.model.get(key);
    }

    @Override
    protected final boolean set0(DaemonManager dm, String[] key, String value) throws ReadOnlyException, IOException, DataSourceException {
        if (this.modifiers.contains(DataSource.DataSourceModifier.READONLY)) {
            throw new ReadOnlyException();
        }
        String old = this.get(key);
        if (old == null && value == null || old != null && old.equals(value)) {
            return false;
        }
        this.model.set(key, value);
        if (!this.inTransaction()) {
            this.writeData(dm, this.serializeModel());
        } else {
            this.hasChanges = true;
        }
        return true;
    }

    protected abstract void populateModel(String var1) throws DataSourceException;

    protected abstract String serializeModel();

    @Override
    protected String getBlankDataModel() {
        return "";
    }

    @Override
    public void disconnect() {
    }
}

