/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ReflectionUtils {
    private static Map<String, Boolean> classExistsMap = new HashMap<String, Boolean>();

    private ReflectionUtils() {
    }

    public static <T> T newInstance(Class<T> clazz) throws ReflectionException {
        return ReflectionUtils.newInstance(clazz, new Class[0], new Object[0]);
    }

    public static <T> T newInstance(Class<T> clazz, Class[] argTypes, Object[] args2) throws ReflectionException {
        try {
            Constructor<T> c = clazz.getDeclaredConstructor(argTypes);
            c.setAccessible(true);
            return c.newInstance(args2);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Object get(Class clazz, String variableName) throws ReflectionException {
        return ReflectionUtils.get(clazz, null, variableName);
    }

    public static Object get(Class clazz, Object instance, String variableName) throws ReflectionException {
        try {
            if (variableName.contains(".")) {
                String[] split2 = variableName.split("\\.");
                Object myInstance = instance;
                Class<?> myClazz = clazz;
                for (String var : split2) {
                    myInstance = ReflectionUtils.get(myClazz, myInstance, var);
                    myClazz = myInstance.getClass();
                }
                return myInstance;
            }
            Field f = clazz.getDeclaredField(variableName);
            f.setAccessible(true);
            return f.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static void set(Class clazz, String variableName, Object value) throws ReflectionException {
        ReflectionUtils.set(clazz, null, variableName, value);
    }

    public static void set(Class clazz, Object instance, String variableName, Object value) throws ReflectionException {
        try {
            if (variableName.contains(".")) {
                String[] split2 = variableName.split("\\.");
                Object myInstance = instance;
                Class<?> myClazz = clazz;
                int count = 0;
                for (String var : split2) {
                    if (count == split2.length - 1) break;
                    myInstance = ReflectionUtils.get(myClazz, myInstance, var);
                    myClazz = myInstance.getClass();
                    ++count;
                }
                ReflectionUtils.set(myClazz, myInstance, split2[split2.length - 1], value);
            } else {
                Field f = clazz.getDeclaredField(variableName);
                f.setAccessible(true);
                if (Modifier.isFinal(f.getModifiers())) {
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                }
                f.set(instance, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static <T> T invokeMethod(Class clazz, Object instance, String methodName) throws ReflectionException {
        return ReflectionUtils.invokeMethod(clazz, instance, methodName, new Class[0], new Object[0]);
    }

    public static <T> T invokeMethod(Object instance, String methodName, Object ... params) throws ReflectionException {
        Class<?> c = instance.getClass();
        ArrayList cl = new ArrayList();
        Object[] objectArray = params;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object o = objectArray[i];
            if (o != null) {
                cl.add(o.getClass());
                continue;
            }
            cl.add(null);
        }
        Class[] argTypes = cl.toArray(new Class[cl.size()]);
        while (c != null) {
            block4: for (Method m : c.getDeclaredMethods()) {
                if (!methodName.equals(m.getName())) continue;
                try {
                    if (m.getParameterTypes().length != argTypes.length) continue;
                    Class<?>[] args2 = m.getParameterTypes();
                    for (int i = 0; i < argTypes.length; ++i) {
                        if (argTypes[i] != null && !args2[i].isAssignableFrom(argTypes[i])) continue block4;
                    }
                    m.setAccessible(true);
                    return (T)m.invoke(instance, params);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new ReflectionException(ex);
                }
            }
            c = c.getSuperclass();
        }
        throw new ReflectionException(new NoSuchMethodException(methodName + " was not found in any of the searched classes."));
    }

    public static <T> T invokeMethod(Object instance, String methodName) throws ReflectionException {
        for (Class<?> c = instance.getClass(); c != null; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                if (!methodName.equals(m.getName()) || m.getParameterCount() != 0) continue;
                try {
                    return (T)m.invoke(instance, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new ReflectionException(ex);
                }
            }
        }
        throw new ReflectionException(new NoSuchMethodException(methodName + " was not found in any of the searched classes."));
    }

    public static <T> T invokeMethod(Class clazz, Object instance, String methodName, Class[] argTypes, Object[] args2) throws ReflectionException {
        try {
            Method m = clazz.getDeclaredMethod(methodName, argTypes);
            m.setAccessible(true);
            return (T)m.invoke(instance, args2);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static void PrintObjectTrace(Object instance, boolean instanceOnly) {
        ReflectionUtils.PrintObjectTrace(instance, instanceOnly, null);
    }

    public static void PrintObjectTrace(Object instance, boolean instanceOnly, PrintStream output) {
        if (output == null) {
            output = StreamUtils.GetSystemOut();
        }
        if (instance == null) {
            output.println("The object is null");
            return;
        }
        Class<?> iClass = instance.getClass();
        do {
            for (Field f : iClass.getDeclaredFields()) {
                if ((f.getModifiers() & 8) > 0) continue;
                String value = "null";
                try {
                    f.setAccessible(true);
                    Object o = ReflectionUtils.get(iClass, instance, f.getName());
                    if (o != null) {
                        value = o.toString();
                    }
                }
                catch (SecurityException e) {
                    value = "Could not access value due to a SecurityException";
                }
                output.println("(" + f.getType() + ") " + f.getName() + ": " + value);
            }
        } while (!instanceOnly && (iClass = iClass.getSuperclass()) != null);
    }

    public static Set<Class> getAllExtensions(Class c) {
        HashSet<Class> cs = new HashSet<Class>();
        for (Class cc = c.getSuperclass(); cc != null; cc = cc.getSuperclass()) {
            cs.add(cc);
            for (Class<?> ccc : cc.getInterfaces()) {
                cs.addAll(ReflectionUtils.getAllExtensions(ccc));
            }
        }
        for (Class<?> i : c.getInterfaces()) {
            cs.addAll(ReflectionUtils.getAllExtensions(i));
            cs.add(i);
        }
        return cs;
    }

    public static boolean hasMethod(Class<?> c, String methodName, Class returnType, Class ... params) throws ReflectionException {
        Method m;
        try {
            m = c.getMethod(methodName, params);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        catch (SecurityException ex) {
            throw new ReflectionException(ex);
        }
        if (returnType != null) {
            return returnType.isAssignableFrom(m.getReturnType());
        }
        return true;
    }

    private static Object getUnsafe() {
        Object unsafe;
        try {
            unsafe = ReflectionUtils.get(Class.forName("sun.misc.Unsafe"), "theUnsafe");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return unsafe;
    }

    public static <T> T instantiateUnsafe(Class<T> cls) throws RuntimeException {
        return ReflectionUtils.invokeMethod(ReflectionUtils.getUnsafe(), "allocateInstance", cls);
    }

    public static void throwUncheckedException(Throwable t) {
        ReflectionUtils.invokeMethod(ReflectionUtils.getUnsafe(), "throwException", t);
    }

    public static Class forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Class forName(String name, boolean initialize, ClassLoader loader) {
        try {
            return Class.forName(name, initialize, loader);
        }
        catch (ClassNotFoundException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static boolean classExists(String name) {
        if (classExistsMap.containsKey(name)) {
            return classExistsMap.get(name);
        }
        try {
            Class.forName(name);
            classExistsMap.put(name, Boolean.TRUE);
            return true;
        }
        catch (ClassNotFoundException ex) {
            classExistsMap.put(name, Boolean.FALSE);
            return false;
        }
    }

    public static class ReflectionException
    extends RuntimeException {
        public ReflectionException(Throwable cause) {
            super(cause);
        }

        @Override
        public Throwable getCause() {
            return super.getCause();
        }
    }
}

