/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LinkedComparatorSet<T>
extends AbstractSet<T>
implements Set<T> {
    final EqualsComparator comparator;
    final List<T> list = new ArrayList<T>();

    public LinkedComparatorSet(EqualsComparator comparator) {
        this(null, comparator);
    }

    public LinkedComparatorSet(Collection c, EqualsComparator comparator) {
        this.comparator = comparator;
        if (c != null && comparator != null) {
            HashSet<Integer> skip = new HashSet<Integer>();
            ArrayList array2 = new ArrayList(c);
            for (int i = 0; i < c.size(); ++i) {
                if (skip.contains(i)) continue;
                boolean foundMatch = false;
                Object item1 = array2.get(i);
                for (int j = i + 1; j < array2.size(); ++j) {
                    Object item2;
                    if (skip.contains(j) || !comparator.checkIfEquals(item1, item2 = array2.get(j))) continue;
                    skip.add(j);
                    if (!foundMatch) {
                        this.list.add(item1);
                    }
                    foundMatch = true;
                }
                if (foundMatch) continue;
                this.list.add(item1);
            }
        } else if (c != null) {
            this.addAll(c);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean add(T e) {
        if (!this.contains(e)) {
            this.list.add(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (this.comparator == null) {
            return super.contains(o);
        }
        Iterator<T> e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() != null) continue;
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!this.comparator.checkIfEquals(o, e.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.comparator == null) {
            return super.remove(o);
        }
        Iterator<T> e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() != null) continue;
                e.remove();
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!this.comparator.checkIfEquals(o, e.next())) continue;
                e.remove();
                return true;
            }
        }
        return false;
    }

    public static interface EqualsComparator<T> {
        public boolean checkIfEquals(T var1, T var2);
    }
}

