/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCShapedRecipe;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCRecipe;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCMaterial;
import com.laytonsmith.abstraction.enums.MCRecipeType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class BukkitMCShapedRecipe
extends BukkitMCRecipe
implements MCShapedRecipe {
    private final ShapedRecipe recipe;

    public BukkitMCShapedRecipe(ShapedRecipe recipe) {
        super((Recipe)recipe);
        this.recipe = recipe;
    }

    @Override
    public String getKey() {
        return this.recipe.getKey().getKey();
    }

    @Override
    public MCRecipeType getRecipeType() {
        return MCRecipeType.SHAPED;
    }

    @Override
    public String getGroup() {
        return this.recipe.getGroup();
    }

    @Override
    public void setGroup(String group) {
        this.recipe.setGroup(group);
    }

    @Override
    public Object getHandle() {
        return this.recipe;
    }

    @Override
    public Map<Character, MCMaterial[]> getIngredientMap() {
        HashMap<Character, MCMaterial[]> ret = new HashMap<Character, MCMaterial[]>();
        for (Map.Entry e : this.recipe.getChoiceMap().entrySet()) {
            if (e.getValue() == null) {
                ret.put((Character)e.getKey(), null);
                continue;
            }
            List choices = ((RecipeChoice.MaterialChoice)e.getValue()).getChoices();
            MCMaterial[] list = new MCMaterial[choices.size()];
            for (int i = 0; i < choices.size(); ++i) {
                list[i] = BukkitMCMaterial.valueOfConcrete((Material)choices.get(i));
            }
            ret.put((Character)e.getKey(), list);
        }
        return ret;
    }

    @Override
    public MCItemStack getResult() {
        return new BukkitMCItemStack(this.recipe.getResult());
    }

    @Override
    public String[] getShape() {
        return this.recipe.getShape();
    }

    @Override
    public void setIngredient(char key, MCItemStack ingredient) {
        this.recipe.setIngredient(key, (RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)ingredient.getHandle()));
    }

    @Override
    public void setIngredient(char key, MCItemStack ... ingredients) {
        ItemStack[] concrete = new ItemStack[ingredients.length];
        for (int i = 0; i < ingredients.length; ++i) {
            concrete[i] = (ItemStack)ingredients[i].getHandle();
        }
        this.recipe.setIngredient(key, (RecipeChoice)new RecipeChoice.ExactChoice(concrete));
    }

    @Override
    public void setIngredient(char key, MCMaterial mat) {
        this.recipe.setIngredient(key, (Material)mat.getHandle());
    }

    @Override
    public void setIngredient(char key, MCMaterial ... ingredients) {
        Material[] concrete = new Material[ingredients.length];
        for (int i = 0; i < ingredients.length; ++i) {
            concrete[i] = (Material)ingredients[i].getHandle();
        }
        this.recipe.setIngredient(key, (RecipeChoice)new RecipeChoice.MaterialChoice(concrete));
    }

    @Override
    public void setShape(String[] shape) {
        this.recipe.shape(shape);
    }
}

