/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.commandhelper;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscoveryCache;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Common.TimeConversionUtil;
import com.laytonsmith.PureUtilities.MapBuilder;
import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCServer;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCCommand;
import com.laytonsmith.abstraction.bukkit.BukkitMCServer;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCMaterial;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCBiomeType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEntityType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCLegacyMaterial;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCParticle;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCPotionEffectType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCProfession;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCSound;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCTrimMaterial;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCTrimPattern;
import com.laytonsmith.annotations.EventIdentifier;
import com.laytonsmith.commandhelper.BukkitDirtyRegisteredListener;
import com.laytonsmith.commandhelper.CommandHelperFileLocations;
import com.laytonsmith.commandhelper.CommandHelperInterpreterListener;
import com.laytonsmith.commandhelper.CommandHelperListener;
import com.laytonsmith.commandhelper.CommandHelperServerListener;
import com.laytonsmith.commandhelper.Metrics;
import com.laytonsmith.core.AliasCore;
import com.laytonsmith.core.Installer;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.UpgradeLog;
import com.laytonsmith.core.apps.AppsApiUtil;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.extensions.ExtensionManager;
import com.laytonsmith.core.telemetry.DefaultTelemetry;
import com.laytonsmith.core.telemetry.Telemetry;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.TimedRegisteredListener;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandHelperPlugin
extends JavaPlugin {
    private static AliasCore ac;
    public static MCServer myServer;
    public static SimpleVersion version;
    public static CommandHelperPlugin self;
    public static ExecutorService hostnameLookupThreadPool;
    public static ConcurrentHashMap<String, String> hostnameLookupCache;
    private static int hostnameThreadPoolID;
    private boolean firstLoad = true;
    private long interpreterUnlockedUntil = 0L;
    final CommandHelperListener playerListener = new CommandHelperListener(this);
    public final CommandHelperInterpreterListener interpreterListener = new CommandHelperInterpreterListener(this);
    final CommandHelperServerListener serverListener = new CommandHelperServerListener();

    public void onLoad() {
        AppsApiUtil.ConfigureDefaults();
        Implementation.setServerType(Implementation.Type.BUKKIT);
        myServer = BukkitMCServer.Get();
        version = new SimpleVersion(this.getDescription().getVersion());
        self = this;
        CommandHelperFileLocations.setDefault(new CommandHelperFileLocations());
        CommandHelperFileLocations.getDefault().getCacheDirectory().mkdirs();
        CommandHelperFileLocations.getDefault().getPreferencesDirectory().mkdirs();
        UpgradeLog upgradeLog = new UpgradeLog(CommandHelperFileLocations.getDefault().getUpgradeLogFile());
        upgradeLog.addUpgradeTask(new UpgradeLog.UpgradeTask(){
            String version = null;

            @Override
            public boolean doRun() {
                try {
                    this.version = "versionUpgrade-" + version;
                    return !this.hasBreadcrumb(this.version);
                }
                catch (Exception ex) {
                    CommandHelperPlugin.this.getLogger().log(Level.SEVERE, null, ex);
                    return false;
                }
            }

            @Override
            public void run() {
                this.leaveBreadcrumb(this.version);
            }
        });
        upgradeLog.addUpgradeTask(new UpgradeLog.UpgradeTask(){
            File oldPreferences = new File(CommandHelperFileLocations.getDefault().getConfigDirectory(), "preferences.txt");

            @Override
            public boolean doRun() {
                return this.oldPreferences.exists() && !CommandHelperFileLocations.getDefault().getPreferencesFile().exists();
            }

            @Override
            public void run() {
                try {
                    Prefs.init(this.oldPreferences);
                    Prefs.SetColors();
                    CommandHelperPlugin.this.getLogger().log(Level.INFO, TermColors.YELLOW + "[" + Implementation.GetServerType().getBranding() + "] Old preferences.txt file detected. Moving preferences.txt to preferences.ini." + TermColors.reset());
                    FileUtil.copy(this.oldPreferences, CommandHelperFileLocations.getDefault().getPreferencesFile(), true);
                    this.oldPreferences.deleteOnExit();
                }
                catch (IOException ex) {
                    CommandHelperPlugin.this.getLogger().log(Level.SEVERE, null, ex);
                }
            }
        });
        upgradeLog.addUpgradeTask(new UpgradeLog.UpgradeTask(){
            File cd = CommandHelperFileLocations.getDefault().getConfigDirectory();
            private final String breadcrumb = "move-preference-files-v1.0";

            @Override
            public boolean doRun() {
                return !this.hasBreadcrumb("move-preference-files-v1.0") && new File(this.cd, "preferences.ini").exists();
            }

            @Override
            public void run() {
                CommandHelperFileLocations p2 = CommandHelperFileLocations.getDefault();
                try {
                    FileUtil.move(new File(this.cd, "persistance.config"), p2.getPersistenceConfig());
                }
                catch (IOException ex) {
                    CommandHelperPlugin.this.getLogger().log(Level.SEVERE, null, ex);
                }
                try {
                    FileUtil.move(new File(this.cd, "preferences.ini"), p2.getPreferencesFile());
                }
                catch (IOException ex) {
                    CommandHelperPlugin.this.getLogger().log(Level.SEVERE, null, ex);
                }
                try {
                    FileUtil.move(new File(this.cd, "profiler.config"), p2.getProfilerConfigFile());
                }
                catch (IOException ex) {
                    CommandHelperPlugin.this.getLogger().log(Level.SEVERE, null, ex);
                }
                try {
                    FileUtil.move(new File(this.cd, "sql-profiles.xml"), p2.getProfilesFile());
                }
                catch (IOException ex) {
                    CommandHelperPlugin.this.getLogger().log(Level.SEVERE, null, ex);
                }
                new File(this.cd, "logs/debug/loggerPreferences.txt").delete();
                this.leaveBreadcrumb("move-preference-files-v1.0");
                CommandHelperPlugin.this.getLogger().log(Level.INFO, "Preference files have been relocated to " + p2.getPreferencesDirectory());
                CommandHelperPlugin.this.getLogger().log(Level.INFO, "loggerPreferences.txt has been re-created, as the defaults have changed.");
            }
        });
        upgradeLog.addUpgradeTask(new UpgradeLog.UpgradeTask(){
            private final File oldProfilesFile = new File(MethodScriptFileLocations.getDefault().getPreferencesDirectory(), "sql-profiles.xml");

            @Override
            public boolean doRun() {
                return this.oldProfilesFile.exists();
            }

            @Override
            public void run() {
                try {
                    FileUtil.move(this.oldProfilesFile, MethodScriptFileLocations.getDefault().getProfilesFile());
                    CommandHelperPlugin.this.getLogger().log(Level.INFO, "sql-profiles.xml has been renamed to " + MethodScriptFileLocations.getDefault().getProfilesFile().getName());
                }
                catch (IOException ex) {
                    CommandHelperPlugin.this.getLogger().log(Level.SEVERE, null, ex);
                }
            }
        });
        try {
            upgradeLog.runTasks();
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        catch (NoClassDefFoundError ex) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Failed to load CommandHelper. Incorrect jar?", Target.UNKNOWN);
            return;
        }
        try {
            Prefs.init(CommandHelperFileLocations.getDefault().getPreferencesFile());
            Prefs.SetColors();
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
            return;
        }
        Installer.Install(CommandHelperFileLocations.getDefault().getConfigDirectory());
        ClassDiscoveryCache cdc = new ClassDiscoveryCache(CommandHelperFileLocations.getDefault().getCacheDirectory());
        cdc.setLogger(this.getLogger());
        ClassDiscovery.getDefaultInstance().setClassDiscoveryCache(cdc);
        ClassDiscovery.getDefaultInstance().addDiscoveryLocation(ClassDiscovery.GetClassContainer(CommandHelperPlugin.class));
        MSLog.initialize(CommandHelperFileLocations.getDefault().getConfigDirectory());
        Telemetry.GetDefault().initializeTelemetry();
        Telemetry.GetDefault().doNag();
        Telemetry.GetDefault().log(DefaultTelemetry.StartupModeMetric.class, MapBuilder.start("mode", Implementation.GetServerType().getBranding()), null);
        Thread loadingThread = new Thread("extensionloader"){

            @Override
            public void run() {
                ExtensionManager.AddDiscoveryLocation(CommandHelperFileLocations.getDefault().getExtensionsDirectory());
                if (OSUtils.GetOS() == OSUtils.OS.WINDOWS) {
                    CommandHelperPlugin.this.getLogger().log(Level.INFO, "Caching extensions in the background...");
                    ExtensionManager.Cache(CommandHelperFileLocations.getDefault().getExtensionCacheDirectory(), new Class[0]);
                    CommandHelperPlugin.this.getLogger().log(Level.INFO, "Extension caching complete.");
                }
            }
        };
        loadingThread.start();
        BukkitMCEntityType.build();
        BukkitMCBiomeType.build();
        BukkitMCSound.build();
        BukkitMCParticle.build();
        BukkitMCPotionEffectType.build();
        BukkitMCProfession.build();
        BukkitMCMaterial.build();
        BukkitMCLegacyMaterial.build();
        if (myServer.getMinecraftVersion().gte(MCVersion.MC1_20)) {
            BukkitMCTrimMaterial.build();
            BukkitMCTrimPattern.build();
        }
        try {
            Class<?> cls = Class.forName("org.bukkit.plugin.java.PluginClassLoader");
            Set ignored = (Set)ReflectionUtils.get(cls, this.getClassLoader(), "seenIllegalAccess");
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                if (plugin == self) continue;
                ignored.add(plugin.getName());
            }
        }
        catch (ReflectionUtils.ReflectionException | ClassNotFoundException cls) {
            // empty catch block
        }
        if (loadingThread.isAlive()) {
            this.getLogger().log(Level.INFO, "Waiting for extension caching to complete...");
            try {
                loadingThread.join();
            }
            catch (InterruptedException ex) {
                this.getLogger().log(Level.SEVERE, null, ex);
            }
        }
        ExtensionManager.Initialize(ClassDiscovery.getDefaultInstance());
        this.getLogger().log(Level.INFO, "Extensions initialized.");
    }

    public void onEnable() {
        Metrics m = new Metrics(this, 2987);
        m.addCustomChart(new Metrics.SingleLineChart("player_count", () -> Static.getServer().getOnlinePlayers().size()));
        if (Prefs.UseSudoFallback().booleanValue()) {
            this.getLogger().log(Level.WARNING, "In your preferences, use-sudo-fallback is turned on. Consider turning this off if you can.");
        }
        if (Prefs.ShowSplashScreen().booleanValue()) {
            StreamUtils.GetSystemOut().println(TermColors.reset());
            StreamUtils.GetSystemOut().println("\n\n" + Static.Logo());
        }
        ac = new AliasCore(CommandHelperFileLocations.getDefault());
        ac.reload(null, null, this.firstLoad);
        hostnameLookupCache = new ConcurrentHashMap();
        hostnameLookupThreadPool = Executors.newFixedThreadPool(3, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "CommandHelperHostnameLookup-" + ++hostnameThreadPoolID);
            }
        });
        for (Player p2 : this.getServer().getOnlinePlayers()) {
            Static.HostnameCache(p2.getName(), p2.getAddress());
        }
        BukkitDirtyRegisteredListener.PlayDirty();
        this.registerEvents(this.playerListener);
        this.registerEvents(this.interpreterListener);
        this.registerEvents(this.serverListener);
        StaticLayer.Startup(this);
        this.firstLoad = false;
        this.getLogger().log(Level.INFO, "CommandHelper {0} enabled", this.getDescription().getVersion());
    }

    public boolean isFirstLoad() {
        return this.firstLoad;
    }

    public static AliasCore getCore() {
        return ac;
    }

    public void onDisable() {
        StaticLayer.GetConvertor().runShutdownHooks();
        if (ac.getStaticRuntimeEnv() != null) {
            ac.getStaticRuntimeEnv().getExecutionQueue().stopAllNow();
        }
        ExtensionManager.Cleanup();
        ac = null;
    }

    public void registerEvents(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public void registerEventsDynamic(Listener listener) {
        for (final Method method : listener.getClass().getMethods()) {
            HandlerList handler;
            Class<?> eventClass;
            EventIdentifier identifier = method.getAnnotation(EventIdentifier.class);
            EventHandler defaultHandler = method.getAnnotation(EventHandler.class);
            EventPriority priority = EventPriority.LOWEST;
            if (defaultHandler != null) {
                priority = defaultHandler.priority();
            }
            if (identifier == null) {
                if (defaultHandler == null || method.getParameterTypes().length != 1) continue;
                try {
                    eventClass = method.getParameterTypes()[0];
                }
                catch (ClassCastException e) {
                    continue;
                }
            }
            if (!identifier.event().existsInCurrent()) continue;
            try {
                eventClass = Class.forName(identifier.className());
            }
            catch (ClassCastException | ClassNotFoundException e) {
                MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.RUNTIME, "Could not listen for " + identifier.event().name() + " because the class " + identifier.className() + " could not be found. This problem is not expected to occur, so please report it on the bug tracker if it does.", Target.UNKNOWN);
                continue;
            }
            try {
                handler = (HandlerList)ReflectionUtils.invokeMethod(eventClass, null, "getHandlerList");
            }
            catch (ReflectionUtils.ReflectionException ref) {
                Class<?> eventSuperClass = eventClass.getSuperclass();
                if (eventSuperClass != null) {
                    try {
                        handler = (HandlerList)ReflectionUtils.invokeMethod(eventSuperClass, null, "getHandlerList");
                    }
                    catch (ReflectionUtils.ReflectionException refInner) {
                        MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.RUNTIME, "Could not listen for " + identifier.event().name() + " because the handler for class " + identifier.className() + " could not be found. An attempt has already been made to find the correct handler, but" + eventSuperClass.getName() + " did not have it either. Please report this on the bug tracker.", Target.UNKNOWN);
                        continue;
                    }
                }
                MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.RUNTIME, "Could not listen for " + identifier.event().name() + " because the handler for class " + identifier.className() + " could not be found. An attempt has already been made to find the correct handler, but no superclass could be found. Please report this on the bug tracker.", Target.UNKNOWN);
                continue;
            }
            final Class<?> finalEventClass = eventClass;
            EventExecutor executor = new EventExecutor(){

                public void execute(Listener listener, Event event) throws EventException {
                    try {
                        if (!finalEventClass.isAssignableFrom(event.getClass())) {
                            return;
                        }
                        method.invoke((Object)listener, event);
                    }
                    catch (InvocationTargetException ex) {
                        throw new EventException(ex.getCause());
                    }
                    catch (Throwable t) {
                        throw new EventException(t);
                    }
                }
            };
            if (this.getServer().getPluginManager().useTimings()) {
                handler.register((RegisteredListener)new TimedRegisteredListener(listener, executor, priority, (Plugin)this, false));
                continue;
            }
            handler.register(new RegisteredListener(listener, executor, priority, (Plugin)this, false));
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args2) {
        MCCommandSender mcsender = BukkitConvertor.BukkitGetCorrectSender(sender);
        BukkitMCCommand cmd = new BukkitMCCommand(command);
        return cmd.handleTabComplete(mcsender, alias, args2);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args2) {
        String cmdName = cmd.getName().toLowerCase();
        if ((sender.isOp() || sender instanceof Player && (sender.hasPermission("commandhelper.reloadaliases") || sender.hasPermission("ch.reloadaliases"))) && (cmdName.equals("reloadaliases") || cmdName.equals("reloadalias") || cmdName.equals("recompile"))) {
            BukkitMCPlayer player2 = null;
            if (sender instanceof Player) {
                player2 = new BukkitMCPlayer((Entity)((Player)sender));
            }
            ac.reload(player2, args2, false);
            return true;
        }
        if (cmdName.equalsIgnoreCase("commandhelper")) {
            return args2.length >= 1 && args2[0].equalsIgnoreCase("null");
        }
        if (cmdName.equals("runalias")) {
            if (args2.length == 0) {
                return false;
            }
            String command = StringUtils.Join(args2, " ");
            if (sender instanceof Player) {
                PlayerCommandPreprocessEvent pcpe = new PlayerCommandPreprocessEvent((Player)sender, command);
                this.playerListener.onPlayerCommandPreprocess(pcpe);
            } else if (sender instanceof ConsoleCommandSender || sender instanceof RemoteConsoleCommandSender || sender instanceof BlockCommandSender || sender instanceof CommandMinecart) {
                if (command.startsWith("/")) {
                    command = command.substring(1);
                }
                ServerCommandEvent sce = new ServerCommandEvent(sender, command);
                this.serverListener.onServerCommand(sce);
            }
            return true;
        }
        if (cmdName.equalsIgnoreCase("interpreter-on")) {
            if (sender instanceof ConsoleCommandSender) {
                int interpreterTimeout = Prefs.InterpreterTimeout();
                if (interpreterTimeout != 0) {
                    this.interpreterUnlockedUntil = TimeConversionUtil.inMilliseconds(interpreterTimeout, TimeConversionUtil.TimeUnit.MINUTE) + System.currentTimeMillis();
                    sender.sendMessage("Interpreter mode unlocked for " + interpreterTimeout + " minute" + (interpreterTimeout == 1 ? "" : "s"));
                }
            } else {
                sender.sendMessage("This command can only be run from console.");
            }
            return true;
        }
        if (sender instanceof Player && cmdName.equalsIgnoreCase("interpreter")) {
            if (!sender.hasPermission("commandhelper.interpreter")) {
                sender.sendMessage(MCChatColor.RED + "You do not have permission to run that command");
            } else if (!Prefs.EnableInterpreter().booleanValue()) {
                sender.sendMessage(MCChatColor.RED + "The interpreter is currently disabled. Check your preferences file.");
            } else if (Prefs.InterpreterTimeout() != 0 && this.interpreterUnlockedUntil < System.currentTimeMillis()) {
                sender.sendMessage(MCChatColor.RED + "Interpreter mode is currently locked. Run \"interpreter-on\" console to unlock it. If you want to turn this off entirely, set the interpreter-timeout option to 0 in " + CommandHelperFileLocations.getDefault().getPreferencesFile().getName());
            } else {
                this.interpreterListener.startInterpret(sender.getName());
                sender.sendMessage(MCChatColor.YELLOW + "You are now in interpreter mode. Type a dash (-) on a line by itself to exit, and >>> to enter multiline mode.");
            }
            return true;
        }
        MCCommandSender mcsender = BukkitConvertor.BukkitGetCorrectSender(sender);
        BukkitMCCommand mccmd = new BukkitMCCommand(cmd);
        return mccmd.handleCustomCommand(mcsender, commandLabel, args2);
    }

    static {
        hostnameThreadPoolID = 0;
    }
}

