/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.profiler.Profiler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Installer {
    private Installer() {
    }

    public static void Install(File root) {
        root.mkdirs();
        new File(root, "includes").mkdirs();
        new File(root, "extensions").mkdirs();
        File autoInclude = new File(root, "auto_include.ms");
        if (!autoInclude.exists()) {
            String sample = Installer.parseISToString(Installer.class.getResourceAsStream("/samp_auto_include.txt"));
            sample = sample.replaceAll("\n|\r\n", System.getProperty("line.separator"));
            try {
                FileUtil.write(sample, autoInclude);
            }
            catch (IOException ex) {
                Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        MethodScriptFileLocations.getDefault().getLocalPackagesDirectory().mkdirs();
        try {
            Profiler.Install(MethodScriptFileLocations.getDefault().getProfilerConfigFile());
        }
        catch (IOException ex) {
            Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
        }
        File persistenceNetwork = MethodScriptFileLocations.getDefault().getPersistenceConfig();
        if (!persistenceNetwork.exists()) {
            try {
                FileUtil.write(StreamUtils.GetString(Installer.class.getResourceAsStream("/samp_persistence_network.txt"), "UTF-8"), persistenceNetwork, true);
            }
            catch (IOException ex) {
                Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!MethodScriptFileLocations.getDefault().getProfilesFile().exists()) {
            try {
                FileUtil.write(StreamUtils.GetString(Installer.class.getResourceAsStream("/samp_profiles.xml"), "UTF-8"), MethodScriptFileLocations.getDefault().getProfilesFile(), true);
            }
            catch (IOException ex) {
                Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void InstallCmdlineInterpreter() {
        MethodScriptFileLocations.getDefault().getCmdlineInterpreterDirectory().mkdir();
        try {
            MethodScriptFileLocations.getDefault().getCmdlineInterpreterAutoIncludeFile().createNewFile();
        }
        catch (IOException ex) {
            Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseISToString(InputStream is) {
        BufferedReader din = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = din.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (Exception ex) {
            ex.getMessage();
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }
}

