/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.webserver;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.SignalHandler;
import com.laytonsmith.core.webserver.InvalidVerbException;
import com.laytonsmith.core.webserver.ReverseProxyListener;
import com.laytonsmith.core.webserver.ReverseProxySettings;
import com.laytonsmith.core.webserver.ServerAlreadyUpException;
import com.laytonsmith.core.webserver.ServerNotRunningException;
import com.laytonsmith.core.webserver.WebServer;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.Timer;
import java.util.TimerTask;

public final class WebServerController {
    private static final int NORMAL_SHUTDOWN = 0;
    private static final int HARD_SHUTDOWN = 1;
    private final File ctrlDir = ReverseProxySettings.getCtrlFolder();
    private final File pidFile = new File(this.ctrlDir, "pid");
    private final File cmdFile = new File(this.ctrlDir, "cmd");
    private final WebServer server = new WebServer();
    private static final File SYSTEMD = new File("/lib/systemd/system");
    private boolean stopWatchdog = false;
    private static volatile WebServerController webServerController = null;
    private static final Object WEB_SERVER_CONTROLLER_LOCK = new Object();

    public static void main(String[] args2) throws Exception {
        ReverseProxyListener.main(args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeCmd(Verb cmd, byte[] params) throws ServerNotRunningException, IOException {
        if (!this.isServerUp()) {
            throw new ServerNotRunningException();
        }
        FileChannel ch = FileChannel.open(this.cmdFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        FileLock lock2 = null;
        try {
            lock2 = ch.lock();
            ch.truncate(0L);
            byte[] data = new byte[params.length + 1];
            data[0] = cmd.getByte();
            System.arraycopy(params, 0, data, 1, params.length);
            ByteBuffer contents = ByteBuffer.wrap(data);
            ch.write(contents);
        }
        finally {
            if (lock2 != null) {
                lock2.release();
            }
            ch.close();
        }
    }

    public boolean isServerUp() throws IOException {
        if (!this.ctrlDir.exists()) {
            return false;
        }
        if (!this.pidFile.exists()) {
            return false;
        }
        long pid = this.getPid();
        return OSUtils.GetRunningProcesses().stream().anyMatch(p2 -> p2.getPid() == pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPid() throws IOException {
        FileChannel ch = FileChannel.open(this.pidFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
        FileLock lock2 = null;
        try {
            long pid;
            lock2 = ch.lock();
            long l = pid = Long.parseLong(FileUtil.read(ch));
            return l;
        }
        finally {
            if (lock2 != null) {
                lock2.release();
            }
            ch.close();
        }
    }

    public void install() throws IOException {
        if (OSUtils.GetOS().isUnixLike()) {
            this.installUnix();
        } else if (OSUtils.GetOS().isWindows()) {
            // empty if block
        }
    }

    private void installUnix() throws IOException {
        if (!SYSTEMD.exists()) {
            return;
        }
        FileUtil.write(StreamUtils.GetResource("systemd.service").replace("%%PIDFILE%%", this.pidFile.getAbsolutePath()), new File(SYSTEMD, "msws.service"), true);
    }

    public void start() throws ServerAlreadyUpException, IOException {
        if (this.isServerUp()) {
            throw new ServerAlreadyUpException();
        }
        this.log("Starting up...");
        File prefs = ReverseProxySettings.getPrefsFile();
        ReverseProxySettings.init(prefs);
        this.ctrlDir.mkdirs();
        this.registerPid();
        this.startWatchDog();
        this.registerShutdownListeners();
        this.server.start(ReverseProxySettings.getPort(), ReverseProxySettings.getRoot(), ReverseProxySettings.getThreads());
        this.log("Started");
    }

    private void registerShutdownListeners() {
        SignalHandler.addStopHandlers(type -> {
            this.shutdown(false);
            return true;
        });
    }

    private void registerPid() throws IOException {
        FileChannel ch = FileChannel.open(this.pidFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        FileLock lock2 = null;
        try {
            lock2 = ch.lock();
            FileUtil.write(ch, Long.toString(OSUtils.GetMyPid()));
        }
        finally {
            this.pidFile.deleteOnExit();
            this.cmdFile.deleteOnExit();
            if (lock2 != null) {
                lock2.release();
            }
            ch.close();
        }
    }

    private void startWatchDog() {
        final Timer t = new Timer("MSWS-Watchdog", false);
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (WebServerController.this.stopWatchdog) {
                    t.cancel();
                    WebServerController.this.stopWatchdog = false;
                    return;
                }
                try {
                    WebServerController.this.readCmd();
                }
                catch (IOException ex) {
                    WebServerController.this.log(ex);
                }
                catch (InvalidVerbException ex) {
                    WebServerController.this.log("Invalid verb specified. Are you running the same version?");
                }
            }
        }, 0L, 1000L);
        this.log("Watchdog thread started");
    }

    private void stopWatchdog() throws InterruptedException {
        this.stopWatchdog = true;
        Thread.sleep(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCmd() throws IOException, InvalidVerbException {
        if (!this.cmdFile.exists()) {
            return;
        }
        FileChannel ch = FileChannel.open(this.cmdFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
        FileLock lock2 = null;
        try {
            lock2 = ch.lock();
            byte[] cmd = FileUtil.readData(ch);
            if (cmd.length < 1) {
                return;
            }
            Verb verb = Verb.fromByte(cmd[0]);
            FileUtil.write(ch, "");
            new Thread(() -> verb.execute(this, cmd), "VerbExecute-" + verb.name()).start();
        }
        finally {
            if (lock2 != null) {
                lock2.release();
            }
            ch.close();
        }
    }

    public void shutdown(boolean graceful) {
        this.log((graceful ? "Graceful" : "Hard") + " shutdown detected");
        if (!graceful) {
            System.exit(1);
        }
        this.server.stop();
        try {
            this.stopWatchdog();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    public void recompile() {
        this.server.recompile();
    }

    private void log(Throwable t) {
        this.log(StackTraceUtils.GetStacktrace(t));
    }

    private void log(String message) {
        StreamUtils.GetSystemOut().println(message);
    }

    private WebServerController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServerController GetWebServer() {
        WebServerController webServer = webServerController;
        if (webServer == null) {
            Object object = WEB_SERVER_CONTROLLER_LOCK;
            synchronized (object) {
                webServer = webServerController;
                if (webServer == null) {
                    webServerController = webServer = new WebServerController();
                }
            }
        }
        return webServer;
    }

    public static enum Verb {
        STOP(0, (server, cmd) -> {
            byte graceful = cmd[1];
            server.shutdown(graceful != 0);
        }),
        RECOMPILE(1, (server, cmd) -> server.recompile());

        private final byte id;
        private final VerbAction action;

        private Verb(byte id, VerbAction action) {
            this.id = id;
            this.action = action;
        }

        public byte getByte() {
            return this.id;
        }

        public static Verb fromByte(byte b) throws InvalidVerbException {
            for (Verb v : Verb.values()) {
                if (v.id != b) continue;
                return v;
            }
            throw new InvalidVerbException("Unrecognized verb: " + b);
        }

        public void execute(WebServerController server, byte[] cmd) {
            this.action.activate(server, cmd);
        }

        private static interface VerbAction {
            public void activate(WebServerController var1, byte[] var2);
        }
    }
}

