/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.signature;

import com.laytonsmith.core.constructs.CClassType;

public class Param {
    private final CClassType type;
    private final String name;
    private final String desc;
    private final boolean isVarParam;
    private final boolean isOptional;

    public Param(CClassType type, String name, String desc, boolean isVarParam, boolean isOptional) {
        assert (!isVarParam || !isOptional) : "A parameter cannot be variadic and optional at the same time.";
        this.type = type;
        this.name = name;
        this.desc = desc;
        this.isVarParam = isVarParam;
        this.isOptional = isOptional;
    }

    public Param(CClassType type, String name, String desc) {
        this(type, name, desc, false, false);
    }

    public CClassType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isVarParam() {
        return this.isVarParam;
    }

    public boolean isOptional() {
        return this.isOptional;
    }
}

