/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.Pair;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.persistence.DataSource;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.DataSourceFactory;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public final class ThreadsafeDataSource
implements DataSource {
    private static final WeakHashMap<Pair<URI, ConnectionMixinFactory.ConnectionMixinOptions>, ThreadsafeDataSource> SOURCES = new WeakHashMap();
    private final DataSource source;

    public static synchronized ThreadsafeDataSource GetDataSource(URI uri, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException {
        Pair<URI, ConnectionMixinFactory.ConnectionMixinOptions> pair = new Pair<URI, ConnectionMixinFactory.ConnectionMixinOptions>(uri, options);
        ThreadsafeDataSource source2 = SOURCES.get(pair);
        if (source2 != null) {
            return source2;
        }
        ThreadsafeDataSource ds = new ThreadsafeDataSource(DataSourceFactory.GetDataSource(uri, options));
        SOURCES.put(pair, ds);
        return ds;
    }

    private ThreadsafeDataSource(DataSource source2) {
        this.source = source2;
    }

    @Override
    public synchronized Set<String[]> keySet(String[] keyBase) throws DataSourceException {
        return this.source.keySet(keyBase);
    }

    @Override
    public synchronized Set<String> stringKeySet(String[] keyBase) throws DataSourceException {
        return this.source.stringKeySet(keyBase);
    }

    @Override
    public synchronized Set<String[]> getNamespace(String[] namespace) throws DataSourceException {
        return this.source.getNamespace(namespace);
    }

    @Override
    public synchronized String get(String[] key) throws DataSourceException {
        return this.source.get(key);
    }

    @Override
    public synchronized Map<String[], String> getValues(String[] leadKey) throws DataSourceException {
        return this.source.getValues(leadKey);
    }

    @Override
    public synchronized boolean set(DaemonManager dm, String[] key, String value) throws ReadOnlyException, DataSourceException, IOException, IllegalArgumentException {
        return this.source.set(dm, key, value);
    }

    @Override
    public synchronized void populate() throws DataSourceException {
        this.source.populate();
    }

    @Override
    public synchronized void addModifier(DataSource.DataSourceModifier modifier) {
        this.source.addModifier(modifier);
    }

    @Override
    public synchronized EnumSet<DataSource.DataSourceModifier> implicitModifiers() {
        return this.source.implicitModifiers();
    }

    @Override
    public synchronized EnumSet<DataSource.DataSourceModifier> invalidModifiers() {
        return this.source.invalidModifiers();
    }

    @Override
    public synchronized Set<DataSource.DataSourceModifier> getModifiers() {
        return this.source.getModifiers();
    }

    @Override
    public synchronized boolean hasModifier(DataSource.DataSourceModifier modifier) {
        return this.source.hasModifier(modifier);
    }

    @Override
    public synchronized boolean hasKey(String[] key) throws DataSourceException {
        return this.source.hasKey(key);
    }

    @Override
    public synchronized void clearKey(DaemonManager dm, String[] key) throws DataSourceException, ReadOnlyException, IOException {
        this.source.clearKey(dm, key);
    }

    @Override
    public synchronized void startTransaction(DaemonManager dm) {
        this.source.startTransaction(dm);
    }

    @Override
    public synchronized void stopTransaction(DaemonManager dm, boolean rollback) throws DataSourceException, IOException {
        this.source.stopTransaction(dm, rollback);
    }

    @Override
    public synchronized void disconnect() throws DataSourceException {
        this.source.disconnect();
    }

    @Override
    public synchronized String getName() {
        return this.source.getName();
    }

    @Override
    public synchronized String docs() {
        return this.source.docs();
    }

    @Override
    public synchronized Version since() {
        return this.source.since();
    }

    public synchronized boolean equals(Object obj) {
        return this.source.equals(obj);
    }

    public synchronized int hashCode() {
        return this.source.hashCode();
    }

    public synchronized String toString() {
        return this.source.toString();
    }
}

