/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Set;

public class CFunction
extends Construct {
    public static final long serialVersionUID = 1L;
    private transient Function function = null;
    private transient Class<? extends Environment.EnvironmentImpl>[] envImpls = null;

    public CFunction(String name, Target t) {
        super(name, Construct.ConstructType.FUNCTION, t);
    }

    @Override
    public String toString() {
        return this.val();
    }

    @Override
    public CFunction clone() throws CloneNotSupportedException {
        return (CFunction)super.clone();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    public boolean hasProcedure() {
        return this.val().charAt(0) == '_' && this.val().charAt(1) != '_';
    }

    public boolean hasFunction() {
        return !this.hasProcedure();
    }

    public Function getFunction() throws ConfigCompileException {
        if (this.function == null) {
            this.function = (Function)FunctionList.getFunction(this.val(), null, this.getTarget());
        }
        return this.function;
    }

    public Function getCachedFunction() {
        return this.function;
    }

    public Function getCachedFunction(Set<Class<? extends Environment.EnvironmentImpl>> envs) {
        if (this.function == null) {
            return null;
        }
        if (this.envImpls == null) {
            api api2 = this.function.getClass().getAnnotation(api.class);
            this.envImpls = api2.environments();
        }
        for (Class<? extends Environment.EnvironmentImpl> envImpl : this.envImpls) {
            if (envs.contains(envImpl)) continue;
            return null;
        }
        return this.function;
    }

    public void setFunction(FunctionBase f) {
        this.function = (Function)f;
    }

    public static boolean IsFunction(Mixed possibleFunction, Class<? extends Function> ofType) {
        Function f = ReflectionUtils.newInstance(ofType);
        return possibleFunction instanceof CFunction && possibleFunction.val().equals(f.getName());
    }

    public static boolean IsFunction(ParseTree tree, Class<? extends Function> ofType) {
        return CFunction.IsFunction(tree.getData(), ofType);
    }

    @Override
    public Version since() {
        return super.since();
    }

    @Override
    public String docs() {
        return super.docs();
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[0];
    }
}

