/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCColor;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.core.Static;
import org.bukkit.Color;

public final class BukkitMCColor
implements MCColor {
    private static final BukkitMCColor BUILDER = new BukkitMCColor();
    private int red;
    private int green;
    private int blue;
    private int alpha;

    public static MCColor GetMCColor(Color c) {
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_19_4)) {
            return BUILDER.build(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }
        return BUILDER.build(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static Color GetColor(MCColor c) {
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_19_4)) {
            return Color.fromARGB((int)c.getAlpha(), (int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
        }
        return Color.fromRGB((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
    }

    private BukkitMCColor() {
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public int getRed() {
        return this.red;
    }

    @Override
    public int getGreen() {
        return this.green;
    }

    @Override
    public int getBlue() {
        return this.blue;
    }

    @Override
    public MCColor build(int red, int green, int blue) {
        BukkitMCColor color2 = new BukkitMCColor();
        color2.alpha = 255;
        color2.red = red;
        color2.green = green;
        color2.blue = blue;
        return color2;
    }

    @Override
    public MCColor build(int red, int green, int blue, int alpha) {
        BukkitMCColor color2 = new BukkitMCColor();
        color2.alpha = alpha;
        color2.red = red;
        color2.green = green;
        color2.blue = blue;
        return color2;
    }

    public int hashCode() {
        int hash2 = 5;
        hash2 = 11 * hash2 + this.alpha;
        hash2 = 11 * hash2 + this.red;
        hash2 = 11 * hash2 + this.green;
        hash2 = 11 * hash2 + this.blue;
        return hash2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BukkitMCColor other = (BukkitMCColor)obj;
        if (this.red != other.red) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        if (this.blue != other.blue) {
            return false;
        }
        return this.alpha == other.alpha;
    }
}

