/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;

public final class DataType {
    private DataTypes type;
    private DataTypes subType;
    Map<DataTypes, Boolean> cachedCastableTo = new EnumMap<DataTypes, Boolean>(DataTypes.class);
    private static final DataType MIXED = new DataType(DataTypes.MIXED, null);
    private static final DataType PRIMITIVE = new DataType(DataTypes.PRIMITIVE, null);

    private DataType(DataTypes myType, DataTypes subType) {
        if (myType != DataTypes.ARRAY && subType != null) {
            throw new Error("subType cannot be set except for arrays");
        }
        this.type = myType;
        this.subType = subType;
    }

    public boolean castableTo(DataType type) {
        return this.castableTo(type.type, null);
    }

    private boolean castableTo(DataTypes type, Boolean upward) {
        if (this.cachedCastableTo.containsKey((Object)type)) {
            return this.cachedCastableTo.get((Object)type);
        }
        boolean answer = false;
        if (upward == null || upward.booleanValue()) {
            for (DataTypes parent : this.type.parents) {
                if (parent == type) {
                    answer = true;
                    break;
                }
                if (!this.castableTo(parent, true)) continue;
                answer = true;
            }
        }
        if (upward == null || !upward.booleanValue()) {
            for (DataTypes child : this.type.children) {
                if (child == type) {
                    answer = true;
                    break;
                }
                this.castableTo(child, false);
            }
        }
        this.cachedCastableTo.put(type, answer);
        return answer;
    }

    public boolean isSameType(DataType type) {
        return this.type == type.type;
    }

    public static DataType MIXED() {
        return MIXED;
    }

    public static DataType PRIMITIVE() {
        return PRIMITIVE;
    }

    private static enum DataTypes {
        DOUBLE,
        INT,
        STRING,
        MAP,
        OBJECT,
        NUMBER,
        PRIMITIVE,
        ARRAY,
        MIXED;

        EnumSet<DataTypes> parents;
        EnumSet<DataTypes> children;

        private void setup(EnumSet<DataTypes> parents, EnumSet<DataTypes> children) {
            this.parents = parents == null ? EnumSet.noneOf(DataTypes.class) : parents;
            this.children = children == null ? EnumSet.noneOf(DataTypes.class) : children;
        }

        static {
            DOUBLE.setup(EnumSet.of(NUMBER), null);
            INT.setup(EnumSet.of(INT), null);
            STRING.setup(EnumSet.of(PRIMITIVE), null);
            MAP.setup(EnumSet.of(ARRAY), null);
            OBJECT.setup(EnumSet.of(ARRAY), null);
            NUMBER.setup(EnumSet.of(PRIMITIVE), EnumSet.of(DOUBLE, INT));
            PRIMITIVE.setup(EnumSet.of(MIXED), EnumSet.of(STRING, NUMBER));
            ARRAY.setup(EnumSet.of(MIXED), EnumSet.of(MAP, OBJECT));
            MIXED.setup(null, EnumSet.of(PRIMITIVE, ARRAY));
        }
    }
}

