/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateBuilder {
    private final Map<String, Generator> templates;
    private static final Pattern PATTERN = Pattern.compile("%%([^\\|%]+)([^%]*?)%%");
    private boolean silentFail = true;

    public TemplateBuilder() {
        this.templates = new HashMap<String, Generator>();
    }

    public TemplateBuilder(Map<String, Generator> templates) {
        this.templates = new HashMap<String, Generator>(templates);
    }

    public void addTemplate(String name, Generator replacement) {
        this.templates.put(name, replacement);
    }

    public void removeTemplate(String name) {
        this.templates.remove(name);
    }

    public void setSilentFail(boolean silentFail) {
        this.silentFail = silentFail;
    }

    public String build(String template) throws IllegalArgumentException {
        Matcher m = PATTERN.matcher(template);
        StringBuilder templateBuilder = new StringBuilder();
        int lastMatch = 0;
        boolean appended = false;
        while (m.find()) {
            if (!appended) {
                templateBuilder.append(template.substring(lastMatch, m.start()));
                appended = true;
            }
            String name = m.group(1);
            String[] tmplArgs = ArrayUtils.EMPTY_STRING_ARRAY;
            if (m.group(2) != null && !m.group(2).isEmpty()) {
                tmplArgs = m.group(2).substring(1).split("\\|");
            }
            if (this.templates.containsKey(name)) {
                String templateValue = this.templates.get(name).generate(tmplArgs);
                templateBuilder.append(templateValue);
            } else if (!this.silentFail) {
                throw new IllegalArgumentException("Template with name \"" + name + "\" was found in the input text, but no such template exists.");
            }
            lastMatch = m.end();
            appended = false;
        }
        if (!appended) {
            templateBuilder.append(template.substring(lastMatch));
        }
        return templateBuilder.toString();
    }

    public static interface Generator {
        public String generate(String ... var1);
    }
}

