/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.services;

import com.laytonsmith.libs.com.google.gson.TypeAdapterFactory;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.Endpoint;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json.ResponseJsonAdapter;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.services.AnnotationUtil;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.services.EndpointProxy;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.services.GenericEndpoint;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class ServiceEndpoints {
    private ServiceEndpoints() {
    }

    public static <T> T toServiceObject(Endpoint endpoint, Class<T> interface_) {
        Class[] interfArray = new Class[]{interface_, Endpoint.class};
        EndpointProxy invocationHandler = new EndpointProxy(endpoint, interface_);
        return (T)Proxy.newProxyInstance(interface_.getClassLoader(), interfArray, (InvocationHandler)invocationHandler);
    }

    public static Object toServiceObject(Endpoint endpoint, Collection<Class<?>> interfaces, ClassLoader classLoader) {
        Class[] interfArray = new Class[interfaces.size() + 1];
        interfaces.toArray(interfArray);
        interfArray[interfArray.length - 1] = Endpoint.class;
        EndpointProxy invocationHandler = new EndpointProxy(endpoint, interfaces);
        return Proxy.newProxyInstance(classLoader, interfArray, (InvocationHandler)invocationHandler);
    }

    public static Endpoint toEndpoint(Object serviceObject) {
        return new GenericEndpoint(serviceObject);
    }

    public static Endpoint toEndpoint(Collection<Object> serviceObjects) {
        return new GenericEndpoint(serviceObjects);
    }

    public static Map<String, JsonRpcMethod> getSupportedMethods(Class<?> type) {
        HashSet visitedTypes = new HashSet();
        return ServiceEndpoints.getSupportedMethods(type, visitedTypes);
    }

    private static Map<String, JsonRpcMethod> getSupportedMethods(Class<?> type, Set<Class<?>> visitedTypes) {
        LinkedHashMap<String, JsonRpcMethod> result = new LinkedHashMap<String, JsonRpcMethod>();
        AnnotationUtil.findRpcMethods(type, visitedTypes, methodInfo -> {
            JsonRpcMethod meth;
            if (methodInfo.isNotification) {
                meth = JsonRpcMethod.notification(methodInfo.name, methodInfo.parameterTypes);
            } else {
                Type genericReturnType = methodInfo.method.getGenericReturnType();
                if (genericReturnType instanceof ParameterizedType) {
                    Type returnType = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
                    TypeAdapterFactory responseTypeAdapter = null;
                    ResponseJsonAdapter responseTypeAdapterAnnotation = methodInfo.method.getAnnotation(ResponseJsonAdapter.class);
                    if (responseTypeAdapterAnnotation != null) {
                        try {
                            responseTypeAdapter = responseTypeAdapterAnnotation.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (ReflectiveOperationException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    meth = JsonRpcMethod.request(methodInfo.name, returnType, responseTypeAdapter, methodInfo.parameterTypes);
                } else {
                    throw new IllegalStateException("Expecting return type of CompletableFuture but was : " + genericReturnType);
                }
            }
            if (result.put(methodInfo.name, meth) != null) {
                throw new IllegalStateException("Duplicate RPC method " + methodInfo.name + ".");
            }
        });
        AnnotationUtil.findDelegateSegments(type, new HashSet(), method -> {
            Map<String, JsonRpcMethod> supportedDelegateMethods = ServiceEndpoints.getSupportedMethods(method.getReturnType(), visitedTypes);
            for (JsonRpcMethod meth : supportedDelegateMethods.values()) {
                if (result.put(meth.getMethodName(), meth) == null) continue;
                throw new IllegalStateException("Duplicate RPC method " + meth.getMethodName() + ".");
            }
        });
        return result;
    }
}

