/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import java.util.Arrays;

public class RollingAverage {
    private final Double[] data;
    private int insertionIndex;
    private final int dataSize;
    private final double initialValue;

    public RollingAverage(int datasetSize, double initialValue) {
        this.data = new Double[datasetSize];
        Arrays.fill((Object[])this.data, null);
        this.dataSize = datasetSize;
        this.insertionIndex = 0;
        this.initialValue = initialValue;
    }

    public void addData(double d) {
        this.data[this.insertionIndex] = d;
        ++this.insertionIndex;
        if (this.insertionIndex == this.dataSize) {
            this.insertionIndex = 0;
        }
    }

    public double getAverage() {
        double sum2 = 0.0;
        int count = 0;
        boolean hasValue = false;
        for (Double d : this.data) {
            if (d == null) continue;
            hasValue = true;
            sum2 += d.doubleValue();
            ++count;
        }
        if (!hasValue) {
            return this.initialValue;
        }
        return sum2 / (double)count;
    }
}

