/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.signature;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.core.compiler.signature.Param;
import com.laytonsmith.core.compiler.signature.ReturnType;
import com.laytonsmith.core.compiler.signature.Throws;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.environments.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class FunctionSignature {
    private final ReturnType returnType;
    private final List<Param> params;
    private final List<Throws> throwsList;
    private boolean noneIsAllowed;

    public FunctionSignature(ReturnType returnType, List<Param> params, List<Throws> throwsList, boolean noneIsAllowed) {
        this.returnType = returnType;
        this.params = params;
        this.throwsList = throwsList;
        this.noneIsAllowed = noneIsAllowed;
    }

    public FunctionSignature(ReturnType returnType) {
        this(returnType, new ArrayList<Param>(), new ArrayList<Throws>(), false);
    }

    protected void addParam(Param param) {
        this.params.add(param);
    }

    protected void addThrows(Throws throwsObj) {
        this.throwsList.add(throwsObj);
    }

    protected void setNoneIsAllowed(boolean noneIsAllowed) {
        this.noneIsAllowed = noneIsAllowed;
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    public List<Param> getParams() {
        return Collections.unmodifiableList(this.params);
    }

    public List<Throws> getThrows() {
        return Collections.unmodifiableList(this.throwsList);
    }

    public boolean matches(List<CClassType> argTypes, Environment env, boolean allowUnmatchedArgs) {
        int argIndex = 0;
        Stack<Integer> numArgMatchStack = new Stack<Integer>();
        block0: for (int paramIndex = 0; paramIndex < this.params.size(); ++paramIndex) {
            Param param = this.params.get(paramIndex);
            if (!param.isVarParam()) {
                if (argIndex < argTypes.size() && InstanceofUtil.isInstanceof(argTypes.get(argIndex), param.getType(), env)) {
                    if (param.isOptional()) {
                        numArgMatchStack.push(1);
                    }
                    ++argIndex;
                    continue;
                }
                if (param.isOptional()) {
                    numArgMatchStack.push(0);
                    continue;
                }
            } else {
                int numMatches = 0;
                while (argIndex < argTypes.size() && (argTypes.get(argIndex) == null && this.noneIsAllowed || InstanceofUtil.isInstanceof(argTypes.get(argIndex), param.getType(), env))) {
                    ++argIndex;
                    ++numMatches;
                }
                numArgMatchStack.push(numMatches);
                continue;
            }
            --paramIndex;
            while (!numArgMatchStack.empty()) {
                while (!this.params.get(paramIndex).isVarParam() && !this.params.get(paramIndex).isOptional()) {
                    --paramIndex;
                    --argIndex;
                }
                int numArgMatches = (Integer)numArgMatchStack.pop();
                if (numArgMatches <= 0) continue;
                numArgMatchStack.push(numArgMatches - 1);
                --argIndex;
                continue block0;
            }
            return false;
        }
        return allowUnmatchedArgs || argIndex >= argTypes.size();
    }

    public String getParamTypesString() {
        return "(" + StringUtils.Join(this.params, ", ", null, null, null, param -> {
            Object ret;
            Object object = ret = param.getType() == null ? "any" : param.getType().getSimpleName();
            if (param.isVarParam()) {
                ret = (String)ret + "...";
            }
            if (param.isOptional()) {
                ret = "[" + (String)ret + "]";
            }
            return ret;
        }) + ")";
    }
}

