/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import java.io.IOException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.search.StringTerm;

public final class BodyTerm
extends StringTerm {
    private static final long serialVersionUID = -4888862527916911385L;

    public BodyTerm(String pattern) {
        super(pattern);
    }

    @Override
    public boolean match(Message msg2) {
        return this.matchPart(msg2);
    }

    private boolean matchPart(Part p2) {
        try {
            if (p2.isMimeType("text/*")) {
                String s = (String)p2.getContent();
                if (s == null) {
                    return false;
                }
                return super.match(s);
            }
            if (p2.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)p2.getContent();
                int count = mp.getCount();
                for (int i = 0; i < count; ++i) {
                    if (!this.matchPart(mp.getBodyPart(i))) continue;
                    return true;
                }
            } else if (p2.isMimeType("message/rfc822")) {
                return this.matchPart((Part)p2.getContent());
            }
        }
        catch (MessagingException messagingException) {
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BodyTerm)) {
            return false;
        }
        return super.equals(obj);
    }
}

